/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.bean.ProofBean;
import cfca.paperless.base.exception.CodeException;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.util.HashUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofHashUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ProofHashUtil.class);

    public static String bytes2hex(byte[] bytes) {
        String result = Hex.toHexString((byte[])bytes);
        return result.toUpperCase();
    }

    public static String digestAndHex(byte[] source) throws Exception {
        businessLog.info("digestAndHex start");
        long start = System.currentTimeMillis();
        if (source == null || source.length == 0) {
            return "";
        }
        ByteArrayInputStream input = new ByteArrayInputStream(source);
        byte[] digestBytes = HashUtil.RSAHashFile((InputStream)input, (Mechanism)new Mechanism("SHA-1"), (Session)BCSoftLib.INSTANCE(), (boolean)false);
        input = null;
        String digest = ProofHashUtil.bytes2hex(digestBytes);
        long end = System.currentTimeMillis();
        businessLog.info("digestAndHex end, cost =" + (end - start) + " ms");
        return digest;
    }

    public static String digestAndHex(byte[] source, String hashAlg) throws Exception {
        businessLog.info("digestAndHex start");
        long start = System.currentTimeMillis();
        if (source == null || source.length == 0) {
            return "";
        }
        if (!("SHA-1".equals(hashAlg) || "SHA-256".equals(hashAlg) || "SHA-384".equals(hashAlg) || "SHA-512".equals(hashAlg) || "SM3".equals(hashAlg) || "MD5".equals(hashAlg))) {
            throw new CodeException("600402", "hashAlg\u53d6\u503c\u9519\u8bef");
        }
        Mechanism mechanism = new Mechanism("SHA-1");
        if ("SHA-1".equals(hashAlg)) {
            mechanism = new Mechanism("SHA-1");
        } else if ("SHA-256".equals(hashAlg)) {
            mechanism = new Mechanism("SHA-256");
        } else if ("SHA-384".equals(hashAlg)) {
            mechanism = new Mechanism("SHA-384");
        } else if ("SHA-512".equals(hashAlg)) {
            mechanism = new Mechanism("SHA-512");
        } else if ("SM3".equals(hashAlg)) {
            mechanism = new Mechanism("SM3");
        } else if ("MD5".equals(hashAlg)) {
            mechanism = new Mechanism("MD5");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(source);
        byte[] digestBytes = null;
        if ("SHA-1".equals(hashAlg) || "SHA-256".equals(hashAlg) || "SHA-384".equals(hashAlg) || "SHA-512".equals(hashAlg)) {
            digestBytes = HashUtil.RSAHashFile((InputStream)input, (Mechanism)mechanism, (Session)BCSoftLib.INSTANCE(), (boolean)false);
        } else if ("SM3".equals(hashAlg)) {
            digestBytes = HashUtil.SM3HashFileWithoutZValue((InputStream)input, (Session)BCSoftLib.INSTANCE());
        } else if ("MD5".equals(hashAlg)) {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5", SADKProvider.INSTANCE());
            digestBytes = messageDigest.digest(source);
        }
        input = null;
        String digest = ProofHashUtil.bytes2hex(digestBytes);
        long end = System.currentTimeMillis();
        businessLog.info("digestAndHex end, cost =" + (end - start) + " ms");
        return digest;
    }

    public static boolean compareHashHex(byte[] source, String result) throws Exception {
        businessLog.info("compareHashHex start");
        long start = System.currentTimeMillis();
        ByteArrayInputStream input = new ByteArrayInputStream(source);
        byte[] digestBytes = HashUtil.RSAHashFile((InputStream)input, (Mechanism)new Mechanism("SHA-1"), (Session)BCSoftLib.INSTANCE(), (boolean)false);
        String real = ProofHashUtil.bytes2hex(digestBytes);
        input = null;
        long end = System.currentTimeMillis();
        businessLog.info("compareHashHex end, cost =" + (end - start) + " ms");
        return result != null && real != null && result.equals(real);
    }

    public static List<ProofBean> getProofHashFromXml(File xmlFile) throws CodeException {
        try {
            byte[] sourceData = FileUtils.readFileToByteArray((File)xmlFile);
            ArrayList<ProofBean> resultList = new ArrayList<ProofBean>();
            SAXReader sax = new SAXReader();
            Document document = sax.read((InputStream)new ByteArrayInputStream(sourceData));
            List list = document.selectNodes("/ProofHashXml/Proof");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ProofBean proofBean = new ProofBean();
                Element element = (Element)iter.next();
                String fileName = element.attribute("fileName").getText();
                if (fileName.contains(".pdf")) continue;
                String hash = element.attribute("hash").getText();
                proofBean.setFileName(fileName);
                proofBean.setHash(hash);
                resultList.add(proofBean);
            }
            return resultList;
        }
        catch (Exception e) {
            throw new CodeException("600646", e);
        }
    }

    public static Map<String, String> getProofNameAndHashFromXml(File xmlFile) throws CodeException {
        try {
            byte[] sourceData = FileUtils.readFileToByteArray((File)xmlFile);
            HashMap<String, String> proofMap = new HashMap<String, String>();
            SAXReader sax = new SAXReader();
            Document document = sax.read((InputStream)new ByteArrayInputStream(sourceData));
            List list = document.selectNodes("/ProofHashXml/Proof");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ProofBean proofBean = new ProofBean();
                Element element = (Element)iter.next();
                String fileName = element.attribute("fileName").getText();
                if (fileName.contains(".pdf")) continue;
                String hash = element.attribute("hash").getText();
                proofBean.setFileName(fileName);
                proofBean.setHash(hash);
                proofMap.put(fileName, hash);
            }
            return proofMap;
        }
        catch (Exception e) {
            throw new CodeException("600646", e);
        }
    }
}

