/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import java.math.BigInteger;

final class BigIntegers {
    private BigIntegers() {
    }

    static int parseModulusBitLength(BigInteger modulus) throws CardException {
        if (modulus == null) {
            throw new CardParameterException("parseModulusBitLength failure with missing param#modulus");
        }
        int bitLength = 7 + modulus.bitLength() >> 3 << 3;
        if (bitLength < 1024 || bitLength > 4096) {
            throw new CardParameterException("parseModulusBitLength failure with invalid bitLength: " + bitLength);
        }
        return bitLength;
    }

    static int parseModulusBitLength(byte[] c200RKeyData) throws CardException {
        if (c200RKeyData == null) {
            throw new CardParameterException("parseModulusBitLength failure with missing param#c200RKeyData");
        }
        if (c200RKeyData.length < 4) {
            throw new CardParameterException("parseModulusBitLength failure with invalid length param#c200RKeyData");
        }
        int bitLength = (c200RKeyData[2] & 0xFF) << 8 | c200RKeyData[3] & 0xFF;
        if (bitLength < 1024 || bitLength > 4096) {
            throw new CardParameterException("parseModulusBitLength failure with invalid bitLength: " + bitLength);
        }
        return bitLength;
    }

    static BigInteger parseBigInteger(byte[] c200RKeyData, int offset, int length, int bitLengthLimited) throws CardException {
        if (c200RKeyData == null) {
            throw new CardParameterException("parseBigInteger failure with missing param#c200RKeyData");
        }
        if (c200RKeyData.length < offset + length) {
            throw new CardParameterException("parseModulusBitLength failure with less param#c200RKeyData");
        }
        byte[] bytes = new byte[length];
        System.arraycopy(c200RKeyData, offset, bytes, 0, bytes.length);
        BigInteger value = new BigInteger(1, bytes);
        if (value.bitLength() > bitLengthLimited) {
            throw new CardParameterException("invalid bitLength:  " + value.bitLength() + ", limitedBitLength=" + bitLengthLimited);
        }
        return value;
    }

    static void copyBigInteger(String paramName, BigInteger m, int limitedLength, byte[] output, int offset) throws CardException {
        if (m == null || m.bitLength() == 0) {
            throw new CardParameterException("invalid params: " + paramName + " == null or bitsLength ==0");
        }
        int limitedBitsLength = limitedLength << 3;
        if (m.bitLength() > limitedBitsLength) {
            throw new CardParameterException("invalid params: " + paramName + " bitsLength > " + limitedBitsLength);
        }
        byte[] data = cfca.sadk.org.bouncycastle.util.BigIntegers.asUnsignedByteArray(limitedLength, m);
        System.arraycopy(data, 0, output, offset, data.length);
    }

    static int copyBitLength(int bitLength, byte[] output, int offset) throws CardException {
        output[offset++] = 0;
        output[offset++] = 0;
        output[offset++] = (byte)(bitLength >> 8 & 0xFF);
        output[offset++] = (byte)(bitLength & 0xFF);
        return 4;
    }
}

