/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.ssl;

import cfca.paperless.httpframework.utils.CloseUtils;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Locale;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.configuration2.PropertiesConfiguration;

public class SSLManager {
    private static final String KEY_STORE_TYPE_JKS = "JKS";
    private String keyStorePath = null;
    private String keyStorePwd = null;
    private String trustStorePath = null;
    private String trustStorePwd = null;
    private String protocol = "SSL";
    public static final String IBM_X509 = "IBMX509";
    public static final String IBMJSSE2 = "IBMJSSE2";
    public static final String SUN = "SUN";
    public static final String HEWLETT = "HEWLETT";
    private SSLContext context = null;

    public SSLManager(String keyStorePath, String keyStorePwd, String trustStorePath, String trustStorePwd, String protocol) {
        this.keyStorePath = keyStorePath;
        this.keyStorePwd = keyStorePwd;
        this.trustStorePath = trustStorePath;
        this.trustStorePwd = trustStorePwd;
        this.protocol = protocol;
    }

    public SSLManager(PropertiesConfiguration config) {
        this.keyStorePath = config.getString("httpserver.keystorePath");
        this.keyStorePwd = config.getString("httpserver.keystorePwd");
        this.trustStorePath = config.getString("httpserver.truststorePath");
        this.trustStorePwd = config.getString("httpserver.truststorePwd");
        this.protocol = config.getString("httpserver.sslProtocol", this.protocol);
    }

    public SSLContext getSSLContext() throws Exception {
        String vmVender = System.getProperty("java.vm.vendor");
        if (vmVender.toUpperCase(Locale.getDefault()).indexOf("IBM") != -1) {
            this.protocol = "SSL_TLS";
            this.context = SSLContext.getInstance(this.protocol, IBMJSSE2);
        } else {
            this.context = SSLContext.getInstance(this.protocol);
        }
        KeyManager[] kms = this.getKeyManagers();
        TrustManager[] tms = this.getTrustManagers();
        this.context.init(kms, tms, null);
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() throws Exception {
        KeyManager[] keyManagerArray;
        KeyManagerFactory kmFact = null;
        KeyStore ks = null;
        FileInputStream fis = null;
        try {
            KeyManager[] kms;
            kmFact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ks = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            fis = new FileInputStream(this.keyStorePath);
            ks.load(fis, this.keyStorePwd.toCharArray());
            fis.close();
            kmFact.init(ks, this.keyStorePwd.toCharArray());
            keyManagerArray = kms = kmFact.getKeyManagers();
        }
        catch (Throwable throwable) {
            CloseUtils.closeQuietly(fis);
            throw throwable;
        }
        CloseUtils.closeQuietly(fis);
        return keyManagerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] trustManagerArray;
        TrustManagerFactory trustManagerFactory = null;
        KeyStore trustKS = null;
        FileInputStream trustCert = null;
        try {
            TrustManager[] tms;
            trustKS = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            trustCert = new FileInputStream(this.trustStorePath);
            trustKS.load(trustCert, this.trustStorePwd.toCharArray());
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustKS);
            trustManagerArray = tms = trustManagerFactory.getTrustManagers();
        }
        catch (Throwable throwable) {
            CloseUtils.closeQuietly(trustCert);
            throw throwable;
        }
        CloseUtils.closeQuietly(trustCert);
        return trustManagerArray;
    }
}

