/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardRefPrivateKeyParams;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;

public final class RSACardExternalPrivateKey
extends BCRSAPrivateCrtKey
implements RSACardKey {
    private static final long serialVersionUID = -1821426554423688246L;
    final int bitLength;
    final byte[] priKeyData;

    RSACardExternalPrivateKey(byte[] priKeyData) throws CryptoException {
        super(new RSACardRefPrivateKeyParams((byte[])priKeyData).params);
        this.bitLength = RSACardBigIntegers.parseBitLength(priKeyData);
        this.priKeyData = priKeyData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RSACardExternalPrivateKey [bitLength=").append(this.bitLength);
        builder.append(",priKeyMD5").append(NumberHelper.md5(this.priKeyData));
        builder.append(",pubKeyData=").append(Hex.toHexString(this.priKeyData, 0, 1028));
        builder.append("]");
        return builder.toString();
    }

    public boolean isInternalKey() {
        return false;
    }

    public int getKeyIndex() {
        return 0;
    }

    public int modulusBitsLength() {
        return this.bitLength;
    }

    public int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public byte[] keyData() throws CryptoException {
        return (byte[])this.priKeyData.clone();
    }

    public String dumpPublicKey() {
        return "pubKeyData=" + Hex.toHexString(this.priKeyData, 0, 1028);
    }
}

