/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import java.io.IOException;
import java.security.PrivateKey;

public final class ECCCardInternalPrivateKey
implements ECKey,
ECCCardKey,
PrivateKey {
    private static final long serialVersionUID = 661739263234396995L;
    private final ECCCurveId curveId;
    private final int keyIndex;
    private final int keyUsage;
    private final ECCCardPublicKey pubKey;

    public ECCCardInternalPrivateKey(int keyIndex, int keyUsage, ECCCardPublicKey pubKey) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("ECCCardInternalPrivateKey invalid keyIndex = " + keyIndex);
        }
        if (pubKey == null) {
            throw new CryptoParameterException("ECCCardInternalPrivateKey invalid pubKey = null");
        }
        this.curveId = pubKey.getCurveId();
        this.keyIndex = keyIndex;
        this.keyUsage = keyUsage;
        this.pubKey = pubKey;
    }

    public boolean isInternalKey() {
        return true;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public ECCCurveId getCurveId() {
        return this.curveId;
    }

    public int getCurveBitLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBitLength();
    }

    public int getCurveByteLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBytesLength();
    }

    public byte[] keyData() throws CryptoException {
        throw new CryptoException("ECCCardInternalPrivateKey not support keyData()");
    }

    public String dumpPublicKey() {
        return this.pubKey == null ? null : this.pubKey.dumpPublicKey();
    }

    public byte[] getPubX() {
        return this.pubKey == null ? null : this.pubKey.getPubX();
    }

    public byte[] getPubY() {
        return this.pubKey == null ? null : this.pubKey.getPubY();
    }

    public byte[] getPubH() {
        return this.pubKey == null ? null : this.pubKey.getPubH();
    }

    public String getAlgorithm() {
        return "ECC";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public ECParameterSpec getParams() {
        return this.pubKey == null ? null : this.pubKey.getParameters();
    }

    public ECParameterSpec getParameters() {
        return this.pubKey == null ? null : this.pubKey.getParameters();
    }

    public byte[] getEncoded() {
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERUTF8String("ECC"));
            v.add(new ASN1Integer(this.keyIndex));
            v.add(new ASN1Integer(this.keyUsage));
            v.add(new ASN1Integer(this.curveId.getCurveId()));
            v.add(new ASN1Integer(this.pubKey.getPubX()));
            v.add(new ASN1Integer(this.pubKey.getPubY()));
            DERSequence value = new DERSequence(v);
            return value.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("ECCCardInternalPrivateKey getEncoded() failed", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCCardInternalPrivateKey [curveId=").append((Object)this.curveId);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",defZ=").append(DataHelper.toHexString(this.getPubH()));
        builder.append("]");
        return builder.toString();
    }
}

