/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.geom.Vector;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasTag;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.seal.base.util.KMPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class OldKeywordLocationExtractionStrategy
implements ILocationExtractionStrategy {
    private int[] kmpnext = null;
    private String originKeyword = null;
    private static boolean DUMP_STATE = false;
    private static final float DIACRITICAL_MARKS_ALLOWED_VERTICAL_DEVIATION = 2.0f;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final ITextChunkLocationStrategy tclStrat;
    private boolean useActualText = false;
    private boolean rightToLeftRunDirection = false;
    private TextRenderInfo lastTextRenderInfo;
    private static final float ROTATION_PRECISION = 0.001f;

    public OldKeywordLocationExtractionStrategy() {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public OldKeywordLocationExtractionStrategy(String keyword, int[] kmpnext, String originKeyword) {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
        this.kmpnext = kmpnext;
        this.originKeyword = originKeyword;
    }

    public OldKeywordLocationExtractionStrategy(ITextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    public OldKeywordLocationExtractionStrategy setUseActualText(boolean useActualText) {
        this.useActualText = useActualText;
        return this;
    }

    public OldKeywordLocationExtractionStrategy setRightToLeftRunDirection(boolean rightToLeftRunDirection) {
        this.rightToLeftRunDirection = rightToLeftRunDirection;
        return this;
    }

    public boolean isUseActualText() {
        return this.useActualText;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            if (renderInfo.getRise() != 0.0f) {
                Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
                segment = segment.transformBy(riseOffsetTransform);
            }
            if (this.useActualText) {
                CanvasTag lastTagWithActualText;
                CanvasTag canvasTag = lastTagWithActualText = this.lastTextRenderInfo != null ? this.findLastTagWithActualText(this.lastTextRenderInfo.getCanvasTagHierarchy()) : null;
                if (lastTagWithActualText != null && lastTagWithActualText == this.findLastTagWithActualText(renderInfo.getCanvasTagHierarchy())) {
                    TextChunk lastTextChunk = this.locationalResult.get(this.locationalResult.size() - 1);
                    Vector mergedStart = new Vector(Math.min(lastTextChunk.getLocation().getStartLocation().get(0), segment.getStartPoint().get(0)), Math.min(lastTextChunk.getLocation().getStartLocation().get(1), segment.getStartPoint().get(1)), Math.min(lastTextChunk.getLocation().getStartLocation().get(2), segment.getStartPoint().get(2)));
                    Vector mergedEnd = new Vector(Math.max(lastTextChunk.getLocation().getEndLocation().get(0), segment.getEndPoint().get(0)), Math.max(lastTextChunk.getLocation().getEndLocation().get(1), segment.getEndPoint().get(1)), Math.max(lastTextChunk.getLocation().getEndLocation().get(2), segment.getEndPoint().get(2)));
                    TextChunk merged = new TextChunk(lastTextChunk.getText(), this.tclStrat.createLocation(renderInfo, new LineSegment(mergedStart, mergedEnd)));
                    this.locationalResult.set(this.locationalResult.size() - 1, merged);
                } else {
                    String actualText = renderInfo.getActualText();
                    TextChunk tc = new TextChunk(actualText != null ? actualText : renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                    this.locationalResult.add(tc);
                }
            } else {
                TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment), renderInfo.getFont(), segment, renderInfo.getAscentLine(), renderInfo.getDescentLine());
                this.locationalResult.add(tc);
            }
            this.lastTextRenderInfo = renderInfo;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>(this.locationalResult);
        this.sortWithMarks(textChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : textChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    private boolean startsWithSpace(String str) {
        return str.length() != 0 && str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        return str.length() != 0 && str.charAt(str.length() - 1) == ' ';
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
        }
    }

    private CanvasTag findLastTagWithActualText(List<CanvasTag> canvasTagHierarchy) {
        CanvasTag lastActualText = null;
        for (CanvasTag tag : canvasTagHierarchy) {
            if (tag.getActualText() == null) continue;
            lastActualText = tag;
            break;
        }
        return lastActualText;
    }

    private void sortWithMarks(List<TextChunk> textChunks) {
        HashMap<TextChunk, TextChunkMarks> marks = new HashMap<TextChunk, TextChunkMarks>();
        ArrayList<TextChunk> toSort = new ArrayList<TextChunk>();
        for (int markInd = 0; markInd < textChunks.size(); ++markInd) {
            ITextChunkLocation location = textChunks.get(markInd).getLocation();
            if (location.getStartLocation().equals(location.getEndLocation())) {
                boolean foundBaseToAttachTo = false;
                for (int baseInd = 0; baseInd < textChunks.size(); ++baseInd) {
                    ITextChunkLocation baseLocation;
                    if (markInd == baseInd || (baseLocation = textChunks.get(baseInd).getLocation()).getStartLocation().equals(baseLocation.getEndLocation()) || !this.containsMark(baseLocation, location)) continue;
                    TextChunkMarks currentMarks = (TextChunkMarks)marks.get(textChunks.get(baseInd));
                    if (currentMarks == null) {
                        currentMarks = new TextChunkMarks();
                        marks.put(textChunks.get(baseInd), currentMarks);
                    }
                    if (markInd < baseInd) {
                        currentMarks.preceding.add(textChunks.get(markInd));
                    } else {
                        currentMarks.succeeding.add(textChunks.get(markInd));
                    }
                    foundBaseToAttachTo = true;
                    break;
                }
                if (foundBaseToAttachTo) continue;
                toSort.add(textChunks.get(markInd));
                continue;
            }
            toSort.add(textChunks.get(markInd));
        }
        if (this.rightToLeftRunDirection) {
            Collections.sort(toSort, new TextChunkComparator(new TextChunkLocationComparator(false)));
        } else {
            Collections.sort(toSort);
        }
        textChunks.clear();
        for (TextChunk current : toSort) {
            int j;
            TextChunkMarks currentMarks = (TextChunkMarks)marks.get(current);
            if (currentMarks != null) {
                if (!this.rightToLeftRunDirection) {
                    for (j = 0; j < currentMarks.preceding.size(); ++j) {
                        textChunks.add(currentMarks.preceding.get(j));
                    }
                } else {
                    for (j = currentMarks.succeeding.size() - 1; j >= 0; --j) {
                        textChunks.add(currentMarks.succeeding.get(j));
                    }
                }
            }
            textChunks.add(current);
            if (currentMarks == null) continue;
            if (!this.rightToLeftRunDirection) {
                for (j = 0; j < currentMarks.succeeding.size(); ++j) {
                    textChunks.add(currentMarks.succeeding.get(j));
                }
                continue;
            }
            for (j = currentMarks.preceding.size() - 1; j >= 0; --j) {
                textChunks.add(currentMarks.preceding.get(j));
            }
        }
    }

    private boolean containsMark(ITextChunkLocation baseLocation, ITextChunkLocation markLocation) {
        return baseLocation.getStartLocation().get(0) <= markLocation.getStartLocation().get(0) && baseLocation.getEndLocation().get(0) >= markLocation.getEndLocation().get(0) && (float)Math.abs(baseLocation.distPerpendicular() - markLocation.distPerpendicular()) <= 2.0f;
    }

    @Override
    public Collection<IPdfTextLocation> getResultantLocations() {
        HashMap<Integer, Integer> chunkPositions = new HashMap<Integer, Integer>();
        StringBuilder sb = new StringBuilder();
        ArrayList<IPdfTextLocation> retval = new ArrayList();
        int totalChars = 0;
        for (int i = 0; i < this.locationalResult.size(); ++i) {
            TextChunk chunk = this.locationalResult.get(i);
            String text = chunk.getText();
            sb.append(text);
            for (int j = 0; j < text.length(); ++j) {
                chunkPositions.put(totalChars, i);
                ++totalChars;
            }
        }
        retval = this.getKeywordList(sb.toString(), chunkPositions);
        Collections.sort(retval, new Comparator<IPdfTextLocation>(){

            @Override
            public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
                Vector orientationVector = l1.getOrientationVector();
                Rectangle o1 = l1.getRectangle();
                Rectangle o2 = l2.getRectangle();
                if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) {
                    if (o1.getY() == o2.getY()) {
                        return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? -1 : 1);
                    }
                    return o1.getY() < o2.getY() ? 1 : -1;
                }
                if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                    if (o1.getX() == o2.getX()) {
                        return o1.getY() == o2.getY() ? 0 : (o1.getY() < o2.getY() ? -1 : 1);
                    }
                    return o1.getX() < o2.getX() ? -1 : 1;
                }
                if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                    if (o1.getY() == o2.getY()) {
                        return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? 1 : -1);
                    }
                    return o1.getY() < o2.getY() ? -1 : 1;
                }
                if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                    if (o1.getX() == o2.getX()) {
                        return o1.getY() == o2.getY() ? 0 : (o1.getY() < o2.getY() ? 1 : -1);
                    }
                    return o1.getX() < o2.getX() ? 1 : -1;
                }
                return 0;
            }
        });
        this.reset();
        return retval;
    }

    private List<IPdfTextLocation> getKeywordList(String pageWords, HashMap<Integer, Integer> chunkPositions) {
        boolean flag = true;
        ArrayList<IPdfTextLocation> retval = new ArrayList<IPdfTextLocation>();
        String sourceStr = pageWords;
        int charLastIndex = 0;
        int markChunkIndex = -1;
        while (flag) {
            TextChunk firstChunk;
            int charStartIndex = KMPUtil.kmp(sourceStr, this.originKeyword, this.kmpnext);
            if (charStartIndex == -1) {
                flag = false;
                continue;
            }
            charStartIndex = charLastIndex + charStartIndex;
            int charEndIndex = charStartIndex + this.kmpnext.length;
            int chunkStartIndex = charStartIndex;
            try {
                chunkStartIndex = chunkPositions.get(charStartIndex);
            }
            catch (NullPointerException e) {
                chunkStartIndex = chunkPositions.get(charStartIndex - 1);
            }
            if (chunkStartIndex <= markChunkIndex) {
                charLastIndex = charEndIndex;
                sourceStr = pageWords.substring(charEndIndex);
                continue;
            }
            markChunkIndex = chunkStartIndex;
            int chunkEndIndex = chunkStartIndex;
            if (this.kmpnext.length != 1) {
                chunkEndIndex = charEndIndex - 1;
                try {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex);
                }
                catch (NullPointerException e) {
                    chunkEndIndex = chunkPositions.get(chunkEndIndex + 1);
                }
            } else {
                chunkEndIndex = chunkPositions.get(charEndIndex - 1);
            }
            if ("".equals((firstChunk = this.locationalResult.get(0)).getText().trim())) {
                int size = this.locationalResult.size();
                for (int i = 1; i < size && "".equals((firstChunk = this.locationalResult.get(i)).getText().trim()); ++i) {
                }
            }
            TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
            Vector orientationVector = textChunkLocation.getOrientationVector();
            for (Rectangle r : this.getKeywordRectangleList(this.getSubChunkList(this.locationalResult, chunkStartIndex, chunkEndIndex))) {
                retval.add(new DefaultPdfTextLocation(0, r, this.originKeyword, orientationVector));
            }
            charLastIndex = charEndIndex;
            sourceStr = pageWords.substring(charEndIndex);
        }
        return retval;
    }

    protected List<TextChunk> getSubChunkList(List<TextChunk> chunkList, int startIndex, int endIndex) {
        ArrayList<TextChunk> subChunkList = new ArrayList<TextChunk>();
        TextChunk lastChunk = chunkList.get(startIndex);
        subChunkList.add(lastChunk);
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            TextChunk curChunk = chunkList.get(i);
            subChunkList.add(curChunk);
            lastChunk = curChunk;
        }
        return subChunkList;
    }

    protected List<Rectangle> getKeywordRectangleList(List<TextChunk> cris) {
        ArrayList<Rectangle> retval = new ArrayList<Rectangle>();
        if (cris.isEmpty()) {
            return retval;
        }
        int chunkSize = cris.size();
        TextChunk firstChunk = cris.get(0);
        TextChunk lastChunk = cris.get(chunkSize - 1);
        Rectangle firstRectangle = firstChunk.getRectangle();
        Rectangle lastRectangle = lastChunk.getRectangle();
        if (chunkSize > 1) {
            TextChunkLocationDefaultImp textChunkLocation;
            Vector orientationVector;
            TextChunk tmpChunk;
            PdfFont pdfFont = firstChunk.getPdfFont();
            LineSegment ascentLine = firstChunk.getAscentLine();
            LineSegment descentLine = firstChunk.getDescentLine();
            boolean hasSameLineChunk = false;
            for (int i = 1; i < chunkSize && this.isSameLine(firstChunk, tmpChunk = cris.get(i)); ++i) {
                lastChunk = tmpChunk;
                hasSameLineChunk = true;
            }
            if (!hasSameLineChunk) {
                lastChunk = firstChunk;
            }
            if (Math.abs((orientationVector = (textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation()).getOrientationVector()).get(0) - 1.0f) < 0.001f) {
                float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                float fontSize = ascentLine.getStartPoint().get(1) - descentLine.getStartPoint().get(1);
                Rectangle keywordRect = this.getKeywordRect(0, chunkWidth, firstChunk, lastChunk, pdfFont, fontSize);
                retval.add(keywordRect);
            } else if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                float chunkHeight = lastRectangle.getY() - firstRectangle.getY() + lastRectangle.getHeight();
                float fontSize = descentLine.getStartPoint().get(0) - ascentLine.getStartPoint().get(0);
                Rectangle keywordRect = this.getKeywordRect(90, chunkHeight, firstChunk, lastChunk, pdfFont, fontSize);
                float w = keywordRect.getWidth();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), -w, keywordRect.getHeight()));
            } else if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                float fontSize = descentLine.getStartPoint().get(1) - ascentLine.getStartPoint().get(1);
                Rectangle keywordRect = this.getKeywordRect(180, chunkWidth, firstChunk, lastChunk, pdfFont, fontSize);
                float w = keywordRect.getWidth();
                float h = keywordRect.getHeight();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), -w, -h));
            } else if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                float chunkHeight = firstRectangle.getY() - lastRectangle.getY() + firstRectangle.getHeight();
                float fontSize = ascentLine.getStartPoint().get(0) - descentLine.getStartPoint().get(0);
                Rectangle keywordRect = this.getKeywordRect(270, chunkHeight, firstChunk, lastChunk, pdfFont, fontSize);
                float w = keywordRect.getWidth();
                retval.add(new Rectangle(keywordRect.getX(), keywordRect.getY(), w, -keywordRect.getHeight()));
            }
        } else {
            LineSegment ascentLine = firstChunk.getAscentLine();
            LineSegment descentLine = firstChunk.getDescentLine();
            TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
            Vector orientationVector = textChunkLocation.getOrientationVector();
            if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) {
                float h = ascentLine.getStartPoint().get(1) - descentLine.getStartPoint().get(1);
                this.getKeywordRect(0, retval, firstChunk, h);
            } else if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                float h = descentLine.getStartPoint().get(0) - ascentLine.getStartPoint().get(0);
                this.getKeywordRect(90, retval, firstChunk, h);
            } else if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                float h = descentLine.getStartPoint().get(1) - ascentLine.getStartPoint().get(1);
                this.getKeywordRect(180, retval, firstChunk, h);
            } else if (Math.abs(orientationVector.get(1) + 1.0f) < 0.001f) {
                float h = ascentLine.getStartPoint().get(0) - descentLine.getStartPoint().get(0);
                this.getKeywordRect(270, retval, firstChunk, h);
            }
        }
        return retval;
    }

    private Rectangle getKeywordRect(int rotation, float chunkWidth, TextChunk firstChunk, TextChunk lastChunk, PdfFont pdfFont, float fontSize) {
        Rectangle firstRectangle = firstChunk.getRectangle();
        Rectangle lastRectangle = lastChunk.getRectangle();
        String first1String = this.originKeyword.substring(0, 1);
        String firstChunkText = firstChunk.getText();
        int offsetOfKeywordInFirstChunk = firstChunkText.lastIndexOf(first1String);
        float offsetPoundsFirst = 0.0f;
        if (offsetOfKeywordInFirstChunk != -1) {
            String stringBeforeKeyword = firstChunkText.substring(0, offsetOfKeywordInFirstChunk);
            offsetPoundsFirst = pdfFont.getWidth(stringBeforeKeyword, fontSize);
        }
        int offsetOfKeywordInLastChunk = -1;
        String lastChunkText = lastChunk.getText();
        if (!firstRectangle.equalsWithEpsilon(lastRectangle)) {
            String last1String = this.originKeyword.substring(this.kmpnext.length - 1);
            offsetOfKeywordInLastChunk = lastChunkText.indexOf(last1String);
        }
        float offsetPoundsLast = 0.0f;
        if (offsetOfKeywordInLastChunk != -1) {
            String stringAfterKeyword = lastChunkText.substring(offsetOfKeywordInLastChunk + 1);
            offsetPoundsLast = pdfFont.getWidth(stringAfterKeyword, fontSize);
        }
        offsetPoundsFirst = (int)(offsetPoundsFirst + 0.5f);
        offsetPoundsLast = (int)(offsetPoundsLast + 0.5f);
        chunkWidth = lastRectangle.getX() - firstRectangle.getX() > 2.0f ? lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth() : Math.abs(lastRectangle.getY() - firstRectangle.getY()) + lastRectangle.getWidth();
        float x = firstRectangle.getX() + offsetPoundsFirst;
        float y = firstRectangle.getY();
        float w = Math.abs(chunkWidth) - offsetPoundsFirst - offsetPoundsLast;
        float h = firstRectangle.getHeight();
        if (rotation == 90) {
            w = Math.abs(firstRectangle.getHeight());
            h = Math.abs(chunkWidth - offsetPoundsFirst - offsetPoundsLast);
        } else if (rotation == 180) {
            x = firstRectangle.getX() - offsetPoundsFirst;
        } else if (rotation == 270) {
            w = Math.abs(firstRectangle.getHeight());
            h = Math.abs(chunkWidth - offsetPoundsFirst - offsetPoundsLast);
        }
        return new Rectangle(x, y, w, h);
    }

    private void getKeywordRect(int rotation, List<Rectangle> retval, TextChunk firstChunk, float fontSize) {
        String originFirstChunkText;
        boolean flag = true;
        float offsetPounds = 0.0f;
        int offsetStartIndex = 0;
        Rectangle firstRectangle = firstChunk.getRectangle();
        PdfFont pdfFont = firstChunk.getPdfFont();
        String firstChunkText = originFirstChunkText = firstChunk.getText();
        String firstKey = this.originKeyword.substring(0, 1);
        while (flag) {
            if (!firstChunkText.equals("")) {
                float y;
                float x;
                String replacedText = firstChunkText;
                int startIndex = KMPUtil.kmp(replacedText, this.originKeyword, this.kmpnext);
                if (startIndex == -1) {
                    flag = false;
                    break;
                }
                String stringBeforeKeyword = originFirstChunkText.substring(0, startIndex + offsetStartIndex);
                if (firstChunkText.length() != replacedText.length()) {
                    String stringAfterKeyword = firstChunkText.substring(startIndex);
                    int firstKeyIndex = stringAfterKeyword.indexOf(firstKey);
                    stringBeforeKeyword = originFirstChunkText.substring(0, (startIndex += firstKeyIndex) + offsetStartIndex);
                }
                offsetPounds = pdfFont.getWidth(stringBeforeKeyword, fontSize);
                offsetPounds = (int)(offsetPounds + 0.5f);
                float w = pdfFont.getWidth(this.originKeyword, fontSize);
                if (rotation == 90) {
                    x = firstRectangle.getX();
                    y = firstRectangle.getY() + offsetPounds;
                    retval.add(new Rectangle(x, y, -fontSize, w));
                } else if (rotation == 180) {
                    x = firstRectangle.getX() - offsetPounds;
                    y = firstRectangle.getY();
                    retval.add(new Rectangle(x, y, -w, -fontSize));
                } else {
                    x = firstRectangle.getX() + offsetPounds;
                    y = firstRectangle.getY();
                    retval.add(new Rectangle(x, y, w, fontSize));
                }
                offsetStartIndex = startIndex + offsetStartIndex + this.kmpnext.length;
                if (offsetStartIndex > originFirstChunkText.length()) {
                    offsetStartIndex = originFirstChunkText.length();
                }
                firstChunkText = originFirstChunkText.substring(offsetStartIndex);
                continue;
            }
            flag = false;
            break;
        }
    }

    private boolean isSameLine(TextChunk firstChunk, TextChunk secondChunk) {
        boolean sameLine = firstChunk.sameLine(secondChunk);
        return sameLine;
    }

    public void reset() {
        this.locationalResult.clear();
    }

    private static class TextChunkMarks {
        List<TextChunk> preceding = new ArrayList<TextChunk>();
        List<TextChunk> succeeding = new ArrayList<TextChunk>();

        private TextChunkMarks() {
        }
    }

    private static class TextChunkLocationComparator
    implements Comparator<ITextChunkLocation> {
        private boolean leftToRight = true;

        public TextChunkLocationComparator() {
        }

        public TextChunkLocationComparator(boolean leftToRight) {
            this.leftToRight = leftToRight;
        }

        @Override
        public int compare(ITextChunkLocation first, ITextChunkLocation second) {
            int result;
            int m2;
            if (first == second) {
                return 0;
            }
            int m1 = first.orientationMagnitude();
            int n = m1 < (m2 = second.orientationMagnitude()) ? -1 : (result = m1 == m2 ? 0 : 1);
            if (result != 0) {
                return result;
            }
            int distPerpendicularDiff = first.distPerpendicular() - second.distPerpendicular();
            if (distPerpendicularDiff != 0) {
                return distPerpendicularDiff;
            }
            return this.leftToRight ? Float.compare(first.distParallelStart(), second.distParallelStart()) : -Float.compare(first.distParallelEnd(), second.distParallelEnd());
        }
    }

    private static class TextChunkComparator
    implements Comparator<TextChunk> {
        private Comparator<ITextChunkLocation> locationComparator;

        public TextChunkComparator(Comparator<ITextChunkLocation> locationComparator) {
            this.locationComparator = locationComparator;
        }

        @Override
        public int compare(TextChunk o1, TextChunk o2) {
            return this.locationComparator.compare(o1.location, o2.location);
        }
    }

    public static class TextChunkLocationDefaultImp
    implements ITextChunkLocation {
        private static final TextChunkLocationComparator defaultComparator = new TextChunkLocationComparator();
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;

        public TextChunkLocationDefaultImp(Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        @Override
        public int orientationMagnitude() {
            return this.orientationMagnitude;
        }

        @Override
        public int distPerpendicular() {
            return this.distPerpendicular;
        }

        @Override
        public float distParallelStart() {
            return this.distParallelStart;
        }

        @Override
        public float distParallelEnd() {
            return this.distParallelEnd;
        }

        @Override
        public Vector getStartLocation() {
            return this.startLocation;
        }

        @Override
        public Vector getEndLocation() {
            return this.endLocation;
        }

        @Override
        public Vector getOrientationVector() {
            return this.orientationVector;
        }

        @Override
        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        @Override
        public boolean sameLine(ITextChunkLocation as) {
            if (this.orientationMagnitude() != as.orientationMagnitude()) {
                return false;
            }
            float distPerpendicularDiff = this.distPerpendicular() - as.distPerpendicular();
            if (distPerpendicularDiff == 0.0f) {
                return true;
            }
            LineSegment mySegment = new LineSegment(this.startLocation, this.endLocation);
            LineSegment otherSegment = new LineSegment(as.getStartLocation(), as.getEndLocation());
            return Math.abs(distPerpendicularDiff) <= 2.0f && (mySegment.getLength() == 0.0f || otherSegment.getLength() == 0.0f);
        }

        @Override
        public float distanceFromEndOf(ITextChunkLocation other) {
            return this.distParallelStart() - other.distParallelEnd();
        }

        @Override
        public boolean isAtWordBoundary(ITextChunkLocation previous) {
            if (this.getCharSpaceWidth() < 0.1f) {
                return false;
            }
            if (this.startLocation.equals(this.endLocation) || previous.getEndLocation().equals(previous.getStartLocation())) {
                return false;
            }
            float dist = this.distanceFromEndOf(previous);
            return dist < -this.getCharSpaceWidth() || dist > this.getCharSpaceWidth() / 2.0f;
        }

        @Override
        public int compareTo(ITextChunkLocation other) {
            return defaultComparator.compare(this, other);
        }
    }

    public static class TextChunk
    implements Comparable<TextChunk> {
        protected final String text;
        protected final ITextChunkLocation location;
        protected LineSegment baseLine;
        protected LineSegment ascentLine;
        protected LineSegment descentLine;
        protected PdfFont pdfFont;

        public TextChunk(String string, ITextChunkLocation loc) {
            this.text = string;
            this.location = loc;
        }

        public TextChunk(String string, ITextChunkLocation loc, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
            this.text = string;
            this.location = loc;
            this.baseLine = baseLine;
            this.ascentLine = ascentLine;
            this.descentLine = descentLine;
        }

        public TextChunk(String string, ITextChunkLocation loc, PdfFont pdfFont, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
            this.text = string;
            this.location = loc;
            this.pdfFont = pdfFont;
            this.baseLine = baseLine;
            this.ascentLine = ascentLine;
            this.descentLine = descentLine;
        }

        public String getText() {
            return this.text;
        }

        public PdfFont getPdfFont() {
            return this.pdfFont;
        }

        public LineSegment getBaseLine() {
            return this.baseLine;
        }

        public LineSegment getAscentLine() {
            return this.ascentLine;
        }

        public LineSegment getDescentLine() {
            return this.descentLine;
        }

        public ITextChunkLocation getLocation() {
            return this.location;
        }

        public Rectangle getRectangle() {
            float x0 = this.descentLine.getStartPoint().get(0);
            float y0 = this.descentLine.getStartPoint().get(1);
            float h = this.ascentLine.getStartPoint().get(1) - this.descentLine.getStartPoint().get(1);
            float w = Math.abs(this.descentLine.getStartPoint().get(0) - this.descentLine.getEndPoint().get(0));
            if (w == 0.0f) {
                w = h;
            }
            if (w == 0.0f && h == 0.0f) {
                h = this.ascentLine.getStartPoint().get(0) - this.descentLine.getStartPoint().get(0);
                w = Math.abs(this.descentLine.getStartPoint().get(1) - this.descentLine.getEndPoint().get(1));
            }
            Rectangle chunkRectangle = new Rectangle(x0, y0, w, h);
            return chunkRectangle;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            return this.location.compareTo(rhs.location);
        }

        void printDiagnostics() {
            System.out.println("Text (@" + this.location.getStartLocation() + " -> " + this.location.getEndLocation() + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.location.orientationMagnitude());
            System.out.println("distPerpendicular: " + this.location.distPerpendicular());
            System.out.println("distParallel: " + this.location.distParallelStart());
        }

        boolean sameLine(TextChunk lastChunk) {
            return this.getLocation().sameLine(lastChunk.getLocation());
        }
    }

    public static interface ITextChunkLocation
    extends Comparable<ITextChunkLocation> {
        public float distParallelEnd();

        public float distParallelStart();

        public int distPerpendicular();

        public float getCharSpaceWidth();

        public Vector getEndLocation();

        public Vector getStartLocation();

        public Vector getOrientationVector();

        public int orientationMagnitude();

        public boolean sameLine(ITextChunkLocation var1);

        public float distanceFromEndOf(ITextChunkLocation var1);

        public boolean isAtWordBoundary(ITextChunkLocation var1);
    }

    public static interface ITextChunkLocationStrategy {
        public ITextChunkLocation createLocation(TextRenderInfo var1, LineSegment var2);
    }
}

