/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.JsonUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean isContainChinese(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean validateStrMaxLength(String str, int length) {
        if (StringUtil.isEmpty(str)) {
            return true;
        }
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < str.length(); ++i) {
            String temp = str.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return length >= valueLength;
    }

    public static String bytes2hex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                b = "0" + b;
            }
            result.append(b);
        }
        return result.toString().toUpperCase();
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNotEmptyAndNull(String str) {
        return str != null && !"".equals(str.trim()) && !"null".equals(str.trim().toLowerCase());
    }

    public static String getNodeText(String xmlString, String nodeName) {
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int beginIndex = xmlString.indexOf(beginName);
        if (beginIndex == -1) {
            return "";
        }
        int endIndex = xmlString.indexOf(endName);
        if (endIndex == -1) {
            return "";
        }
        String nodeValue = xmlString.substring(beginIndex + beginName.length(), endIndex);
        return nodeValue;
    }

    public static List<String> getNodeTextList(String xmlString, String nodeName) {
        ArrayList<String> itemList = new ArrayList<String>();
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int fromStart = 0;
        int beginIndex = xmlString.indexOf(beginName, fromStart);
        int endIndex = xmlString.indexOf(endName, beginIndex);
        while (beginIndex != -1 && endIndex != -1) {
            String nodeValue = xmlString.substring(beginIndex + beginName.length(), endIndex);
            itemList.add(nodeValue);
            fromStart = endIndex;
            beginIndex = xmlString.indexOf(beginName, fromStart);
            endIndex = xmlString.indexOf(endName, beginIndex);
        }
        return itemList;
    }

    public static String[] toStringItemArray(String message) {
        if (message == null || message.length() == 0) {
            return new String[0];
        }
        int length = message.length();
        String[] itemArray = new String[length];
        for (int i = 0; i < length; ++i) {
            itemArray[i] = String.valueOf(message.charAt(i));
        }
        return itemArray;
    }

    public static void appendXmlNode(StringBuffer stringBuffer, String nodeName, String value) {
        if (value == null) {
            value = "";
        }
        stringBuffer.append('<').append(nodeName).append('>').append(value).append("</").append(nodeName).append('>');
    }

    public static boolean isPositiveNumeric(String str) {
        String regString = "^[0-9]+([.]{1}[0-9]+){0,1}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isNumeric(String str) {
        String regString = "^[-]{0,1}[0-9]+([.]{1}[0-9]+){0,1}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isNaturalNumber(String str) {
        String regString = "^[0-9]{1}[0-9]{0,}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isNaturalNumber(String str, int n) {
        String regString = "^[0-9]{1}[0-9]{0," + (n - 1) + "}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isPositiveNumber(String str, int n) {
        String regString = "^[1-9]{1}[0-9]{0," + (n - 1) + "}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isColorNumber(String str) {
        String regString = "^[0-9a-fA-F]{6}$";
        Pattern pattern = Pattern.compile(regString);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String formatIssuerKey(String issuer) {
        return StringUtil.formatSubject(issuer).replaceAll(" ", "_").toLowerCase();
    }

    public static String formatSubject(String dn) {
        dn = StringUtil.clearSpace(dn, ",");
        dn = StringUtil.clearSpace(dn, "=");
        return dn;
    }

    public static String clearSpace(String target, String operator) {
        String[] items = target.split(operator);
        StringBuffer result = new StringBuffer();
        for (String item : items) {
            result.append(operator + item.trim());
        }
        return result.toString().substring(1);
    }

    public static String trim(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return string.trim();
    }

    public static byte[] digest(byte[] source) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(source);
        return md.digest();
    }

    public static String mapToStr(Map<String, String> map) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.append(entry.getValue()).append("=").append(entry.getValue()).append(",");
            }
        }
        result.delete(result.length() - 1, result.length());
        result.append(")");
        return result.toString();
    }

    public static String byteToUTFString(byte[] data) throws CodeException {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CodeException("600712", "\u5b57\u8282\u6d41\u8f6c\u5b57\u7b26\u4e32\u9519\u8bef," + e.getMessage(), (Throwable)e);
        }
    }

    public static String toJSONString(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return JsonUtil.obj2Json(object);
        }
        catch (Exception e) {
            return object.toString();
        }
    }

    public static boolean containsUCS4Glyph(String content) {
        boolean containUcs4 = false;
        if (null != content) {
            for (int i = 0; i < content.length(); ++i) {
                if (content.codePointAt(i) == content.charAt(i)) continue;
                containUcs4 = true;
                break;
            }
        }
        return containUcs4;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.isNumeric("-1100"));
    }
}

