/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.sample.sfview;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.FontFactory;
import cfca.com.google.typography.font.sfntly.sample.sfview.SFFontView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class SFView {
    public static void main(String[] args) throws IOException {
        for (String fontName : args) {
            System.out.println("Displaying font: " + fontName);
            Font[] fonts = SFView.loadFont(new File(fontName));
            if (fonts == null) continue;
            for (Font font : fonts) {
                JFrame jf = new JFrame("Sfntly Table Viewer");
                jf.setDefaultCloseOperation(3);
                SFFontView view = new SFFontView(font);
                JScrollPane sp = new JScrollPane(view);
                jf.add(sp);
                jf.pack();
                jf.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font[] loadFont(File file) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(true);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Font[] fontArray = fontFactory.loadFonts(is);
            return fontArray;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not load the font: " + file.getName());
            Font[] fontArray = null;
            return fontArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

