/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.tls.java.util.CFCASSLConstants;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.javax.net.ssl.CFCAX509ExtendedTrustManager;
import cfca.sadk.tls.sun.security.ssl.Alerts;
import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.Handshaker;
import cfca.sadk.tls.sun.security.ssl.ProtocolList;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.SSLContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSocketImpl;
import cfca.sadk.tls.sun.security.ssl.SessionId;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.extension.RenegotiationInfoExtension;
import cfca.sadk.tls.sun.security.ssl.extension.ServerNameExtension;
import cfca.sadk.tls.sun.security.ssl.extension.SignatureAlgorithmsExtension;
import cfca.sadk.tls.sun.security.ssl.message.CertificateMsg;
import cfca.sadk.tls.sun.security.ssl.message.CertificateRequest;
import cfca.sadk.tls.sun.security.ssl.message.CertificateVerify;
import cfca.sadk.tls.sun.security.ssl.message.ClientHello;
import cfca.sadk.tls.sun.security.ssl.message.ClientKeyExchange;
import cfca.sadk.tls.sun.security.ssl.message.Finished;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.message.HelloRequest;
import cfca.sadk.tls.sun.security.ssl.message.ServerHello;
import cfca.sadk.tls.sun.security.ssl.message.ServerHelloDone;
import cfca.sadk.tls.sun.security.ssl.message.ServerKeyExchange;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.ECDHCrypt;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.TLSCredentials;
import cfca.sadk.tls.util.Utilities;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverSignerKey;
    private PublicKey serverCipherKey;
    private PublicKey serverEphemeralKey;
    private ECDHCrypt ecdh;
    private CertificateRequest certRequest;
    private ProtocolVersion maxProtocolVersion;
    private static final boolean enableSNIExtension = CFCASSLConstants.enableSNIExtension;
    private List<CFCASNIServerName> serverNamesRequested = Collections.emptyList();
    private boolean serverNamesAccepted = false;

    ClientHandshaker(SSLSocketImpl socket, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(socket, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    ClientHandshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        super(engine, context, enabledProtocols, true, true, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    @Override
    final void processMessage(byte type, int messageLen) throws IOException {
        if (this.state >= type && type != 0) {
            throw new SSLProtocolException("Handshake message sequence violation, " + type);
        }
        switch (type) {
            case 0: {
                this.serverHelloRequest(new HelloRequest(this.in));
                break;
            }
            case 2: {
                this.serverHello(new ServerHello(this.in, messageLen));
                break;
            }
            case 11: {
                this.serverCertificate(new CertificateMsg(this.in));
                if (this.session.getPeerSignerCredentials() == null) {
                    throw new SSLProtocolException("Illegal client handshake msg, missing PeerSignerCredentials for certificates");
                }
                if (this.session.getPeerCipherCredentials() == null) {
                    throw new SSLProtocolException("Illegal client handshake msg, missing PeerCipherCredentials for certificates");
                }
                this.serverSignerKey = this.session.getPeerSignerCredentials().publicKey;
                this.serverCipherKey = this.session.getPeerCipherCredentials().publicKey;
                break;
            }
            case 12: {
                this.serverKeyExchange(messageLen);
                break;
            }
            case 13: {
                this.certificateRequest(this.in, this.beingProtocolVersion);
                break;
            }
            case 14: {
                this.serverHelloDone(new ServerHelloDone(this.in));
                break;
            }
            case 20: {
                this.serverFinished(new Finished(this.beingProtocolVersion, this.in, this.cipherSuite));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + type);
            }
        }
        if (this.state < type) {
            this.state = type;
        }
    }

    private void serverHelloRequest(HelloRequest mesg) throws IOException {
        Debugger.debug(mesg);
        if (this.state < 1) {
            if (!this.secureRenegotiation && !allowUnsafeRenegotiation) {
                this.warningSE((byte)100);
                this.invalidated = true;
            } else {
                if (!this.secureRenegotiation) {
                    Debugger.handshaker.debug("Warning: continue with insecure renegotiation");
                }
                this.kickstart();
            }
        }
    }

    private void serverHello(ServerHello mesg) throws IOException {
        Debugger.debug(mesg);
        ProtocolVersion mesgVersion = mesg.getServerVersion();
        if (!this.isNegotiable(mesgVersion)) {
            throw new SSLHandshakeException("Server chose " + mesgVersion + ", but that protocol version is not enabled or not supported " + "by the client.");
        }
        this.handshakeHash.protocolDetermined(mesgVersion);
        this.setBeingVersion(mesgVersion);
        RenegotiationInfoExtension serverHelloRI = (RenegotiationInfoExtension)mesg.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO);
        if (serverHelloRI != null) {
            if (this.isInitialHandshake) {
                if (!serverHelloRI.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "Unexpected renegotiation indication extension");
                }
                byte[] verifyData = new byte[this.clientVerifyData.length + this.serverVerifyData.length];
                System.arraycopy(this.clientVerifyData, 0, verifyData, 0, this.clientVerifyData.length);
                System.arraycopy(this.serverVerifyData, 0, verifyData, this.clientVerifyData.length, this.serverVerifyData.length);
                if (!Utilities.equals(verifyData, serverHelloRI.getData())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (this.isInitialHandshake) {
            if (!allowLegacyHelloMessages) {
                this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            this.secureRenegotiation = false;
            Debugger.handshaker.debug("Warning: No renegotiation indication extension in ServerHello");
        } else if (this.secureRenegotiation) {
            this.fatalSE((byte)40, "No renegotiation indication extension");
        }
        this.serverRandom = mesg.getServerRandom();
        if (!this.isNegotiable(mesg.getCipherSuite())) {
            this.fatalSE((byte)47, "Server selected improper ciphersuite " + mesg.getCipherSuite());
        }
        this.setBeingCipherSuite(mesg.getCipherSuite());
        if (this.beingProtocolVersion.version == 257) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.prfHashAlg);
        } else if (this.beingProtocolVersion.isStandardTLS12()) {
            this.handshakeHash.setFinishedAlg(this.cipherSuite.prfAlg.prfHashAlg);
        }
        if (mesg.getCompressionMethod().value != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + mesg.getCompressionMethod());
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(mesg.getSessionId())) {
                CipherSuite sessionSuite = this.session.getSuite();
                if (this.cipherSuite != sessionSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion sessionVersion = this.session.getProtocolVersion();
                if (this.beingProtocolVersion != sessionVersion) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                Debugger.handshaker.debug("%% Server resumed {}", (Object)this.session);
            } else {
                this.session = null;
                if (!this.enableNewSession) {
                    throw new SSLException("New session creation is disabled");
                }
            }
        }
        if (this.resumingSession && this.session != null) {
            this.setHandshakeSessionSE(this.session);
            return;
        }
        for (HelloExtension ext : mesg.extensions.list()) {
            ExtensionType type = ext.type;
            if (type == ExtensionType.EXT_SERVER_NAME) {
                this.serverNamesAccepted = true;
                continue;
            }
            if (type == ExtensionType.EXT_ELLIPTIC_CURVES || type == ExtensionType.EXT_EC_POINT_FORMATS || type == ExtensionType.EXT_SERVER_NAME || type == ExtensionType.EXT_RENEGOTIATION_INFO) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + (Object)((Object)type));
        }
        this.session = new SSLSessionImpl(this.beingProtocolVersion, this.cipherSuite, this.getLocalSupportedSignAlgs(), mesg.getSessionId(), this.getHostSE(), this.getPortSE());
        this.session.setRequestedServerNames(this.serverNamesRequested);
        this.setHandshakeSessionSE(this.session);
        Debugger.handshaker.debug("** " + this.cipherSuite);
    }

    private void serverCertificate(CertificateMsg mesg) throws IOException {
        TLSCredentials[] credentials;
        block9: {
            Debugger.debug(mesg);
            X509Certificate[] peercerts = mesg.chain();
            if (peercerts == null || peercerts.length == 0) {
                this.fatalSE((byte)42, "empty certificate chain");
            }
            if ((credentials = TLSCredentials.buildDoubleCredentials(peercerts)) == null || credentials.length != 2) {
                this.fatalSE((byte)42, "invalid certificate chain");
            }
            if (credentials[0] == null || credentials[0].certificates == null) {
                this.fatalSE((byte)42, "invalid signer certificate chain");
            }
            X509TrustManager tm = this.context.getX509TrustManager();
            try {
                String authType = this.cipherSuite.keyExchange.name;
                if (tm instanceof CFCAX509ExtendedTrustManager) {
                    CFCAX509ExtendedTrustManager trustManager = (CFCAX509ExtendedTrustManager)tm;
                    for (TLSCredentials credential : credentials) {
                        if (credential == null || credential.certificates == null) continue;
                        if (this.conn != null) {
                            trustManager.checkServerTrusted((X509Certificate[])credential.certificates.clone(), authType, this.conn);
                            continue;
                        }
                        trustManager.checkServerTrusted((X509Certificate[])credential.certificates.clone(), authType, this.engine);
                    }
                    break block9;
                }
                throw new CertificateException("Improper X509TrustManager implementation");
            }
            catch (CertificateException e) {
                if (Debugger.handshaker.isErrorEnabled()) {
                    Debugger.handshaker.error("handshaker failure", (Throwable)e);
                }
                this.fatalSE((byte)46, e);
            }
        }
        this.session.setPeerCredentials(credentials[0], credentials[1]);
        Debugger.handshaker.debug("serverCertificate Finished");
    }

    private final void serverKeyExchange(int messageLen) throws IOException {
        switch (this.cipherSuite.keyExchange) {
            case K_ECDHE_SM2DSA: {
                try {
                    ServerKeyExchange.SKESM2DHE skeh = new ServerKeyExchange.SKESM2DHE(this.in, this.serverSignerKey, this.clientRandom, this.serverRandom, this.localSupportedSignAlgs, this.beingProtocolVersion);
                    Debugger.debug(skeh);
                    ECPublicKey key = skeh.getPublicKey();
                    this.ecdh = new ECDHCrypt(true, key.getParameters(), this.context.getSecureRandom());
                    this.serverEphemeralKey = key;
                }
                catch (GeneralSecurityException e) {
                    if (Debugger.handshaker.isErrorEnabled()) {
                        Debugger.handshaker.error("handshaker failure", (Throwable)e);
                    }
                    ClientHandshaker.throwSSLException("Server key", e);
                }
                break;
            }
            case K_SM2PKEA_SM2DSA: {
                try {
                    if (this.session.getPeerCipherCredentials() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerCipherCredentials[SM2PKEA_SM2DSA]");
                    }
                    if (this.session.getPeerCipherCredentials().getCertificate() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerCipherCertificate[SM2PKEA_SM2DSA]");
                    }
                    if (this.session.getPeerSignerCredentials() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerSignerCredentials[SM2PKEA_SM2DSA]");
                    }
                    if (this.session.getPeerSignerCredentials().getCertificate() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerSignerCertificate[SM2PKEA_SM2DSA]");
                    }
                    X509Certificate encert = this.session.getPeerCipherCredentials().getCertificate();
                    String sigAlg = this.session.getPeerSignerCredentials().getSigAlgName();
                    ServerKeyExchange.SKEPKEA exchange = new ServerKeyExchange.SKEPKEA(sigAlg, this.in);
                    if (exchange.verify(this.session.getPeerSignerCredentials(), this.clientRandom, this.serverRandom, encert)) break;
                    this.fatalSE((byte)47, "ServerKeyExchange failure");
                }
                catch (GeneralSecurityException e) {
                    if (Debugger.handshaker.isErrorEnabled()) {
                        Debugger.handshaker.error("handshaker failure", (Throwable)e);
                    }
                    ClientHandshaker.throwSSLException("Error decoded ECDH server key exchange", e);
                }
                break;
            }
            case K_RSAPKEA: {
                try {
                    if (this.session.getPeerCipherCredentials() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerCipherCredentials[RSAPKEA]");
                    }
                    if (this.session.getPeerCipherCredentials().getCertificate() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerCipherCertificate[RSAPKEA]");
                    }
                    if (this.session.getPeerSignerCredentials() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerSignerCredentials[RSAPKEA]");
                    }
                    if (this.session.getPeerSignerCredentials().getCertificate() == null) {
                        throw new GeneralSecurityException("ServerKeyExchange failure,missing PeerSignerCertificate[RSAPKEA]");
                    }
                    X509Certificate encert = this.session.getPeerCipherCredentials().getCertificate();
                    ServerKeyExchange.SKEPKEA exchange = new ServerKeyExchange.SKEPKEA("MD5andSHA1withRSA", this.in);
                    if (exchange.verify(this.session.getPeerSignerCredentials(), this.clientRandom, this.serverRandom, encert)) break;
                    this.fatalSE((byte)47, "ServerKeyExchange failure");
                }
                catch (GeneralSecurityException e) {
                    if (Debugger.handshaker.isErrorEnabled()) {
                        Debugger.handshaker.error("handshaker failure", (Throwable)e);
                    }
                    ClientHandshaker.throwSSLException("Error decoded ECDH server key exchange", e);
                }
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.cipherSuite.keyExchange));
            }
        }
    }

    private final void certificateRequest(HandshakeInStream input, ProtocolVersion protocolVersion) throws IOException {
        X500Principal[] cas;
        this.certRequest = new CertificateRequest(input, protocolVersion);
        Debugger.debug(this.certRequest);
        if (protocolVersion.isStandardTLS12()) {
            Collection<SignatureAndHashAlgorithm> peerSignAlgs = this.certRequest.getSignAlgorithms();
            if (peerSignAlgs == null || peerSignAlgs.isEmpty()) {
                throw new SSLHandshakeException("No peer supported signature algorithms");
            }
            List<SignatureAndHashAlgorithm> supportedPeerSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms(peerSignAlgs);
            if (supportedPeerSignAlgs.isEmpty()) {
                throw new SSLHandshakeException("No supported signature and hash algorithm in common");
            }
            this.setPeerSupportedSignAlgs(supportedPeerSignAlgs);
            this.session.setPeerSupportedSignatureAlgorithms(supportedPeerSignAlgs);
        }
        if (Debugger.handshaker.isDebugEnabled() && (cas = this.certRequest.getAuthorities()) != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < cas.length; ++i) {
                builder.append('\n');
                builder.append("CAs: ");
                builder.append(cas[i]);
            }
            builder.append('\n');
            Debugger.handshaker.debug(builder.toString());
            builder = null;
        }
    }

    private void serverHelloDone(ServerHelloDone mesg) throws IOException {
        Debugger.debug(mesg);
        this.in.digestNow();
        PrivateKey signingKey = this.writeCertificate();
        ClientKeyExchange clientKeyExchange = this.writeClientKeyExchange();
        this.out.doHashes();
        this.out.flush();
        this.calculateWorkKeys(clientKeyExchange);
        this.writeCertificateVerify(signingKey);
        this.out.flush();
        this.writeChangeCipherAndFinish(false);
    }

    private final PrivateKey writeCertificate() throws IOException {
        PrivateKey signingKey = null;
        if (this.certRequest != null) {
            X509ExtendedKeyManager km = this.context.getX509KeyManager();
            TLSCredentials[] credentials = null;
            String[] alias = null;
            for (int i = 0; i < this.certRequest.types.length; ++i) {
                switch (this.certRequest.types[i]) {
                    case 1: {
                        alias = km.getClientAliases("RSA", this.certRequest.getAuthorities());
                        credentials = this.getTLSCredentials(km, "RSA", alias);
                        break;
                    }
                    case 64: 
                    case 71: {
                        alias = km.getClientAliases("SM2", this.certRequest.getAuthorities());
                        if (alias == null) {
                            alias = km.getClientAliases("EC", this.certRequest.getAuthorities());
                        }
                        credentials = this.getTLSCredentials(km, "SM2", alias);
                        break;
                    }
                }
                if (credentials != null && credentials.length > 0) break;
            }
            if (credentials == null || credentials.length == 0) {
                return signingKey;
            }
            if (credentials.length == 1) {
                this.signerCredentials = credentials[0];
                this.cipherCredentials = credentials[0];
            } else if (credentials.length > 1) {
                this.signerCredentials = credentials[0];
                this.cipherCredentials = credentials[1];
            }
            if (this.signerCredentials == null) {
                throw new SecurityException("missing signerCredentials for certificates");
            }
            if (this.signerCredentials.certificates == null) {
                throw new SecurityException("missing signerCertificates for certificates");
            }
            if (this.cipherCredentials == null) {
                throw new SecurityException("missing cipherCredentials for certificates");
            }
            if (this.cipherCredentials.certificates == null) {
                throw new SecurityException("missing cipherCertificates for certificates");
            }
            signingKey = this.signerCredentials.privateKey;
            X509Certificate[] certs = TLSCredentials.concat(this.signerCredentials.certificates, this.cipherCredentials.certificates);
            if (certs == null || certs.length == 0) {
                throw new RuntimeException("no certificates");
            }
            this.session.setLocalCredentials(this.signerCredentials, this.signerCredentials);
            CertificateMsg m1 = new CertificateMsg(certs);
            if (m1 != null) {
                Debugger.debug(m1);
                m1.write(this.out);
            }
        }
        return signingKey;
    }

    private final ClientKeyExchange writeClientKeyExchange() throws IOException {
        ClientKeyExchange message;
        switch (this.cipherSuite.keyExchange) {
            case K_ECDHE_SM2DSA: {
                if (this.serverCipherKey == null) {
                    throw new SSLProtocolException("ECDHE_SM2DSA Server did not send certificate message");
                }
                if (!(this.serverCipherKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("ECDHE_SM2DSA Server certificate does not include an EC key");
                }
                ECParameterSpec params = ((ECPublicKey)this.serverEphemeralKey).getParameters();
                this.ecdh = new ECDHCrypt(true, params, this.context.getSecureRandom());
                message = new ClientKeyExchange.CKESM2DH(this.ecdh.getPublicKey());
                break;
            }
            case K_SM2PKEA_SM2DSA: {
                if (this.serverCipherKey == null) {
                    throw new SSLProtocolException("SM2PKEA_SM2DSA Server did not send certificate message");
                }
                if (!(this.serverCipherKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("SM2PKEA_SM2DSA Server certificate does not include an SM2 key");
                }
                message = new ClientKeyExchange.CKEPKEA(this.beingProtocolVersion, this.maxProtocolVersion, this.context.getSecureRandom(), this.serverCipherKey);
                break;
            }
            case K_RSAPKEA: {
                if (this.serverCipherKey == null) {
                    throw new SSLProtocolException("RSAPKEA Server did not send certificate message");
                }
                if (!(this.serverCipherKey instanceof RSAPublicKey)) {
                    throw new SSLProtocolException("RSAPKEA Server certificate does not include an RSA key");
                }
                message = new ClientKeyExchange.CKEPKEA(this.beingProtocolVersion, this.maxProtocolVersion, this.context.getSecureRandom(), this.serverCipherKey);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)((Object)this.cipherSuite.keyExchange));
            }
        }
        Debugger.debug(message);
        message.write(this.out);
        return message;
    }

    private final void writeCertificateVerify(PrivateKey signingKey) throws SSLHandshakeException, IOException {
        if (signingKey != null) {
            try {
                SignatureAndHashAlgorithm signatureAlgorithm = null;
                if (this.beingProtocolVersion.isStandardTLS12()) {
                    signatureAlgorithm = SignatureAndHashAlgorithm.getPreferableAlgorithm(this.peerSupportedSignAlgs, signingKey.getAlgorithm(), signingKey);
                    if (signatureAlgorithm == null) {
                        throw new SSLHandshakeException("No supported signature algorithm");
                    }
                    String hashAlg = SignatureAndHashAlgorithm.getHashAlgorithmName(signatureAlgorithm);
                    if (hashAlg == null || hashAlg.length() == 0) {
                        throw new SSLHandshakeException("No supported hash algorithm");
                    }
                }
                SecretKey masterKey = this.session.getMasterSecret();
                SecureRandom random = this.context.getSecureRandom();
                CertificateVerify certificateVerify = new CertificateVerify(this.beingProtocolVersion, this.handshakeHash, signingKey, masterKey, signatureAlgorithm, random);
                Debugger.debug(certificateVerify);
                certificateVerify.write(this.out);
                this.out.doHashes();
            }
            catch (GeneralSecurityException e) {
                if (Debugger.handshaker.isErrorEnabled()) {
                    Debugger.handshaker.error("handshaker failure", (Throwable)e);
                }
                this.fatalSE((byte)40, "Error signing certificate verify", e);
                Object var2_7 = null;
            }
        } else if (Debugger.handshaker.isDebugEnabled()) {
            Debugger.handshaker.debug("handshaker failure:signingKey cannot be null!");
        }
    }

    private void writeChangeCipherAndFinish(boolean finishedTag) throws IOException {
        Finished mesg = new Finished(this.beingProtocolVersion, this.handshakeHash, 1, this.session.getMasterSecret(), this.cipherSuite);
        this.sendChangeCipherSpec(mesg, finishedTag);
        if (this.secureRenegotiation) {
            this.clientVerifyData = mesg.getVerifyData();
        }
        this.state = 19;
    }

    private void serverFinished(Finished mesg) throws IOException {
        Debugger.debug(mesg);
        boolean verified = mesg.verify(this.handshakeHash, 2, this.session.getMasterSecret());
        if (!verified) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.serverVerifyData = mesg.getVerifyData();
        }
        if (this.resumingSession) {
            this.in.digestNow();
            this.writeChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.context.engineGetClientSessionContext()).put(this.session);
                if (Debugger.handshaker.isDebugEnabled()) {
                    Debugger.handshaker.debug("%% Cached client session: {}", (Object)this.session);
                }
            } else if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("%% Didn't cache non-resumable client session: {}", (Object)this.session);
            }
        }
    }

    private final void calculateWorkKeys(ClientKeyExchange clientKeyExchange) throws IOException {
        SecretKey preMasterSecret;
        switch (this.cipherSuite.keyExchange) {
            case K_RSAPKEA: {
                preMasterSecret = ((ClientKeyExchange.CKEPKEA)clientKeyExchange).preMasterKey;
                break;
            }
            case K_ECDHE_SM2DSA: {
                if (this.cipherCredentials == null || this.cipherCredentials.privateKey == null) {
                    throw new SecurityException("missing cipherCredentials for calculateWorkKeys[ECDHE_SM2DSA]");
                }
                preMasterSecret = this.ecdh.getSM2AgreedSecret((ECPrivateKey)this.cipherCredentials.privateKey, (ECPublicKey)this.cipherCredentials.publicKey, (ECPublicKey)this.serverCipherKey, (ECPublicKey)this.serverEphemeralKey);
                break;
            }
            case K_SM2PKEA_SM2DSA: {
                preMasterSecret = ((ClientKeyExchange.CKEPKEA)clientKeyExchange).preMasterKey;
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)((Object)this.cipherSuite.keyExchange));
            }
        }
        this.calculateKeys(preMasterSecret, null);
        preMasterSecret = null;
    }

    @Override
    HandshakeMessage getKickstartMessage() throws SSLException {
        SessionId sessionId = SSLSessionImpl.nullSession.getSessionId();
        CipherSuiteList cipherSuites = this.getActiveCipherSuites();
        this.maxProtocolVersion = this.beingProtocolVersion;
        this.session = ((SSLSessionContextImpl)this.context.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (Debugger.handshaker.isDebugEnabled()) {
            if (this.session != null) {
                Debugger.handshaker.debug("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                Debugger.handshaker.debug("%% No cached client session");
            }
        }
        if (this.session != null && !this.session.isRejoinable()) {
            this.session = null;
        }
        if (this.session != null) {
            CipherSuite sessionSuite = this.session.getSuite();
            ProtocolVersion sessionVersion = this.session.getProtocolVersion();
            if (!this.isNegotiable(sessionSuite)) {
                Debugger.handshaker.debug("%% can't resume, unavailable cipher");
                this.session = null;
            }
            if (this.session != null && !this.isNegotiable(sessionVersion)) {
                Debugger.handshaker.debug("%% can't resume, protocol disabled");
                this.session = null;
            }
            if (this.session != null) {
                Debugger.handshaker.debug("%% Try resuming {} from port {}", (Object)this.session, (Object)this.getLocalPortSE());
                sessionId = this.session.getSessionId();
                this.maxProtocolVersion = sessionVersion;
                this.setBeingVersion(sessionVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLHandshakeException("Can't reuse existing SSL client session");
                }
                ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(2);
                cipherList.add(sessionSuite);
                if (!this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
                    cipherList.add(CipherSuite.C_SCSV);
                }
                cipherSuites = new CipherSuiteList(cipherList);
            }
        }
        if (this.session == null && !this.enableNewSession) {
            throw new SSLHandshakeException("No existing session to resume");
        }
        if (this.secureRenegotiation && cipherSuites.contains(CipherSuite.C_SCSV)) {
            ArrayList<CipherSuite> cipherList = new ArrayList<CipherSuite>(cipherSuites.size() - 1);
            for (CipherSuite suite : cipherSuites.collection()) {
                if (suite == CipherSuite.C_SCSV) continue;
                cipherList.add(suite);
            }
            cipherSuites = new CipherSuiteList(cipherList);
        }
        boolean negotiable = false;
        for (CipherSuite suite : cipherSuites.collection()) {
            if (!this.isNegotiable(suite)) continue;
            negotiable = true;
            break;
        }
        if (!negotiable) {
            throw new SSLHandshakeException("No negotiable cipher suite");
        }
        ClientHello clientHelloMessage = new ClientHello(this.maxProtocolVersion, this.context.getSecureRandom(), sessionId, cipherSuites);
        if (this.maxProtocolVersion.isStandardTLS12()) {
            List<SignatureAndHashAlgorithm> localSignAlgs = this.getLocalSupportedSignAlgs();
            if (localSignAlgs.isEmpty()) {
                throw new SSLHandshakeException("No supported signature algorithm");
            }
            clientHelloMessage.addExtension(new SignatureAlgorithmsExtension(localSignAlgs));
        }
        if (enableSNIExtension) {
            this.serverNamesRequested = this.session != null ? this.session.getRequestedServerNames() : this.serverNames;
            if (!this.serverNamesRequested.isEmpty()) {
                try {
                    clientHelloMessage.addExtension(new ServerNameExtension(this.serverNamesRequested));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        this.clientRandom = clientHelloMessage.getClientRandom();
        if (this.secureRenegotiation || !cipherSuites.contains(CipherSuite.C_SCSV)) {
            clientHelloMessage.addExtension(new RenegotiationInfoExtension(this.clientVerifyData, new byte[0]));
        }
        return clientHelloMessage;
    }

    @Override
    void handshakeAlert(byte description) throws SSLProtocolException {
        String message = Alerts.alertDescription(description);
        Debugger.handshaker.debug("SSL - handshake alert: {}", (Object)message);
        throw new SSLProtocolException("handshake alert:  " + message);
    }

    final TLSCredentials[] getTLSCredentials(X509ExtendedKeyManager km, String keyAlgorithm, String[] alias) {
        TLSCredentials[] credentials = new TLSCredentials[2];
        if (alias == null) {
            return null;
        }
        int numb = 0;
        PrivateKey tempPrivateKey = null;
        X509Certificate[] certificates = null;
        String name = null;
        TLSCredentials[] others = new TLSCredentials[2];
        for (int i = 0; i < alias.length; ++i) {
            ECParameterSpec params;
            tempPrivateKey = km.getPrivateKey(alias[i]);
            if (tempPrivateKey == null) {
                return null;
            }
            certificates = km.getCertificateChain(alias[i]);
            if (certificates == null || certificates.length == 0) {
                return null;
            }
            PublicKey publicKey = certificates[0].getPublicKey();
            String prikType = tempPrivateKey.getAlgorithm();
            String pubkType = publicKey.getAlgorithm();
            if ("ECDSA".equals(prikType)) {
                prikType = "SM2";
            }
            if (!prikType.equals(keyAlgorithm) || !pubkType.equals(keyAlgorithm) || keyAlgorithm.equals("SM2") && publicKey instanceof ECPublicKey && !ECNamedCurve.isSM2NamedCurve(params = ((ECPublicKey)publicKey).getParameters())) continue;
            name = alias[i].toLowerCase();
            if (name.contains("cipher")) {
                credentials[1] = new TLSCredentials(tempPrivateKey, certificates);
                ++numb;
                continue;
            }
            if (name.contains("signer")) {
                credentials[0] = new TLSCredentials(tempPrivateKey, certificates);
                ++numb;
                continue;
            }
            others[numb++] = new TLSCredentials(tempPrivateKey, certificates);
            if (numb >= 2) break;
        }
        for (int j = 0; j < credentials.length; ++j) {
            if (credentials[j] != null || others[j] == null) continue;
            credentials[j] = others[j];
        }
        if (credentials[0] == null) {
            credentials[0] = credentials[1];
        }
        if (credentials[1] == null) {
            credentials[1] = credentials[0];
        }
        if (credentials[1] == null) {
            return null;
        }
        return credentials;
    }
}

