/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class EngineArgs {
    ByteBuffer netData;
    ByteBuffer[] appData;
    private int offset;
    private int length;
    private int netPos;
    private int netLim;
    private int[] appPoss;
    private int[] appLims;
    private int appRemaining = 0;
    private boolean wrapMethod;

    EngineArgs(ByteBuffer[] appData, int offset, int len, ByteBuffer netData) {
        this.wrapMethod = true;
        this.init(netData, appData, offset, len);
    }

    EngineArgs(ByteBuffer netData, ByteBuffer[] appData, int offset, int len) {
        this.wrapMethod = false;
        this.init(netData, appData, offset, len);
    }

    private void init(ByteBuffer netData, ByteBuffer[] appData, int offset, int len) {
        if (netData == null || appData == null) {
            throw new IllegalArgumentException("src/dst is null");
        }
        if (offset < 0 || len < 0 || offset > appData.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (this.wrapMethod && netData.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.netPos = netData.position();
        this.netLim = netData.limit();
        this.appPoss = new int[appData.length];
        this.appLims = new int[appData.length];
        for (int i = offset; i < offset + len; ++i) {
            if (appData[i] == null) {
                throw new IllegalArgumentException("appData[" + i + "] == null");
            }
            if (!this.wrapMethod && appData[i].isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            this.appRemaining += appData[i].remaining();
            this.appPoss[i] = appData[i].position();
            this.appLims[i] = appData[i].limit();
        }
        this.netData = netData;
        this.appData = appData;
        this.offset = offset;
        this.length = len;
    }

    void gather(int spaceLeft) {
        int amount;
        for (int i = this.offset; i < this.offset + this.length && spaceLeft > 0; spaceLeft -= amount, ++i) {
            amount = Math.min(this.appData[i].remaining(), spaceLeft);
            this.appData[i].limit(this.appData[i].position() + amount);
            this.netData.put(this.appData[i]);
            this.appRemaining -= amount;
        }
    }

    void scatter(ByteBuffer readyData) {
        int amount;
        int amountLeft = readyData.remaining();
        for (int i = this.offset; i < this.offset + this.length && amountLeft > 0; amountLeft -= amount, ++i) {
            amount = Math.min(this.appData[i].remaining(), amountLeft);
            readyData.limit(readyData.position() + amount);
            this.appData[i].put(readyData);
        }
        assert (readyData.remaining() == 0);
    }

    int getAppRemaining() {
        return this.appRemaining;
    }

    int deltaNet() {
        return this.netData.position() - this.netPos;
    }

    int deltaApp() {
        int sum = 0;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            sum += this.appData[i].position() - this.appPoss[i];
        }
        return sum;
    }

    void resetPos() {
        this.netData.position(this.netPos);
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            this.appData[i].position(this.appPoss[i]);
        }
    }

    void resetLim() {
        this.netData.limit(this.netLim);
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            this.appData[i].limit(this.appLims[i]);
        }
    }
}

