/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.cert.assist.CrlManager;
import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.CertVerifyUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.com.itextpdf.signatures.PdfPKCS7;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.VerifyInfo;
import cfca.sadk.seal.util.VerifyUtil;
import cfca.sadk.x509.certificate.X509CRL;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfVerifyUtil {
    public static final Logger sysLog = LoggerFactory.getLogger(PdfVerifyUtil.class);
    public static final String OCA32 = "oca32";

    public static void verifyPdfSeal(byte[] pdfData, int sealVerifyType) throws Exception {
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])pdfData);
        ArrayList<X509Certificate> x509CertList = new ArrayList<X509Certificate>();
        HashMap<String, X509Certificate> x509CertMap = new HashMap<String, X509Certificate>();
        HashMap<String, PdfPKCS7> pdfPKCS7Map = new HashMap<String, PdfPKCS7>();
        if (verifyResult.getVerifyResult()) {
            HashMap verifyInfos = verifyResult.getVerifyInfos();
            for (String key : verifyInfos.keySet()) {
                VerifyInfo verifyInfo = (VerifyInfo)verifyInfos.get(key);
                x509CertList.add(verifyInfo.getX509Certificate());
                x509CertMap.put(verifyInfo.getSignatureName(), verifyInfo.getX509Certificate());
                pdfPKCS7Map.put(verifyInfo.getSignatureName(), verifyInfo.getPdfPKCS7());
            }
        } else {
            throw new CodeException("600619", "pdf verify error");
        }
        sysLog.info("PDF\u6587\u6863\u5305\u542b\u8bc1\u4e66\u6570\u91cf" + x509CertList.size());
        PdfVerifyUtil.verifyPdfSeal(x509CertMap, pdfPKCS7Map, sealVerifyType);
    }

    public static void verifyPdfSeal(Map<String, X509Certificate> x509CertMap, Map<String, PdfPKCS7> pdfPKCS7Map, int sealVerifyType) throws CodeException, Exception {
        ArrayList<X509Cert> x509Certs = new ArrayList<X509Cert>();
        if (sealVerifyType >= 1) {
            for (Map.Entry<String, Object> entry : pdfPKCS7Map.entrySet()) {
                X509Certificate x509Certificate = x509CertMap.get(entry.getKey());
                PdfPKCS7 p7 = pdfPKCS7Map.get(entry.getKey());
                Calendar calendar = p7.getTimeStampDate();
                if (calendar == null) {
                    calendar = p7.getSignDate();
                }
                Date date = calendar.getTime();
                X509Cert x509Cert = new X509Cert(x509Certificate.getEncoded());
                x509Certs.add(x509Cert);
                if (CertVerifyUtil.verifyCertDate(x509Cert, date)) continue;
                throw new CodeException("640052", "subject\uff1a" + x509Cert.getSubject() + "notBefore:" + x509Cert.getNotBefore() + "notAfter:" + x509Cert.getNotAfter());
            }
            sysLog.info("\u9a8c\u8bc1\u8bc1\u4e66\u6709\u6548\u6027\u5b8c\u6210");
            if (!CertVerifyUtil.verifyCertSign(x509Certs)) {
                throw new CodeException("640053", "\u9a8c\u8bc1\u5931\u8d25");
            }
            sysLog.info("\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5b8c\u6210");
        }
        if (sealVerifyType == 2) {
            for (X509Cert x509Cert : x509Certs) {
                String issuer = StringUtil.formatIssuerKey(x509Cert.getIssuer());
                if (issuer.indexOf(OCA32) != -1) continue;
                X509CRL x509crl = CrlManager.getX509CRL(issuer);
                if (x509crl == null) {
                    throw new CodeException("640054", " crl:" + issuer);
                }
                if (!CertVerifyUtil.verifyByCRL(x509Cert, x509crl)) continue;
                throw new CodeException("640055", "subject=" + x509Cert.getSubject() + ",issuer=" + x509Cert.getIssuer());
            }
            sysLog.info("\u9a8c\u8bc1CRL\u5b8c\u6210");
        }
    }
}

