/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.conversion.eot;

import cfca.com.google.typography.font.sfntly.table.truetype.ControlValueTable;
import java.io.ByteArrayOutputStream;

public class CvtEncoder {
    private static final int CVT_POS8 = 255;
    private static final int CVT_POS1 = 248;
    private static final int CVT_NEG8 = 247;
    private static final int CVT_NEG1 = 240;
    private static final int CVT_NEG0 = 239;
    private static final int CVT_WORDCODE = 238;
    private static final int CVT_LOWESTCODE = 238;
    private ByteArrayOutputStream cvtStream = new ByteArrayOutputStream();

    public void encode(ControlValueTable cvtTable) {
        int numEntries = cvtTable.fwordCount();
        this.cvtStream.write(numEntries >> 8);
        this.cvtStream.write(numEntries & 0xFF);
        int lastValue = 0;
        for (int i = 0; i < numEntries; ++i) {
            int value = cvtTable.fword(i * 2);
            short deltaValue = (short)(value - lastValue);
            int absValue = Math.abs(deltaValue);
            int index = absValue / 238;
            if (index <= 8) {
                if (deltaValue < 0) {
                    this.cvtStream.write(239 + index);
                    this.cvtStream.write(absValue - index * 238);
                } else {
                    if (index > 0) {
                        this.cvtStream.write(248 + index - 1);
                    }
                    this.cvtStream.write(absValue - index * 238);
                }
            } else {
                this.cvtStream.write(238);
                this.cvtStream.write(deltaValue >> 8);
                this.cvtStream.write(deltaValue & 0xFF);
            }
            lastValue = value;
        }
    }

    public byte[] toByteArray() {
        return this.cvtStream.toByteArray();
    }
}

