/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.signer;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;

public final class ECCSignature {
    private final int eccByteLength;
    private final byte[] dataRInt;
    private final byte[] dataSInt;

    public ECCSignature(byte[] signData, int eccByteLength) throws Exception {
        int tlvLength;
        int minLength = 8;
        int maxLength = 10 + (eccByteLength << 1);
        if (signData == null || signData.length < 8 || signData.length > maxLength) {
            throw new IllegalArgumentException(String.format("eccSignData==null/signDataLength not in [%s,%s]", 8, maxLength));
        }
        if (signData[0] != 48) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: signData[0]==0x%X", signData[0]));
        }
        int tagL = signData[1] & 0xFF;
        if (tagL > 127 && tagL != 129) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: signData[1]==0x%X", signData[1]));
        }
        boolean isLength = tagL <= 127;
        int n = tlvLength = isLength ? 2 + tagL : 3 + (signData[2] & 0xFF);
        if (signData.length != tlvLength) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: dataLength=%s, tlvLength=%s", signData.length, tlvLength));
        }
        int index = isLength ? 2 : 3;
        byte tagRInt = signData[index++];
        byte lenRInt = signData[index++];
        if (tagRInt != 2 || lenRInt <= 0 || lenRInt > eccByteLength + 1) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: tagR=%s, lenR=%s", tagRInt, (int)lenRInt));
        }
        this.dataRInt = new byte[lenRInt];
        System.arraycopy(signData, index, this.dataRInt, 0, this.dataRInt.length);
        index += lenRInt;
        byte tagSInt = signData[index++];
        byte lenSInt = signData[index++];
        if (tagSInt != 2 || lenSInt <= 0 || lenSInt > eccByteLength + 1) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: tagS=%s, lenS=%s", tagSInt, (int)lenSInt));
        }
        if ((index += lenSInt) != signData.length) {
            throw new IllegalArgumentException(String.format("eccSignData is not valid: indexRS=%s, dataLength=%s", index, signData.length));
        }
        this.dataSInt = new byte[lenSInt];
        System.arraycopy(signData, signData.length - this.dataSInt.length, this.dataSInt, 0, this.dataSInt.length);
        this.eccByteLength = eccByteLength;
    }

    public byte[] asn1Encoded() throws Exception {
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(this.dataRInt).formatToPositive(this.eccByteLength));
            v.add(new ASN1Integer(this.dataSInt).formatToPositive(this.eccByteLength));
            return new DERSequence(v).getEncoded("DER");
        }
        catch (Exception e) {
            throw new Exception("ECCSignature  asn1Encoded failed", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCSignature [eccByteLength=");
        builder.append(this.eccByteLength);
        builder.append(", dataRInt=");
        builder.append(this.dataRInt == null ? null : Hex.toHexString(this.dataRInt));
        builder.append(", dataSInt=");
        builder.append(this.dataSInt == null ? null : Hex.toHexString(this.dataSInt));
        builder.append("]");
        return builder.toString();
    }
}

