/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.util.Hexifys;
import java.util.Arrays;

public abstract class CFCASNIServerName {
    private final int type;
    private final byte[] encoded;

    protected CFCASNIServerName(int type, byte[] encoded) {
        if (type < 0) {
            throw new IllegalArgumentException("Server name type cannot be less than zero");
        }
        if (type > 255) {
            throw new IllegalArgumentException("Server name type cannot be greater than 255");
        }
        this.type = type;
        if (encoded == null) {
            throw new NullPointerException("Server name encoded value cannot be null");
        }
        this.encoded = (byte[])encoded.clone();
    }

    public final int getType() {
        return this.type;
    }

    public final byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public final int length() {
        return this.encoded.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encoded);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFCASNIServerName other = (CFCASNIServerName)obj;
        if (!Arrays.equals(this.encoded, other.encoded)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        if (this.type == 0) {
            return "type=host_name (0), value=0x" + Hexifys.hexify(this.encoded);
        }
        return "type=(" + this.type + "), value=0x" + Hexifys.hexify(this.encoded);
    }
}

