/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.security.external;

import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFailureInfo;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import java.io.IOException;

public abstract class PreExternalTSAClient
extends TSAClientBouncyCastle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSAClientBouncyCastle.class);

    public PreExternalTSAClient(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        super(url, username, password, tokSzEstimate, digestAlgorithm);
    }

    public PreExternalTSAClient(String url, String username, String password) {
        super(url, username, password);
    }

    public abstract byte[] getTimeStampToken(byte[] var1) throws IOException, TSPException;

    public byte[] validate(byte[] respBytes) throws TSPException, IOException {
        int value;
        TimeStampResponse response = new TimeStampResponse(respBytes);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new IOException(MessageLocalization.getComposedMessage("invalid.tsa.1.response.code.2", this.tsaURL, String.valueOf(value)));
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException(MessageLocalization.getComposedMessage("tsa.1.failed.to.return.time.stamp.token.2", this.tsaURL, response.getStatusString()));
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }
}

