/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.symmetric;

import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.engines.NoekeonEngine;
import cfca.sadk.org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.macs.GMac;
import cfca.sadk.org.bouncycastle.crypto.modes.GCMBlockCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class Noekeon {
    private Noekeon() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Noekeon.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.NOEKEON", PREFIX + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameterGenerator.NOEKEON", PREFIX + "$AlgParamGen");
            provider.addAlgorithm("Cipher.NOEKEON", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.NOEKEON", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "NOEKEON", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "NOEKEON", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Noekeon IV";
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Noekeon parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Noekeon", BouncyCastleProvider.getCFCAProviderName());
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Noekeon", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cfca.sadk.org.bouncycastle.crypto.macs.Poly1305(new NoekeonEngine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new NoekeonEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Noekeon", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new NoekeonEngine();
                }
            });
        }
    }
}

