/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.source;

import cfca.sadk.com.itextpdf.io.source.IRandomAccessSource;
import cfca.sadk.com.itextpdf.io.source.MappedChannelRandomAccessSource;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelRandomAccessSource
implements IRandomAccessSource,
Serializable {
    private static final long serialVersionUID = -7550288945325499416L;
    private final FileChannel channel;
    private final MappedChannelRandomAccessSource source;

    public FileChannelRandomAccessSource(FileChannel channel) throws IOException {
        this.channel = channel;
        if (channel.size() == 0L) {
            throw new IOException("File size is 0 bytes");
        }
        this.source = new MappedChannelRandomAccessSource(channel, 0L, channel.size());
        this.source.open();
    }

    @Override
    public void close() throws IOException {
        try {
            this.source.close();
        }
        finally {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                Logger logger = LoggerFactory.getLogger(FileChannelRandomAccessSource.class);
                logger.error("Closing of the file channel this source is based on failed.", (Throwable)ex);
            }
        }
    }

    @Override
    public int get(long position) throws IOException {
        return this.source.get(position);
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        return this.source.get(position, bytes, off, len);
    }

    @Override
    public long length() {
        return this.source.length();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.getClass().toString());
    }
}

