/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.ExceptionConverter;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.pdf.ICC_Profile;
import cfca.com.itextpdf.text.pdf.PdfException;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfStream;

public class PdfICCBased
extends PdfStream {
    public PdfICCBased(ICC_Profile profile) {
        this(profile, -1);
    }

    public PdfICCBased(ICC_Profile profile, int compressionLevel) {
        try {
            int numberOfComponents = profile.getNumComponents();
            switch (numberOfComponents) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(MessageLocalization.getComposedMessage("1.component.s.is.not.supported", numberOfComponents));
                }
            }
            this.put(PdfName.N, new PdfNumber(numberOfComponents));
            this.bytes = profile.getData();
            this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
            this.flateCompress(compressionLevel);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

