/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.client.util.PdfCompoundUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.FieldBean;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeBusinessDataRequestBody;
import cfca.paperless.dto.request.tx10.SynthesizeBusinessDataRequest;
import cfca.paperless.dto.response.responsebody.tx10.SynthesizeBusinessDataResponseBody;
import cfca.paperless.dto.response.tx10.SynthesizeBusinessDataResponse;
import cfca.sadk.seal.base.bean.form.FormFieldInfo;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.FormFieldUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynthesizeBusinessDataProcess {
    private static final Logger logger = LoggerFactory.getLogger(SynthesizeBusinessDataProcess.class);

    public SynthesizeBusinessDataResponse process(SynthesizeBusinessDataRequest requestBean) throws Exception {
        List imageBeanInfos;
        List textBeans;
        long start = System.currentTimeMillis();
        logger.info("SynthesizeBusinessDataProcess.process start.");
        SynthesizeBusinessDataRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            throw new Exception("invalid inputType");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception("inputSource is null");
            }
            pdfData = FileUtils.readFileToByteArray((File)new File(requestBody.getInputSource()));
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                throw new Exception("pdfData is null");
            }
            pdfData = requestBody.getPdfData();
        }
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        List fieldBeans = requestBody.getFieldBeans();
        ArrayList<FieldBean> checkboxFieldBeanList = new ArrayList<FieldBean>();
        ArrayList<FormFieldInfo> textfieldBeanList = new ArrayList<FormFieldInfo>();
        for (FieldBean fieldBean : fieldBeans) {
            if ("text".equals(fieldBean.getFieldType())) {
                FormFieldInfo formFieldInfo = new FormFieldInfo();
                formFieldInfo.setFieldName(fieldBean.getFieldId());
                formFieldInfo.setTextValue(fieldBean.getFieldValue());
                textfieldBeanList.add(formFieldInfo);
                continue;
            }
            if (!"checkbox".equals(fieldBean.getFieldType())) continue;
            checkboxFieldBeanList.add(fieldBean);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (checkboxFieldBeanList != null && checkboxFieldBeanList.size() > 0) {
            for (int i = 0; i < checkboxFieldBeanList.size(); ++i) {
                FieldBean fieldBean = (FieldBean)checkboxFieldBeanList.get(i);
                String fieldId = fieldBean.getFieldId();
                String fieldValue = fieldBean.getFieldValue();
                map.put(fieldId, fieldValue);
            }
            pdfData = FormFieldUtil.fillCheckBox((byte[])pdfData, map, (boolean)true);
            logger.info("\u5408\u6210checkbox\u7c7b\u578b\u7684\u57df\u5b8c\u6210\uff1a" + checkboxFieldBeanList.size());
        }
        if (null != textfieldBeanList && textfieldBeanList.size() > 0) {
            boolean isPartialFlattening = "1".equals(requestBody.getPartialFlattening());
            pdfData = PdfCompoundUtil.compoundPdfTextfield(pdfData, textfieldBeanList, isPartialFlattening);
            logger.info("\u5408\u6210text\u7c7b\u578b\u7684\u57df\u5b8c\u6210\uff1a" + textfieldBeanList.size());
        }
        if (null != (textBeans = requestBody.getTextBeans()) && textBeans.size() > 0) {
            pdfData = PdfCompoundUtil.addTextToPdf(pdfData, textBeans);
            logger.info("\u5408\u6210text\u5b8c\u6210\uff1a" + textBeans.size());
        }
        if (null != (imageBeanInfos = requestBody.getImageBeans()) && imageBeanInfos.size() > 0) {
            pdfData = PdfCompoundUtil.compoundPdfDataByImage(pdfData, imageBeanInfos);
            logger.info("\u5408\u6210image\u5b8c\u6210\uff1a" + imageBeanInfos.size());
        }
        String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])pdfData);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        SynthesizeBusinessDataResponseBody body = new SynthesizeBusinessDataResponseBody();
        body.setPdf(pdfData);
        body.setPdfFileDataHash(pdfFileDataHash);
        SynthesizeBusinessDataResponse responseBean = new SynthesizeBusinessDataResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("SynthesizeBusinessDataProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

