/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.utils;

import cfca.paperless.httpframework.bean.RequestStreamVO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpIOUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpIOUtils.class);

    public static int readInt(InputStream inputStream) throws IOException {
        int dataLen = 0;
        try {
            byte[] dataLength = new byte[7];
            int count = inputStream.read(dataLength);
            int step = 7;
            if (count == -1) {
                return count;
            }
            if (count != step) {
                throw new IOException();
            }
            dataLen = Integer.parseInt(new String(dataLength, "UTF-8"));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return dataLen;
    }

    public static byte[] intToByteArray(int dataLength) throws UnsupportedEncodingException {
        int paddingLength = 7;
        String resultLength = String.format("%1$0" + paddingLength + "d", dataLength);
        return resultLength.getBytes("UTF-8");
    }

    public static RequestStreamVO parseRequestStream(InputStream inputStream, String encoding) throws Exception {
        RequestStreamVO requestStreamVO = new RequestStreamVO();
        int receiveLength = 0;
        try {
            receiveLength = HttpIOUtils.readInt(inputStream);
        }
        catch (SocketTimeoutException e) {
            requestStreamVO.setParse(false);
            requestStreamVO.setReadLengthTimeout(true);
            return requestStreamVO;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            requestStreamVO.setParse(false);
            return requestStreamVO;
        }
        requestStreamVO.setRequestDataLength(receiveLength);
        if (receiveLength <= 0) {
            requestStreamVO.setParse(false);
            return requestStreamVO;
        }
        byte[] requestData = null;
        try {
            int bufferSize = receiveLength < 4096 ? receiveLength : 4096;
            requestData = HttpIOUtils.read(inputStream, receiveLength, bufferSize);
        }
        catch (SocketTimeoutException e) {
            requestStreamVO.setParse(false);
            requestStreamVO.setReadContentTimeout(true);
            return requestStreamVO;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            requestStreamVO.setParse(false);
            return requestStreamVO;
        }
        requestStreamVO.setParse(true);
        requestStreamVO.setRequestData(requestData);
        return requestStreamVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream inputStream, int length) throws Exception {
        ByteArrayOutputStream baos = null;
        byte[] outByte = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[3072];
            int totalNum = 0;
            int num = 0;
            totalNum += num;
            while ((num = inputStream.read(buffer)) > 0 && (totalNum += num) <= length) {
                baos.write(buffer, 0, num);
                if (totalNum < length) continue;
            }
            baos.flush();
            outByte = baos.toByteArray();
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
        return outByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream inputStream, int length, int bufferSize) throws Exception {
        ByteArrayOutputStream baos = null;
        byte[] outByte = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            int totalNum = 0;
            int num = 0;
            totalNum += num;
            while ((num = inputStream.read(buffer)) > 0 && (totalNum += num) <= length) {
                baos.write(buffer, 0, num);
                if (totalNum < length) continue;
            }
            baos.flush();
            outByte = baos.toByteArray();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
        return outByte;
    }

    public static void sendLengthAndValue(OutputStream outputStream, byte[] sendBytes) throws UnsupportedEncodingException, IOException {
        int sendLength = sendBytes.length;
        outputStream.write(HttpIOUtils.intToByteArray(sendLength));
        outputStream.write(sendBytes);
        outputStream.flush();
    }

    public static void sendValue(OutputStream outputStream, byte[] sendBytes) throws UnsupportedEncodingException, IOException {
        outputStream.write(sendBytes);
        outputStream.flush();
    }

    public static void sendResponseXml(Socket socket, String responseXml) throws Exception {
        logger.debug("[responseXml String]=[{}]", (Object)responseXml);
        try {
            HttpIOUtils.sendLengthAndValue(socket.getOutputStream(), responseXml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("[response encode error info:]{}", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("[response io error info:]{}", (Throwable)e);
        }
    }

    public static void sendResponseXml(Socket socket, byte[] res) throws Exception {
        logger.debug("[responseXml String]=[{}]", (Object)new String(res, "UTF-8"));
        try {
            HttpIOUtils.sendLengthAndValue(socket.getOutputStream(), res);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("[response encode error info:]{}", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("[response io error info:]{}", (Throwable)e);
        }
    }
}

