/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.service;

import cfca.com.itextpdf.text.Image;
import cfca.paperless.ClientConstants;
import cfca.paperless.base.util.Base64;
import cfca.paperless.base.util.GUIDUtil;
import cfca.paperless.base.util.ImageUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.TimeUtil;
import cfca.paperless.base.util.validity.ParamCheckUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.util.CertVerifyUtil;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.bean.BaseStrategy;
import cfca.paperless.dto.bean.ProofSealStrategy;
import cfca.paperless.dto.bean.SealStrategy;
import cfca.paperless.dto.bean.SignLocation;
import cfca.paperless.dto.request.requestbody.tx40.CalculatePdfHashLocalRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CompoundSealPdfLocalRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SynthesizeOuterSignatureLocalRequestBody;
import cfca.paperless.service.CalculatePdfHashLocalResult;
import cfca.paperless.service.PaperlessSignResult;
import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.DeviceRgb;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.ofd.base.common.SVGUtil;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.BlankAppearance;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.appearance.MixAppearance;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.AsynCFCASigner;
import cfca.sadk.seal.base.util.BytesUtil;
import cfca.sadk.seal.base.util.CFCAP7Signer;
import cfca.sadk.seal.base.util.CFCATSAClient;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.FontsFactory;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.AsyncSignatureUtil;
import cfca.sadk.seal.util.SealSignatureUtil;
import cfca.sadk.seal.util.VerifyUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SealPdfService {
    private static final Logger sysLog = LoggerFactory.getLogger(CertVerifyUtil.class);

    public byte[] doCompoundSealPdfLocal(CompoundSealPdfLocalRequestBody requestBody, String timestampConfig) throws Exception {
        CFCATSAClient tsaClient;
        TimestampConfig config;
        HashAlgorithm hashAlgorithm;
        SignInfoConfig signInfo;
        Mechanism sigAlg;
        String hashAlg;
        PrivateKey privateKey;
        List sealStrategies = requestBody.getSealStrategies();
        List proofSealStrategies = requestBody.getProofSealStrategies();
        boolean flag = false;
        if (proofSealStrategies != null && proofSealStrategies.size() > 0) {
            flag = true;
            for (ProofSealStrategy proofSealStrategy : proofSealStrategies) {
                ValidateUtil.checkProofSealStrategy(proofSealStrategy);
            }
        }
        if (sealStrategies != null && sealStrategies.size() > 0) {
            flag = true;
            for (SealStrategy sealStrategy : sealStrategies) {
                ValidateUtil.checkSealStrategy4Asyn(sealStrategy, true);
            }
        }
        if (!flag) {
            throw new Exception("proofSealStrategy and sealStrategy is null");
        }
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        byte[] x509CertByte = requestBody.getX509Cert();
        if (x509CertByte == null || x509CertByte.length == 0) {
            throw new Exception("x509Cert is null");
        }
        X509Cert x509Cert = new X509Cert(requestBody.getX509Cert());
        X509Cert[] chain = null;
        if (x509Cert != null) {
            chain = new X509Cert[]{x509Cert};
        }
        if ((privateKey = requestBody.getPrivateKey()) == null) {
            throw new Exception("privateKey is null");
        }
        byte[] pdfData = requestBody.getPdfData();
        ValidityUtil.checkIsPdfFile((byte[])pdfData);
        for (ProofSealStrategy proofSealStrategy : proofSealStrategies) {
            hashAlg = proofSealStrategy.getHashAlg();
            if (null == hashAlg || StringUtil.isEmpty((String)hashAlg)) {
                throw new Exception("hashAlg is null");
            }
            sigAlg = Mechanism.getMechanismFromDigestAlgotithm((String)hashAlg);
            signInfo = new SignInfoConfig();
            signInfo.setSession(session);
            signInfo.setChain(chain);
            signInfo.setPrivateKey(privateKey);
            signInfo.setSignAlg(sigAlg);
            signInfo.setP7ContainChain(true);
            signInfo.setPKCS7SigEstimatedSize(8192);
            hashAlgorithm = null;
            hashAlg = hashAlg.replaceAll("-", "");
            if (HashAlgorithm.SHA1.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA1;
            } else if (HashAlgorithm.SHA256.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA256;
            } else if (HashAlgorithm.SHA512.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA512;
            } else if (HashAlgorithm.SM3.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SM3;
            }
            if (StringUtil.isNotEmpty((String)timestampConfig)) {
                config = new TimestampConfig(timestampConfig);
                tsaClient = new CFCATSAClient(hashAlgorithm, config);
                signInfo.setTsaClient((ITSAClient)tsaClient);
                signInfo.setP7Signer((AbstractExternalP7Signer)new CFCAP7Signer(signInfo));
            }
            byte[] imageData = proofSealStrategy.getHandwritingImageData();
            proofSealStrategy.setSealImageData(imageData);
            PaperlessSignResult result = SealPdfService.autoSeal(pdfData, privateKey, x509Cert, (BaseStrategy)proofSealStrategy, signInfo, "", requestBody.getPdfVerifyUrl(), requestBody.getSm2SignatureVersion());
            pdfData = result.getSignedPDFData();
        }
        for (SealStrategy sealStrategy : sealStrategies) {
            hashAlg = sealStrategy.getHashAlg();
            if (null == hashAlg || StringUtil.isEmpty((String)hashAlg)) {
                throw new Exception("hashAlg is null");
            }
            sigAlg = Mechanism.getMechanismFromDigestAlgotithm((String)hashAlg);
            signInfo = new SignInfoConfig();
            signInfo.setSession(session);
            signInfo.setChain(chain);
            signInfo.setPrivateKey(privateKey);
            signInfo.setSignAlg(sigAlg);
            signInfo.setP7ContainChain(true);
            signInfo.setPKCS7SigEstimatedSize(8192);
            hashAlgorithm = null;
            hashAlg = hashAlg.replaceAll("-", "");
            if (HashAlgorithm.SHA1.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA1;
            } else if (HashAlgorithm.SHA256.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA256;
            } else if (HashAlgorithm.SHA512.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA512;
            } else if (HashAlgorithm.SM3.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SM3;
            }
            if (StringUtil.isNotEmpty((String)timestampConfig)) {
                config = new TimestampConfig(timestampConfig);
                tsaClient = new CFCATSAClient(hashAlgorithm, config);
                signInfo.setTsaClient((ITSAClient)tsaClient);
                signInfo.setP7Signer((AbstractExternalP7Signer)new CFCAP7Signer(signInfo));
            }
            PaperlessSignResult result = SealPdfService.autoSeal(pdfData, privateKey, x509Cert, (BaseStrategy)sealStrategy, signInfo, "", requestBody.getPdfVerifyUrl(), requestBody.getSm2SignatureVersion());
            pdfData = result.getSignedPDFData();
        }
        return pdfData;
    }

    private static PaperlessSignResult autoSeal(byte[] pdfData, PrivateKey privateKey, X509Cert x509Cert, BaseStrategy sealStrategy, SignInfoConfig signConifg, String signatureType, String pdfVerifyUrl, int sm2SignatureVersion) throws Exception {
        String hashAlogrithmArg;
        PaperlessSignResult signResult = new PaperlessSignResult();
        if (pdfData == null) {
            throw new Exception("pdfData is null");
        }
        if (sealStrategy == null) {
            throw new Exception("sealStrategy is null");
        }
        String signType = sealStrategy.getSealType();
        if (x509Cert == null) {
            throw new Exception("x509Cert is null");
        }
        if (null == signType || StringUtil.isEmpty((String)signType)) {
            throw new Exception("signType is null");
        }
        if (!("1".equals(signType) || "2".equals(signType) || "3".equals(signType))) {
            throw new Exception("signType = " + signType + " is not exists!");
        }
        X509Cert[] chain = null;
        if (x509Cert != null) {
            chain = new X509Cert[]{x509Cert};
        }
        if (null == (hashAlogrithmArg = sealStrategy.getHashAlg()) || StringUtil.isEmpty((String)hashAlogrithmArg)) {
            throw new Exception("hashAlogrithm is null");
        }
        boolean isAsyn = false;
        boolean isGraphic = true;
        BlankAppearance appearance = null;
        String reason = sealStrategy.getSealReason();
        String location = sealStrategy.getSealLocation();
        float offsetX = Float.parseFloat(sealStrategy.getOffsetX());
        float offsetY = Float.parseFloat(sealStrategy.getOffsetY());
        float transparency = Float.parseFloat(sealStrategy.getFillOpacity());
        byte[] imageData = sealStrategy.getSealImageData();
        String signText = sealStrategy.getSealText();
        String keyword = sealStrategy.getKeyword();
        String signFieldName = sealStrategy.getSignatureFieldName();
        float fontSize = Float.parseFloat(sealStrategy.getFontSize());
        DeviceRgb fontColor = ImageUtil.hex2RGB((String)sealStrategy.getFontColor());
        String businessCode = sealStrategy.getBusinessCode();
        DeviceRgb businessColor = ImageUtil.hex2RGB((String)sealStrategy.getBusinessColor());
        String businessFamily = sealStrategy.getBusinessFamily();
        float businessFontSize = Float.parseFloat(sealStrategy.getBusinessFontSize());
        float textRectHeightPercent = Float.parseFloat(sealStrategy.getTextRectHeightPercent());
        boolean isAddDateText = sealStrategy.isAddDateText();
        boolean isHidden = !"1".equals(sealStrategy.getVisible());
        float imageWidth = 0.0f;
        float imageHeight = 0.0f;
        float addDateImageHeight = 0.0f;
        String family = sealStrategy.getFamily();
        if (StringUtil.isNotEmpty((String)businessCode) && isAddDateText) {
            throw new Exception("\u4e1a\u52a1\u7801:" + businessCode + "\u548c\u56fe\u7247\u4e0b\u65b9\u589e\u52a0\u65e5\u671f:addDateText \u4e0d\u80fd\u540c\u65f6\u589e\u52a0\uff0c\u8bf7\u786e\u8ba4");
        }
        try {
            Mechanism sigAlg = Mechanism.getMechanismFromDigestAlgotithm((String)hashAlogrithmArg);
            if (null == imageData) {
                if (StringUtil.isEmpty((String)signText)) {
                    throw new Exception("imageBytes is null and signText is null");
                }
                isGraphic = false;
            }
            SignInfoConfig signInfo = null;
            if (signConifg == null) {
                String deviceName = "JSOFT_LIB";
                JCrypto.getInstance().initialize("JSOFT_LIB", null);
                Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
                signInfo = new SignInfoConfig();
                signInfo.setSession(session);
                signInfo.setChain(chain);
                signInfo.setSignAlg(sigAlg);
                String signAlg = sigAlg.getMechanismType();
                if (StringUtil.isNotEmpty((String)pdfVerifyUrl) && Mechanisms.M_SM3_SM2.getMechanismType().equals(signAlg)) {
                    String js = "this.submitForm({ cURL: \"" + pdfVerifyUrl + "\", cSubmitAs: \"PDF\" });";
                    signInfo.setJavaScript(js);
                }
                signInfo.setSignatureVersion(sm2SignatureVersion);
                if (null == privateKey) {
                    isAsyn = true;
                    if ("2".equals(signatureType)) {
                        if (!Mechanisms.isSM2WithSM3((Mechanism)sigAlg)) {
                            signInfo.setSignAlg(Mechanisms.M_SHA1_RSA);
                        }
                        signInfo.setSecondHash(true);
                    }
                } else {
                    signInfo.setPrivateKey(privateKey);
                }
                signInfo.setAsyn(isAsyn);
                CFCAP7Signer signer = new CFCAP7Signer(signInfo);
                signInfo.setP7Signer((AbstractExternalP7Signer)signer);
            } else {
                signInfo = signConifg;
            }
            ArrayList<BlankAppearance> appearanceList = new ArrayList<BlankAppearance>();
            if ("1".equals(signType)) {
                BlankAppearance tmpAppearance = new BlankAppearance();
                if (!ParamCheckUtil.isNotEmpty((String)signFieldName)) {
                    throw new Exception("signFieldName :(" + signFieldName + ") not exist! ");
                }
                tmpAppearance.setSignFieldName(signFieldName);
                if (isGraphic) {
                    tmpAppearance.setStamperSr(imageData);
                } else {
                    tmpAppearance.setSignText(signText);
                    tmpAppearance.setFont(FontUtil.getInstance().subsetFont(signText));
                    tmpAppearance.setFontSize(fontSize);
                    tmpAppearance.setFontColor((Color)fontColor);
                    tmpAppearance.setBold(false);
                    if (StringUtil.containsUCS4Glyph((String)signText)) {
                        try {
                            tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                        }
                        catch (Exception e) {
                            sysLog.error("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                        }
                    } else {
                        String fontNames = FontsFactory.getInstance().getFontNames().toString();
                        if (StringUtil.isNotEmpty((String)family) && fontNames.contains(family)) {
                            tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(family, signText));
                        } else {
                            tmpAppearance.setFont(FontUtil.getInstance().subsetFont(signText));
                        }
                    }
                }
                appearance = tmpAppearance;
            } else if ("2".equals(signType)) {
                Object imageSize;
                ArrayList<SignLocation> signLocationList = sealStrategy.getSignLocationList();
                if (signLocationList == null || signLocationList.size() == 0) {
                    signLocationList = new ArrayList<SignLocation>();
                    SignLocation signLocation = new SignLocation();
                    int page = Integer.parseInt(sealStrategy.getPageNo());
                    float lx = Float.parseFloat(sealStrategy.getLx());
                    float ly = Float.parseFloat(sealStrategy.getLy());
                    signLocation.setPageNo(String.valueOf(page));
                    signLocation.setLx(String.valueOf(lx));
                    signLocation.setLy(String.valueOf(ly));
                    signLocation.setSignFileName(sealStrategy.getSignatureFieldName());
                    signLocationList.add(signLocation);
                }
                if (isGraphic) {
                    imageSize = ImageUtil.getImageWidth((byte[])imageData);
                    imageWidth = imageSize[0];
                    imageHeight = imageSize[1];
                    float displaySize = Float.parseFloat(sealStrategy.getDisplaySize());
                    float displayWidth = imageWidth;
                    float displayHeight = imageHeight;
                    if (displaySize > 0.0f) {
                        float n;
                        if (displayWidth == displayHeight) {
                            displayWidth = displaySize;
                            displayHeight = displaySize;
                        } else if (displayWidth > displayHeight) {
                            n = displaySize / displayWidth;
                            displayHeight *= n;
                            displayWidth = displaySize;
                        } else {
                            n = displaySize / displayHeight;
                            displayWidth *= n;
                            displayHeight = displaySize;
                        }
                        Image image = Image.getInstance((byte[])imageData);
                        int xdpi = image.getDpiX();
                        int ydpi = image.getDpiY();
                        xdpi = xdpi == 0 ? 96 : xdpi;
                        ydpi = ydpi == 0 ? 96 : ydpi;
                        int widthPx = cfca.sadk.ofd.base.common.ImageUtil.mmConvertToPx((double)displayWidth, (double)xdpi);
                        int heightPx = cfca.sadk.ofd.base.common.ImageUtil.mmConvertToPx((double)displayHeight, (double)ydpi);
                        imageWidth = (float)widthPx * (72.0f / (float)xdpi);
                        imageHeight = (float)heightPx * (72.0f / (float)ydpi);
                    }
                    addDateImageHeight = imageHeight;
                    for (SignLocation signLocation : signLocationList) {
                        MixAppearance tmpAppearance;
                        if (Mechanisms.M_SM3_SM2.equals((Object)signInfo.getSignAlg()) && 1 == signInfo.getSignatureVersion()) {
                            tmpAppearance = new GraphicAppearance();
                            SealPdfService.setGraphicParams((GraphicAppearance)tmpAppearance, imageData, sealStrategy, signType, imageWidth, imageHeight);
                            tmpAppearance.setPageNum(Integer.parseInt(signLocation.getPageNo()));
                            appearance = tmpAppearance;
                        } else {
                            tmpAppearance = new MixAppearance();
                            SealPdfService.setGraphicParams((GraphicAppearance)tmpAppearance, imageData, sealStrategy, signType, imageWidth, imageHeight);
                            String string = keyword = StringUtil.isEmpty((String)keyword) ? "" : keyword;
                            if (StringUtil.isNotEmpty((String)businessCode) && keyword.indexOf("||") == -1) {
                                long start = System.currentTimeMillis();
                                tmpAppearance.setChangeImageHeight(false);
                                if (imageHeight * textRectHeightPercent <= 10.0f) {
                                    sysLog.error("\u6dfb\u52a0\u4e1a\u52a1\u7801:[" + businessCode + "]\u6240\u9700\u6587\u672c\u57df\u7684\u9ad8\u5ea6\uff0c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u56fe\u7247\u9ad8\u5ea6\u4e58\u4ee5textRectHeightPercent\u7684\u503c:(" + imageHeight + "*" + textRectHeightPercent + "),\u6587\u672c\u57df\u7684\u9ad8\u5ea6\u9700\u8981\u5927\u4e8e10,\u8bf7\u786e\u8ba4");
                                    throw new Exception("\u6dfb\u52a0\u4e1a\u52a1\u7801:[" + businessCode + "]\u6240\u9700\u6587\u672c\u57df\u7684\u9ad8\u5ea6\uff0c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u56fe\u7247\u9ad8\u5ea6\u4e58\u4ee5textRectHeightPercent\u7684\u503c:(" + imageHeight + "*" + textRectHeightPercent + "),\u6587\u672c\u57df\u7684\u9ad8\u5ea6\u9700\u8981\u5927\u4e8e10,\u8bf7\u786e\u8ba4");
                                }
                                tmpAppearance.setTextRectHeightPercent(textRectHeightPercent);
                                tmpAppearance.setSignText(businessCode);
                                tmpAppearance.setFontColor((Color)businessColor);
                                if (StringUtil.containsUCS4Glyph((String)businessCode)) {
                                    try {
                                        tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                                    }
                                    catch (Exception e) {
                                        sysLog.error("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                                    }
                                } else {
                                    String fontNames = FontsFactory.getInstance().getFontNames().toString();
                                    if (!StringUtil.isEmpty((String)businessCode) && fontNames.contains(businessFamily)) {
                                        tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(businessFamily, businessCode));
                                    } else {
                                        tmpAppearance.setFont(FontUtil.getInstance().subsetFont(businessCode));
                                    }
                                }
                                tmpAppearance.setFontSize(businessFontSize);
                                long end = System.currentTimeMillis();
                                sysLog.info("autoSign add businessCode end...cost=" + (end - start) + "ms");
                            }
                            if (isAddDateText && keyword.indexOf("||") == -1) {
                                sysLog.info("autoSign add addDateText start...");
                                long start = System.currentTimeMillis();
                                tmpAppearance.setChangeImageHeight(false);
                                float dateRectHeight = Float.parseFloat(sealStrategy.getDateRectHeight());
                                if (dateRectHeight <= 10.0f || dateRectHeight > imageHeight) {
                                    sysLog.info("dateRectHeight\u7684\u503c:" + dateRectHeight + ",\u9700\u8981\u5927\u4e8e10\u5c0f\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6:" + imageHeight);
                                    throw new Exception("dateRectHeight\u7684\u503c:" + dateRectHeight + ",\u9700\u8981\u5927\u4e8e10\u5c0f\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6:" + imageHeight);
                                }
                                String addDateText = sealStrategy.getAddDateText();
                                if (StringUtil.isEmpty((String)addDateText)) {
                                    addDateText = TimeUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5");
                                }
                                tmpAppearance.setSignText(addDateText);
                                float dateFontSize = Float.parseFloat(sealStrategy.getDateFontSize());
                                tmpAppearance.setFontSize(dateFontSize);
                                String dateFontFamily = sealStrategy.getDateFontFamily();
                                if (StringUtil.containsUCS4Glyph((String)addDateText)) {
                                    try {
                                        tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                                    }
                                    catch (Exception e) {
                                        sysLog.warn("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                                    }
                                } else {
                                    Set fontNames = FontsFactory.getInstance().getFontNames();
                                    if (StringUtil.isNotEmpty((String)dateFontFamily) && fontNames.contains(dateFontFamily)) {
                                        tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(dateFontFamily, addDateText));
                                    } else {
                                        tmpAppearance.setFont(FontUtil.getInstance().subsetFont(addDateText));
                                    }
                                }
                                DeviceRgb dateFontColor = ImageUtil.hex2RGB((String)sealStrategy.getDateFontColor());
                                tmpAppearance.setFontColor((Color)dateFontColor);
                                tmpAppearance.setTextRectHeight(dateRectHeight);
                                tmpAppearance.setAlignmentV(VerticalAlignment.BOTTOM);
                                tmpAppearance.getRectangle().setHeight(addDateImageHeight);
                                long end = System.currentTimeMillis();
                                sysLog.info("autoSign add addDateText end...cost=" + (end - start) + "ms");
                            }
                            appearance = tmpAppearance;
                        }
                        appearance.setPageNum(Integer.parseInt(signLocation.getPageNo()));
                        appearance.setTransparency(transparency);
                        appearance.setOffset(offsetX, offsetY);
                        appearance.setHidden(isHidden);
                        appearance.setSignFieldName(signLocation.getSignFileName());
                        appearance.setReason(reason);
                        appearance.setLocation(location);
                        appearanceList.add(appearance);
                    }
                } else {
                    imageWidth = Float.parseFloat(sealStrategy.getWidth());
                    addDateImageHeight = imageHeight = Float.parseFloat(sealStrategy.getHeight());
                    imageSize = signLocationList.iterator();
                    while (imageSize.hasNext()) {
                        SignLocation signLocation = (SignLocation)imageSize.next();
                        TextAppearance tmpAppearance = new TextAppearance();
                        tmpAppearance.setSignText(signText);
                        tmpAppearance.setFontSize(fontSize);
                        tmpAppearance.setFontColor((Color)fontColor);
                        tmpAppearance.setBold(false);
                        float lx = Float.parseFloat(sealStrategy.getLx());
                        float ly = Float.parseFloat(sealStrategy.getLy());
                        if (StringUtil.containsUCS4Glyph((String)signText)) {
                            try {
                                tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                            }
                            catch (Exception e) {
                                sysLog.warn("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                            }
                        } else {
                            Set fontNames = FontsFactory.getInstance().getFontNames();
                            if (StringUtil.isNotEmpty((String)family) && fontNames.contains(family)) {
                                tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(family, signText));
                            } else {
                                tmpAppearance.setFont(FontUtil.getInstance().subsetFont(signText));
                            }
                        }
                        tmpAppearance.setRectangle(new Rectangle(lx, ly, Float.parseFloat(sealStrategy.getWidth()), Float.parseFloat(sealStrategy.getHeight())));
                        appearance = tmpAppearance;
                        appearance.setUpperLeftCoordinate(false);
                        appearance.setPageNum(Integer.parseInt(signLocation.getPageNo()));
                        appearance.setSignFieldName(signLocation.getSignFileName());
                        imageWidth = Float.parseFloat(sealStrategy.getWidth());
                        addDateImageHeight = Float.parseFloat(sealStrategy.getHeight());
                        appearance.setTransparency(transparency);
                        appearance.setOffset(offsetX, offsetY);
                        appearance.setHidden(isHidden);
                        appearance.setReason(reason);
                        appearance.setLocation(location);
                        appearanceList.add(appearance);
                    }
                }
            } else if ("3".equals(signType)) {
                TextAppearance tmpAppearance;
                int page = Integer.parseInt(sealStrategy.getPageNo());
                float lx = Float.parseFloat(sealStrategy.getLx());
                float ly = Float.parseFloat(sealStrategy.getLy());
                if (isGraphic) {
                    float[] imageSize;
                    if (BytesUtil.isContainsBytes((byte[])imageData, (byte[])"<svg".getBytes("UTF-8")) && BytesUtil.isContainsBytes((byte[])imageData, (byte[])"svg>".getBytes("UTF-8"))) {
                        imageSize = SVGUtil.getSVGPixel((byte[])imageData);
                        imageWidth = imageSize[0];
                        imageHeight = imageSize[1];
                    } else {
                        imageSize = ImageUtil.getImageWidth((byte[])imageData);
                        imageWidth = imageSize[0];
                        imageHeight = imageSize[1];
                        float displaySize = Float.parseFloat(sealStrategy.getDisplaySize());
                        float displayWidth = imageWidth;
                        float displayHeight = imageHeight;
                        if (displaySize > 0.0f) {
                            float n;
                            if (displayWidth == displayHeight) {
                                displayWidth = displaySize;
                                displayHeight = displaySize;
                            } else if (displayWidth > displayHeight) {
                                n = displaySize / displayWidth;
                                displayHeight *= n;
                                displayWidth = displaySize;
                            } else {
                                n = displaySize / displayHeight;
                                displayWidth *= n;
                                displayHeight = displaySize;
                            }
                            Image image = Image.getInstance((byte[])imageData);
                            int xdpi = image.getDpiX();
                            int ydpi = image.getDpiY();
                            xdpi = xdpi == 0 ? 96 : xdpi;
                            ydpi = ydpi == 0 ? 96 : ydpi;
                            int widthPx = cfca.sadk.ofd.base.common.ImageUtil.mmConvertToPx((double)displayWidth, (double)xdpi);
                            int heightPx = cfca.sadk.ofd.base.common.ImageUtil.mmConvertToPx((double)displayHeight, (double)ydpi);
                            imageWidth = (float)widthPx * (72.0f / (float)xdpi);
                            imageHeight = (float)heightPx * (72.0f / (float)ydpi);
                        }
                    }
                    addDateImageHeight = imageHeight;
                    if (Mechanisms.M_SM3_SM2.equals((Object)signInfo.getSignAlg()) && 1 == signInfo.getSignatureVersion()) {
                        tmpAppearance = new GraphicAppearance();
                        SealPdfService.setGraphicParams((GraphicAppearance)tmpAppearance, imageData, sealStrategy, signType, imageWidth, imageHeight);
                        tmpAppearance.setPageNum(page);
                        appearance = tmpAppearance;
                    } else {
                        tmpAppearance = new MixAppearance();
                        SealPdfService.setGraphicParams((GraphicAppearance)tmpAppearance, imageData, sealStrategy, signType, imageWidth, imageHeight);
                        String string = keyword = StringUtil.isEmpty((String)keyword) ? "" : keyword;
                        if (StringUtil.isNotEmpty((String)businessCode) && keyword.indexOf("||") == -1) {
                            tmpAppearance.setChangeImageHeight(false);
                            if (imageHeight * textRectHeightPercent <= 10.0f) {
                                throw new Exception("\u6dfb\u52a0\u4e1a\u52a1\u7801:[" + businessCode + "]\u6240\u9700\u6587\u672c\u57df\u7684\u9ad8\u5ea6\uff0c\u8ba1\u7b97\u65b9\u5f0f\u4e3a\u56fe\u7247\u9ad8\u5ea6\u4e58\u4ee5textRectHeightPercent\u7684\u503c:(" + imageHeight + "*" + textRectHeightPercent + "),\u6587\u672c\u57df\u7684\u9ad8\u5ea6\u9700\u8981\u5927\u4e8e10,\u8bf7\u786e\u8ba4");
                            }
                            tmpAppearance.setTextRectHeightPercent(textRectHeightPercent);
                            tmpAppearance.setSignText(businessCode);
                            tmpAppearance.setFontColor((Color)businessColor);
                            if (StringUtil.containsUCS4Glyph((String)businessCode)) {
                                try {
                                    tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                                }
                                catch (Exception e) {
                                    System.err.println("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                                }
                            } else {
                                String fontNames = FontsFactory.getInstance().getFontNames().toString();
                                if (!StringUtil.isEmpty((String)businessCode) && fontNames.contains(businessFamily)) {
                                    tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(businessFamily, businessCode));
                                } else {
                                    tmpAppearance.setFont(FontUtil.getInstance().subsetFont(businessCode));
                                }
                            }
                            tmpAppearance.setFontSize(businessFontSize);
                        }
                        if (isAddDateText && keyword.indexOf("||") == -1) {
                            tmpAppearance.setChangeImageHeight(false);
                            float dateRectHeight = Float.parseFloat(sealStrategy.getDateRectHeight());
                            if (dateRectHeight <= 10.0f || dateRectHeight > imageHeight) {
                                throw new Exception("dateRectHeight\u7684\u503c:" + dateRectHeight + ",\u9700\u8981\u5927\u4e8e10\u5c0f\u4e8e\u56fe\u7247\u7684\u9ad8\u5ea6:" + imageHeight);
                            }
                            String addDateText = sealStrategy.getAddDateText();
                            if (StringUtil.isEmpty((String)addDateText)) {
                                addDateText = TimeUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5");
                            }
                            tmpAppearance.setSignText(addDateText);
                            float dateFontSize = Float.parseFloat(sealStrategy.getDateFontSize());
                            tmpAppearance.setFontSize(dateFontSize);
                            String dateFontFamily = sealStrategy.getDateFontFamily();
                            if (StringUtil.containsUCS4Glyph((String)addDateText)) {
                                try {
                                    tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                                }
                                catch (Exception e) {
                                    System.err.println("signText \u5305\u542b\u751f\u50fb\u5b57\uff0c\u7cfb\u7edf\u672a\u5339\u914d\u5230\u8be5\u751f\u50fb\u5b57\u5b57\u4f53");
                                }
                            } else {
                                Set fontNames = FontsFactory.getInstance().getFontNames();
                                if (StringUtil.isNotEmpty((String)dateFontFamily) && fontNames.contains(dateFontFamily)) {
                                    tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(dateFontFamily, addDateText));
                                } else {
                                    tmpAppearance.setFont(FontUtil.getInstance().subsetFont(addDateText));
                                }
                            }
                            DeviceRgb dateFontColor = ImageUtil.hex2RGB((String)sealStrategy.getDateFontColor());
                            tmpAppearance.setFontColor((Color)dateFontColor);
                            tmpAppearance.setTextRectHeight(dateRectHeight);
                            tmpAppearance.setAlignmentV(VerticalAlignment.BOTTOM);
                            addDateImageHeight = imageHeight + dateRectHeight;
                            tmpAppearance.getRectangle().setHeight(addDateImageHeight);
                        }
                        appearance = tmpAppearance;
                    }
                } else {
                    imageWidth = Float.parseFloat(sealStrategy.getWidth());
                    imageHeight = Float.parseFloat(sealStrategy.getHeight());
                    addDateImageHeight = Float.parseFloat(sealStrategy.getHeight());
                    tmpAppearance = new TextAppearance();
                    tmpAppearance.setSignText(signText);
                    tmpAppearance.setFontSize(fontSize);
                    tmpAppearance.setFontColor((Color)fontColor);
                    tmpAppearance.setBold(false);
                    if (StringUtil.containsUCS4Glyph((String)signText)) {
                        try {
                            tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(ClientConstants.uncommonFontName, signText));
                        }
                        catch (Exception dateRectHeight) {}
                    } else {
                        Set fontNames = FontsFactory.getInstance().getFontNames();
                        if (StringUtil.isNotEmpty((String)family) && fontNames.contains(family)) {
                            tmpAppearance.setFont(FontsFactory.getInstance().getSubSetFont(family, signText));
                        } else {
                            tmpAppearance.setFont(FontUtil.getInstance().subsetFont(signText));
                        }
                    }
                    tmpAppearance.setRectangle(new Rectangle(lx, ly, Float.parseFloat(sealStrategy.getWidth()), Float.parseFloat(sealStrategy.getHeight())));
                    appearance = tmpAppearance;
                    appearance.setUpperLeftCoordinate(false);
                }
                appearance.setSignFieldName(signFieldName);
                appearance.setPageNum(page);
                appearance.setTransparency(transparency);
                appearance.setOffset(offsetX, offsetY);
                appearance.setHidden(isHidden);
            }
            if (isAsyn) {
                SealResultInfo result = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(pdfData);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                result = "3".equals(signType) ? (isGraphic ? AsyncSignatureUtil.signKeyword((InputStream)new ByteArrayInputStream(pdfData), (OutputStream)baos, (GraphicAppearance)((GraphicAppearance)appearance), (SignInfoConfig)signInfo, (String)keyword, (boolean)true) : AsyncSignatureUtil.signKeyword((InputStream)new ByteArrayInputStream(pdfData), (OutputStream)baos, (TextAppearance)((TextAppearance)appearance), (SignInfoConfig)signInfo, (String)keyword, (boolean)true)) : AsyncSignatureUtil.signCoordinates((InputStream)bais, (OutputStream)baos, appearanceList, (SignInfoConfig)signInfo);
                result.setSignedPDFData(baos.toByteArray());
                byte[] hashData = signInfo.getP7Signer().getHashValue();
                signResult.setHashData(hashData);
                signFieldName = appearance.getSignFieldName();
                result.setSignFieldName(signFieldName);
                signResult.setSealResultInfo(result);
            }
        }
        catch (SealException e) {
            sysLog.error("autoSeal failed", (Throwable)e);
            if (e.getMessage().contains("keyword error:")) {
                throw new Exception(e.getMessage());
            }
            if (e.getMessage().contains("x509Cert is expired")) {
                throw new Exception("x509Cert is expired");
            }
            if (e.getMessage().contains("pageNum error:")) {
                throw new Exception(e.getMessage());
            }
            if (e.getMessage().contains("fontInfo is not found")) {
                throw new Exception("\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5b89\u88c5\u5bf9\u5e94\u7684\u5b57\u4f53\u6587\u4ef6");
            }
            if (e.getCause() instanceof GeneralSecurityException) {
                if (e.getCause().getCause() != null) {
                    throw new Exception(e.getCause().getCause().getMessage());
                }
                throw new Exception(e.getCause().getMessage());
            }
            throw new Exception("\u7b7e\u7ae0\u5f02\u5e38," + e.getMessage());
        }
        catch (Exception e) {
            sysLog.error("autoSeal failed", (Throwable)e);
            throw e;
        }
        return signResult;
    }

    public CalculatePdfHashLocalResult doCalculatePdfHashLocal(CalculatePdfHashLocalRequestBody requestBody) throws Exception {
        String hashAlogrithmArg;
        SealStrategy sealStrategy = requestBody.getSealStrategy();
        ValidateUtil.checkSealStrategy4Asyn(sealStrategy, true);
        byte[] x509CertByte = requestBody.getX509Cert();
        if (x509CertByte == null || x509CertByte.length == 0) {
            throw new Exception("x509Cert is null");
        }
        X509Cert x509Cert = new X509Cert(requestBody.getX509Cert());
        byte[] pdfData = requestBody.getPdfData();
        PdfReader pdfReader = ValidityUtil.checkPdf((byte[])pdfData);
        String sealType = sealStrategy.getSealType();
        if ("2".equals(sealType)) {
            int pdfMaxPage = PDFUtil.getPageNums((PdfReader)pdfReader);
            if (Integer.parseInt(sealStrategy.getPageNo()) > pdfMaxPage) {
                throw new Exception(" pageNo must between:1-" + pdfMaxPage);
            }
        }
        if (null == (hashAlogrithmArg = sealStrategy.getHashAlg()) || StringUtil.isEmpty((String)hashAlogrithmArg)) {
            throw new Exception("hashAlg is null");
        }
        String[] signKey = SealPdfService.getSignKeyAlg(hashAlogrithmArg, true);
        String keyAlg = signKey[0];
        String hashAlg = signKey[1];
        String sigAlg = x509Cert.getSignatureAlgName();
        if (sigAlg.contains("sm3")) {
            keyAlg = "SM2";
            hashAlg = "SM3";
        }
        sealStrategy.setHashAlg(hashAlg);
        String signFileName = sealStrategy.getSignatureFieldName();
        if (StringUtil.isEmpty((String)signFileName)) {
            signFileName = GUIDUtil.generateId();
        }
        sealStrategy.setSignatureFieldName(signFileName);
        PaperlessSignResult result = SealPdfService.autoSeal(pdfData, null, x509Cert, (BaseStrategy)sealStrategy, null, "", requestBody.getPdfVerifyUrl(), requestBody.getSm2SignatureVersion());
        CalculatePdfHashLocalResult localResult = new CalculatePdfHashLocalResult();
        localResult.setPdfHash(Base64.toBase64String((byte[])result.getHashData()));
        localResult.setPdfData(result.getSignedPDFData());
        localResult.setHashAlg(hashAlg);
        localResult.setKeyAlg(keyAlg);
        localResult.setSignFileName(signFileName);
        localResult.setX509Cert(x509CertByte);
        localResult.setPdfHashData(result.getHashData());
        return localResult;
    }

    public byte[] doSynthesizeOuterSignatureLocal(CalculatePdfHashLocalResult localResult, SynthesizeOuterSignatureLocalRequestBody requestBody, String timestampConfig) throws Exception {
        byte[] signature = requestBody.getSignature();
        String signatureType = requestBody.getSignatureType();
        byte[] signedPdfData = null;
        byte[] reservedPdfFile = localResult.getPdfData();
        String keyAlg = localResult.getKeyAlg();
        String hashAlg = localResult.getHashAlg();
        byte[] x509CertByte = localResult.getX509Cert();
        String signFileName = localResult.getSignFileName();
        try {
            SealResultInfo result;
            SealVerifyResult verifyResult;
            boolean isP7;
            AsynCFCASigner p7Signer = null;
            X509Cert[] chain = null;
            CFCATSAClient tsaClient = null;
            X509Cert x509Cert = null;
            if (null == signature || signature.length == 0) {
                throw new Exception(" signature is null");
            }
            String deviceName = "JSOFT_LIB";
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
            Mechanism sigAlg = Mechanisms.M_SHA256_RSA;
            sigAlg = "SM2".equals(keyAlg) ? Mechanisms.M_SM3_SM2 : Mechanism.getMechanismFromDigestAlgotithm((String)hashAlg);
            if (x509CertByte != null) {
                x509Cert = new X509Cert(x509CertByte);
                chain = new X509Cert[]{x509Cert};
            }
            SignInfoConfig asynSignInfo = new SignInfoConfig();
            asynSignInfo.setSession(session);
            asynSignInfo.setChain(chain);
            asynSignInfo.setSignAlg(sigAlg);
            asynSignInfo.setPKCS7SigEstimatedSize(8192);
            GraphicAppearance externalAppearance = new GraphicAppearance();
            externalAppearance.setSignFieldName(signFileName);
            HashAlgorithm hashAlgorithm = null;
            hashAlg = hashAlg.replaceAll("-", "");
            if (HashAlgorithm.SHA1.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA1;
            } else if (HashAlgorithm.SHA256.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA256;
            } else if (HashAlgorithm.SHA512.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SHA512;
            } else if (HashAlgorithm.SM3.toString().contains(hashAlg)) {
                hashAlgorithm = HashAlgorithm.SM3;
            }
            if (StringUtil.isNotEmpty((String)timestampConfig)) {
                TimestampConfig config = new TimestampConfig(timestampConfig);
                if ("SM3".equals(hashAlg)) {
                    config.setHttpURL(config.getCommonConf().getHttpURL() + "/sm2");
                }
                tsaClient = new CFCATSAClient(hashAlgorithm, config);
                asynSignInfo.setTsaClient((ITSAClient)tsaClient);
            }
            if (isP7 = SealPdfService.isPKCS7(signature)) {
                p7Signer = new AsynCFCASigner(signature, sigAlg);
                if ("2".equals(signatureType)) {
                    p7Signer.setOriginHash(localResult.getPdfHashData());
                    p7Signer.setSecondHash(true);
                }
                if (null != tsaClient) {
                    p7Signer.setTsaClient((ITSAClient)tsaClient);
                }
            } else {
                if ("2".equals(signatureType)) {
                    asynSignInfo.setSignAlg(sigAlg);
                    asynSignInfo.setOriginHash(localResult.getPdfHashData());
                }
                p7Signer = new AsynCFCASigner(asynSignInfo, signature);
            }
            if (!(verifyResult = VerifyUtil.verify((byte[])(signedPdfData = (result = AsyncSignatureUtil.combineExternalP7Signature((byte[])reservedPdfFile, (GraphicAppearance)externalAppearance, (AbstractExternalP7Signer)p7Signer)).getSignedPDFData()))).getVerifyResult()) {
                throw new Exception(verifyResult.getFailReason());
            }
        }
        catch (SealException e) {
            System.err.println((Object)e);
            if (e.getMessage().contains("keyword error:")) {
                throw new Exception(e.getMessage());
            }
            if (e.getMessage().contains("x509Cert is expired")) {
                throw new Exception("x509Cert is expired");
            }
            if (e.getCause() instanceof GeneralSecurityException) {
                if (e.getCause().getCause() != null) {
                    throw new Exception(e.getCause().getCause().getMessage());
                }
                throw new Exception(e.getCause().getMessage());
            }
            throw new Exception("\u7b7e\u7ae0\u5f02\u5e38," + e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
        return signedPdfData;
    }

    private static final SealResultInfo autoSign(byte[] sourceData, AbstractAppearance appearance, SignInfoConfig signInfo, String keyword) throws SealException {
        SealResultInfo result;
        block6: {
            block4: {
                block7: {
                    block5: {
                        result = null;
                        if (null != keyword && !StringUtil.isEmpty((String)keyword)) break block4;
                        if (!(appearance instanceof GraphicAppearance)) break block5;
                        int startNum = ((GraphicAppearance)appearance).getStartPageNum();
                        int endNum = ((GraphicAppearance)appearance).getEndPageNum();
                        result = startNum == 0 && endNum == 0 ? SealSignatureUtil.signGraphic((byte[])sourceData, (GraphicAppearance)((GraphicAppearance)appearance), (SignInfoConfig)signInfo) : SealSignatureUtil.signCrossPage((byte[])sourceData, (GraphicAppearance)((GraphicAppearance)appearance), (SignInfoConfig)signInfo);
                        break block6;
                    }
                    if (!(appearance instanceof BlankAppearance)) break block7;
                    result = SealSignatureUtil.signBlank((byte[])sourceData, (BlankAppearance)((BlankAppearance)appearance), (SignInfoConfig)signInfo);
                    break block6;
                }
                if (!(appearance instanceof TextAppearance)) break block6;
                result = SealSignatureUtil.signText((byte[])sourceData, (TextAppearance)((TextAppearance)appearance), (SignInfoConfig)signInfo);
                break block6;
            }
            List<String> keywordList = SealPdfService.getKeywordList(keyword);
            for (String key : keywordList) {
                if (appearance instanceof GraphicAppearance) {
                    result = SealSignatureUtil.signKeyword((byte[])sourceData, (GraphicAppearance)((GraphicAppearance)appearance), (SignInfoConfig)signInfo, (String)key);
                } else if (appearance instanceof TextAppearance) {
                    result = SealSignatureUtil.signKeyword((byte[])sourceData, (TextAppearance)((TextAppearance)appearance), (SignInfoConfig)signInfo, (String)key);
                }
                sourceData = result.getSignedPDFData();
            }
        }
        return result;
    }

    private static List<String> getKeywordList(String totalKeyword) {
        ArrayList<String> keywordList = new ArrayList<String>();
        if (totalKeyword.indexOf("||") != -1) {
            String[] keywordArr = null;
            for (String keyword : keywordArr = totalKeyword.split("\\|\\|")) {
                keywordList.add(keyword);
            }
        } else {
            keywordList.add(totalKeyword);
        }
        return keywordList;
    }

    public boolean checkCertMatchKey(PrivateKey privateKey, X509Cert x509Cert, String signAlg) throws Exception {
        byte[] testData = "CFCA".getBytes("UTF-8");
        boolean verifySign = false;
        Signature signature = new Signature();
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        byte[] sign = signature.p1SignMessage(signAlg, testData, privateKey, session);
        verifySign = signature.p1VerifyMessage(signAlg, testData, sign, x509Cert.getPublicKey(), session);
        if (!verifySign) {
            throw new Exception("\u8bc1\u4e66\u6570\u636e\u5f02\u5e38\uff01");
        }
        return verifySign;
    }

    private static String[] getSignKeyAlg(String hashAlogrithmArg, boolean sha256Supported) {
        String keyAlg = "RSA";
        String hashAlg = "SHA-1";
        if (StringUtil.isNotEmpty((String)hashAlogrithmArg)) {
            if (hashAlogrithmArg.toUpperCase().contains("SHA1")) {
                hashAlg = "SHA-1";
            } else if (hashAlogrithmArg.toUpperCase().contains("SHA-256") && sha256Supported) {
                hashAlg = "SHA-256";
            } else if (hashAlogrithmArg.toUpperCase().contains("SHA-512")) {
                hashAlg = "SHA-512";
            } else if (hashAlogrithmArg.toUpperCase().contains("SM3")) {
                keyAlg = "SM2";
                hashAlg = "SM3";
            } else if (hashAlogrithmArg.toUpperCase().contains("MD5")) {
                hashAlg = "MD5";
            } else if (hashAlogrithmArg.toUpperCase().contains("SHA-384")) {
                hashAlg = "SHA-384";
            }
        }
        return new String[]{keyAlg, hashAlg};
    }

    public static boolean isPKCS7(byte[] signature) {
        boolean isP7 = false;
        try {
            ASN1Sequence sequence;
            if ((ASN1Parser.isDERSequence((byte[])signature) || ASN1Parser.isBERSequence((byte[])signature)) && (sequence = ASN1Sequence.getInstance((Object)signature)).getObjectAt(0) instanceof ASN1ObjectIdentifier) {
                ASN1ObjectIdentifier p7Identifier = (ASN1ObjectIdentifier)sequence.getObjectAt(0);
                if (GMObjectIdentifiers.sm2SignedData.getId().equals(p7Identifier.getId()) || PKCSObjectIdentifiers.signedData.getId().equals(p7Identifier.getId())) {
                    isP7 = true;
                }
            }
        }
        catch (PKIException e) {
            System.err.println("parse signature failed");
        }
        return isP7;
    }

    private static void setGraphicParams(GraphicAppearance tmpAppearance, byte[] imageData, BaseStrategy sealStrategy, String signType, float width, float height) throws SealException, IOException {
        boolean isCenter;
        tmpAppearance.setRectangle(new Rectangle(Float.parseFloat(sealStrategy.getLx()), Float.parseFloat(sealStrategy.getLy()), width, height));
        tmpAppearance.setStamperSr(imageData);
        boolean bl = isCenter = "1".equals(sealStrategy.getIsCenterCoordinate());
        if (isCenter) {
            tmpAppearance.setCenterCoordinate();
            float tmpY = tmpAppearance.getRectangle().getY();
            if (tmpY < 0.0f) {
                tmpAppearance.getRectangle().setY(Math.abs(tmpY));
            }
        } else {
            tmpAppearance.setUpperLeftCoordinate(false);
        }
    }
}

