/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.java.security.CFCACryptoPrimitive;
import cfca.sadk.tls.java.util.CFCASSLConstants;
import cfca.sadk.tls.javax.net.ssl.CFCASNIMatcher;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.CipherSuiteList;
import cfca.sadk.tls.sun.security.ssl.ConnectionKeys;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.EngineOutputRecord;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.OutputRecord;
import cfca.sadk.tls.sun.security.ssl.ProtocolList;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.SSLContextImpl;
import cfca.sadk.tls.sun.security.ssl.SSLEngineImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSessionImpl;
import cfca.sadk.tls.sun.security.ssl.SSLSocketImpl;
import cfca.sadk.tls.sun.security.ssl.message.Finished;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialParameters;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterials;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBulk;
import cfca.sadk.tls.sun.security.ssl.sec.CipherMode;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import cfca.sadk.tls.sun.security.ssl.sec.MAC;
import cfca.sadk.tls.sun.security.ssl.sec.SSLAlgorithmConstraints;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.TLSCredentials;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

abstract class Handshaker {
    static final boolean allowUnsafeRenegotiation = CFCASSLConstants.allowUnsafeRenegotiation;
    static final boolean allowLegacyHelloMessages = CFCASSLConstants.allowLegacyHelloMessages;
    static final boolean rejectClientInitiatedRenego = CFCASSLConstants.rejectClientInitiatedRenego;
    boolean secureRenegotiation;
    boolean isInitialHandshake;
    private boolean isClient;
    private boolean needCertVerify;
    boolean resumingSession;
    boolean enableNewSession;
    boolean invalidated;
    byte[] clientVerifyData;
    byte[] serverVerifyData;
    ProtocolVersion beingProtocolVersion;
    ProtocolVersion activeProtocolVersion;
    private ProtocolList enabledProtocols;
    private ProtocolList activeProtocols;
    private CipherSuiteList enabledCipherSuites;
    private CipherSuiteList activeCipherSuites;
    String identificationProtocol;
    CFCAAlgorithmConstraints algorithmConstraints = null;
    List<SignatureAndHashAlgorithm> localSupportedSignAlgs;
    List<SignatureAndHashAlgorithm> peerSupportedSignAlgs;
    List<CFCASNIServerName> serverNames = Collections.emptyList();
    List<CFCASNIMatcher> sniMatchers = Collections.emptyList();
    HandshakeInStream in;
    HandshakeOutStream out;
    HandshakeHash handshakeHash;
    RandomCookie clientRandom;
    RandomCookie serverRandom;
    SSLContextImpl context;
    SSLSessionImpl session;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    int state;
    CipherSuite cipherSuite;
    boolean preferLocalCipherSuites = false;
    private ConnectionKeys clientConnectionKeys = new ConnectionKeys();
    private ConnectionKeys serverConnectionKeys = new ConnectionKeys();
    private volatile boolean delegatedTaskFlag = false;
    private volatile DelegatedTask<?> delegatedTask = null;
    private volatile Exception thrown = null;
    private Object thrownLock = new Object();
    TLSCredentials signerCredentials = null;
    TLSCredentials cipherCredentials = null;

    Handshaker(SSLSocketImpl conn, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.conn = conn;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    Handshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.engine = engine;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    final void init(SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        if (Debugger.handshaker.isDebugEnabled()) {
            Debugger.handshaker.debug("Allow unsafe renegotiation: {}\nAllow legacy hello messages: {}\nIs initial handshake: {}\nIs secure renegotiation: {}", new Object[]{allowUnsafeRenegotiation, allowLegacyHelloMessages, isInitialHandshake, secureRenegotiation});
        }
        this.context = context;
        this.isClient = isClient;
        this.needCertVerify = needCertVerify;
        this.activeProtocolVersion = activeProtocolVersion;
        this.isInitialHandshake = isInitialHandshake;
        this.secureRenegotiation = secureRenegotiation;
        this.clientVerifyData = clientVerifyData;
        this.serverVerifyData = serverVerifyData;
        this.enableNewSession = true;
        this.invalidated = false;
        this.setBeingCipherSuite(CipherSuite.C_NULL);
        this.setEnabledProtocols(enabledProtocols);
        this.algorithmConstraints = this.conn != null ? new SSLAlgorithmConstraints(this.conn, true) : new SSLAlgorithmConstraints(this.engine, true);
        this.state = -2;
    }

    final void fatalSE(byte description, String diagnostic) throws IOException {
        this.fatalSE(description, diagnostic, null);
    }

    final void fatalSE(byte description, Throwable cause) throws IOException {
        this.fatalSE(description, null, cause);
    }

    final void fatalSE(byte description, String diagnostic, Throwable cause) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(description, diagnostic, cause);
        } else {
            this.engine.fatal(description, diagnostic, cause);
        }
    }

    final void warningSE(byte description) {
        if (this.conn != null) {
            this.conn.warning(description);
        } else {
            this.engine.warning(description);
        }
    }

    final String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    final String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    final int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    final int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    final AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    private final void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    final void setBeingVersion(ProtocolVersion protocolVersion) {
        this.beingProtocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.out.record.setVersion(protocolVersion);
    }

    final void setEnabledProtocols(ProtocolList enabledProtocols) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledProtocols = enabledProtocols;
    }

    final void setEnabledCipherSuites(CipherSuiteList enabledCipherSuites) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    final void setAlgorithmConstraints(CFCAAlgorithmConstraints algorithmConstraints) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.algorithmConstraints = new SSLAlgorithmConstraints(algorithmConstraints);
        this.localSupportedSignAlgs = null;
    }

    final List<SignatureAndHashAlgorithm> getLocalSupportedSignAlgs() {
        if (this.localSupportedSignAlgs == null) {
            this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms(this.algorithmConstraints);
        }
        return this.localSupportedSignAlgs;
    }

    final void setPeerSupportedSignAlgs(Collection<SignatureAndHashAlgorithm> algorithms) {
        this.peerSupportedSignAlgs = new ArrayList<SignatureAndHashAlgorithm>(algorithms);
    }

    final List<SignatureAndHashAlgorithm> getPeerSupportedSignAlgs() {
        return this.peerSupportedSignAlgs;
    }

    final void setIdentificationProtocol(String protocol) {
        this.identificationProtocol = protocol;
    }

    final void setSNIServerNames(List<CFCASNIServerName> serverNames) {
        this.serverNames = serverNames;
    }

    final void setSNIMatchers(List<CFCASNIMatcher> sniMatchers) {
        this.sniMatchers = sniMatchers;
    }

    final void setUseCipherSuitesOrder(boolean on) {
        this.preferLocalCipherSuites = on;
    }

    final void activate(ProtocolVersion helloVersion) throws IOException {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        if (this.activeProtocols.isEmpty() || this.activeProtocols.max.version == ProtocolVersion.NONE.version) {
            throw new SSLHandshakeException("No appropriate protocol");
        }
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        if (this.activeCipherSuites.isEmpty()) {
            throw new SSLHandshakeException("No appropriate cipher suite");
        }
        ProtocolVersion protocolVersion = this.beingProtocolVersion = this.isInitialHandshake ? this.activeProtocols.max : this.activeProtocolVersion;
        if (helloVersion == null || helloVersion.version == ProtocolVersion.NONE.version) {
            helloVersion = this.activeProtocols.helloVersion;
        }
        this.handshakeHash = new HandshakeHash(this.needCertVerify);
        this.in = new HandshakeInStream(this.handshakeHash);
        this.out = this.conn != null ? new HandshakeOutStream(this.beingProtocolVersion, helloVersion, this.handshakeHash, this.conn) : new HandshakeOutStream(this.beingProtocolVersion, helloVersion, this.handshakeHash, this.engine);
        this.state = -1;
    }

    final void setBeingCipherSuite(CipherSuite suit) {
        this.cipherSuite = suit;
    }

    final boolean isNegotiable(CipherSuite s) {
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        return Handshaker.isNegotiable(this.activeCipherSuites, s);
    }

    static final boolean isNegotiable(CipherSuiteList proposed, CipherSuite suit) {
        return proposed.contains(suit) && suit.isNegotiable();
    }

    final boolean isNegotiable(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.contains(protocolVersion);
    }

    final ProtocolVersion selectProtocolVersion(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.selectProtocolVersion(protocolVersion);
    }

    final CipherSuiteList getActiveCipherSuites() {
        if (this.activeCipherSuites == null) {
            if (this.activeProtocols == null) {
                this.activeProtocols = this.getActiveProtocols();
            }
            ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>();
            if (!this.activeProtocols.isEmpty() && this.activeProtocols.min.version != ProtocolVersion.NONE.version) {
                for (CipherSuite suite : this.enabledCipherSuites.collection()) {
                    if (suite.obsoleted > this.activeProtocols.min.version && suite.supported <= this.activeProtocols.max.version) {
                        if (!this.algorithmConstraints.permits(EnumSet.of(CFCACryptoPrimitive.KEY_AGREEMENT), suite.name, null)) continue;
                        suites.add(suite);
                        continue;
                    }
                    if (!Debugger.handshaker.isDebugEnabled()) continue;
                    if (suite.obsoleted <= this.activeProtocols.min.version) {
                        Debugger.handshaker.debug("Ignoring obsoleted cipher suite: {}", (Object)suite);
                        continue;
                    }
                    Debugger.handshaker.debug("Ignoring unsupported cipher suite: {}", (Object)suite);
                }
            }
            this.activeCipherSuites = new CipherSuiteList(suites);
        }
        return this.activeCipherSuites;
    }

    final ProtocolList getActiveProtocols() {
        if (this.activeProtocols == null) {
            ArrayList<ProtocolVersion> protocols = new ArrayList<ProtocolVersion>(4);
            for (ProtocolVersion protocol : this.enabledProtocols.collection()) {
                boolean found = false;
                for (CipherSuite suite : this.enabledCipherSuites.collection()) {
                    if (suite.isAvailable() && suite.obsoleted > protocol.version && suite.supported <= protocol.version) {
                        if (this.algorithmConstraints.permits(EnumSet.of(CFCACryptoPrimitive.KEY_AGREEMENT), suite.name, null)) {
                            protocols.add(protocol);
                            found = true;
                            break;
                        }
                        if (!Debugger.handshaker.isDebugEnabled()) continue;
                        Debugger.handshaker.debug("Ignoring disabled cipher suite: " + suite + " for " + protocol);
                        continue;
                    }
                    if (!Debugger.handshaker.isDebugEnabled()) continue;
                    Debugger.handshaker.debug("Ignoring unsupported cipher suite: " + suite + " for " + protocol);
                }
                if (found || !Debugger.handshaker.isDebugEnabled()) continue;
                Debugger.handshaker.debug("No available cipher suite for " + protocol);
            }
            this.activeProtocols = new ProtocolList(protocols);
        }
        return this.activeProtocols;
    }

    final void setEnableSessionCreation(boolean newSessions) {
        this.enableNewSession = newSessions;
    }

    final CipherBox newReadCipher() throws NoSuchAlgorithmException {
        ConnectionKeys k = this.isClient ? this.serverConnectionKeys : this.clientConnectionKeys;
        return CipherBox.newCipher(this.beingProtocolVersion, this.cipherSuite.cipher, k, this.context.getSecureRandom(), false);
    }

    final CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        ConnectionKeys k = this.isClient ? this.clientConnectionKeys : this.serverConnectionKeys;
        return CipherBox.newCipher(this.beingProtocolVersion, this.cipherSuite.cipher, k, this.context.getSecureRandom(), true);
    }

    final Authenticator newReadAuthenticator() throws NoSuchAlgorithmException, InvalidKeyException {
        ConnectionKeys k = this.isClient ? this.serverConnectionKeys : this.clientConnectionKeys;
        return MAC.newMac(this.cipherSuite.macAlg, this.beingProtocolVersion, k);
    }

    final Authenticator newWriteAuthenticator() throws NoSuchAlgorithmException, InvalidKeyException {
        ConnectionKeys k = this.isClient ? this.clientConnectionKeys : this.serverConnectionKeys;
        return MAC.newMac(this.cipherSuite.macAlg, this.beingProtocolVersion, k);
    }

    final boolean isDone() {
        return this.state == 20;
    }

    final SSLSessionImpl getSession() {
        return this.session;
    }

    final void setHandshakeSessionSE(SSLSessionImpl handshakeSession) {
        if (this.conn != null) {
            this.conn.setHandshakeSession(handshakeSession);
        } else {
            this.engine.setHandshakeSession(handshakeSession);
        }
    }

    final boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    final byte[] getClientVerifyData() {
        return this.clientVerifyData;
    }

    final byte[] getServerVerifyData() {
        return this.serverVerifyData;
    }

    final void process_record(InputRecord record, boolean expectingFinished) throws IOException {
        this.checkThrown();
        this.in.incomingRecord(record);
        if (this.conn != null || expectingFinished) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    final void processLoop() throws IOException {
        while (this.in.available() >= 4) {
            this.in.mark(4);
            byte messageType = (byte)this.in.getInt8();
            int messageLength = this.in.getInt24();
            if (this.in.available() < messageLength) {
                this.in.reset();
                return;
            }
            if (messageType == 0) {
                this.in.reset();
                this.processMessage(messageType, messageLength);
                this.in.ignore(4 + messageLength);
                continue;
            }
            this.in.mark(messageLength);
            this.processMessage(messageType, messageLength);
            this.in.digestNow();
        }
    }

    final boolean activated() {
        return this.state >= -1;
    }

    final boolean started() {
        return this.state >= 0;
    }

    final void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage message = this.getKickstartMessage();
        Debugger.debug(message);
        message.write(this.out);
        this.out.flush();
        this.state = message.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendChangeCipherSpec(Finished message, boolean lastMessage) throws IOException {
        this.out.flush();
        OutputRecord record = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        record.setVersion(this.beingProtocolVersion);
        record.write(1);
        if (this.conn != null) {
            this.conn.writeLock.lock();
            try {
                this.conn.writeRecord(record);
                this.conn.changeWriteCiphers();
                Debugger.debug(message);
                message.write(this.out);
                this.out.flush();
            }
            finally {
                this.conn.writeLock.unlock();
            }
        }
        Object object = this.engine.writeLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)record);
            this.engine.changeWriteCiphers();
            Debugger.debug(message);
            message.write(this.out);
            if (lastMessage) {
                this.out.setFinishedMsg();
            }
            this.out.flush();
        }
    }

    final void calculateKeys(SecretKey preMasterSecret, ProtocolVersion version) {
        SecretKey master = this.calculateMasterSecret(preMasterSecret, version);
        this.session.setMasterSecret(master);
        this.calculateConnectionKeys(master);
    }

    private final SecretKey calculateMasterSecret(SecretKey preMasterSecret, ProtocolVersion requestedVersion) {
        if (Debugger.handshaker.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nSESSION KEYGEN:");
            builder.append("\nPreMaster Secret:");
            builder.append((CharSequence)Hexifys.dump("", preMasterSecret.getEncoded()));
            Debugger.handshaker.debug(builder.toString());
            builder = null;
        }
        HashPRF prf = this.beingProtocolVersion.isChinaTLS11() || this.beingProtocolVersion.isStandardTLS12() ? this.cipherSuite.prfAlg : HashPRF.NONE;
        TlsMasterSecretParameters params = new TlsMasterSecretParameters(preMasterSecret, this.beingProtocolVersion.major, this.beingProtocolVersion.minor, this.clientRandom.random, this.serverRandom.random, prf);
        try {
            return params.generateMasterKey();
        }
        catch (GeneralSecurityException iae) {
            if (Debugger.handshaker.isDebugEnabled()) {
                Debugger.handshaker.debug("RSA master secret generation error:", (Throwable)iae);
            }
            throw new ProviderException(iae);
        }
    }

    final void calculateConnectionKeys(SecretKey masterKey) {
        int hashSize = this.cipherSuite.macAlg.size;
        boolean is_exportable = this.cipherSuite.exportable;
        CipherBulk cipher = this.cipherSuite.cipher;
        int expandedKeySize = is_exportable ? cipher.expandedKeySize : 0;
        HashPRF prf = this.beingProtocolVersion.isChinaTLS11() || this.beingProtocolVersion.isStandardTLS12() ? this.cipherSuite.prfAlg : HashPRF.NONE;
        int ivSize = cipher.ivSize;
        if (this.beingProtocolVersion.isTLS11() && cipher.cipherType == CipherMode.BLOCKS) {
            ivSize = 0;
        }
        TlsKeyMaterialParameters params = new TlsKeyMaterialParameters(masterKey, this.beingProtocolVersion.major, this.beingProtocolVersion.minor, this.clientRandom.random, this.serverRandom.random, cipher.algorithm, cipher.keySize, expandedKeySize, ivSize, hashSize, prf);
        try {
            TlsKeyMaterials keySpec = params.generateWorkKeys();
            this.clientConnectionKeys.writeKey = keySpec.getClientCipherKey();
            this.serverConnectionKeys.writeKey = keySpec.getServerCipherKey();
            this.clientConnectionKeys.writeIV = keySpec.getClientIv();
            this.serverConnectionKeys.writeIV = keySpec.getServerIv();
            this.clientConnectionKeys.macSecret = keySpec.getClientMacKey();
            this.serverConnectionKeys.macSecret = keySpec.getServerMacKey();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        if (Debugger.handshaker.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nCONNECTION KEYGEN:");
            builder.append("\nClient Nonce:");
            builder.append((CharSequence)Hexifys.dump("", this.clientRandom.random));
            builder.append("\nServer Nonce:");
            builder.append((CharSequence)Hexifys.dump("", this.serverRandom.random));
            builder.append("\nMaster Secret:");
            builder.append((CharSequence)Hexifys.dump("", masterKey.getEncoded()));
            if (this.clientConnectionKeys.macSecret != null) {
                builder.append("\nClient MAC write Secret:");
                builder.append((CharSequence)Hexifys.dump("", this.clientConnectionKeys.macSecret.getEncoded()));
                builder.append("\nServer MAC write Secret:");
                builder.append((CharSequence)Hexifys.dump("", this.serverConnectionKeys.macSecret.getEncoded()));
            } else {
                builder.append("\n... no MAC keys used for this cipher");
            }
            if (this.clientConnectionKeys.writeKey != null) {
                builder.append("\nClient write key:");
                builder.append((CharSequence)Hexifys.dump("", this.clientConnectionKeys.writeKey.getEncoded()));
                builder.append("\nServer write key:");
                builder.append((CharSequence)Hexifys.dump("", this.serverConnectionKeys.writeKey.getEncoded()));
            } else {
                builder.append("\n... no encryption keys used");
            }
            if (this.clientConnectionKeys.writeIV != null) {
                builder.append("\nClient write IV:");
                builder.append((CharSequence)Hexifys.dump("", this.clientConnectionKeys.writeIV.getIV()));
                builder.append("\nServer write IV:");
                builder.append((CharSequence)Hexifys.dump("", this.serverConnectionKeys.writeIV.getIV()));
            } else if (this.beingProtocolVersion.isChinaTLS11() || this.beingProtocolVersion.isStandardTLS11()) {
                builder.append("\n... no IV derived for this protocol");
            } else {
                builder.append("\n... no IV used for this cipher");
            }
        }
    }

    static void throwSSLException(String message, Throwable cause) throws SSLException {
        SSLException e = new SSLException(message);
        e.initCause(cause);
        if (Debugger.handshaker.isDebugEnabled()) {
            cause.printStackTrace();
            Debugger.handshaker.error(message, cause);
        }
        throw e;
    }

    private <T> void delegateTask(PrivilegedExceptionAction<T> pea) {
        this.delegatedTask = new DelegatedTask<T>(pea);
        this.delegatedTaskFlag = false;
        this.thrown = null;
    }

    DelegatedTask<?> getTask() {
        if (!this.delegatedTaskFlag) {
            this.delegatedTaskFlag = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThrown() throws SSLException {
        Object object = this.thrownLock;
        synchronized (object) {
            if (this.thrown != null) {
                String msg = this.thrown.getMessage();
                if (msg == null) {
                    msg = "Delegated task threw Exception/Error";
                }
                Exception e = this.thrown;
                this.thrown = null;
                if (e instanceof RuntimeException) {
                    throw new RuntimeException(msg, e);
                }
                if (e instanceof SSLHandshakeException) {
                    throw (SSLHandshakeException)new SSLHandshakeException(msg).initCause(e);
                }
                if (e instanceof SSLKeyException) {
                    throw (SSLKeyException)new SSLKeyException(msg).initCause(e);
                }
                if (e instanceof SSLPeerUnverifiedException) {
                    throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(msg).initCause(e);
                }
                if (e instanceof SSLProtocolException) {
                    throw (SSLProtocolException)new SSLProtocolException(msg).initCause(e);
                }
                throw new SSLException(msg, e);
            }
        }
    }

    class DelegatedTask<E>
    implements Runnable {
        private PrivilegedExceptionAction<E> pea;

        DelegatedTask(PrivilegedExceptionAction<E> pea) {
            this.pea = pea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException pae) {
                    Handshaker.this.thrown = pae.getException();
                }
                catch (RuntimeException rte) {
                    Handshaker.this.thrown = rte;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.delegatedTaskFlag = false;
            }
        }
    }
}

