/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.conversion.eot;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import cfca.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.com.google.typography.font.sfntly.table.truetype.LocaTable;
import cfca.com.google.typography.font.sfntly.table.truetype.SimpleGlyph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class GlyfEncoder {
    private final boolean doPush;
    private final ByteArrayOutputStream glyfStream;
    private final ByteArrayOutputStream pushStream;
    private final ByteArrayOutputStream codeStream;

    public GlyfEncoder(boolean doPush) {
        this.doPush = doPush;
        this.glyfStream = new ByteArrayOutputStream();
        this.pushStream = new ByteArrayOutputStream();
        this.codeStream = new ByteArrayOutputStream();
    }

    public GlyfEncoder() {
        this(true);
    }

    public void encode(Font sourceFont) {
        LocaTable loca = (LocaTable)sourceFont.getTable(Tag.loca);
        int nGlyphs = loca.numGlyphs();
        GlyphTable glyf = (GlyphTable)sourceFont.getTable(Tag.glyf);
        for (int glyphId = 0; glyphId < nGlyphs; ++glyphId) {
            int sourceOffset = loca.glyphOffset(glyphId);
            int length = loca.glyphLength(glyphId);
            Glyph glyph = glyf.glyph(sourceOffset, length);
            this.writeGlyph(glyph);
        }
    }

    private void writeGlyph(Glyph glyph) {
        try {
            if (glyph == null || glyph.dataLength() == 0) {
                this.writeUShort(0);
            } else if (glyph instanceof SimpleGlyph) {
                this.writeSimpleGlyph((SimpleGlyph)glyph);
            } else if (glyph instanceof CompositeGlyph) {
                this.writeCompositeGlyph((CompositeGlyph)glyph);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected IOException writing glyph data", e);
        }
    }

    private void writeInstructions(Glyph glyph) throws IOException {
        if (this.doPush) {
            this.splitPush(glyph);
        } else {
            int pushCount = 0;
            int codeSize = glyph.instructionSize();
            GlyfEncoder.write255UShort(this.glyfStream, pushCount);
            GlyfEncoder.write255UShort(this.glyfStream, codeSize);
            if (codeSize > 0) {
                glyph.instructions().copyTo(this.codeStream);
            }
        }
    }

    private void writeSimpleGlyph(SimpleGlyph glyph) throws IOException {
        int numContours = glyph.numberOfContours();
        this.writeUShort(numContours);
        for (int i = 0; i < numContours; ++i) {
            GlyfEncoder.write255UShort(this.glyfStream, glyph.numberOfPoints(i) - (i == 0 ? 1 : 0));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int lastX = 0;
        int lastY = 0;
        for (int i = 0; i < numContours; ++i) {
            int numPoints = glyph.numberOfPoints(i);
            for (int j = 0; j < numPoints; ++j) {
                int x = glyph.xCoordinate(i, j);
                int y = glyph.yCoordinate(i, j);
                int dx = x - lastX;
                int dy = y - lastY;
                this.writeTriplet(os, glyph.onCurve(i, j), dx, dy);
                lastX = x;
                lastY = y;
            }
        }
        os.writeTo(this.glyfStream);
        if (numContours > 0) {
            this.writeInstructions(glyph);
        }
    }

    private void writeCompositeGlyph(CompositeGlyph glyph) throws IOException {
        boolean haveInstructions = false;
        this.writeUShort(-1);
        this.writeUShort(glyph.xMin());
        this.writeUShort(glyph.yMin());
        this.writeUShort(glyph.xMax());
        this.writeUShort(glyph.yMax());
        for (int i = 0; i < glyph.numGlyphs(); ++i) {
            int flags = glyph.flags(i);
            this.writeUShort(flags);
            haveInstructions = (flags & 0x100) != 0;
            this.writeUShort(glyph.glyphIndex(i));
            if ((flags & 1) == 0) {
                this.glyfStream.write(glyph.argument1(i));
                this.glyfStream.write(glyph.argument2(i));
            } else {
                this.writeUShort(glyph.argument1(i));
                this.writeUShort(glyph.argument2(i));
            }
            if (glyph.transformationSize(i) == 0) continue;
            try {
                this.glyfStream.write(glyph.transformation(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (haveInstructions) {
            this.writeInstructions(glyph);
        }
    }

    private void writeUShort(int value) {
        this.glyfStream.write(value >> 8);
        this.glyfStream.write(value & 0xFF);
    }

    static void write255UShort(OutputStream os, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        if (value < 253) {
            os.write((byte)value);
        } else if (value < 506) {
            os.write(255);
            os.write((byte)(value - 253));
        } else if (value < 762) {
            os.write(254);
            os.write((byte)(value - 506));
        } else {
            os.write(253);
            os.write((byte)(value >> 8));
            os.write((byte)(value & 0xFF));
        }
    }

    static void write255Short(OutputStream os, int value) throws IOException {
        short shortValue = (short)value;
        short lowestCode = 250;
        if (shortValue >= 3 * lowestCode || shortValue <= 3 * -lowestCode) {
            os.write(253);
            os.write((byte)(shortValue >> 8));
            os.write((byte)(shortValue & 0xFF));
        } else {
            if (shortValue < 0) {
                os.write(250);
                shortValue = -shortValue;
            }
            if (shortValue >= lowestCode) {
                if ((shortValue = (short)(shortValue - lowestCode)) >= lowestCode) {
                    shortValue = (short)(shortValue - lowestCode);
                    os.write(254);
                } else {
                    os.write(255);
                }
            }
            os.write((byte)shortValue);
        }
    }

    void writeTriplet(OutputStream os, boolean onCurve, int x, int y) throws IOException {
        int absX = Math.abs(x);
        int absY = Math.abs(y);
        int onCurveBit = onCurve ? 0 : 128;
        int xSignBit = x < 0 ? 0 : 1;
        int ySignBit = y < 0 ? 0 : 1;
        int xySignBits = xSignBit + 2 * ySignBit;
        if (x == 0 && absY < 1280) {
            this.glyfStream.write(onCurveBit + ((absY & 0xF00) >> 7) + ySignBit);
            os.write(absY & 0xFF);
        } else if (y == 0 && absX < 1280) {
            this.glyfStream.write(onCurveBit + 10 + ((absX & 0xF00) >> 7) + xSignBit);
            os.write(absX & 0xFF);
        } else if (absX < 65 && absY < 65) {
            this.glyfStream.write(onCurveBit + 20 + (absX - 1 & 0x30) + ((absY - 1 & 0x30) >> 2) + xySignBits);
            os.write((absX - 1 & 0xF) << 4 | absY - 1 & 0xF);
        } else if (absX < 769 && absY < 769) {
            this.glyfStream.write(onCurveBit + 84 + 12 * ((absX - 1 & 0x300) >> 8) + ((absY - 1 & 0x300) >> 6) + xySignBits);
            os.write(absX - 1 & 0xFF);
            os.write(absY - 1 & 0xFF);
        } else if (absX < 4096 && absY < 4096) {
            this.glyfStream.write(onCurveBit + 120 + xySignBits);
            os.write(absX >> 4);
            os.write((absX & 0xF) << 4 | absY >> 8);
            os.write(absY & 0xFF);
        } else {
            this.glyfStream.write(onCurveBit + 124 + xySignBits);
            os.write(absX >> 8);
            os.write(absX & 0xFF);
            os.write(absY >> 8);
            os.write(absY & 0xFF);
        }
    }

    private void splitPush(Glyph glyph) throws IOException {
        int instrSize = glyph.instructionSize();
        ReadableFontData data = glyph.instructions();
        int i = 0;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (i + 1 < instrSize) {
            int ix = i;
            int instr = data.readUByte(ix++);
            int n = 0;
            int size = 0;
            if (instr == 64 || instr == 65) {
                n = data.readUByte(ix++);
                size = (instr & 1) + 1;
            } else {
                if (instr < 176 || instr >= 192) break;
                n = 1 + (instr & 7);
                size = ((instr & 8) >> 3) + 1;
            }
            if (i + size * n > instrSize) break;
            for (int j = 0; j < n; ++j) {
                if (size == 1) {
                    result.add(data.readUByte(ix));
                } else {
                    result.add(data.readShort(ix));
                }
                ix += size;
            }
            i = ix;
        }
        int pushCount = result.size();
        int codeSize = instrSize - i;
        GlyfEncoder.write255UShort(this.glyfStream, pushCount);
        GlyfEncoder.write255UShort(this.glyfStream, codeSize);
        this.encodePushSequence(this.pushStream, result);
        if (codeSize > 0) {
            data.slice(i).copyTo(this.codeStream);
        }
    }

    private void encodePushSequence(OutputStream os, List<Integer> data) throws IOException {
        int n = data.size();
        int hopSkip = 0;
        for (int i = 0; i < n; ++i) {
            if (!(hopSkip & true)) {
                int val = data.get(i);
                if (hopSkip == 0 && i >= 2 && i + 2 < n && val == data.get(i - 2) && val == data.get(i + 2)) {
                    if (i + 4 < n && val == data.get(i + 4)) {
                        os.write(252);
                        hopSkip = 20;
                    } else {
                        os.write(251);
                        hopSkip = 4;
                    }
                } else {
                    GlyfEncoder.write255Short(os, data.get(i));
                }
            }
            hopSkip >>= 1;
        }
    }

    public byte[] getGlyfBytes() {
        return this.glyfStream.toByteArray();
    }

    public byte[] getPushBytes() {
        return this.pushStream.toByteArray();
    }

    public byte[] getCodeBytes() {
        return this.codeStream.toByteArray();
    }
}

