/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.ssl.ConnectionKeys;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.sun.security.ssl.sec.CipherMode;
import cfca.sadk.tls.sun.security.ssl.sec.SecureRandoms;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public enum CipherBulk {
    B_NULL("NULL", CipherMode.STREAM, 0, 0, 0, 0, true),
    B_AES_256("AES/CBC/NoPadding", CipherMode.BLOCKS, 32, 16, 0, true),
    B_SM4_128("SM4/CBC/NoPadding", CipherMode.BLOCKS, 16, 16, 0, true);

    public final String description;
    public final String transformation;
    public final String algorithm;
    public final boolean allowed;
    public final int keySize;
    public final int expandedKeySize;
    public final int ivSize;
    public final int fixedIvSize;
    public final boolean exportable;
    public final CipherMode cipherType;
    private static final Map<CipherBulk, Boolean> availableCache;
    private static final SecureRandom secureRandom;

    private CipherBulk(String transformation, CipherMode cipherType, int keySize, int expandedKeySize, int ivSize, int fixedIvSize, boolean allowed) {
        this.transformation = transformation;
        String[] splits = transformation.split("/");
        this.algorithm = splits[0];
        this.cipherType = cipherType;
        this.description = this.algorithm + "/" + (keySize << 3);
        this.keySize = keySize;
        this.ivSize = ivSize;
        this.fixedIvSize = fixedIvSize;
        this.allowed = allowed;
        this.expandedKeySize = expandedKeySize;
        this.exportable = false;
    }

    private CipherBulk(String transformation, CipherMode cipherType, int keySize, int ivSize, int fixedIvSize, boolean allowed) {
        this(transformation, cipherType, keySize, keySize, ivSize, fixedIvSize, allowed);
    }

    boolean isAvailable() {
        if (!this.allowed) {
            return false;
        }
        if (this == B_AES_256) {
            return CipherBulk.isAvailable(this);
        }
        return true;
    }

    public static synchronized void clearAvailableCache() {
        availableCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isAvailable(CipherBulk cipher) {
        Boolean b = availableCache.get((Object)cipher);
        if (b == null) {
            int keySizeInBits = cipher.keySize * 8;
            if (keySizeInBits > 128) {
                try {
                    if (Cipher.getMaxAllowedKeyLength(cipher.transformation) < keySizeInBits) {
                        b = Boolean.FALSE;
                    }
                }
                catch (Exception e) {
                    if (Debugger.record.isDebugEnabled()) {
                        Debugger.record.debug("isAvailable failure: " + (Object)((Object)cipher), (Throwable)e);
                    }
                    b = Boolean.FALSE;
                }
            }
            if (b == null) {
                b = Boolean.FALSE;
                CipherBox temporary = null;
                try {
                    ConnectionKeys key = new ConnectionKeys();
                    key.writeKey = new SecretKeySpec(new byte[cipher.expandedKeySize], cipher.algorithm);
                    key.writeIV = new IvParameterSpec(new byte[cipher.ivSize]);
                    temporary = CipherBox.newCipher(ProtocolVersion.DEFAULT, cipher, key, secureRandom, true);
                    b = temporary.isAvailable();
                }
                catch (NoSuchAlgorithmException e) {
                    if (Debugger.record.isDebugEnabled()) {
                        Debugger.record.debug("isAvailable failure: " + (Object)((Object)cipher), (Throwable)e);
                    }
                }
                finally {
                    if (temporary != null) {
                        temporary.dispose();
                    }
                }
            }
            availableCache.put(cipher, b);
        }
        return b;
    }

    public String toString() {
        return this.description;
    }

    static {
        availableCache = new HashMap<CipherBulk, Boolean>(8);
        secureRandom = SecureRandoms.newSecure();
    }
}

