/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

public final class EphemeralKeyManager {
    private static final int INDEX_RSA512 = 0;
    private static final int INDEX_RSA1024 = 1;
    private final EphemeralKeyPair[] keys = new EphemeralKeyPair[]{new EphemeralKeyPair(null), new EphemeralKeyPair(null)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyPair getRSAKeyPair(boolean export, SecureRandom random) {
        int index;
        int length;
        if (export) {
            length = 512;
            index = 0;
        } else {
            length = 1024;
            index = 1;
        }
        EphemeralKeyPair[] ephemeralKeyPairArray = this.keys;
        synchronized (this.keys) {
            KeyPair kp = this.keys[index].getKeyPair();
            if (kp == null) {
                try {
                    KeyPairGenerator kgen = JSSEJCE.getKeyPairGenerator("RSA");
                    kgen.initialize(length, random);
                    this.keys[index] = new EphemeralKeyPair(kgen.genKeyPair());
                    kp = this.keys[index].getKeyPair();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return kp;
        }
    }

    private static class EphemeralKeyPair {
        private static final int MAX_USE = 200;
        private static final long USE_INTERVAL = 3600000L;
        private KeyPair keyPair;
        private int uses;
        private long expirationTime;

        private EphemeralKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            this.expirationTime = System.currentTimeMillis() + 3600000L;
        }

        private boolean isValid() {
            return this.keyPair != null && this.uses < 200 && System.currentTimeMillis() < this.expirationTime;
        }

        private KeyPair getKeyPair() {
            if (!this.isValid()) {
                this.keyPair = null;
                return null;
            }
            ++this.uses;
            return this.keyPair;
        }
    }
}

