/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.lib.crypto.Session;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import cfca.sadk.tls.sun.security.ssl.sec.SymEncryption;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class JCEEncryption
implements SymEncryption {
    private Cipher cipher = null;

    public JCEEncryption(String transformation, Session session) throws SecurityException {
        try {
            this.cipher = JSSEJCE.getCipher(transformation);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public void init(int mode, SecretKey key, IvParameterSpec iv, SecureRandom random) throws SecurityException {
        try {
            this.cipher.init(mode, (Key)key, iv, random);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws SecurityException {
        try {
            return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public Provider getProvider() {
        return this.cipher.getProvider();
    }

    @Override
    public int update(ByteBuffer dup, ByteBuffer bb) throws SecurityException {
        try {
            return this.cipher.update(dup, bb);
        }
        catch (ShortBufferException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public void doFinal() throws SecurityException {
        try {
            this.cipher.doFinal();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

