/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.timestamp.exception.TSAException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.util.Args;

final class TscSSLContext {
    private SSLContext context;
    private KeyManagerFactory keyManager;
    private TrustManagerFactory trustManager;

    final void setKeyManager(KeyManagerFactory keyManager) {
        this.keyManager = keyManager;
    }

    final void setTrustManager(TrustManagerFactory trustManager) {
        this.trustManager = trustManager;
    }

    final void initContext(String protocol) throws TSAException {
        SSLContext context;
        Args.notNull((Object)protocol, (String)"protocol");
        if (this.trustManager == null) {
            throw new TSAException("trustManager required not be null!!!");
        }
        try {
            context = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException("SSLProtocol algorithm not supported: " + protocol, (Throwable)e);
        }
        try {
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (this.keyManager != null) {
                keyManagers = this.keyManager.getKeyManagers();
            }
            trustManagers = this.trustManager.getTrustManagers();
            context.init(keyManagers, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new TSAException("KeyManagement invalid", (Throwable)e);
        }
        this.context = context;
    }

    final SSLContext getContext() {
        return this.context;
    }
}

