/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class DigestInfoHelper {
    static final int BUFFSIZE = 16384;

    private DigestInfoHelper() {
    }

    static byte[] hashSM3Digest(SM2Key cardKey, InputStream stream) throws CardException {
        if (stream == null) {
            throw new CardException("hashSM3Digest missing stream");
        }
        byte[] hashValue = new byte[32];
        BufferedInputStream sourceData = null;
        try {
            SM3Digest digest = new SM3Digest();
            if (cardKey != null) {
                byte[] zvalue = cardKey.getDefaultZ();
                if (zvalue == null) {
                    throw new CardException("hashSM3Digest cardKey without tDefaultZ");
                }
                if (zvalue.length != 32) {
                    throw new CardException("hashSM3Digest cardKey with invalid DefaultZ");
                }
                digest.update(zvalue, 0, 32);
            }
            hashValue = new byte[digest.getDigestSize()];
            byte[] buffer = new byte[16384];
            sourceData = new BufferedInputStream(stream);
            int rLength = 0;
            while ((rLength = ((InputStream)sourceData).read(buffer)) > 0) {
                digest.update(buffer, 0, rLength);
            }
            digest.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new CardException("hashSM3Digest Failure", e);
        }
        catch (Throwable e) {
            throw new CardException("hashSM3Digest Failure", e);
        }
        return hashValue;
    }

    static byte[] hashSM3Digest(SM2Key cardKey, byte[] sourceData) throws CardException {
        if (sourceData == null) {
            throw new CardException("hashSM3Digest missing sourceData");
        }
        byte[] hashValue = new byte[32];
        try {
            SM3Digest digest = new SM3Digest();
            if (cardKey != null) {
                byte[] zvalue = cardKey.getDefaultZ();
                if (zvalue == null) {
                    throw new CardException("hashSM3Digest cardKey without tDefaultZ");
                }
                if (zvalue.length != 32) {
                    throw new CardException("hashSM3Digest cardKey with invalid DefaultZ");
                }
                digest.update(zvalue, 0, 32);
            }
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new CardException("hashSM3Digest Failure", e);
        }
        catch (Throwable e) {
            throw new CardException("hashSM3Digest Failure", e);
        }
        return hashValue;
    }

    static byte[] hashDigestInfo(Mechanism mechanism, byte[] sourceData) throws CardException {
        if (sourceData == null) {
            throw new CardException("hashDigestInfo missing sourceData");
        }
        try {
            return HashUtil.RSAHashMessageByJNI(sourceData, mechanism, true);
        }
        catch (Exception e) {
            throw new CardException("hashDigestInfo failure", e);
        }
        catch (Throwable e) {
            throw new CardException("hashDigestInfo failure", e);
        }
    }

    static byte[] hashDigestInfo(Mechanism mechanism, InputStream sourceStream) throws CardException {
        if (sourceStream == null) {
            throw new CardException("hashDigestInfo missing sourceStream");
        }
        try {
            return HashUtil.RSAHashFileByJNI(sourceStream, mechanism, true);
        }
        catch (Exception e) {
            throw new CardException("hashDigestInfo failure", e);
        }
        catch (Throwable e) {
            throw new CardException("hashDigestInfo failure", e);
        }
    }

    static byte[] buildDigestInfo(Mechanism mechanism, byte[] hash) throws CardException {
        if (mechanism == null) {
            throw new CardException("buildDigestInfo missing mechanism");
        }
        if (hash == null) {
            throw new CardException("buildDigestInfo missing hash");
        }
        try {
            AlgorithmIdentifier algId = Mechanisms.getDigestAlgIdentifier(mechanism);
            if (algId == null) {
                algId = DigestInfoHelper.getRIPEMDIdentifier(mechanism);
            }
            if (algId == null) {
                throw new CardException("buildDigestInfo with invalid digest mechanism: " + mechanism);
            }
            DigestInfo dInfo = new DigestInfo(algId, hash);
            return dInfo.getEncoded("DER");
        }
        catch (CardException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CardException("buildDigestInfo Failure", e);
        }
    }

    private static AlgorithmIdentifier getRIPEMDIdentifier(Mechanism mechanism) {
        ASN1ObjectIdentifier oid = null;
        if (mechanism == null || mechanism.getMechanismType() == null) {
            oid = null;
        } else {
            String type = mechanism.getMechanismType().toUpperCase();
            if (type.equals("RIPEMD128")) {
                oid = TeleTrusTObjectIdentifiers.ripemd128;
            } else if (type.equals("RIPEMD160")) {
                oid = TeleTrusTObjectIdentifiers.ripemd160;
            } else if (type.equals("RIPEMD256")) {
                oid = TeleTrusTObjectIdentifiers.ripemd256;
            }
        }
        AlgorithmIdentifier digestAlgIdentifier = null;
        if (oid != null) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, DERNull.INSTANCE);
        }
        return digestAlgIdentifier;
    }
}

