/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.sec;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;

public final class JSSEJCE {
    public static final Provider SADK = new BouncyCastleProvider();
    public static final String SIGNATURE_RAWECDSA = "NONEwithECDSA";
    static final String SIGNATURE_RAWSM2DSA = "NONEwithSM2";
    public static final String SIGNATURE_RAWRSA = "NONEwithRSA";
    public static final String SIGNATURE_SSLRSA = "MD5andSHA1withRSA";

    private JSSEJCE() {
    }

    public static Signature getSignature(String algorithm) throws NoSuchAlgorithmException {
        Signature signature = null;
        signature = SIGNATURE_RAWRSA.equals(algorithm) ? Signature.getInstance(SIGNATURE_RAWRSA, SADK) : (SIGNATURE_SSLRSA.equals(algorithm) ? Signature.getInstance(SIGNATURE_SSLRSA, JSSEProvider.getInstance()) : Signature.getInstance(algorithm));
        return signature;
    }

    public static Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (transformation.startsWith("RSA") || transformation.startsWith("SM2")) {
            return Cipher.getInstance(transformation);
        }
        return Cipher.getInstance(transformation, SADK);
    }

    public static KeyStore getDefaultKeyStore(String defaultKeyStoreType, String defaultKeyStoreProvider) throws NoSuchProviderException, KeyStoreException {
        KeyStore ks = null;
        ks = defaultKeyStoreProvider == null || defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
        return ks;
    }

    static Mac getMac(String algorithm) throws NoSuchAlgorithmException {
        return Mac.getInstance(algorithm, SADK);
    }

    public static KeyAgreement getAgreement(String algorithm) throws NoSuchAlgorithmException {
        return KeyAgreement.getInstance(algorithm, SADK);
    }

    public static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm, SADK);
    }

    public static CertificateFactory getCertificateFactory(String algorithm) throws CertificateException {
        return CertificateFactory.getInstance(algorithm, SADK);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm, SADK);
    }

    public static AlgorithmParameters getAlgorithmParameters(String algorithm) throws NoSuchAlgorithmException {
        return AlgorithmParameters.getInstance(algorithm, SADK);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm, SADK);
    }

    public static CertStore getCertStore(String algorithm, CollectionCertStoreParameters parameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return CertStore.getInstance("Collection", parameters);
    }
}

