/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.refit;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PdfAnnotation;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfFileSpecification;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;

public class PdfAttachmentAndAnnotationRefit {
    private PdfReader reader;
    private OutputStream os;
    private PdfStamper pdfStamper;
    private PdfWriter pdfWriter;
    private boolean appearance = false;

    public PdfAttachmentAndAnnotationRefit(PdfReader reader, OutputStream os) {
        this.reader = reader;
        this.os = os;
    }

    public void setAppend(boolean append) throws DocumentException, IOException {
        this.setAppendAndAppearance(append, this.appearance);
    }

    public void setAppendAndAppearance(boolean append, boolean appearance) throws DocumentException, IOException {
        if (null != this.reader && null != this.os) {
            this.pdfStamper = new PdfStamper(this.reader, this.os, '\u0000', append);
            this.pdfWriter = this.pdfStamper.getWriter();
            this.pdfWriter.getAcroForm().setNeedAppearances(appearance);
        } else if (null == this.reader || null != this.os) {
            throw new DocumentException("need pdf document and os if refit document. Otherwise,do not need call this method if just get something from it!");
        }
    }

    public void addFileAttachment(String attachFilePath, String attachFileDisplay, byte[] attachContentBytes) throws IOException {
        PdfFileSpecification pdfFileSpecification = PdfFileSpecification.fileEmbedded(this.pdfWriter, attachFilePath, attachFileDisplay, attachContentBytes);
        this.pdfStamper.addFileAttachment(attachFileDisplay, pdfFileSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileAttachment(String attachFileDisplay) throws DocumentException, IOException {
        if (attachFileDisplay == null) throw new DocumentException("attachFIleCaption can not be null!!!");
        if (attachFileDisplay.length() == 0) {
            throw new DocumentException("attachFIleCaption can not be null!!!");
        }
        PdfDictionary rootDictionary = this.reader.getCatalog();
        PdfDictionary namesDictionary = rootDictionary.getAsDict(PdfName.NAMES);
        PdfDictionary embeddedDictionary = namesDictionary.getAsDict(PdfName.EMBEDDEDFILES);
        PdfArray pdfArray = embeddedDictionary.getAsArray(PdfName.NAMES);
        if (pdfArray == null) {
            return null;
        }
        int i = 0;
        int size = pdfArray.size();
        while (true) {
            String key;
            if (i >= size) {
                return null;
            }
            PdfDictionary nameDictionary = pdfArray.getAsDict(i);
            if (nameDictionary != null && attachFileDisplay.equals(key = nameDictionary.getAsString(PdfName.UF).toUnicodeString())) {
                PdfDictionary valueDictionary = nameDictionary.getAsDict(PdfName.EF);
                if (valueDictionary == null) return null;
                return PdfReader.getStreamBytes((PRStream)valueDictionary.getAsStream(PdfName.UF));
            }
            ++i;
        }
    }

    public void addFileAttachmentAnnotation(int page, Rectangle rect, String annotCommentString, byte[] attachContentBytes, String attachFilePath, String attachFileDisplay) throws IOException, DocumentException {
        PdfAnnotation pdfAnnotation = PdfAnnotation.createFileAttachment(this.pdfWriter, rect, annotCommentString, attachContentBytes, attachFilePath, attachFileDisplay);
        this.pdfStamper.addAnnotation(pdfAnnotation, page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileAttachmentAnnotation(String attachFileDisplay, int page) throws IOException, DocumentException {
        if (attachFileDisplay == null) throw new DocumentException("fieldName can not be null or empty string!");
        if (attachFileDisplay.length() == 0) {
            throw new DocumentException("fieldName can not be null or empty string!");
        }
        int i = 1;
        int numOfPages = this.reader.getNumberOfPages();
        if (page > 0) {
            i = page;
            numOfPages = page;
        } else if (-1 != page) {
            throw new DocumentException("page must be -1 or positive!");
        }
        while (true) {
            if (i > numOfPages) {
                return null;
            }
            PdfArray pdfArray = this.reader.getPageN(i).getAsArray(PdfName.ANNOTS);
            if (pdfArray != null) {
                int sizeOfAnnots = pdfArray.size();
                for (int j = 0; j < sizeOfAnnots; ++j) {
                    String key;
                    PdfDictionary nameDictionary;
                    PdfDictionary pdfDictionary = pdfArray.getAsDict(j);
                    if (!PdfName.FILEATTACHMENT.equals(pdfDictionary.getAsName(PdfName.SUBTYPE)) || (nameDictionary = pdfDictionary.getAsDict(PdfName.FS)) == null || !attachFileDisplay.equals(key = nameDictionary.getAsString(PdfName.UF).toUnicodeString())) continue;
                    PdfDictionary valueDictionary = nameDictionary.getAsDict(PdfName.EF);
                    if (valueDictionary == null) return null;
                    return PdfReader.getStreamBytes((PRStream)valueDictionary.getAsStream(PdfName.UF));
                }
            }
            ++i;
        }
    }

    public void close() throws DocumentException, IOException {
        if (this.pdfStamper != null) {
            this.pdfStamper.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

