/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.collection;

import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfNumber;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.collection.PdfCollectionField;
import cfca.sadk.com.itextpdf.kernel.pdf.collection.PdfCollectionSchema;

public class PdfCollectionItem
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -6471103872805179766L;
    private PdfCollectionSchema schema;

    public PdfCollectionItem(PdfCollectionSchema schema) {
        super(new PdfDictionary());
        this.schema = schema;
    }

    public PdfCollectionItem addItem(String key, String value) {
        PdfCollectionField field = this.schema.getField(key);
        ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), field.getValue(value));
        return this;
    }

    public void addItem(String key, PdfDate d) {
        PdfCollectionField field = this.schema.getField(key);
        if (field.subType == 1) {
            ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), (PdfObject)d.getPdfObject());
        }
    }

    public void addItem(String key, PdfNumber n) {
        PdfCollectionField field = this.schema.getField(key);
        if (field.subType == 2) {
            ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), n);
        }
    }

    public PdfCollectionItem setPrefix(String key, String prefix) {
        PdfName fieldName = new PdfName(key);
        PdfObject obj = ((PdfDictionary)this.getPdfObject()).get(fieldName);
        if (obj == null) {
            throw new PdfException("You must set a value before adding a prefix.");
        }
        PdfDictionary subItem = new PdfDictionary();
        subItem.put(PdfName.D, obj);
        subItem.put(PdfName.P, new PdfString(prefix));
        ((PdfDictionary)this.getPdfObject()).put(fieldName, subItem);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

