/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;

final class CertKeyType {
    final String keyAlgorithm;
    final String sigKeyAlgorithm;

    CertKeyType(String algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("parameters algorithm must not null");
        }
        int k = algorithm.indexOf("_");
        if (k == -1) {
            this.keyAlgorithm = algorithm;
            this.sigKeyAlgorithm = null;
        } else {
            this.keyAlgorithm = algorithm.substring(0, k);
            this.sigKeyAlgorithm = algorithm.substring(k + 1);
        }
    }

    final boolean matches(Certificate[] chain) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (!this.keyAlgorithm.equals(chain[0].getPublicKey().getAlgorithm())) {
            return false;
        }
        if (this.sigKeyAlgorithm == null) {
            return true;
        }
        if (chain.length > 1) {
            return this.sigKeyAlgorithm.equals(chain[1].getPublicKey().getAlgorithm());
        }
        X509Certificate issuer = (X509Certificate)chain[0];
        String sigAlgName = null;
        sigAlgName = GMObjectIdentifiers.sm3WithSM2Encryption.getId().equals(issuer.getSigAlgOID()) ? "SM3WITHSM2" : issuer.getSigAlgName().toUpperCase(Locale.ENGLISH);
        String pattern = "WITH" + this.sigKeyAlgorithm.toUpperCase(Locale.ENGLISH);
        return sigAlgName.contains(pattern);
    }
}

