/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.IoUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ParseResponsePdfUtil {
    public static List<String> parsePdfList(String outputFilepath, byte[] responseData, int responseJSONLength, String responseFileDataLenth) throws IOException {
        String[] fileDataLengthStrGroup;
        ArrayList<String> outputFilePathList = new ArrayList<String>();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        if (StringUtil.isNotEmpty(responseFileDataLenth) && (fileDataLengthStrGroup = responseFileDataLenth.split("\\|\\|")) != null && fileDataLengthStrGroup.length > 0) {
            int position = responseJSONLength;
            int i = 1;
            for (String fileDataLengthStr : fileDataLengthStrGroup) {
                int fileDataLength = Integer.parseInt(fileDataLengthStr);
                byte[] bodyBuffer = new byte[fileDataLength];
                System.arraycopy(responseData, position, bodyBuffer, 0, fileDataLength);
                fileDataList.add(bodyBuffer);
                position += fileDataLength;
                String filepath = outputFilepath + "-" + i++ + ".pdf";
                IoUtil.write(filepath, bodyBuffer);
                System.out.println("\u6587\u4ef6\u5df2\u8f93\u51fa\u5230\uff1a" + filepath);
                outputFilePathList.add(filepath);
            }
        }
        System.out.println("fileDataList's size = " + fileDataList.size());
        return outputFilePathList;
    }

    public static void parseTemplateList(String outputFilepath, byte[] responseData, int responseJSONLength, String responseFileDataLenth) throws IOException, CodeException {
        String[] fileDataLengthStrGroup;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        if (StringUtil.isNotEmpty(responseFileDataLenth) && (fileDataLengthStrGroup = responseFileDataLenth.split("\\|\\|")) != null && fileDataLengthStrGroup.length > 0) {
            int position = responseJSONLength;
            for (String fileDataLengthStr : fileDataLengthStrGroup) {
                int fileDataLength = Integer.parseInt(fileDataLengthStr);
                byte[] bodyBuffer = new byte[fileDataLength];
                System.arraycopy(responseData, position, bodyBuffer, 0, fileDataLength);
                fileDataList.add(bodyBuffer);
                position += fileDataLength;
                String filepath = outputFilepath;
                ValidityUtil.checkIsPdfFile(bodyBuffer);
                IoUtil.write(filepath, bodyBuffer);
                System.out.println("\u6587\u4ef6\u5df2\u8f93\u51fa\u5230\uff1a" + filepath);
            }
        }
        System.out.println("fileDataList's size = " + fileDataList.size());
    }
}

