/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz5A;
import asposewobfuscated.zz68;
import asposewobfuscated.zz9X;
import asposewobfuscated.zz9Z;
import asposewobfuscated.zzAV;
import asposewobfuscated.zzCM;
import asposewobfuscated.zzCO;
import asposewobfuscated.zzKV;
import asposewobfuscated.zzLH;
import asposewobfuscated.zzME;
import asposewobfuscated.zzYM;
import asposewobfuscated.zzYN;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.zz0O;
import com.aspose.words.zz37;
import com.aspose.words.zz3R;
import com.aspose.words.zz3Y;
import com.aspose.words.zz41;
import com.aspose.words.zz7;
import com.aspose.words.zz9Y;
import com.aspose.words.zzCW;
import com.aspose.words.zzE7;
import com.aspose.words.zzF0;
import com.aspose.words.zzFE;
import com.aspose.words.zzGY;
import com.aspose.words.zzJL;
import com.aspose.words.zzNI;
import com.aspose.words.zzY0;
import com.aspose.words.zzYK;
import com.aspose.words.zzYUI;
import com.aspose.words.zzYYJ;
import com.aspose.words.zzYYT;
import com.aspose.words.zzYZF;
import com.aspose.words.zzZ35;
import com.aspose.words.zzZ4B;
import com.aspose.words.zzZ8C;
import com.aspose.words.zzZB5;
import com.aspose.words.zzZBX;
import com.aspose.words.zzZBZ;
import com.aspose.words.zzZIP;
import com.aspose.words.zzZKB;
import com.aspose.words.zzZN;
import com.aspose.words.zzZQW;
import com.aspose.words.zzZRD;
import com.aspose.words.zzZRG;
import com.aspose.words.zzZS5;
import com.aspose.words.zzZSI;
import com.aspose.words.zzZTT;
import com.aspose.words.zzZVO;
import com.aspose.words.zzZVP;
import com.aspose.words.zzZWE;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzZRD,
zzZRG,
zzZTT {
    private Document zzZC1;
    private Node zzZAz;
    private Node zzZAy;
    private zzZ4B zzZH1;
    private Font zz3a;
    private zzAV zzZAx;
    private zzYYJ zzZAw = zzYYJ.zzZ0T();
    private zzYK zz4L = new zzYK();
    private RowFormat zzZAv;
    private CellFormat zz4K;
    private zzAV zzZAu;
    private int zzZAt = 0;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) throws Exception {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() throws Exception {
        this.zzO(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() throws Exception {
        this.zzO(-1, 1, -1, -1);
    }

    public void moveToSection(int sectionIndex) throws Exception {
        this.zzO(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) throws Exception {
        this.zzZ(this.getCurrentSection(), zzYUI.zzuz(headerFooterType), 0, 0);
    }

    private void zzO(int n, int n2, int n3, int n4) throws Exception {
        this.zzZC1.ensureMinimum();
        Section section = (Section)this.zzZC1.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, n2, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) throws Exception {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYUI.zzuy(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZC1, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZC1));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) throws Exception {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzZ(paragraph, n2);
    }

    void zzZ(Paragraph paragraph, int n) throws Exception {
        if (n == 0) {
            this.zzY(paragraph, paragraph.getFirstChild());
        } else if (n == -1) {
            this.zzY(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        FieldMergeField fieldMergeField;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName");
        }
        FieldMergeField fieldMergeField2 = fieldMergeField = this.zzZZh().isRemoved() ? zzZKB.zzU(this.zzZC1, fieldName) : zzZKB.zzT(this.zzZZh(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZSI zzZSI2 = field.getFormat().zzZQe();
        Inline inline = zzZSI2.zzqI();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZQf(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new IllegalArgumentException("bookmarkName");
        }
        Node node = isStart ? zzZN.zzZ(this.zzZC1, bookmarkName) : zzZN.zzY(this.zzZC1, bookmarkName);
        if (node == null) {
            return false;
        }
        this.zzY((Paragraph)node.zzZtx(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) throws Exception {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) throws Exception {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ8(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzZ(cell.getFirstParagraph(), 0);
        } else if (characterIndex == -1) {
            this.zzZ(cell.getLastParagraph(), -1);
        }
    }

    void zzY(Paragraph paragraph, Node node) throws Exception {
        if (node != null) {
            this.moveTo(node);
        } else {
            this.moveTo(paragraph);
        }
    }

    public void moveTo(Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() != 8 && !zzZIP.zzZc(node)) {
            throw new IllegalStateException("The node must be a paragraph or an inline node.");
        }
        this.zzF(node);
        if (this.isAtEndOfParagraph()) {
            this.zzZZs();
        } else if (!this.zzZZt()) {
            this.zzZZs();
        }
    }

    private boolean zzZZt() throws Exception {
        Node node = this.zzZZh();
        if (!(node instanceof zzZS5)) {
            while (node != null && !(node instanceof zzZS5)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzZZh(); node != null && !(node instanceof zzZS5); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            zzZS5 zzZS52 = (zzZS5)((Object)node);
            this.zzZ(zzZS52.getRunPr_IInline(), true);
            return true;
        }
        return false;
    }

    private void zzZZs() throws Exception {
        this.zzZ(this.getCurrentParagraph().zzZjZ(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) throws Exception {
        Row row = this.zzZ8(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZZj() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzZZh().zzZJ(row)) {
            boolean bl;
            boolean bl2 = bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZtu();
                this.zzZ(paragraph, 0);
            }
        }
        row.remove();
        if (!table.zznX()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) throws Exception {
        this.zzI(text, false);
    }

    public void writeln(String text) throws Exception {
        this.zzI(text, true);
    }

    public void writeln() throws Exception {
        this.insertParagraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Paragraph insertParagraph() throws Exception {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYZF zzYZF2 = new zzYZF(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZC1, this.zzZZo(), this.zzZZp());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zzZZh(), null, paragraph2.getLastChild());
            }
        }
        finally {
            if (zzYZF2 != null) {
                zzYZF2.dispose();
            }
        }
        if (this.getDocument().zzZZO()) {
            zzZ8C.zzX((zzZQW)paragraph, this.getDocument().zzZZT());
        }
        return this.getCurrentParagraph();
    }

    public void insertBreak(int breakType) throws Exception {
        this.zzC(breakType, true);
    }

    void zzC(int n, boolean bl) throws Exception {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXs(bl)) {
                    this.zzSg(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXs(bl)) {
                    this.zzSg(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXs(bl)) {
                    this.zzMz(1);
                }
                return;
            }
            case 5: {
                if (this.zzXs(bl)) {
                    this.zzMz(2);
                }
                return;
            }
            case 3: {
                if (this.zzXs(bl)) {
                    this.zzMz(0);
                }
                return;
            }
            case 6: {
                if (this.zzXs(bl)) {
                    this.zzMz(3);
                }
                return;
            }
            case 7: {
                if (this.zzXs(bl)) {
                    this.zzMz(4);
                }
                return;
            }
            case 8: {
                this.zzSg(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) throws Exception {
        if (!zzME.zzZT(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz68.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zz41.zzZ(fieldType, updateField, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zz41.zzZ(fieldCode, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) throws Exception {
        return zz41.zzZ(fieldCode, fieldValue, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) throws Exception {
        zzME.zzW((Object)displayText, "displayText");
        zzME.zzW((Object)urlOrBookmark, "hrefOrBookmark");
        zz3Y zz3Y2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        zz3Y2.zzY(this.zzZZq());
        return zz37.zzX(zz3Y2.getStart(), zz3Y2.getSeparator(), zz3Y2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (format == null) {
            throw new IllegalArgumentException("format");
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzMy(70);
        if (zzME.zzZT(name)) {
            this.startBookmark(name);
        }
        this.zzSf(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzMx(70);
        String string = zzME.zzZT(fieldValue) ? fieldValue : FormField.zzZkf;
        Run run = new Run(this.zzZC1, string, this.zzZZp());
        this.insertNode(run);
        this.zzB(70, true);
        if (zzME.zzZT(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzG(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean defaultValue, int size) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzMy(71);
        if (zzME.zzZT(name)) {
            this.startBookmark(name);
        }
        this.zzSf(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzB(71, false);
        if (zzME.zzZT(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzG(fieldEnd);
        formField.setName(name);
        formField.setChecked(defaultValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (items == null) {
            throw new IllegalArgumentException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzMy(83);
        if (zzME.zzZT(name)) {
            this.startBookmark(name);
        }
        this.zzSf(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzB(83, false);
        if (zzME.zzZT(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzG(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) throws Exception {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) throws Exception {
        boolean bl = footnoteType == 0;
        Footnote footnote = new Footnote((DocumentBase)this.zzZC1, footnoteType);
        footnote.getFont().setStyleIdentifier(bl ? 38 : 42);
        if (zzME.zzZT(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZC1);
        paragraph.getParagraphFormat().setStyleIdentifier(bl ? 29 : 43);
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZC1, '\u0002', new zzZ4B()) : new Run(this.zzZC1, footnote.getReferenceMark(), new zzZ4B());
        inline.getFont().setStyleIdentifier(bl ? 38 : 42);
        paragraph.appendChild(inline);
        if (zzME.zzZT(footnoteText)) {
            Node node = this.zzZZh();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzF(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    Shape zzZZ(zz9X zz9X2) throws Exception {
        return this.zzZ(zz9X2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZZ(zz9X.zzZ(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    Shape zzZ(zz9X zz9X2, double d, double d2) throws Exception {
        return this.zzZ(zz9X2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz9X.zzZ(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new IllegalArgumentException("image");
        }
        zz9Z zz9Z2 = new zz9Z();
        try {
            zzLH.zzY(image, zz9Z2);
            Shape shape = this.zzZ(zz9Z2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (zz9Z2 != null) {
                zz9Z2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzME.zzM(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzKV.zzZ1(fileName);
        try {
            Shape shape = this.zzZ((zz9X)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz9X)object).close();
            }
        }
    }

    Shape zzZ(zz9X zz9X2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz9X2 == null) {
            throw new IllegalArgumentException("stream");
        }
        byte[] byArray = zzME.zzt(zz9X2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz9X.zzZ(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        Shape shape;
        if (imageBytes == null) {
            throw new IllegalArgumentException("imageBytes");
        }
        if (this.zzZC1.getCompatibilityOptions().zzo6() > 12 || this.zzZC1.getCompatibilityOptions().zzo6() == 0) {
            shape = new Shape((DocumentBase)this.zzZC1, 0);
            object = new zzE7();
            ((zzCW)object).zzZ(zzGY.zzSD("rect"));
            ((zzE7)object).zzZ(new zzNI());
            zzF0 zzF02 = new zzF0();
            zzF02.zz5Z().setId(Integer.toString(shape.getId()));
            zzF02.zzZ(new zzJL());
            ((zzFE)object).zzZ(zzF02);
            shape.zzKA(75);
            shape.zzZ((zzFE)object);
        } else {
            shape = new Shape((DocumentBase)this.zzZC1, 75);
        }
        shape.zzQ(this.zzZZp());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        object = shape.getImageData().getImageSize();
        shape.zzz(width < 0.0 ? ((ImageSize)object).getWidthPoints() : width, height < 0.0 ? ((ImageSize)object).getHeightPoints() : height);
        return shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape zzK(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz9Z zz9Z2 = new zz9Z();
        try {
            zzLH.zzY(bufferedImage, zz9Z2);
            byArray = zzME.zzt(zz9Z2);
        }
        finally {
            if (zz9Z2 != null) {
                zz9Z2.close();
            }
        }
        if (byArray == null) {
            throw new IllegalArgumentException("image");
        }
        Shape shape = new Shape((DocumentBase)this.zzZC1, 1);
        shape.zzKA(75);
        shape.zzQ(this.zzZZp());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzz(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    Shape zzZ(zz9X zz9X2, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzZBZ zzZBZ2 = zzZBZ.zzJZ(string);
        if (bufferedImage == null) {
            bufferedImage = zzZBX.zzZ(zzZBZ2, bl);
        }
        Shape shape = this.zzK(bufferedImage);
        shape.zzKA(-2);
        shape.getOleFormat().setProgId(zzZBZ2.zzYKR);
        shape.getOleFormat().zzY(zzZBX.zzZ(zz9X2, string, bl));
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzZ(zz9X.zzZ(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZBZ zzZBZ2 = zzZBZ.zzJY(asposewobfuscated.zz9Y.zzXk(fileName));
        if (presentation == null) {
            presentation = zzZBX.zzZ(zzZBZ2, asIcon);
        }
        Shape shape = this.zzK(presentation);
        shape.zzKA(-2);
        shape.getOleFormat().setProgId(zzZBZ2.zzYKR);
        shape.getOleFormat().zzY(zzZBX.zzS(fileName, isLinked, asIcon));
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZWE zzZWE2 = new zzZWE();
        zzZWE2.zzWr(useBuilderFormatting);
        zzZWE2.zzWq(useBuilderFormatting);
        this.zzZ(html, zzZWE2);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzY0(this).insertChart(chartType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    void zzZ(String string, zzZWE zzZWE2) throws Exception {
        if (this.zzZZr()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSh(documentBuilder.getDocument().toString(70)));
        } else {
            zzZVO zzZVO2 = new zzZVO(this.getDocument().getResourceLoadingCallback());
            if (zzZWE2 == null) {
                zzZWE2 = new zzZWE();
            }
            zzZVP zzZVP2 = new zzZVP(50, zzZVO2);
            zzZVP2.zzZ(string, this, zzZWE2);
        }
    }

    private boolean zzZZr() {
        boolean bl = false;
        if (this.zzZZh().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzZZh().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzSh(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() throws Exception {
        if (this.zzZZj() == null) {
            this.startTable();
        }
        if (this.zzZZj().zzZ21() == 1) {
            this.zzZZj().zzZ24();
        }
        if (this.zzZZj().zzZ21() == 3) {
            this.zzZZj().zzZ22();
        }
        return this.zzZZj().zzZ23();
    }

    public Table startTable() throws Exception {
        this.zzZAu.push(new zzYYT(this));
        return this.zzZZj().startTable();
    }

    public Table endTable() throws Exception {
        if (this.zzZZj() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZZj().endTable();
        this.zzZAu.pop();
        return table;
    }

    public Row endRow() throws Exception {
        if (this.zzZZj() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        return this.zzZZj().endRow();
    }

    public BookmarkStart startBookmark(String bookmarkName) throws Exception {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZC1, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) throws Exception {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZC1, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) throws Exception {
        return new zz9Y(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZC1;
    }

    public void setDocument(Document value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value == this.zzZC1) {
            return;
        }
        this.zzZC1 = value;
        this.zzF(null);
        this.zzZH1 = new zzZ4B();
        this.zzZAx = null;
        this.zz3a = null;
        this.zzZAu = new zzAV();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zz3a == null) {
            this.zz3a = new Font(this, this.getDocument());
        }
        return this.zz3a;
    }

    public boolean getBold() throws Exception {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) throws Exception {
        this.getFont().setBold(value);
    }

    public boolean getItalic() throws Exception {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) throws Exception {
        this.getFont().setItalic(value);
    }

    public int getUnderline() throws Exception {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) throws Exception {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZAv == null) {
            this.zzZAv = new RowFormat(this);
        }
        return this.zzZAv;
    }

    public CellFormat getCellFormat() {
        if (this.zz4K == null) {
            this.zz4K = new CellFormat(this);
        }
        return this.zz4K;
    }

    void zzH(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() throws Exception {
        this.zzZZi().push(this.zzZZp());
    }

    public void popFont() throws Exception {
        if (this.zzZZi().getCount() > 0) {
            this.zzZ((zzZ4B)this.zzZZi().pop(), false);
        }
    }

    zz3Y zzZ(String string, boolean bl, String string2, String string3) throws Exception {
        FieldStart fieldStart = this.zzMy(88);
        zz3R zz3R2 = new zz3R();
        zz3R2.setTarget(string2);
        zz3R2.setScreenTip(string3);
        if (bl) {
            zz3R2.setSubAddress(string);
        } else {
            zz3R2.setAddress(zzCM.zzYd(string));
            zz3R2.setSubAddress(zzCM.zzYc(string));
        }
        this.zzSf(zz3R2.toString());
        FieldSeparator fieldSeparator = this.zzMx(88);
        return new zz3Y(fieldStart, fieldSeparator, null);
    }

    zz3Y zzQ(String string, String string2, String string3) throws Exception {
        boolean bl = zzCM.zzY4(string);
        String string4 = bl ? zzCM.zzYc(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    FieldEnd zzZZq() throws Exception {
        return this.zzB(88, true);
    }

    zzZ4B zzZZp() throws Exception {
        return (zzZ4B)this.zzZH1.zzuY();
    }

    zzZB5 zzZZo() throws Exception {
        return (zzZB5)this.getCurrentParagraph().zzZK7().zzuY();
    }

    zzYYJ zzZZn() throws Exception {
        return (zzYYJ)this.zzZZg().zzuY();
    }

    zzYK zzZZm() throws Exception {
        return (zzYK)this.zzsy().zzuY();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzZZh(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzZZh().getNodeType() == 8;
    }

    private void zzI(String string, boolean bl) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("text");
        }
        String string2 = zzYUI.zzGo(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSe(string2.substring(n, n + n2));
                }
                switch (this.zzZAt) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSg(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSe(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            break;
        }
    }

    private Run zzSg(String string) throws Exception {
        Run run = new Run(this.zzZC1, string, this.zzZZp());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) throws Exception {
        if (this.zzZZj() != null && this.zzZZj().zzZ21() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
        } else {
            this.zzZZh().getParentNode().insertBefore(node, this.zzZZh());
        }
    }

    void zzMA(int n) throws Exception {
        this.zzXs(true);
        this.zzMz(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzMz(int n) throws Exception {
        this.insertParagraph();
        zzYZF zzYZF2 = new zzYZF(this.getDocument());
        try {
            zzZ35 zzZ352 = (zzZ35)this.getCurrentSection().zzZpa().zzuY();
            Section section = new Section(this.zzZC1, zzZ352);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZC1));
            this.zzZC1.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
        }
        finally {
            if (zzYZF2 != null) {
                zzYZF2.dispose();
            }
        }
    }

    private FieldStart zzMy(int n) throws Exception {
        return zz41.zzZ(n, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private Run zzSf(String string) throws Exception {
        return zz41.zzY(string, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FieldEnd zzB(int n, boolean bl) throws Exception {
        return zz41.zzY(n, bl, this.zzZZp(), this.zzZZh(), this.getCurrentParagraph(), null, true);
    }

    private FieldSeparator zzMx(int n) throws Exception {
        return zz41.zzY(n, this.zzZZp(), this.zzZZh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzG(Node node) throws Exception {
        FormField formField = new FormField((DocumentBase)this.zzZC1, new zz0O(), this.zzZZp());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean zzXs(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZZj() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ8(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSe(String string) throws Exception {
        if (this.zzSd(string)) {
            zzYN zzYN2 = new zzYN(string, -1, null);
            for (zzYM zzYM2 : zzYN2.zzZ(this.getParagraphFormat().getBidi(), false)) {
                zz7 zz710 = zz7.zzZp(zzYM2.zzYc());
                zzZ4B zzZ4B2 = this.zzZZp();
                zzZ4B2.zzX(265, zz710);
                Run run = new Run(this.zzZC1, zzYM2.getText(), zzZ4B2);
                this.insertNode(run);
            }
        } else {
            this.zzSg(string);
        }
    }

    private boolean zzSd(String string) throws Exception {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = zzCO.zzd(c);
            if ((!bl || n != 0) && (bl || n != 3)) continue;
            return true;
        }
        return false;
    }

    void zzZ(zzZ4B zzZ4B2, boolean bl) throws Exception {
        this.zzZH1 = bl ? (zzZ4B)zzZ4B2.zzuY() : zzZ4B2;
    }

    void zzZZl() {
        this.zzZH1.zzv0();
    }

    void zzZZk() throws Exception {
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            this.zz4L = (zzYK)this.getCurrentParagraph().zzZQC().zzsy().zzuY();
        }
    }

    void zzMw(int n) {
        this.zzZAt = n;
    }

    public Node getCurrentNode() {
        return this.isAtEndOfParagraph() ? null : this.zzZZh();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzZZh();
        }
        return (Paragraph)this.zzZZh().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYYT zzZZj() {
        return this.zzZAu.getCount() > 0 ? zz5A.zzZ(this.zzZAu.peek(), zzYYT.class) : null;
    }

    private zzAV zzZZi() {
        if (this.zzZAx == null) {
            this.zzZAx = new zzAV();
        }
        return this.zzZAx;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunKey(int index) {
        return this.zzZH1.zzV2(index);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZH1.zzT3(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZH1.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) throws Exception {
        Object object = this.getFont().getStyle().zzZM(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZM(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZH1.zzX(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZjN()) {
            this.getCurrentParagraph().zzZjZ().zzX(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZH1.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZH1.zzv0();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZjN()) {
            this.getCurrentParagraph().zzZjZ().zzv0();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZZg().zzT3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZZg().zzT2(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZZg().zzT1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZZg().zzX(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZZg().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() throws Exception {
        this.zzZZg().clear();
        zzYYJ.zzZ0T().zzZ(this.zzZZg());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzsy().zzT3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzsy().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzsy().zzT1(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzsy().zzX(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzsy().zzv0();
    }

    private Node zzZZh() {
        if (this.zzZAz != null && this.zzZAz.getParentNode() == null) {
            return this.zzZAy;
        }
        return this.zzZAz;
    }

    private void zzF(Node node) {
        this.zzZAz = node;
        if (this.zzZAz != null) {
            this.zzZAy = this.zzZAz.getParentNode();
        }
    }

    private zzYYJ zzZZg() {
        if (this.zzZZj() != null && this.zzZZj().zzZ21() == 1) {
            return this.zzZAw;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZZg();
        }
        return this.zzZAw;
    }

    private zzYK zzsy() {
        if (this.zzZZj() != null && this.zzZZj().zzZ21() != 3) {
            return this.zz4L;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZQC().zzsy();
        }
        return this.zz4L;
    }
}

