/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.tls.sun.security.ssl.sec.CryptoFactory;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import cfca.sadk.tls.util.TLSEnvironments;
import cfca.sadk.tls.util.TLSLoggings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public final class JSSEProvider
extends Provider {
    private static final long serialVersionUID = 3231825739635378733L;
    private static String info = "CFCA JSSE Provider(SunX509/PKIX key/trust factories, GMTLSv1.1)";
    private static final String PROVIDER_NAME = BouncyCastleProvider.PROVIDER_NAME;
    private static final Provider provider = new JSSEProvider();

    public static Provider getInstance() {
        return provider;
    }

    public JSSEProvider() {
        super("CfcaJSSE", 1.8, info);
        this.registerAlgorithms(true);
    }

    public JSSEProvider(boolean isTomcat) {
        super("CfcaJSSE", 1.8, info);
        this.registerAlgorithms(isTomcat);
    }

    private void registerAlgorithms(final boolean isTomcat) {
        TLSLoggings.ENVIRONMENT_LOGGER.info(TLSEnvironments.environments().buildEnvironments());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JSSEProvider.this.doRegister(isTomcat);
                return null;
            }
        });
    }

    private void doRegister(boolean isTomcat) {
        this.put("KeyManagerFactory.GMTX509", "cfca.sadk.tls.sun.security.ssl.manager.CFCAX509KeyManagerFactory$CFCAX509Factory");
        this.put("TrustManagerFactory.GMTX509", "cfca.sadk.tls.sun.security.ssl.manager.CFCAX509TrustManagerFactory$PKIXFactory");
        this.put("SSLContext.GMTLSv1.1", "cfca.sadk.tls.sun.security.ssl.SSLContextImpl$TLS11Context");
        this.put("Signature.MD5andSHA1withRSA", "cfca.sadk.tls.sun.security.ssl.RSASignature");
        if (isTomcat) {
            this.doRegisterForTomcat();
        }
    }

    private void doRegisterForTomcat() {
        this.put("Alg.Alias.KeyManagerFactory.SunX509", "GMTX509");
        this.put("Alg.Alias.KeyManagerFactory.PKIX", "GMTX509");
        this.put("Alg.Alias.TrustManagerFactory.SunX509", "GMTX509");
        this.put("Alg.Alias.TrustManagerFactory.PKIX", "GMTX509");
        this.put("SSLContext.Default", "cfca.sadk.tls.sun.security.ssl.SSLContextImpl$TLS11Context");
    }

    public static String getProviderName() {
        return PROVIDER_NAME;
    }

    public static void setCheckUrlMatchCertIdentity(boolean checkUrlMatchCertIdentity) {
        CFCASSLHelper.setCheckUrlMatchCertIdentity(checkUrlMatchCertIdentity);
    }

    public static boolean isCheckUrlMatchCertIdentity() {
        return CFCASSLHelper.isCheckUrlMatchCertIdentity();
    }

    public static void setDeviceType(String deviceType) throws PKIException {
        CryptoFactory.singleton().setDeviceType(deviceType);
    }

    public static Session getSession() throws PKIException {
        return CryptoFactory.singleton().session();
    }
}

