/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.link.jni;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.link.ICryptoLinkPartECC;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;

final class CryptoLinkPartECCImp
implements ICryptoLinkPartECC {
    private static final int PUBLICKEYDATA_LENGTH = 72;
    private static final int PRIVATEKEYDATA_LENGTH = 40;
    private static final int HASH_LENGTH_MIN = 20;
    private static final int SIGN_LENGTH = 132;
    private final JNISDF jnisdf;
    private final long warningTimeThreshold;

    CryptoLinkPartECCImp(JNISDF jnisdf, long warningTimeThreshold) {
        this.jnisdf = jnisdf;
        this.warningTimeThreshold = warningTimeThreshold;
    }

    public int generateKeyPairECC(long sessionHandle, int algID, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC generateKeyPairECC Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 72) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed: param publicKeyData is null/invalid");
        }
        if (privateKeyData == null || privateKeyData.length < 40) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed: param privateKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.generateKeyPairECC(sessionHandle, algID, keyBits, publicKeyData, privateKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC generateKeyPairECC finished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC generateKeyPairECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int exportPublicKeyECC(long sessionHandle, int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC exportPublicKeyECC Running: sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType});
        if (publicKeyData == null || publicKeyData.length < 72) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC exportPublicKeyECC failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportPublicKeyECC(sessionHandle, keyIndex, algType, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed, sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType, e});
            throw new CryptoException("CryptoNativeImpECC exportPublicKeyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed, sessionHandle={},returnResult={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algType});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC exportPublicKeyECC finished, sessionHandle={},returnResult={},costTime={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, algType});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC exportPublicKeyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalSignECC(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalSignECC Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param hashLength is invalid");
        }
        if (signOutput == null || signOutput.length < 132) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param signOutput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param signOutput is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalSignECC(sessionHandle, keyIndex, hashInput, hashLength, signOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed, sessionHandle={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalSignECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalSignECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalSignECC(long sessionHandle, int algID, byte[] privateKeyData, byte[] hashInput, int hashLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalSignECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (privateKeyData == null || privateKeyData.length < 40) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param privateKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalSignECC(sessionHandle, privateKeyData, hashInput, hashLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed, sessionHandle={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed, sessionHandle={},returnResult={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalSignECC finished, sessionHandle={},returnResult={},costTime={}, algID={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalSignECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalVerifyECC(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalVerifyECC Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed: param hashInput is null/invalid");
        }
        if (signature == null || signature.length != 132) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed: param signature is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed: param signature is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalVerifyECC(sessionHandle, keyIndex, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed, sessionHandle={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature), e});
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalVerifyECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalVerifyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalVerifyECC(long sessionHandle, int algID, byte[] publicKeyData, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalVerifyECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (publicKeyData == null || publicKeyData.length < 72) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param publicKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalVerifyECC(sessionHandle, publicKeyData, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},returnResult={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},returnResult={},costTime={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalVerifyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }
}

