/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.security.spec.AlgorithmParameterSpec;

public final class SM2DHAlgorithmParameter
implements AlgorithmParameterSpec {
    private final byte[] ZA;
    private final byte[] ZB;

    public SM2DHAlgorithmParameter(ECPoint serverPoint, ECPoint clientPoint) {
        ECPoint QA = serverPoint.normalize();
        ECPoint QB = clientPoint.normalize();
        this.ZA = SM2Params.calcZ(QA);
        this.ZB = SM2Params.calcZ(QB);
    }

    public SM2DHAlgorithmParameter(ECParameterSpec spec, ECPoint serverPoint, ECPoint clientPoint, byte[] serverID, byte[] clientID) {
        ECPoint QA = serverPoint.normalize();
        ECPoint QB = clientPoint.normalize();
        this.ZA = SM2Params.calcZ(spec, QA.getXCoord().toBigInteger(), QA.getYCoord().toBigInteger(), serverID);
        this.ZB = SM2Params.calcZ(spec, QB.getXCoord().toBigInteger(), QB.getYCoord().toBigInteger(), clientID);
    }

    public byte[] getZA() {
        return (byte[])this.ZA.clone();
    }

    public byte[] getZB() {
        return (byte[])this.ZB.clone();
    }

    public byte[] getZBytes() {
        return SM2Params.concat(this.ZA, this.ZB);
    }
}

