/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static void saveDataToFile(byte[] data, String filePath) throws CodeException {
        try {
            FileOutputStream output = FileUtils.openOutputStream((File)new File(filePath));
            IOUtils.writeChunked((byte[])data, (OutputStream)output);
            IOUtils.closeQuietly((OutputStream)output);
        }
        catch (Exception e) {
            throw new CodeException("600804", filePath + "\uff0c\u8def\u5f84\u6709\u8bef ", (Throwable)e);
        }
    }

    public static void saveDataToFileNoCover(byte[] data, String filePath) throws CodeException {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                throw new CodeException("600804", filePath + "\uff0c\u6587\u4ef6\u5df2\u5b58\u5728 ");
            }
            FileOutputStream output = FileUtils.openOutputStream((File)file);
            IOUtils.writeChunked((byte[])data, (OutputStream)output);
            IOUtils.closeQuietly((OutputStream)output);
        }
        catch (Exception e) {
            throw new CodeException("600804", filePath + "\uff0c\u8def\u5f84\u6709\u8bef ", (Throwable)e);
        }
    }

    public static byte[] getBytesFromFile(String filePath) throws CodeException {
        try {
            return FileUtils.readFileToByteArray((File)new File(filePath));
        }
        catch (Exception e) {
            throw new CodeException("600801", filePath + "\uff0c\u8def\u5f84\u6709\u8bef ", (Throwable)e);
        }
    }

    public static boolean deleteSingleFile(String filePath) {
        File file = new File(filePath);
        return FileUtils.deleteQuietly((File)file);
    }
}

