/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.CSREncoder;
import cfca.sadk.asn1.pkcs.CSRPublicKeyHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.system.Mechanisms;
import java.security.PublicKey;

final class CSRMetadata {
    public static final int CERT_REQ_TYPE_P10_SINGLE = 0;
    public static final int CERT_REQ_TYPE_P10_DOUBLE = 1;
    final X500Name subject;
    final PublicKey publicKey;
    final ASN1Set attributes;
    final Mechanism mechanism;
    final byte[] sourceData;
    final byte[] signature;
    final String keyType;
    final PublicKey tempPublicKey;
    final int certReqType;
    byte[] base64P10Data;

    CSRMetadata(CertificationRequest certficationRequest) throws PKIException {
        if (certficationRequest == null) {
            throw new PKIException("certficationRequest parameter certficationRequest=null ");
        }
        String signAlg = Mechanism.getSignatureAlgName(certficationRequest.getSignatureAlgorithm());
        if (!Mechanisms.isValid(signAlg)) {
            throw new PKIException("certficationRequest signAlg invalid: " + certficationRequest.getSignatureAlgorithm());
        }
        Mechanism mechanism = new Mechanism(signAlg);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certficationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        ASN1Set attributes = certficationRequest.getCertificationRequestInfo().getAttributes();
        X500Name subject = certficationRequest.getCertificationRequestInfo().getSubject();
        byte[] sourceData = CSREncoder.buildCertificationRequestInfoData(certficationRequest.getCertificationRequestInfo());
        byte[] signature = certficationRequest.getSignature().getBytes();
        PublicKey publicKey = CSRPublicKeyHelper.buildPublicKeyFrom(subjectPublicKeyInfo);
        this.subject = subject;
        this.publicKey = publicKey;
        this.attributes = attributes;
        this.mechanism = mechanism;
        this.sourceData = sourceData;
        this.signature = signature;
        this.keyType = CSRPublicKeyHelper.decodeP10PublicKeyType(publicKey);
        this.tempPublicKey = CSRPublicKeyHelper.buildTemporaryPublicKeyFromP10(attributes, publicKey);
        this.certReqType = this.buildP10Type(this.tempPublicKey);
    }

    CSRMetadata(Mechanism mechanism, X500Name subject, PublicKey publicKey, ASN1Set attributes, byte[] sourceData, byte[] signature) throws PKIException {
        this.mechanism = mechanism;
        this.subject = subject;
        this.publicKey = publicKey;
        this.attributes = attributes;
        this.sourceData = sourceData;
        this.signature = signature;
        this.keyType = CSRPublicKeyHelper.decodeP10PublicKeyType(publicKey);
        this.tempPublicKey = CSRPublicKeyHelper.buildTemporaryPublicKeyFromP10(attributes, publicKey);
        this.certReqType = this.buildP10Type(this.tempPublicKey);
    }

    private int buildP10Type(PublicKey tempPublicKey) {
        return tempPublicKey == null ? 0 : 1;
    }

    public boolean isSM2SignType() {
        return Mechanisms.isSM2WithSM3(this.mechanism);
    }

    public boolean isSM2KeyType() {
        return "SM2".equals(this.keyType);
    }
}

