/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.tax;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.pkcs.PKCS10;
import cfca.sadk.util.Base64;

public class PublicKeyUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PublicKeyUtil.class);

    public static byte[] genSM2PubKey(byte[] p10Data) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("genSM2PubKey start...");
        try {
            PKCS10 req = new PKCS10();
            req.load(p10Data);
            if (req.getSignatureAlgorithm().equals("sm3WithSM2Encryption")) {
                byte[] qmgy;
                SM2PublicKey pubKey = (SM2PublicKey)req.getPublicKey();
                byte[] pubx = pubKey.getPubX();
                byte[] puby = pubKey.getPubY();
                byte[] finalPubKey = new byte[132];
                System.arraycopy(pubx, 0, finalPubKey, 36, 32);
                System.arraycopy(puby, 0, finalPubKey, 100, 32);
                finalPubKey[1] = 1;
                byte[] byArray = qmgy = Base64.encode((byte[])finalPubKey);
                return byArray;
            }
            try {
                throw new Exception("signAlg must be SM2!");
            }
            catch (Exception e) {
                businessLog.error("genSM2PubKey failed", (Throwable)e);
                throw e;
            }
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("genSM2PubKey end...cost=" + (end - start) + " ms");
        }
    }
}

