/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

import cfca.com.itextpdf.text.io.RandomAccessSourceFactory;
import cfca.com.itextpdf.text.io.StreamUtil;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.system.FileHelper;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.HashUtil;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.maker.util.EndianUtil;
import cfca.seal.maker.util.WebSealUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SealMaker {
    private String ID = "CFCASEALID";
    private byte[] version = new byte[]{2, 0, 1, 0};
    private byte[] pfxFileData;
    private byte[] imageFileData;
    private String signerName;
    private String unitName;
    private String sealName;
    private String subjectName;
    private long startValidTime = 0L;
    private long endValidTime = 0L;
    private int keyType = 0;

    public SealMaker(byte[] pfxFileData, String pfxPWD, byte[] imageFileData, String signerName, String unitName, String sealName) throws PKIException {
        this.initSealMaker(pfxFileData, pfxPWD, imageFileData, signerName, unitName, sealName);
    }

    private void initSealMaker(byte[] pfxFileData, String pfxPWD, byte[] imageFileData, String signerName, String unitName, String sealName) throws PKIException {
        if (pfxFileData[0] != 48) {
            pfxFileData = Base64.decode((byte[])pfxFileData);
        }
        this.pfxFileData = pfxFileData;
        this.imageFileData = imageFileData;
        this.signerName = signerName;
        this.unitName = unitName;
        this.sealName = sealName;
        try {
            this.keyType = WebSealUtil.getKeyStoreType(pfxFileData);
            X509Cert cert = null;
            if (this.keyType == 1) {
                cert = CertUtil.getCertFromPFX((byte[])pfxFileData, (String)pfxPWD);
            } else if (this.keyType == 2) {
                cert = CertUtil.getCertFromSM2((byte[])pfxFileData);
            } else {
                throw new PKIException("unknow key type,rsa or sm2?");
            }
            this.subjectName = cert.getSubject();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public byte[] createSeal() throws Exception {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        baos.write(this.ID.getBytes("UTF-8"));
        baos.write(this.version);
        byte[] usbKeyData = this.generateUSBKeyData();
        int pfxLen = this.pfxFileData.length;
        int totalLen = 4 + pfxLen + usbKeyData.length;
        baos.write(EndianUtil.intToBytes(totalLen));
        byte[] pfxLenData = EndianUtil.intToBytes(pfxLen);
        baos.write(pfxLenData);
        byte[] pfxData = this.pfxFileData;
        baos.write(pfxData);
        baos.write(usbKeyData);
        byte[] sourceData = new byte[4 + pfxLen + usbKeyData.length];
        System.arraycopy(pfxLenData, 0, sourceData, 0, pfxLenData.length);
        System.arraycopy(pfxData, 0, sourceData, 4, pfxData.length);
        System.arraycopy(usbKeyData, 0, sourceData, 4 + pfxData.length, usbKeyData.length);
        byte[] hash = null;
        if (this.keyType == 1) {
            hash = HashUtil.RSAHashMessageByBC((byte[])sourceData, (Mechanism)new Mechanism("SHA-1"), (boolean)true);
        } else if (this.keyType == 2) {
            hash = new byte[32];
            SM3Digest digest = new SM3Digest();
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hash, 0);
        } else {
            throw new PKIException("unknow key type,rsa or sm2?");
        }
        baos.write(hash);
        return baos.toByteArray();
    }

    public void createSeal(OutputStream sealSaveOutputStream) throws Exception {
        byte[] data = this.createSeal();
        StreamUtil.CopyBytes(new RandomAccessSourceFactory().createSource(data), 0L, data.length, sealSaveOutputStream);
    }

    private byte[] generateUSBKeyData() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len = this.imageFileData.length;
        bos.write(EndianUtil.intToBytes(len));
        byte[] imageData = this.imageFileData;
        bos.write(imageData);
        byte[] signerData = this.signerName.getBytes("UTF-8");
        bos.write(EndianUtil.intToBytes(signerData.length));
        bos.write(signerData);
        byte[] unitData = this.unitName.getBytes("UTF-8");
        bos.write(EndianUtil.intToBytes(unitData.length));
        bos.write(unitData);
        byte[] sealNameData = this.sealName.getBytes("UTF-8");
        bos.write(EndianUtil.intToBytes(sealNameData.length));
        bos.write(sealNameData);
        byte[] subjectData = this.subjectName.getBytes("UTF-8");
        bos.write(EndianUtil.intToBytes(subjectData.length));
        bos.write(subjectData);
        bos.write(EndianUtil.longToBytes(this.startValidTime));
        bos.write(EndianUtil.longToBytes(this.endValidTime));
        byte[] before_temp = bos.toByteArray();
        len = before_temp.length;
        byte[] after_temp = new byte[len + 4];
        byte[] len_data = EndianUtil.intToBytes(len);
        System.arraycopy(len_data, 0, after_temp, 0, len_data.length);
        System.arraycopy(before_temp, 0, after_temp, 4, len);
        return after_temp;
    }

    public static void main(String[] args) throws Exception {
        byte[] sm2Bytes = FileHelper.read((String)"TestData/sm2/sm2_123123.sm2");
        byte[] imageBytes = FileHelper.read((String)"TestData/1.png");
        SealMaker maker = new SealMaker(sm2Bytes, "123123", imageBytes, "signername", "unitname", "sealname");
        FileOutputStream sealSaveOutputStream = new FileOutputStream("TestData/sm2-test.seal");
        maker.createSeal(sealSaveOutputStream);
    }
}

