/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.truetype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.Header;
import cfca.sadk.com.google.typography.font.sfntly.table.SubTableContainerTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.Glyph;
import java.util.ArrayList;
import java.util.List;

public final class GlyphTable
extends SubTableContainerTable {
    private GlyphTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public Glyph glyph(int offset, int length) {
        return Glyph.getGlyph(this, this.data, offset, length);
    }

    public static class Builder
    extends SubTableContainerTable.Builder<GlyphTable> {
        private List<Glyph.Builder<? extends Glyph>> glyphBuilders;
        private List<Integer> loca;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        public void setLoca(List<Integer> loca) {
            this.loca = new ArrayList<Integer>(loca);
            this.setModelChanged(false);
            this.glyphBuilders = null;
        }

        public List<Integer> generateLocaList() {
            ArrayList<Integer> locas = new ArrayList<Integer>(this.getGlyphBuilders().size());
            locas.add(0);
            if (this.getGlyphBuilders().size() == 0) {
                locas.add(0);
            } else {
                int total = 0;
                for (Glyph.Builder<? extends Glyph> b : this.getGlyphBuilders()) {
                    int size = b.subDataSizeToSerialize();
                    locas.add(total + size);
                    total += size;
                }
            }
            return locas;
        }

        private void initialize(ReadableFontData data, List<Integer> loca) {
            this.glyphBuilders = new ArrayList<Glyph.Builder<? extends Glyph>>();
            if (data != null) {
                int lastLocaValue = loca.get(0);
                for (int i = 1; i < loca.size(); ++i) {
                    int locaValue = loca.get(i);
                    this.glyphBuilders.add(Glyph.Builder.getBuilder(this, data, lastLocaValue, locaValue - lastLocaValue));
                    lastLocaValue = locaValue;
                }
            }
        }

        private List<Glyph.Builder<? extends Glyph>> getGlyphBuilders() {
            if (this.glyphBuilders == null) {
                if (this.internalReadData() != null && this.loca == null) {
                    throw new IllegalStateException("Loca values not set - unable to parse glyph data.");
                }
                this.initialize(this.internalReadData(), this.loca);
                this.setModelChanged();
            }
            return this.glyphBuilders;
        }

        public void revert() {
            this.glyphBuilders = null;
            this.setModelChanged(false);
        }

        public List<Glyph.Builder<? extends Glyph>> glyphBuilders() {
            return this.getGlyphBuilders();
        }

        public void setGlyphBuilders(List<Glyph.Builder<? extends Glyph>> glyphBuilders) {
            this.glyphBuilders = glyphBuilders;
            this.setModelChanged();
        }

        public Glyph.Builder<? extends Glyph> glyphBuilder(ReadableFontData data) {
            Glyph.Builder<Glyph> glyphBuilder = Glyph.Builder.getBuilder(this, data);
            return glyphBuilder;
        }

        @Override
        protected GlyphTable subBuildTable(ReadableFontData data) {
            return new GlyphTable(this.header(), data);
        }

        @Override
        protected void subDataSet() {
            this.glyphBuilders = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.glyphBuilders == null || this.glyphBuilders.size() == 0) {
                return 0;
            }
            boolean variable = false;
            int size = 0;
            for (Glyph.Builder<? extends Glyph> b : this.glyphBuilders) {
                int glyphSize = b.subDataSizeToSerialize();
                size += Math.abs(glyphSize);
                variable |= glyphSize <= 0;
            }
            return variable ? -size : size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.glyphBuilders != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = 0;
            for (Glyph.Builder<? extends Glyph> b : this.glyphBuilders) {
                size += b.subSerialize(newData.slice(size));
            }
            return size;
        }
    }

    public static enum Offset {
        numberOfContours(0),
        xMin(2),
        yMin(4),
        xMax(6),
        yMax(8),
        simpleEndPtsOfCountours(10),
        simpleInstructionLength(0),
        simpleInstructions(2),
        compositeFlags(0),
        compositeGyphIndexWithoutFlag(0),
        compositeGlyphIndexWithFlag(2);

        final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

