/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.common.BytesUtil;
import cfca.sadk.ofd.base.common.SVGUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.base.seal.cross.SplittedImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;

public class ImageUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ImageUtil.class);
    public static byte[] svgImage = null;
    public static final String svg = "svg";
    private static final int BUFFER_SIZE = 8192;
    private static final float DEFAULT_POUND_RATIO = 72.0f;
    private static final byte[] gif = new byte[]{71, 73, 70};
    private static final byte[] jpeg = new byte[]{-1, -40};
    private static final byte[] jpeg2000_1 = new byte[]{0, 0, 0, 12};
    private static final byte[] jpeg2000_2 = new byte[]{-1, 79, -1, 81};
    private static final byte[] png = new byte[]{-119, 80, 78, 71};
    private static final byte[] wmf = new byte[]{-41, -51};
    private static final byte[] bmp = new byte[]{66, 77};
    private static final byte[] tiff_1 = new byte[]{77, 77, 0, 42};
    private static final byte[] tiff_2 = new byte[]{73, 73, 42, 0};
    private static final byte[] jbig2 = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};

    public static int cmConvertToPx(double cm, int dpi) {
        return (int)Math.round(cm * (double)dpi / 2.54);
    }

    public static double pxConvertToCm(double px, double dpi) {
        return (double)Math.round(px * 2.54 * 100.0 / dpi) / 100.0;
    }

    public static double pxConvertToMm(int px, double dpi) {
        return (double)Math.round((double)px * 2.54 * 100000.0 / dpi) / 10000.0;
    }

    public static double pxConvertToMm(float px, double dpi) {
        return (double)Math.round((double)px * 2.54 * 100000.0 / dpi) / 10000.0;
    }

    public static int mmConvertToPx(double mm, double dpi) {
        return (int)Math.round(mm * dpi / 25.4);
    }

    public static ArrayList<SplittedImage> splitImage(byte[] imageBytes, int startPageNo, int endPageNo, int crosspageStyle, int pageRangeOption) throws IOException, ImageReadException {
        int step = 1;
        int pages = endPageNo - startPageNo + 1;
        if (pageRangeOption != 0) {
            step = 2;
            int oddNum = 0;
            int evenNum = 0;
            if (pageRangeOption == 1) {
                if (startPageNo % 2 == 0) {
                    ++startPageNo;
                }
            } else if (pageRangeOption == 2 && startPageNo % 2 != 0) {
                ++startPageNo;
            }
            for (int i = startPageNo; i <= endPageNo; ++i) {
                if (i % 2 == 0) {
                    ++evenNum;
                    continue;
                }
                ++oddNum;
            }
            if (pageRangeOption == 1) {
                pages = oddNum;
            } else if (pageRangeOption == 2) {
                pages = evenNum;
            }
        }
        ArrayList<SplittedImage> splittedImages = new ArrayList<SplittedImage>();
        BufferedImage bufImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
        ImageInfo imageInfo = Sanselan.getImageInfo((byte[])imageBytes);
        double dpi = imageInfo.getPhysicalWidthDpi();
        if (dpi <= 0.0) {
            dpi = 96.0;
        }
        String format = imageInfo.getFormat().name;
        switch (crosspageStyle) {
            case 3: {
                ImageUtil.splittImageHorizontal(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, false, dpi);
                break;
            }
            case 4: {
                ImageUtil.splittImageHorizontal(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, true, dpi);
                break;
            }
            case 1: {
                if (pageRangeOption != 2) {
                    ImageUtil.splittImage(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, false, true, dpi);
                    break;
                }
                ImageUtil.splittImage(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, true, true, dpi);
                break;
            }
            case 2: {
                if (pageRangeOption != 2) {
                    ImageUtil.splittImage(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, true, false, dpi);
                    break;
                }
                ImageUtil.splittImage(splittedImages, startPageNo, endPageNo, pages, step, bufImage, format, false, false, dpi);
                break;
            }
            default: {
                businessLog.error("Unsupportted cross page style!");
                throw new IOException("Unsupportted cross page style!");
            }
        }
        return splittedImages;
    }

    private static void splittImage(ArrayList<SplittedImage> splittedImages, int startPageNo, int endPageNo, int pages, int step, BufferedImage bufImage, String format, boolean startFromLeft, boolean isLeft, double dpi) throws IOException {
        int pixelsHeight = bufImage.getHeight();
        int pixelsWidth = bufImage.getWidth();
        int splitedWidth = 0;
        int remainder = pixelsWidth % pages;
        int singleLength = (pixelsWidth - remainder) / pages;
        int remainderPixel = 1;
        remainderPixel = remainder < pages ? 1 : remainder / pages;
        for (int i = startPageNo; i <= endPageNo; i += step) {
            if (remainder > 0) {
                remainder -= remainderPixel;
            } else {
                remainderPixel = 0;
            }
            if (!startFromLeft && i == startPageNo) {
                splitedWidth = singleLength + remainderPixel;
            }
            BufferedImage subImage = ImageUtil.getSubImage(bufImage, singleLength + remainderPixel, startFromLeft, pixelsWidth, pixelsHeight, true, splitedWidth);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)subImage, format, baos);
            byte[] stripeImageBytes = baos.toByteArray();
            baos.reset();
            SplittedImage splittedImage = new SplittedImage();
            splittedImage.imageBytes = stripeImageBytes;
            splittedImage.pageNo = i;
            int splittedPixelsWidth = subImage.getWidth();
            splittedImage.imageRect = new Rectangle((float)ImageUtil.pxConvertToMm(splittedPixelsWidth, dpi), (float)ImageUtil.pxConvertToMm(pixelsHeight, dpi));
            splittedImages.add(splittedImage);
            splitedWidth += splittedPixelsWidth;
        }
    }

    private static void splittImageHorizontal(ArrayList<SplittedImage> splittedImages, int startPageNo, int endPageNo, int pages, int step, BufferedImage bufImage, String format, boolean startFromTop, double dpi) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        int pixelsWidth = bufImage.getWidth();
        int pixelsHeight = bufImage.getHeight();
        int splitedHeight = 0;
        float floatSingleLength = (float)pixelsHeight / (float)pages;
        int singleLength = (int)Math.floor(floatSingleLength);
        int remainder = pixelsHeight % pages;
        int remainderPixel = 1;
        remainderPixel = remainder < pages ? 1 : remainder / pages;
        for (int i = startPageNo; i <= endPageNo; i += step) {
            if (remainder > 0) {
                remainder -= remainderPixel;
            } else {
                remainderPixel = 0;
            }
            if (!startFromTop && i == startPageNo) {
                splitedHeight = singleLength + remainderPixel;
            }
            BufferedImage subImage = ImageUtil.getSubImage(bufImage, singleLength + remainderPixel, startFromTop, pixelsWidth, pixelsHeight, false, splitedHeight);
            ImageIO.write((RenderedImage)subImage, format, baos);
            byte[] stripeImageBytes = baos.toByteArray();
            baos.reset();
            SplittedImage splittedImage = new SplittedImage();
            splittedImage.imageBytes = stripeImageBytes;
            splittedImage.pageNo = i;
            int singlePixelsHeight = subImage.getHeight();
            splittedImage.imageRect = new Rectangle((float)ImageUtil.pxConvertToMm(pixelsWidth, dpi), (float)ImageUtil.pxConvertToMm(singlePixelsHeight, dpi));
            splittedImages.add(splittedImage);
            splitedHeight += singlePixelsHeight;
        }
    }

    private static BufferedImage getSubImage(BufferedImage bufImage, int singleLength, boolean isFromLeft, int totalWidth, int totalHeight, boolean verticalCut, int splittedWidth) {
        if (verticalCut) {
            int x = splittedWidth;
            if (!isFromLeft && (x = totalWidth - splittedWidth) < 0) {
                x = 0;
            }
            BufferedImage subImage = bufImage.getSubimage(x, 0, singleLength, totalHeight);
            return subImage;
        }
        int y = splittedWidth;
        if (!isFromLeft && (y = totalHeight - splittedWidth) < 0) {
            y = 0;
        }
        BufferedImage subImage = bufImage.getSubimage(0, y, totalWidth, singleLength);
        return subImage;
    }

    public static float div(float f, float divisor) {
        BigDecimal a = new BigDecimal(f);
        BigDecimal b = new BigDecimal(divisor);
        return a.divide(b, RoundingMode.HALF_UP).floatValue();
    }

    private static byte[] readImageType(byte[] source) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(source);
            byte[] bytes = new byte[8];
            stream.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean imageTypeIs(byte[] imageType, byte[] compareWith) {
        for (int i = 0; i < compareWith.length; ++i) {
            if (imageType[i] == compareWith[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isPNGType(byte[] source) {
        if (source == null) {
            return false;
        }
        byte[] imageType = ImageUtil.readImageType(source);
        return ImageUtil.imageTypeIs(imageType, png);
    }

    public static String getImageType(byte[] source) {
        if (source == null) {
            throw new IllegalArgumentException("imageData is null!");
        }
        byte[] imageType = ImageUtil.readImageType(source);
        if (ImageUtil.imageTypeIs(imageType, png)) {
            return "png";
        }
        if (ImageUtil.imageTypeIs(imageType, jpeg)) {
            return "jpeg";
        }
        if (ImageUtil.imageTypeIs(imageType, bmp)) {
            return "bmp";
        }
        if (ImageUtil.imageTypeIs(imageType, gif)) {
            return "gif";
        }
        if (BytesUtil.isContainsBytes(source, svgImage)) {
            return svg;
        }
        throw new IllegalArgumentException("image type is not support,image must be png or jpeg!");
    }

    public static float pound2mm(float pound) {
        float mm = 2.54f * pound / 72.0f;
        return mm;
    }

    public static int[] getImageSize(byte[] imageBytes, int dpi) throws Exception {
        int[] imageSize = new int[2];
        String imageType = ImageUtil.getImageType(imageBytes);
        if (svg.equals(imageType)) {
            float[] svgInfo = SVGUtil.getSVGPixel(imageBytes);
            if (dpi <= 0) {
                dpi = 96;
            }
            imageSize[0] = Math.round((float)ImageUtil.pxConvertToMm(svgInfo[0], (double)dpi));
            imageSize[1] = Math.round((float)ImageUtil.pxConvertToMm(svgInfo[1], (double)dpi));
            return imageSize;
        }
        ImageInfo imageInfo = Sanselan.getImageInfo((byte[])imageBytes);
        int dpiY = imageInfo.getPhysicalHeightDpi();
        int dpiX = imageInfo.getPhysicalWidthDpi();
        if (dpi > 0) {
            dpiX = dpi;
            dpiY = dpi;
        }
        if (dpiX <= 0 || dpiY <= 0) {
            dpiX = 96;
            dpiY = 96;
        }
        imageSize[0] = Math.round((float)ImageUtil.pxConvertToMm(imageInfo.getWidth(), (double)dpiX));
        imageSize[1] = Math.round((float)ImageUtil.pxConvertToMm(imageInfo.getHeight(), (double)dpiY));
        return imageSize;
    }

    public static byte[] resizeImageOptimized(byte[] imageByte, int width, int height) throws SealException {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageByte);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageInfo imageInfo = Sanselan.getImageInfo((byte[])imageByte);
            int dpi = imageInfo.getPhysicalWidthDpi();
            if (dpi <= 0) {
                dpi = 96;
            }
            width = ImageUtil.mmConvertToPx(width, dpi);
            height = ImageUtil.mmConvertToPx(height, dpi);
            BufferedImage bufferedImage = ImageIO.read(bais);
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            if (w == width && h == height) {
                return imageByte;
            }
            double scaleW = (double)width / (double)w;
            double scaleH = (double)height / (double)h;
            double scale = Math.min(scaleW, scaleH);
            height = (int)((double)h * scale);
            width = (int)((double)w * scale);
            BufferedImage buffImg = null;
            buffImg = new BufferedImage(width, height, 6);
            buffImg.getGraphics().drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, null);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (Exception e) {
            businessLog.error("ImageUtil.resizeImageOptimized Exception", (Throwable)e);
            throw new SealException("resizeImage failed", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] rotation(byte[] imageData, float rotation) throws IOException {
        if (rotation > 0.0f) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(imageData)}).scale(1.0).rotate((double)rotation).toOutputStream((OutputStream)output);
            return output.toByteArray();
        }
        return imageData;
    }

    static {
        try {
            svgImage = svg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

