/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;

final class SM2CardBigIntegers {
    private SM2CardBigIntegers() {
    }

    static int parseInt(byte[] data, int offset) throws CryptoException {
        if (data == null || data.length - offset < 4) {
            throw new CryptoParameterException("parseInt failure with data is null/not enough length");
        }
        int starter = offset;
        int length = (data[starter++] & 0xFF) << 24 | (data[starter++] & 0xFF) << 16 | (data[starter++] & 0xFF) << 8 | data[starter++] & 0xFF;
        return length;
    }

    static int parseBitLength(byte[] sm2KeyData) throws CryptoException {
        if (sm2KeyData == null || sm2KeyData.length < 4) {
            throw new CryptoParameterException("parseBitLength failure with sm2KeyData is null/not enough length");
        }
        if (sm2KeyData[0] != 0 || sm2KeyData[1] != 0) {
            throw new CryptoParameterException("parseBitLength failure with sm2KeyData[0/1] invalid");
        }
        int bitLength = (sm2KeyData[2] & 0xFF) << 8 | sm2KeyData[3] & 0xFF;
        if (bitLength != 256) {
            throw new CryptoParameterException("parseBitLength failure with sm2KeyData[2/3] invalid");
        }
        return bitLength;
    }

    static byte[] parseBytes(byte[] sm2KeyData, int offset, int length) throws CryptoException {
        if (sm2KeyData == null || sm2KeyData.length < offset + length) {
            throw new CryptoParameterException("parseBytes failure with sm2KeyData is null/not enough length");
        }
        byte[] bytes = new byte[length];
        System.arraycopy(sm2KeyData, offset, bytes, 0, bytes.length);
        return bytes;
    }

    static int copyBytes(String paramName, byte[] input, byte[] output, int offset) throws CryptoException {
        if (input == null) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with input is null", paramName));
        }
        if (input.length != 32) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with input length invalid", paramName));
        }
        if (output == null || output.length < input.length + offset) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with output is null/not enough space", paramName));
        }
        System.arraycopy(input, 0, output, offset, input.length);
        return input.length;
    }

    static int copyBitLength(int bitLength, byte[] output, int offset) throws CryptoException {
        if (output == null || output.length < offset + 4) {
            throw new CryptoParameterException("copyBitLength failure with output is null/not enough length");
        }
        int starter = offset;
        output[starter++] = 0;
        output[starter++] = 0;
        output[starter++] = (byte)(bitLength >> 8 & 0xFF);
        output[starter++] = (byte)(bitLength & 0xFF);
        return 4;
    }

    static int copyLength(int length, byte[] output, int offset) throws CryptoException {
        if (output == null || output.length < offset + 4) {
            throw new CryptoParameterException("copyLength failure with output is null/not enough length");
        }
        int starter = offset;
        output[starter++] = (byte)(length >> 24 & 0xFF);
        output[starter++] = (byte)(length >> 16 & 0xFF);
        output[starter++] = (byte)(length >> 8 & 0xFF);
        output[starter++] = (byte)(length & 0xFF);
        return 4;
    }
}

