/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.socket.TscLayeredConnectionSocketFactory;
import cfca.sadk.timestamp.client.socket.TscSocketFactory;
import cfca.sadk.timestamp.client.utils.TscStrings;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.util.Args;

public final class TscSSLHelper {
    private static final IgnoreHostnameVerifier IGNORE_HOSTNAME_VERIFIER = new IgnoreHostnameVerifier();

    private TscSSLHelper() {
    }

    public static final void loggingLocalCertificates(SSLSession session) {
        if (TscLogging.DEBUG_LOGGER.isDebugEnabled() && session != null) {
            StringBuilder builder = new StringBuilder(4096);
            builder.append("\r\n").append("Secure session established");
            builder.append("\r\n").append(" negotiated protocol: ").append(session.getProtocol());
            builder.append("\r\n").append(" negotiated cipher suite: ").append(session.getCipherSuite());
            try {
                Certificate[] certs = session.getLocalCertificates();
                if (certs != null && certs.length > 0) {
                    for (int i = 0; i < certs.length; ++i) {
                        builder.append("\r\n").append(" local certs: ").append(TscStrings.toBase64String(certs[i].getEncoded()));
                    }
                    X509Certificate x509 = (X509Certificate)certs[0];
                    X500Principal local = x509.getSubjectX500Principal();
                    builder.append("\r\n").append("  local principal: ").append(local);
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        builder.append("\r\n").append("  local alternative names: ").append(altNames);
                    }
                } else {
                    builder.append("\r\n").append(" local certs is null");
                }
                TscLogging.DEBUG_LOGGER.debug(builder.toString());
            }
            catch (Exception e) {
                builder.append("\r\n").append(" local certs parse failed");
                TscLogging.DEBUG_LOGGER.debug(builder.toString(), (Throwable)e);
            }
        }
    }

    public static final void loggingPeerCertificates(SSLSession session) {
        if (TscLogging.DEBUG_LOGGER.isDebugEnabled() && session != null) {
            StringBuilder builder = new StringBuilder(4096);
            builder.append("\r\n").append("Secure session established");
            builder.append("\r\n").append(" negotiated protocol: ").append(session.getProtocol());
            builder.append("\r\n").append(" negotiated cipher suite: ").append(session.getCipherSuite());
            try {
                Certificate[] certs = session.getPeerCertificates();
                if (certs != null && certs.length > 0) {
                    for (int i = 0; i < certs.length; ++i) {
                        builder.append("\r\n").append(" peer certs: ").append(TscStrings.toBase64String(certs[i].getEncoded()));
                    }
                    X509Certificate x509 = (X509Certificate)certs[0];
                    X500Principal peer = x509.getSubjectX500Principal();
                    builder.append("\r\n").append("  peer principal: ").append(peer);
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        builder.append("\r\n").append("  peer alternative names: ").append(altNames);
                    }
                    X500Principal issuer = x509.getIssuerX500Principal();
                    builder.append("\r\n").append("  issuer principal: ").append(issuer);
                    Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                    if (altNames2 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames2) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        builder.append("\r\n").append("  issuer alternative names: ").append(altNames);
                    }
                } else {
                    builder.append("\r\n").append(" peer certs is null");
                }
                TscLogging.DEBUG_LOGGER.debug(builder.toString());
            }
            catch (Exception e) {
                builder.append("\r\n").append(" peer certs parse failed");
                TscLogging.DEBUG_LOGGER.debug(builder.toString(), (Throwable)e);
            }
        }
    }

    public static final HostnameVerifier getDefaultHostnameVerifier() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    public static final LayeredConnectionSocketFactory newLayeredConnectionSocketFactory(SSLContext sslContext, TscLayeredConf tscLayeredConf, long loggingWarnThresholdTime) {
        Args.notNull((Object)tscLayeredConf, (String)"tscLayeredConf");
        TscSocketFactory sslSocketFactory = sslContext == null ? null : new TscSocketFactory(sslContext.getSocketFactory());
        boolean isGMSSL = tscLayeredConf.isGMSSL();
        String[] supportedProtocols = isGMSSL ? null : tscLayeredConf.getSupportedProtocols();
        String[] supportedCipherSuites = isGMSSL ? null : tscLayeredConf.getSupportedCipherSuites();
        HostnameVerifier hostnameVerifier = tscLayeredConf.isHostnameChecker() ? TscSSLHelper.getDefaultHostnameVerifier() : IGNORE_HOSTNAME_VERIFIER;
        return new TscLayeredConnectionSocketFactory(sslSocketFactory, supportedProtocols, supportedCipherSuites, hostnameVerifier, loggingWarnThresholdTime);
    }

    static final class IgnoreHostnameVerifier
    implements HostnameVerifier {
        IgnoreHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

