/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class GUIDUtil {
    private static SecureRandom random = new SecureRandom();

    public static synchronized String generateId() {
        Date date = Calendar.getInstance().getTime();
        String timeString = DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS");
        return timeString + GUIDUtil.getRandomNumber(6) + GUIDUtil.getRandomNumber(7);
    }

    public static synchronized String generateId(int length) {
        if (length < 17) {
            throw new IllegalArgumentException("Requested random string length " + length + " is less than 17");
        }
        Date date = Calendar.getInstance().getTime();
        String timeString = DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS");
        RandomStringUtils.randomNumeric((int)4);
        return timeString + GUIDUtil.getRandomNumber(length - 17);
    }

    public static String getRandomNumber(int length) {
        StringBuffer stringBuffer = new StringBuffer();
        String randomLongStr = GUIDUtil.getRandomLongStr();
        stringBuffer.append(randomLongStr);
        while (randomLongStr.length() < length) {
            String tempRandomLongStr = GUIDUtil.getRandomLongStr();
            stringBuffer.append(tempRandomLongStr);
        }
        return stringBuffer.toString().substring(0, length);
    }

    private static String getRandomLongStr() {
        long s1 = random.nextLong();
        long s2 = s1 >> 1;
        long s3 = 0x3FFFFFFFFFFFFFFFL;
        long s4 = s2 + s3;
        return String.valueOf(s4);
    }
}

