/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.AbstractTransaction;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.PdfBean4Response;
import cfca.paperless.dto.request.requestbody.tx40.ApplyAndDownloadCertRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CalculatePdfHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CompoundSealPdfListRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CompoundSealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CrossPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.MessageSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.RevokePdfSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SealOfdRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SignPdfHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SignPdfProofHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SynthesizeOuterSignatureAndSealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SynthesizeOuterSignatureRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyMessageSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyOfdSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyPdfSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyWebSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.WebSealRequestBody;
import cfca.paperless.dto.request.tx40.ApplyAndDownloadCertRequest;
import cfca.paperless.dto.request.tx40.CalculatePdfHashRequest;
import cfca.paperless.dto.request.tx40.CompoundSealPdfListDetachedRequest;
import cfca.paperless.dto.request.tx40.CompoundSealPdfListRequest;
import cfca.paperless.dto.request.tx40.CompoundSealPdfRequest;
import cfca.paperless.dto.request.tx40.CrossPdfRequest;
import cfca.paperless.dto.request.tx40.CrossSealPdfRequest;
import cfca.paperless.dto.request.tx40.MessageSealRequest;
import cfca.paperless.dto.request.tx40.RevokePdfSealRequest;
import cfca.paperless.dto.request.tx40.SealOfdRequest;
import cfca.paperless.dto.request.tx40.SealPdfRequest;
import cfca.paperless.dto.request.tx40.SignPdfHashRequest;
import cfca.paperless.dto.request.tx40.SignPdfProofHashRequest;
import cfca.paperless.dto.request.tx40.SynthesizeOuterSignatureAndSealPdfRequest;
import cfca.paperless.dto.request.tx40.SynthesizeOuterSignatureRequest;
import cfca.paperless.dto.request.tx40.VerifyMessageSealRequest;
import cfca.paperless.dto.request.tx40.VerifyOfdSealRequest;
import cfca.paperless.dto.request.tx40.VerifyPdfSealRequest;
import cfca.paperless.dto.request.tx40.VerifyWebSealRequest;
import cfca.paperless.dto.request.tx40.WebSealRequest;
import cfca.paperless.dto.response.responsebody.tx40.CompoundSealPdfListDetachedResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.CompoundSealPdfListResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.CompoundSealPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.RevokePdfSealResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.SealOfdResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.SealPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.SynthesizeOuterSignatureAndSealPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx40.SynthesizeOuterSignatureResponseBody;
import cfca.paperless.dto.response.tx40.ApplyAndDownloadCertResponse;
import cfca.paperless.dto.response.tx40.CalculatePdfHashResponse;
import cfca.paperless.dto.response.tx40.CompoundSealPdfListDetachedResponse;
import cfca.paperless.dto.response.tx40.CompoundSealPdfListResponse;
import cfca.paperless.dto.response.tx40.CompoundSealPdfResponse;
import cfca.paperless.dto.response.tx40.MessageSealResponse;
import cfca.paperless.dto.response.tx40.RevokePdfSealResponse;
import cfca.paperless.dto.response.tx40.SealOfdResponse;
import cfca.paperless.dto.response.tx40.SealPdfResponse;
import cfca.paperless.dto.response.tx40.SignPdfHashResponse;
import cfca.paperless.dto.response.tx40.SynthesizeOuterSignatureAndSealPdfResponse;
import cfca.paperless.dto.response.tx40.SynthesizeOuterSignatureResponse;
import cfca.paperless.dto.response.tx40.VerifyPdfSealResponse;
import cfca.paperless.dto.response.tx40.VerifyWebSealResponse;
import cfca.paperless.dto.response.tx40.WebSealResponse;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.bean.sign.SealVerifyResult;
import cfca.sadk.seal.util.VerifyUtil;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;

public class Tx40Transaction
extends AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(Tx40Transaction.class);
    public static final BouncyCastleProvider provider = new BouncyCastleProvider();

    public SealPdfResponse doTx4001(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4001 start.");
        SealPdfRequest requestBean = (SealPdfRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        SealPdfRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4001(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4001 doCheckTx4001 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4001 handleRequest finish.");
        SealPdfResponse responseBean = this.parseTx4001Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4001 parseTx4001Result finish.");
        logger.info("Tx40Transaction.doTx4001 end.");
        return responseBean;
    }

    public CompoundSealPdfResponse doTx4002(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4002 start.");
        CompoundSealPdfRequest requestBean = (CompoundSealPdfRequest)requestDto;
        CompoundSealPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4002(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4002 doCheckTx4002 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4002 handleRequest finish.");
        CompoundSealPdfResponse responseBean = this.parseTx4002Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4002 parseTx4002Result finish.");
        logger.info("Tx40Transaction.doTx4002 end.");
        return responseBean;
    }

    public CompoundSealPdfListResponse doTx4003(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4003 start.");
        CompoundSealPdfListRequest requestBean = (CompoundSealPdfListRequest)requestDto;
        CompoundSealPdfListRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4003(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4003 doCheckTx4003 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4003 handleRequest finish.");
        CompoundSealPdfListResponse responseBean = this.parseTx4003Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4003 parseTx4003Result finish.");
        logger.info("Tx40Transaction.doTx4003 end.");
        return responseBean;
    }

    public CompoundSealPdfListDetachedResponse doTx4004(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4004 start.");
        CompoundSealPdfListDetachedRequest requestBean = (CompoundSealPdfListDetachedRequest)requestDto;
        CompoundSealPdfListRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4003(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4004 doCheckTx4004 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4004 handleRequest finish.");
        CompoundSealPdfListDetachedResponse responseBean = this.parseTx4004Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4004 parseTx4004Result finish.");
        logger.info("Tx40Transaction.doTx4004 end.");
        return responseBean;
    }

    public VerifyPdfSealResponse doTx4005(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4005 start.");
        VerifyPdfSealRequest requestBean = (VerifyPdfSealRequest)requestDto;
        VerifyPdfSealRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4005(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4005 doCheckTx4005 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4005 handleRequest finish.");
        VerifyPdfSealResponse responseBean = this.parseTx4005Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4005 parseTx4005Result finish.");
        logger.info("Tx40Transaction.doTx4005 end.");
        return responseBean;
    }

    public RevokePdfSealResponse doTx4006(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4006 start.");
        RevokePdfSealRequest requestBean = (RevokePdfSealRequest)requestDto;
        RevokePdfSealRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4006(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4006 doCheckTx4006 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4006 handleRequest finish.");
        RevokePdfSealResponse responseBean = this.parseTx4006Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4006 parseTx4006Result finish.");
        logger.info("Tx40Transaction.doTx4006 end.");
        return responseBean;
    }

    public CalculatePdfHashResponse doTx4007(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4007 start.");
        CalculatePdfHashRequest requestBean = (CalculatePdfHashRequest)requestDto;
        CalculatePdfHashRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4007(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4007 doCheckTx4007 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4007 handleRequest finish.");
        CalculatePdfHashResponse responseBean = this.parseTx4007Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4007 parseTx4007Result finish.");
        logger.info("Tx40Transaction.doTx4007 end.");
        return responseBean;
    }

    public SynthesizeOuterSignatureResponse doTx4008(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4008 start.");
        SynthesizeOuterSignatureRequest requestBean = (SynthesizeOuterSignatureRequest)requestDto;
        SynthesizeOuterSignatureRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4008(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4008 doCheckTx4008 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4008 handleRequest finish.");
        SynthesizeOuterSignatureResponse responseBean = this.parseTx4008Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4008 parseTx4008Result finish.");
        logger.info("Tx40Transaction.doTx4008 end.");
        return responseBean;
    }

    public SynthesizeOuterSignatureAndSealPdfResponse doTx4009(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4009 start.");
        SynthesizeOuterSignatureAndSealPdfRequest requestBean = (SynthesizeOuterSignatureAndSealPdfRequest)requestDto;
        SynthesizeOuterSignatureAndSealPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4009(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4009 doCheckTx4009 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4009 handleRequest finish.");
        SynthesizeOuterSignatureAndSealPdfResponse responseBean = this.parseTx4009Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4009 parseTx4009Result finish.");
        logger.info("Tx40Transaction.doTx4009 end.");
        return responseBean;
    }

    public ApplyAndDownloadCertResponse doTx4011(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4011 start.");
        ApplyAndDownloadCertRequest requestBean = (ApplyAndDownloadCertRequest)requestDto;
        ApplyAndDownloadCertRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4011(requestBody);
        logger.info("Tx40Transaction.doTx4011 doCheckTx4011 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4011 handleRequest finish.");
        ApplyAndDownloadCertResponse responseBean = this.parseTx4011Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4011 parseTx4011Result finish.");
        logger.info("Tx40Transaction.doTx4011 end.");
        return responseBean;
    }

    public SealPdfResponse doTx4012(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4012 start.");
        CrossPdfRequest requestBean = (CrossPdfRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        CrossPdfRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4012(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4012 doCheckTx4012 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4012 handleRequest finish.");
        SealPdfResponse responseBean = this.parseTx4001Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4012 parseTx4012Result finish.");
        logger.info("Tx40Transaction.doTx4012 end.");
        return responseBean;
    }

    public SignPdfHashResponse doTx4013(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4013 start.");
        SignPdfProofHashRequest requestBean = (SignPdfProofHashRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        SignPdfProofHashRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4013(requestBody);
        logger.info("Tx40Transaction.doTx4013 doCheckTx4013 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4013 handleRequest finish.");
        SignPdfHashResponse responseBean = this.parseTx4013Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4013 parseTx4013Result finish.");
        logger.info("Tx40Transaction.doTx4013 end.");
        return responseBean;
    }

    public SignPdfHashResponse doTx4014(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4014 start.");
        SignPdfHashRequest requestBean = (SignPdfHashRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        SignPdfHashRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4014(requestBody);
        logger.info("Tx40Transaction.doTx4014 doCheckTx4014 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4014 handleRequest finish.");
        SignPdfHashResponse responseBean = this.parseTx4013Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4014 parseTx4014Result finish.");
        logger.info("Tx40Transaction.doTx4014 end.");
        return responseBean;
    }

    public SealPdfResponse doTx4015(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4015 start.");
        CrossSealPdfRequest requestBean = (CrossSealPdfRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        CrossPdfRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4012(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4015 doCheckTx4015 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4015 handleRequest finish.");
        SealPdfResponse responseBean = this.parseTx4001Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4015 parseTx4015Result finish.");
        logger.info("Tx40Transaction.doTx4015 end.");
        return responseBean;
    }

    public WebSealResponse doTx4016(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4016 start.");
        WebSealRequest requestBean = (WebSealRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        WebSealRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4016(requestBody);
        logger.info("Tx40Transaction.doTx4016 doCheckTx4016 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4016 handleRequest finish.");
        WebSealResponse responseBean = this.parseTx4016Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4016 parseTx4016Result finish.");
        logger.info("Tx40Transaction.doTx4016 end.");
        return responseBean;
    }

    public MessageSealResponse doTx4017(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4017 start.");
        MessageSealRequest requestBean = (MessageSealRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        MessageSealRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4017(requestBody);
        logger.info("Tx40Transaction.doTx4017 doCheckTx4017 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4017 handleRequest finish.");
        MessageSealResponse responseBean = this.parseTx4017Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4017 parseTx4017Result finish.");
        logger.info("Tx40Transaction.doTx4017 end.");
        return responseBean;
    }

    public VerifyWebSealResponse doTx4018(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4018 start.");
        VerifyWebSealRequest requestBean = (VerifyWebSealRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        VerifyWebSealRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4018(requestBody);
        logger.info("Tx40Transaction.doTx4018 doCheckTx4018 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4018 handleRequest finish.");
        VerifyWebSealResponse responseBean = this.parseTx4018Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4018 parseTx4016Result finish.");
        logger.info("Tx40Transaction.doTx4018 end.");
        return responseBean;
    }

    public VerifyWebSealResponse doTx4019(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4019 start.");
        VerifyMessageSealRequest requestBean = (VerifyMessageSealRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        VerifyMessageSealRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4019(requestBody);
        logger.info("Tx40Transaction.doTx4019 doCheckTx4019 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4019 handleRequest finish.");
        VerifyWebSealResponse responseBean = this.parseTx4018Result(responseJSONString);
        logger.info("Tx40Transaction.doTx4019 parseTx4019Result finish.");
        logger.info("Tx40Transaction.doTx4019 end.");
        return responseBean;
    }

    public SealOfdResponse doTx4101(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4101 start.");
        SealOfdRequest requestBean = (SealOfdRequest)requestDto;
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        SealOfdRequestBody requestBody = requestBean.getBody();
        ValidateUtil.doCheckTx4101(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4101 doCheckTx4101 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4101 handleRequest finish.");
        SealOfdResponse responseBean = this.parseTx4101Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4101 parseTx4101Result finish.");
        logger.info("Tx40Transaction.doTx4101 end.");
        return responseBean;
    }

    public VerifyPdfSealResponse doTx4105(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx40Transaction.doTx4105 start.");
        VerifyOfdSealRequest requestBean = (VerifyOfdSealRequest)requestDto;
        VerifyOfdSealRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx4105(requestBody, fileDataList);
        logger.info("Tx40Transaction.doTx4105 doCheckTx4105 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx40Transaction.doTx4105 handleRequest finish.");
        VerifyPdfSealResponse responseBean = this.parseTx4005Result(responseJSONString, outputFileDataList);
        logger.info("Tx40Transaction.doTx4105 parseTx4105Result finish.");
        logger.info("Tx40Transaction.doTx4105 end.");
        return responseBean;
    }

    private SealPdfResponse parseTx4001Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SealPdfResponse responseBean = (SealPdfResponse)JsonUtil.json2Obj((String)responseJSONString, SealPdfResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            SealPdfResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private CompoundSealPdfResponse parseTx4002Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        CompoundSealPdfResponse responseBean = (CompoundSealPdfResponse)JsonUtil.json2Obj((String)responseJSONString, CompoundSealPdfResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            CompoundSealPdfResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private CompoundSealPdfListResponse parseTx4003Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        CompoundSealPdfListResponse responseBean = (CompoundSealPdfListResponse)JsonUtil.json2Obj((String)responseJSONString, CompoundSealPdfListResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            CompoundSealPdfListResponseBody body = responseBean.getBody();
            List pdfBeans = body.getPdfBeans();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                for (int i = 0; i < pdfBeans.size(); ++i) {
                    PdfBean4Response pdfBean4Response = (PdfBean4Response)pdfBeans.get(i);
                    byte[] pdf = outputFileDataList.get(i);
                    String resultPdfFileDataHash = pdfBean4Response.getPdfFileDataHash();
                    this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                    pdfBean4Response.setPdf(pdf);
                }
                body.setPdfBeans(pdfBeans);
            }
        }
        return responseBean;
    }

    private CompoundSealPdfListDetachedResponse parseTx4004Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        CompoundSealPdfListDetachedResponse responseBean = (CompoundSealPdfListDetachedResponse)JsonUtil.json2Obj((String)responseJSONString, CompoundSealPdfListDetachedResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            CompoundSealPdfListDetachedResponseBody body = responseBean.getBody();
            List pdfBeans = body.getPdfBeans();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                for (int i = 0; i < pdfBeans.size(); ++i) {
                    PdfBean4Response pdfBean4Response = (PdfBean4Response)pdfBeans.get(i);
                    byte[] pdf = outputFileDataList.get(i);
                    String resultPdfFileDataHash = pdfBean4Response.getPdfFileDataHash();
                    this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                    pdfBean4Response.setPdf(pdf);
                }
                body.setPdfBeans(pdfBeans);
            }
        }
        return responseBean;
    }

    private VerifyPdfSealResponse parseTx4005Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        VerifyPdfSealResponse responseBean = (VerifyPdfSealResponse)JsonUtil.json2Obj((String)responseJSONString, VerifyPdfSealResponse.class);
        return responseBean;
    }

    private RevokePdfSealResponse parseTx4006Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        RevokePdfSealResponse responseBean = (RevokePdfSealResponse)JsonUtil.json2Obj((String)responseJSONString, RevokePdfSealResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            RevokePdfSealResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private CalculatePdfHashResponse parseTx4007Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        CalculatePdfHashResponse responseBean = (CalculatePdfHashResponse)JsonUtil.json2Obj((String)responseJSONString, CalculatePdfHashResponse.class);
        return responseBean;
    }

    private SynthesizeOuterSignatureResponse parseTx4008Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SynthesizeOuterSignatureResponse responseBean = (SynthesizeOuterSignatureResponse)JsonUtil.json2Obj((String)responseJSONString, SynthesizeOuterSignatureResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            SynthesizeOuterSignatureResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private SynthesizeOuterSignatureAndSealPdfResponse parseTx4009Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SynthesizeOuterSignatureAndSealPdfResponse responseBean = (SynthesizeOuterSignatureAndSealPdfResponse)JsonUtil.json2Obj((String)responseJSONString, SynthesizeOuterSignatureAndSealPdfResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            SynthesizeOuterSignatureAndSealPdfResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private ApplyAndDownloadCertResponse parseTx4011Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        ApplyAndDownloadCertResponse responseBean = (ApplyAndDownloadCertResponse)JsonUtil.json2Obj((String)responseJSONString, ApplyAndDownloadCertResponse.class);
        return responseBean;
    }

    private SignPdfHashResponse parseTx4013Result(String responseJSONString) throws Exception {
        SignPdfHashResponse responseBean = (SignPdfHashResponse)JsonUtil.json2Obj((String)responseJSONString, SignPdfHashResponse.class);
        return responseBean;
    }

    private WebSealResponse parseTx4016Result(String responseJSONString) throws Exception {
        WebSealResponse responseBean = (WebSealResponse)JsonUtil.json2Obj((String)responseJSONString, WebSealResponse.class);
        return responseBean;
    }

    private MessageSealResponse parseTx4017Result(String responseJSONString) throws Exception {
        MessageSealResponse responseBean = (MessageSealResponse)JsonUtil.json2Obj((String)responseJSONString, MessageSealResponse.class);
        return responseBean;
    }

    private VerifyWebSealResponse parseTx4018Result(String responseJSONString) throws Exception {
        VerifyWebSealResponse responseBean = (VerifyWebSealResponse)JsonUtil.json2Obj((String)responseJSONString, VerifyWebSealResponse.class);
        return responseBean;
    }

    private SealOfdResponse parseTx4101Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SealOfdResponse responseBean = (SealOfdResponse)JsonUtil.json2Obj((String)responseJSONString, SealOfdResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            SealOfdResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] ofd = outputFileDataList.get(0);
                String resultOfdFileDataHash = body.getOfdFileDataHash();
                this.checkAndCompareOfd(ofd, resultOfdFileDataHash);
                body.setOfd(ofd);
            }
        }
        return responseBean;
    }

    private void checkAndVerifyPdf(byte[] pdf, String resultPdfFileDataHash) throws Exception {
        boolean checkResult;
        if (StringUtil.isNotEmpty((String)resultPdfFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])pdf, (String)resultPdfFileDataHash))) {
            System.err.println("pdf hash compare resultPdfFileDataHash is error.");
            throw new Exception("pdf hash compare resultPdfFileDataHash is error.");
        }
        ValidityUtil.checkIsPdfFile((byte[])pdf);
        SealVerifyResult verifyResult = VerifyUtil.verify((byte[])pdf);
        if (!verifyResult.getVerifyResult()) {
            logger.error("pdf verify error" + verifyResult.getFailReason());
            throw new Exception("pdf verify error" + verifyResult.getFailReason());
        }
    }

    private void checkAndComparePdf(byte[] pdf, String resultPdfFileDataHash) throws Exception {
        boolean checkResult;
        ValidityUtil.checkIsPdfFile((byte[])pdf);
        if (StringUtil.isNotEmpty((String)resultPdfFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])pdf, (String)resultPdfFileDataHash))) {
            System.err.println("pdf hash compare resultPdfFileDataHash is error.");
            throw new Exception("pdf hash compare resultPdfFileDataHash is error.");
        }
    }

    private void checkAndCompareOfd(byte[] ofd, String resultOfdFileDataHash) throws Exception {
        boolean checkResult;
        if (StringUtil.isNotEmpty((String)resultOfdFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])ofd, (String)resultOfdFileDataHash))) {
            System.err.println("ofd hash compare resultOfdFileDataHash is error.");
            throw new Exception("ofd hash compare resultOfdFileDataHash is error.");
        }
    }

    static {
        Security.addProvider((Provider)provider);
    }
}

