/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.AbstractTransaction;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.request.requestbody.tx80.SynthesizeAndCompoundSealPdfRequestBody;
import cfca.paperless.dto.request.tx80.SynthesizeAndCompoundSealPdfRequest;
import cfca.paperless.dto.response.responsebody.tx80.SynthesizeAndCompoundSealPdfResponseBody;
import cfca.paperless.dto.response.tx80.SynthesizeAndCompoundSealPdfResponse;
import java.util.ArrayList;
import java.util.List;

public class Tx80Transaction
extends AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(Tx80Transaction.class);

    public SynthesizeAndCompoundSealPdfResponse doTx8001(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx8001 start.");
        SynthesizeAndCompoundSealPdfRequest requestBean = (SynthesizeAndCompoundSealPdfRequest)requestDto;
        SynthesizeAndCompoundSealPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> fileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx8001(requestBody, fileDataList);
        logger.info("Tx10Transaction.doTx8001 doCheckTx8001 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, (RequestDto)requestBean, fileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx8001 handleRequest finish.");
        SynthesizeAndCompoundSealPdfResponse responseBean = this.parseTx8001Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx8001 parseTx8001Result finish.");
        logger.info("Tx10Transaction.doTx8001 end.");
        return responseBean;
    }

    private SynthesizeAndCompoundSealPdfResponse parseTx8001Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SynthesizeAndCompoundSealPdfResponse responseBean = (SynthesizeAndCompoundSealPdfResponse)JsonUtil.json2Obj((String)responseJSONString, SynthesizeAndCompoundSealPdfResponse.class);
        ResponseHead responseHead = responseBean.getHead();
        if ("000000".equals(responseHead.getCode())) {
            SynthesizeAndCompoundSealPdfResponseBody body = responseBean.getBody();
            if (outputFileDataList != null && outputFileDataList.size() > 0) {
                byte[] pdf = outputFileDataList.get(0);
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndVerifyPdf(pdf, resultPdfFileDataHash);
                body.setPdf(pdf);
            }
        }
        return responseBean;
    }

    private void checkAndVerifyPdf(byte[] pdf, String resultPdfFileDataHash) throws Exception {
        boolean checkResult;
        if (StringUtil.isNotEmpty((String)resultPdfFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])pdf, (String)resultPdfFileDataHash))) {
            System.err.println("pdf hash compare resultPdfFileDataHash is error.");
            throw new Exception("pdf hash compare resultPdfFileDataHash is error.");
        }
        ValidityUtil.checkIsPdfFile((byte[])pdf);
    }
}

