/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.ImageUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.dto.bean.ImageInfoBean;
import cfca.paperless.dto.bean.TextBean;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.DeviceRgb;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.seal.base.bean.annotation.Annotation;
import cfca.sadk.seal.base.bean.annotation.AnnotationList;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.bean.form.FormFieldInfo;
import cfca.sadk.seal.base.util.FontsFactory;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.AnnotationUtil;
import cfca.sadk.seal.util.ContentUtil;
import cfca.sadk.seal.util.FormFieldUtil;
import cfca.sadk.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PdfCompoundUtil {
    public static final String fontTagName = "textfont";

    public static byte[] compoundPdfTextfield(byte[] pdfData, List<FormFieldInfo> textfieldBeanList, boolean isPartialFlattening) throws Exception {
        try {
            ArrayList<String> flattenStringList = new ArrayList<String>();
            String[] flattenStringArr = null;
            for (int i = 0; i < textfieldBeanList.size(); ++i) {
                FormFieldInfo formFieldInfo = textfieldBeanList.get(i);
                flattenStringList.add(formFieldInfo.getFieldName());
            }
            if (isPartialFlattening) {
                flattenStringArr = new String[flattenStringList.size()];
            }
            pdfData = FormFieldUtil.fillTextFormField((byte[])pdfData, textfieldBeanList, (String[])flattenStringArr, (boolean)false);
        }
        catch (Exception e) {
            throw new Exception("pdf\u5408\u6210\u6587\u672c\u57df\u51fa\u9519", e);
        }
        return pdfData;
    }

    public static byte[] addTextToPdf(byte[] pdfData, List<TextBean> textBeanList) throws Exception {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArrayList<TextAppearance> appearanceList = new ArrayList<TextAppearance>();
            for (TextBean textBean : textBeanList) {
                TextAppearance appearance = new TextAppearance();
                float fontSize = 12.0f;
                if (StringUtil.isNotEmptyAndNull((String)textBean.getTextFontSize()) && (fontSize = Float.parseFloat(textBean.getTextFontSize())) <= 0.0f) {
                    fontSize = 12.0f;
                }
                Color fontColor = Color.BLACK;
                if (StringUtil.isNotEmptyAndNull((String)textBean.getTextColor())) {
                    DeviceRgb businessColor = ImageUtil.hex2RGB((String)textBean.getTextColor());
                    fontColor = Color.convertRgbToCmyk((DeviceRgb)businessColor);
                }
                String fontName = textBean.getTextFontName();
                PdfFont pdfFont = null;
                if (StringUtil.isNotEmpty((String)fontName)) {
                    pdfFont = FontsFactory.getInstance().getSubSetFont(fontName, textBean.getTextValue(), false);
                }
                int len = textBean.getTextValue().length();
                float width = (float)(len + 1) * fontSize;
                float height = fontSize + 3.0f;
                int pageNo = Integer.parseInt(textBean.getPageNo());
                if ("2".equals(textBean.getType())) {
                    int num = PDFUtil.getPageNums((byte[])pdfData);
                    if (pageNo > num) {
                        throw new Exception("\u9875\u7801\u8d85\u51fa\u6a21\u677f\u6587\u6863\u8303\u56f4");
                    }
                    appearance.setPageNum(pageNo);
                    appearance.setRectangle(new Rectangle(Float.parseFloat(textBean.getLx()), Float.parseFloat(textBean.getLy()), width, height));
                    appearance.setTransparency(1.0f);
                    appearance.setSignText(textBean.getTextValue());
                    appearance.setFontColor(fontColor);
                    appearance.setFontSize(fontSize);
                    appearance.setFont(pdfFont);
                    appearance.setUpperLeftCoordinate(false);
                    appearanceList.add(appearance);
                    continue;
                }
                if (!"3".equals(textBean.getType())) continue;
                String keyword = textBean.getKeyword();
                int offsetX = Integer.parseInt(textBean.getOffsetX());
                int offsetY = Integer.parseInt(textBean.getOffsetY());
                int num = PDFUtil.getPageNums((byte[])pdfData);
                for (int j = 1; j <= num; ++j) {
                    List locationList = PDFUtil.locationExtraction((byte[])pdfData, (String)keyword, (int)j);
                    if (locationList == null || locationList.size() <= 0) continue;
                    for (int n = 0; n < locationList.size(); ++n) {
                        TextAppearance appearance2 = new TextAppearance();
                        Rectangle rect = (Rectangle)locationList.get(n);
                        float llx = rect.getX();
                        float lly = rect.getY();
                        appearance2.setPageNum(j);
                        appearance2.setRectangle(new Rectangle(llx += (float)offsetX, lly += (float)offsetY, width, height));
                        appearance2.setTransparency(1.0f);
                        appearance2.setSignText(textBean.getTextValue());
                        appearance2.setFontColor(fontColor);
                        appearance2.setFontSize(fontSize);
                        appearance2.setFont(pdfFont);
                        appearance2.setUpperLeftCoordinate(false);
                        appearanceList.add(appearance2);
                    }
                }
            }
            ContentUtil.addTextToPdf((byte[])pdfData, (OutputStream)baos, appearanceList);
            if (null != baos && baos.size() > 0) {
                pdfData = baos.toByteArray();
            }
            return pdfData;
        }
        catch (Exception e) {
            throw new Exception("pdf\u5408\u6210\u6587\u672c\u51fa\u9519", e);
        }
    }

    public static byte[] compoundPdfDataByImage(byte[] pdfData, List<ImageInfoBean> imageBeanInfos) throws Exception {
        PdfReader pdfReader = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArrayList<GraphicAppearance> appearanceList = new ArrayList<GraphicAppearance>();
            pdfReader = new PdfReader(pdfData);
            int pages = PDFUtil.getPageNums((PdfReader)pdfReader);
            for (ImageInfoBean imageBeanInfo : imageBeanInfos) {
                GraphicAppearance appearance = new GraphicAppearance();
                pdfReader = new PdfReader(pdfData);
                int pageNo = Integer.parseInt(imageBeanInfo.getPageNo());
                String ImageDataStr = imageBeanInfo.getImageSource();
                byte[] imageData = Base64.decode((byte[])ImageDataStr.getBytes("UTF-8"));
                float[] imageWidthAndHeight = ImageUtil.getImageWidth((byte[])imageData);
                float width = Float.parseFloat(imageBeanInfo.getWidth());
                float height = Float.parseFloat(imageBeanInfo.getHeight());
                if (width == 0.0f || height == 0.0f) {
                    width = imageWidthAndHeight[0];
                    height = imageWidthAndHeight[1];
                }
                appearance.setStamperSr(imageData);
                appearance.setTransparency(1.0f);
                appearance.setUpperLeftCoordinate(false);
                if ("2".equals(imageBeanInfo.getType())) {
                    if (pages < pageNo) {
                        throw new Exception("pageNo\u4e0d\u80fd\u8d85\u8fc7pdf\u603b\u9875\u6570: pageNo=" + pageNo + " pdf\u603b\u9875\u6570=" + pages);
                    }
                    appearance.setPageNum(pageNo);
                    appearance.setRectangle(new Rectangle(Float.parseFloat(imageBeanInfo.getLx()), Float.parseFloat(imageBeanInfo.getLy()), width * 0.75f, height * 0.75f));
                    appearanceList.add((GraphicAppearance)appearance.clone());
                } else if ("3".equals(imageBeanInfo.getType())) {
                    String keyword = imageBeanInfo.getKeyword();
                    int offsetX = Integer.parseInt(imageBeanInfo.getOffsetX());
                    int offsetY = Integer.parseInt(imageBeanInfo.getOffsetY());
                    pageNo = Integer.parseInt(imageBeanInfo.getPageNo());
                    boolean flag = false;
                    if (pageNo != 0) {
                        List locationList = PDFUtil.locationExtraction((byte[])pdfData, (String)keyword, (int)pageNo);
                        if (locationList != null && locationList.size() > 0) {
                            flag = true;
                            for (int n = 0; n < locationList.size(); ++n) {
                                Rectangle rect = (Rectangle)locationList.get(n);
                                float llx = rect.getX();
                                float lly = rect.getY();
                                appearance.setPageNum(pageNo);
                                appearance.setRectangle(new Rectangle(llx += (float)offsetX, lly += (float)offsetY, width * 0.75f, height * 0.75f));
                                appearanceList.add((GraphicAppearance)appearance.clone());
                            }
                        }
                    } else {
                        for (int j = 1; j <= pages; ++j) {
                            List locationList = PDFUtil.locationExtraction((byte[])pdfData, (String)keyword, (int)j);
                            if (locationList == null || locationList.size() <= 0) continue;
                            flag = true;
                            for (int n = 0; n < locationList.size(); ++n) {
                                Rectangle rect = (Rectangle)locationList.get(n);
                                float llx = rect.getX();
                                float lly = rect.getY();
                                appearance.setPageNum(j);
                                appearance.setRectangle(new Rectangle(llx += (float)offsetX, lly += (float)offsetY, width * 0.75f, height * 0.75f));
                                appearanceList.add((GraphicAppearance)appearance.clone());
                            }
                        }
                    }
                    if (!flag) {
                        throw new CodeException("600612", "\uff0cPDF\u6587\u6863\u4e2d\u627e\u4e0d\u5230\u5173\u952e\u5b57" + keyword);
                    }
                }
                ContentUtil.addImageToPdf((byte[])pdfData, (OutputStream)baos, appearanceList);
            }
            if (null != baos && baos.size() > 0) {
                pdfData = baos.toByteArray();
            }
            return pdfData;
        }
        catch (Exception e) {
            throw new Exception("pdf\u5408\u6210\u56fe\u7247\u51fa\u9519", e);
        }
    }

    public static byte[] compoundPdfDataByAttachment(byte[] pdfData, byte[] fileData, String fileName) throws Exception {
        return PdfCompoundUtil.compoundPdfDataByAttachment(pdfData, fileData, fileName, false);
    }

    public static byte[] compoundPdfDataByAttachment(byte[] pdfData, byte[] fileData, String fileName, boolean checkPdfSignature) throws Exception {
        try {
            int sigLen;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pdfData);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (checkPdfSignature && (sigLen = PDFUtil.getSignatureNum((InputStream)byteArrayInputStream)) > 0) {
                throw new Exception("pdf\u4e2d\u5df2\u7ecf\u5b58\u5728\u7b7e\u540d\u4e0d\u80fd\u7ee7\u7eed\u5408\u6210\u6570\u636e ");
            }
            AnnotationList annotationList = new AnnotationList();
            Annotation annotation = new Annotation();
            annotation.setRect(new Rectangle(100.0f, 200.0f, 50.0f, 20.0f));
            annotation.setFileDisplay(fileName);
            annotation.setFileData(fileData);
            annotationList.add((Object)annotation);
            AnnotationUtil.addAnnotationList((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream, (AnnotationList)annotationList);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("pdf\u6587\u6863\u5408\u6210\u4e1a\u52a1\u6570\u636e\u5f02\u5e38", e);
        }
    }

    public static int getPdfSignatureLength(byte[] pdfData) throws Exception {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(pdfData);
            return PDFUtil.getSignatureNum((InputStream)bais);
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6PDF\u7b7e\u540d\u4e2a\u6570\u51fa\u9519", e);
        }
    }
}

