/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.client.bean.PaperSize;
import cfca.paperless.base.enums.IdType;
import cfca.paperless.base.util.IoUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.TimeUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.util.CommonUtil;
import cfca.paperless.dto.RequestHead;
import cfca.paperless.dto.bean.CircleImageStrategy;
import cfca.paperless.dto.bean.CrossPdfStrategy;
import cfca.paperless.dto.bean.CrossSealStrategy;
import cfca.paperless.dto.bean.CrossStrategy;
import cfca.paperless.dto.bean.FieldBean;
import cfca.paperless.dto.bean.ImageBean;
import cfca.paperless.dto.bean.ImageInfoBean;
import cfca.paperless.dto.bean.KeywordLocation;
import cfca.paperless.dto.bean.MultiDataBean;
import cfca.paperless.dto.bean.OfdSealStrategy;
import cfca.paperless.dto.bean.Organization;
import cfca.paperless.dto.bean.PdfBean;
import cfca.paperless.dto.bean.PdfHashBean;
import cfca.paperless.dto.bean.ProofSealStrategy;
import cfca.paperless.dto.bean.RectangleImageStrategy;
import cfca.paperless.dto.bean.SealCertBean;
import cfca.paperless.dto.bean.SealInfoBean;
import cfca.paperless.dto.bean.SealStrategy;
import cfca.paperless.dto.bean.SignInfoBean;
import cfca.paperless.dto.bean.SignLocation;
import cfca.paperless.dto.bean.SquareImageStrategy;
import cfca.paperless.dto.bean.TextBean;
import cfca.paperless.dto.bean.WaterMarkStrategy;
import cfca.paperless.dto.request.requestbody.tx10.AddCrossToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.AddOrganizationRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.AddWaterMarkToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.ConcatPdfListRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.DownloadTemplateRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeBusinessDataRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeMultiDataRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.UploadTemplateRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.DeleteSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeCircleSealImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeRectangleSealImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.MakeSquareSealImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx20.UpdateSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformHtmlToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformImageToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformPdfToImageRequestBody;
import cfca.paperless.dto.request.requestbody.tx30.TransformWordToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.ApplyAndDownloadCertRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CalculatePdfHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CompoundSealPdfListRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CompoundSealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.CrossPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.MessageSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.RevokePdfSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SealOfdRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SignPdfHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SignPdfProofHashRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SynthesizeOuterSignatureAndSealPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.SynthesizeOuterSignatureRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyMessageSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyOfdSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyPdfSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.VerifyWebSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx40.WebSealRequestBody;
import cfca.paperless.dto.request.requestbody.tx50.CheckNetWorkConnRequestBody;
import cfca.paperless.dto.request.requestbody.tx50.GetP10AmountRequestBody;
import cfca.paperless.dto.request.requestbody.tx50.GetSceneCertAmountRequestBody;
import cfca.paperless.dto.request.requestbody.tx50.HeartBeatRequestBody;
import cfca.paperless.dto.request.requestbody.tx60.DownloadProofFileRequestBody;
import cfca.paperless.dto.request.requestbody.tx60.QueryProofInfoListRequestBody;
import cfca.paperless.dto.request.requestbody.tx80.SynthesizeAndCompoundSealPdfRequestBody;
import java.util.Date;
import java.util.List;

public class ValidateUtil {
    public static final Logger logger = LoggerFactory.getLogger(ValidateUtil.class);

    public static void checkRequestHead(RequestHead requestHead) throws Exception {
        if (CommonUtil.isEmpty(requestHead.getTransactionNo())) {
            logger.error("transactionNo is null");
            throw new Exception("transactionNo is null");
        }
        if (CommonUtil.isEmpty(requestHead.getOrganizationCode())) {
            logger.error("organizationCode is null");
            throw new Exception("organizationCode is null");
        }
    }

    public static void doCheckTx1001(UploadTemplateRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error("inputType \u53d6\u503c\u9519\u8bef");
            throw new Exception("inputType\u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error("inputSource is null");
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix) && !"docx".equals(pdfSuffix)) {
                logger.error("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6216docx\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6216docx\u6587\u4ef6");
            }
            if (!pdfSuffix.equalsIgnoreCase(requestBody.getTemplateFormat())) {
                throw new Exception("\u8bf7\u68c0\u67e5inputSource\u4e0etemplateFormat\u662f\u5426\u4e00\u81f4");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getTemplateData() == null) {
                logger.error(" templateData is null");
                throw new Exception(" templateData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getTemplateFileDataHash())) {
                String templateFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getTemplateData());
                requestBody.setTemplateFileDataHash(templateFileDataHash);
            }
            fileDataList.add(requestBody.getTemplateData());
            requestBody.setTemplateData(null);
        }
        logger.info("inputType={} templateFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getTemplateFileDataHash(), requestBody.getInputSource()});
        if (StringUtil.isEmpty((String)requestBody.getTemplateCode())) {
            logger.error("templateCode is null");
            throw new Exception("templateCode is null");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getTemplateCode(), (int)32)) {
            logger.error("templateCode \u957f\u5ea6\u8d85\u9650\uff0c\u4e0a\u965032");
            throw new Exception("templateCode \u957f\u5ea6\u8d85\u9650\uff0c\u4e0a\u965032");
        }
        if (StringUtil.isEmpty((String)requestBody.getTemplateName())) {
            logger.error("templateName is null");
            throw new Exception("templateName is null");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getTemplateName(), (int)128)) {
            logger.error("templateName \u957f\u5ea6\u8d85\u9650\uff0c\u4e0a\u9650128");
            throw new Exception("templateName \u957f\u5ea6\u8d85\u9650\uff0c\u4e0a\u9650128");
        }
        if (!"pdf".equalsIgnoreCase(requestBody.getTemplateFormat()) && !"docx".equalsIgnoreCase(requestBody.getTemplateFormat())) {
            logger.error("templateFormat \u53d6\u503c\u9519\u8bef\uff0c\u652f\u6301pdf docx \u4e24\u79cd\u7c7b\u578b\u7684\u6a21\u677f");
            throw new Exception("templateFormat \u53d6\u503c\u9519\u8bef\uff0c\u652f\u6301pdf docx \u4e24\u79cd\u7c7b\u578b\u7684\u6a21\u677f");
        }
        if (!"1".equals(requestBody.getOperationType()) && !"3".equals(requestBody.getOperationType())) {
            throw new Exception("operationType \u53d6\u503c\u9519\u8bef");
        }
    }

    public static void doCheckTx1002(DownloadTemplateRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getTemplateCode())) {
            logger.error(" TemplateCode is null");
            throw new Exception(" TemplateCode is null");
        }
    }

    public static void doCheckTx1003(SynthesizeBusinessDataRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!("1".equals(requestBody.getInputType()) || "2".equals(requestBody.getInputType()) || "3".equals(requestBody.getInputType()))) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error(" inputSource is null");
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error("pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        List fieldBeans = requestBody.getFieldBeans();
        List textBeans = requestBody.getTextBeans();
        List imageBeans = requestBody.getImageBeans();
        ValidateUtil.checkBusinessData(fieldBeans, textBeans, imageBeans);
    }

    private static void checkBusinessData(List<FieldBean> fieldBeans, List<TextBean> textBeans, List<ImageInfoBean> imageBeans) throws Exception {
        boolean flag = false;
        if (fieldBeans != null && fieldBeans.size() > 0) {
            flag = true;
            for (FieldBean fieldBean : fieldBeans) {
                String fieldType = fieldBean.getFieldType();
                if ("text".equals(fieldType) || "checkbox".equals(fieldType)) continue;
                logger.error("fieldType \u53d6\u503c\u9519\u8bef\uff0c\u6587\u672c\u57df\u7c7b\u578b\u652f\u6301text,checkbox\u4e24\u79cd\u7c7b\u578b");
                throw new Exception("fieldType \u53d6\u503c\u9519\u8bef\uff0c\u6587\u672c\u57df\u7c7b\u578b\u652f\u6301text,checkbox\u4e24\u79cd\u7c7b\u578b");
            }
        }
        if (textBeans != null && textBeans.size() > 0) {
            flag = true;
            for (TextBean textBean : textBeans) {
                if (StringUtil.isEmpty((String)textBean.getTextValue())) {
                    logger.error("textValue is null");
                    throw new Exception("textValue is null");
                }
                if (!"2".equals(textBean.getType()) && !"3".equals(textBean.getType())) {
                    logger.error("type \u53d6\u503c\u9519\u8bef\uff0ctype\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u80053");
                    throw new Exception("type \u53d6\u503c\u9519\u8bef\uff0ctype\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u80053");
                }
                if (StringUtil.isNotEmpty((String)textBean.getTextFontSize()) && !StringUtil.isNaturalNumber((String)textBean.getTextFontSize(), (int)4)) {
                    logger.error("textFontSize \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("textFontSize \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isNotEmpty((String)textBean.getTextColor()) && !StringUtil.isColorNumber((String)textBean.getTextColor())) {
                    logger.error("textColor \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("textColor \u53d6\u503c\u9519\u8bef");
                }
                if ("2".equals(textBean.getType())) {
                    if (StringUtil.isEmpty((String)textBean.getPageNo())) {
                        logger.error("type=2\u5750\u6807\u5408\u6210\u65f6\uff0cpageoNo\u4e0d\u80fd\u4e3a\u7a7a ");
                        throw new Exception("type=2\u5750\u6807\u5408\u6210\u65f6\uff0cpageoNo\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtil.isNaturalNumber((String)textBean.getPageNo(), (int)6)) {
                        logger.error("pageoNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("pageoNo \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)textBean.getLx())) {
                        textBean.setLx("0");
                    }
                    if (!StringUtil.isPositiveNumeric((String)textBean.getLx())) {
                        logger.error("lx \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("lx \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)textBean.getLy())) {
                        textBean.setLy("0");
                    }
                    if (StringUtil.isPositiveNumeric((String)textBean.getLy())) continue;
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("ly \u53d6\u503c\u9519\u8bef");
                }
                if (!"3".equals(textBean.getType())) continue;
                if (StringUtil.isEmpty((String)textBean.getKeyword())) {
                    logger.error("type=3\u5173\u952e\u5b57\u5408\u6210\u65f6\uff0ckeyword\u4e0d\u80fd\u4e3a\u7a7a ");
                    throw new Exception("type=3\u5173\u952e\u5b57\u5408\u6210\u65f6\uff0ckeyword\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtil.isEmpty((String)textBean.getPageNo())) {
                    textBean.setPageNo("1");
                }
                if (!StringUtil.isNaturalNumber((String)textBean.getPageNo(), (int)6)) {
                    logger.error("pageoNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("pageoNo \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)textBean.getOffsetX())) {
                    textBean.setOffsetX("0");
                }
                if (!StringUtil.isNumeric((String)textBean.getOffsetX())) {
                    logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)textBean.getOffsetY())) {
                    textBean.setOffsetY("0");
                }
                if (StringUtil.isNumeric((String)textBean.getOffsetY())) continue;
                logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
            }
        }
        if (imageBeans != null && imageBeans.size() > 0) {
            flag = true;
            int i = 1;
            for (ImageInfoBean imageBean : imageBeans) {
                if (!"1".equals(imageBean.getImageType()) && !"2".equals(imageBean.getImageType())) {
                    logger.error("inputType \u53d6\u503c\u9519\u8bef\uff0cinputType\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
                    throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0cinputType\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
                }
                if (StringUtil.isEmpty((String)imageBean.getImageSource())) {
                    logger.error("\u7b2c" + (i + 1) + "imageSource is null");
                    throw new Exception("\u7b2c" + (i + 1) + " imageSource is null");
                }
                if (!"2".equals(imageBean.getType()) && !"3".equals(imageBean.getType())) {
                    logger.error("type\u53d6\u503c\u9519\u8bef\uff0ctype\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u80053");
                    throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0ctype\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u80053");
                }
                if (StringUtil.isEmpty((String)imageBean.getIsCenterCoordinate())) {
                    imageBean.setIsCenterCoordinate("0");
                }
                if (StringUtil.isEmpty((String)imageBean.getHeight())) {
                    imageBean.setHeight("0");
                }
                if (StringUtil.isEmpty((String)imageBean.getWidth())) {
                    imageBean.setWidth("0");
                }
                if ("2".equals(imageBean.getType())) {
                    if (StringUtil.isEmpty((String)imageBean.getPageNo())) {
                        logger.error("type=2\u5750\u6807\u5408\u6210\u65f6\uff0cpageoNo\u4e0d\u80fd\u4e3a\u7a7a ");
                        throw new Exception("type=2\u5750\u6807\u5408\u6210\u65f6\uff0cpageoNo\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtil.isNaturalNumber((String)imageBean.getPageNo(), (int)6)) {
                        logger.error("pageoNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("pageoNo \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)imageBean.getLx())) {
                        imageBean.setLx("0");
                    }
                    if (!StringUtil.isPositiveNumeric((String)imageBean.getLx())) {
                        logger.error("lx \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("lx \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)imageBean.getLy())) {
                        imageBean.setLy("0");
                    }
                    if (StringUtil.isPositiveNumeric((String)imageBean.getLy())) continue;
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("ly \u53d6\u503c\u9519\u8bef");
                }
                if (!"3".equals(imageBean.getType())) continue;
                if (StringUtil.isEmpty((String)imageBean.getKeyword())) {
                    logger.error("type\u503c\u4e3a3\u5750\u6807\u7b7e\u7ae0\u65f6\uff0ckeyword\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new Exception("type\u503c\u4e3a3\u5750\u6807\u7b7e\u7ae0\u65f6\uff0ckeyword\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtil.isEmpty((String)imageBean.getPageNo())) {
                    imageBean.setPageNo("0");
                }
                if (!StringUtil.isNaturalNumber((String)imageBean.getPageNo(), (int)6)) {
                    logger.error("pageoNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("pageoNo \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)imageBean.getOffsetX())) {
                    imageBean.setOffsetX("0");
                }
                if (!StringUtil.isNumeric((String)imageBean.getOffsetX())) {
                    logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)imageBean.getOffsetY())) {
                    imageBean.setOffsetY("0");
                }
                if (StringUtil.isNumeric((String)imageBean.getOffsetY())) continue;
                logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
            }
        }
        if (!flag) {
            logger.error("fieldBeans \u3001 textBeans \u3001 imageBeans all null");
            throw new Exception("fieldBeans \u3001 textBeans \u3001 imageBeans all null");
        }
    }

    public static void doCheckTx1004(SynthesizeMultiDataRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List multiDataBeans;
        if (!("1".equals(requestBody.getInputType()) || "2".equals(requestBody.getInputType()) || "3".equals(requestBody.getInputType()))) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        if ((multiDataBeans = requestBody.getMultiDataBeans()) == null || multiDataBeans.size() == 0) {
            logger.error(" multiDatas is null");
            throw new Exception(" multiDatas is null");
        }
        for (MultiDataBean multiDataBean : multiDataBeans) {
            if (StringUtil.isEmpty((String)multiDataBean.getFileName())) {
                logger.error(" fileName is null");
                throw new Exception(" fileName is null");
            }
            if (!StringUtil.validateStrMaxLength((String)multiDataBean.getFileName(), (int)128)) {
                logger.error("fileName \u957f\u5ea6\u8d85\u8fc7128");
                throw new Exception("fileName \u957f\u5ea6\u8d85\u8fc7128");
            }
            if (StringUtil.isEmpty((String)multiDataBean.getFileData())) {
                logger.error(" fileData is null");
                throw new Exception(" fileData is null");
            }
            if (!StringUtil.isEmpty((String)multiDataBean.getFileDataHash())) continue;
            logger.error(" fileDataHash is null");
            throw new Exception(" fileDataHash is null");
        }
    }

    public static void doCheckTx1005(ConcatPdfListRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List pdfBeans = requestBody.getPdfBeans();
        if (pdfBeans == null || pdfBeans.size() < 2) {
            logger.error(" pdfBeans \u81f3\u5c11\u9700\u8981\u5305\u542b\u4e24\u4e2apdf\u6587\u6863");
            throw new Exception("pdfBeans \u81f3\u5c11\u9700\u8981\u5305\u542b\u4e24\u4e2apdf\u6587\u6863");
        }
        for (PdfBean bean : pdfBeans) {
            if (!"1".equals(bean.getInputType()) && !"2".equals(bean.getInputType())) {
                logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
                throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            }
            if ("1".equals(bean.getInputType())) {
                if (StringUtil.isEmpty((String)bean.getInputSource())) {
                    throw new Exception(" inputSource is null");
                }
                String pdfSuffix = IoUtil.getFileNameSuffix((String)bean.getInputSource());
                if ("pdf".equals(pdfSuffix)) continue;
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
            if (!"2".equals(bean.getInputType())) continue;
            byte[] pdfData = bean.getPdfData();
            if (pdfData == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)bean.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])bean.getPdfData());
                bean.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(pdfData);
            bean.setPdfData(null);
        }
    }

    public static void doCheckTx1006(AddWaterMarkToPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        int toPage;
        WaterMarkStrategy waterMarkStrategy;
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error("inputSource is null");
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        if ((waterMarkStrategy = requestBody.getWaterMarkStrategy()) == null) {
            logger.error("waterMarkStrategy is null");
            throw new Exception(" waterMarkStrategy is null ");
        }
        if (!StringUtil.isNaturalNumber((String)waterMarkStrategy.getFromPage(), (int)6)) {
            logger.error("fromPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" fromPage \u53d6\u503c\u9519\u8bef,fromPage\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u662f\u5927\u4e8e\u7b49\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        if (!StringUtil.isNaturalNumber((String)waterMarkStrategy.getToPage(), (int)6)) {
            logger.error("toPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" toPage \u53d6\u503c\u9519\u8bef ,toPage\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u662f\u5927\u4e8e\u7b49\u4e8e0\u7684\u6b63\u6574\u6570");
        }
        int fromPage = Integer.parseInt(waterMarkStrategy.getFromPage());
        if (fromPage > (toPage = Integer.parseInt(waterMarkStrategy.getToPage()))) {
            logger.error("frompage \u53d6\u503c \u5927\u4e8e toPage ");
            throw new Exception(" frompage \u53d6\u503c \u4e0d\u5e94\u5927\u4e8e toPage ");
        }
        if (!StringUtil.isPositiveNumeric((String)waterMarkStrategy.getFitHeight())) {
            logger.error(" fitHeight \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fitHeight \u53d6\u503c \u9519\u8bef ");
        }
        if (!StringUtil.isPositiveNumeric((String)waterMarkStrategy.getFitWidth())) {
            logger.error(" fitWidth \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fitWidth \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getAbsoluteX())) {
            waterMarkStrategy.setAbsoluteX("0");
        }
        if (!StringUtil.isPositiveNumeric((String)waterMarkStrategy.getAbsoluteX())) {
            logger.error(" absoluteX \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" absoluteX \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getAbsoluteY())) {
            waterMarkStrategy.setAbsoluteY("0");
        }
        if (!StringUtil.isPositiveNumeric((String)waterMarkStrategy.getAbsoluteY())) {
            logger.error(" absoluteX \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" absoluteX \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getApartX())) {
            waterMarkStrategy.setApartX("-1");
        }
        if (!StringUtil.isNumeric((String)waterMarkStrategy.getApartX())) {
            logger.error(" apartX \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" apartX \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getApartY())) {
            waterMarkStrategy.setApartY("-1");
        }
        if (!StringUtil.isNumeric((String)waterMarkStrategy.getApartY())) {
            logger.error(" apartY \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" apartY \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isNotEmpty((String)waterMarkStrategy.getColor()) && !StringUtil.isColorNumber((String)waterMarkStrategy.getColor())) {
            logger.error(" color \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" color \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getFontSize())) {
            waterMarkStrategy.setFontSize("12");
        }
        if (!StringUtil.isPositiveNumber((String)waterMarkStrategy.getFontSize(), (int)6)) {
            logger.error(" fontSize \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fontSize \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getRotationDegree())) {
            waterMarkStrategy.setRotationDegree("0");
        }
        if (!StringUtil.isPositiveNumeric((String)waterMarkStrategy.getRotationDegree())) {
            logger.error(" rotationDegree \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" rotationDegree \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getIsAboveText())) {
            waterMarkStrategy.setIsAboveText("0");
        }
        if (CommonUtil.isEmpty(waterMarkStrategy.getWaterMarkImage()) && CommonUtil.isEmpty(waterMarkStrategy.getWaterMarkText())) {
            logger.error("waterMarkImage and waterMarkText both null");
            throw new Exception(" waterMarkImage and waterMarkText both null ");
        }
    }

    public static void doCheckTx1007(AddCrossToPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        int toPage;
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        CrossStrategy crossStrategy = requestBody.getCrossStrategy();
        if (crossStrategy == null) {
            logger.error("crossSealStrategy  is null");
            throw new Exception("crossSealStrategy is null");
        }
        if (StringUtil.isEmpty((String)crossStrategy.getImage())) {
            logger.error("image  is null");
            throw new Exception(" image   is null");
        }
        if (!("5".equals(crossStrategy.getCrossStyle()) || "6".equals(crossStrategy.getCrossStyle()) || "7".equals(crossStrategy.getCrossStyle()))) {
            logger.error("crossStyle \u53d6\u503c\u9519\u8bef");
            throw new Exception("crossStyle \u53d6\u503c\u9519\u8bef");
        }
        if (!StringUtil.isNaturalNumber((String)crossStrategy.getFromPage(), (int)6)) {
            logger.error("fromPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" fromPage \u53d6\u503c\u9519\u8bef ");
        }
        if ("0".equals(crossStrategy.getFromPage())) {
            crossStrategy.setToPage("0");
        }
        if (!StringUtil.isNaturalNumber((String)crossStrategy.getToPage(), (int)6)) {
            logger.error("toPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" toPage \u53d6\u503c\u9519\u8bef ");
        }
        int fromPage = Integer.parseInt(crossStrategy.getFromPage());
        if (fromPage > (toPage = Integer.parseInt(crossStrategy.getToPage()))) {
            logger.error("frompage \u53d6\u503c \u5927\u4e8e toPage ");
            throw new Exception(" frompage \u53d6\u503c \u5927\u4e8e toPage ");
        }
        if ("5".equals(crossStrategy.getCrossStyle()) || "6".equals(crossStrategy.getCrossStyle())) {
            crossStrategy.setAbsoluteX("0");
        }
        if ("7".equals(crossStrategy.getCrossStyle())) {
            crossStrategy.setAbsoluteY("0");
        }
        if (StringUtil.isEmpty((String)crossStrategy.getAbsoluteX())) {
            crossStrategy.setAbsoluteX("0");
        }
        if (!StringUtil.isPositiveNumeric((String)crossStrategy.getAbsoluteX())) {
            logger.error("absoluteX\u53d6\u503c\u9519\u8bef");
            throw new Exception("absoluteX\u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)crossStrategy.getAbsoluteY())) {
            crossStrategy.setAbsoluteY("0");
        }
        if (!StringUtil.isPositiveNumeric((String)crossStrategy.getAbsoluteY())) {
            logger.error("absoluteY\u53d6\u503c\u9519\u8bef");
            throw new Exception("absoluteY\u53d6\u503c\u9519\u8bef");
        }
    }

    public static void doCheckTx1008(AddOrganizationRequestBody requestBody) throws Exception {
        List orgList = requestBody.getOrganizationList();
        if (orgList == null || orgList.size() == 0) {
            logger.error("organizationList is null");
            throw new Exception("organizationList is null");
        }
        int n = orgList.size();
        if (n > 100) {
            logger.error("\u8bf7\u4e00\u6b21\u6dfb\u52a0\u673a\u6784\u6570\u91cf\u4e0d\u8981\u8d85\u8fc7100\u4e2a");
            throw new Exception("\u8bf7\u4e00\u6b21\u6dfb\u52a0\u673a\u6784\u6570\u91cf\u4e0d\u8981\u8d85\u8fc7100\u4e2a");
        }
        for (Organization org : orgList) {
            String code = org.getCode();
            if (!StringUtil.isNotEmptyAndNull((String)code)) {
                logger.error("code \u4e3a\u7a7a ");
                throw new Exception("code \u4e3a\u7a7a ");
            }
            if (!StringUtil.validateStrMaxLength((String)code, (int)32)) {
                logger.error("code \u957f\u5ea6\u8d85\u8fc732");
                throw new Exception("code \u957f\u5ea6\u8d85\u8fc732");
            }
            String name = org.getName();
            if (!StringUtil.isNotEmptyAndNull((String)name)) {
                logger.error("name is null ");
                throw new Exception("name is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)name, (int)128)) {
                logger.error("name \u957f\u5ea6\u8d85\u8fc7128");
                throw new Exception("name \u957f\u5ea6\u8d85\u8fc7128");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getIdentificationType())) {
                logger.error("identificationType is null");
                throw new Exception("identificationType is null");
            }
            if (!StringUtil.isNotEmptyAndNull((String)IdType.getNameByCode((String)org.getIdentificationType()))) {
                throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getIdentificationNo())) {
                logger.error("identificationNo is null");
                throw new Exception("identificationNo is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)org.getIdentificationNo(), (int)80)) {
                logger.error("identificationNo \u957f\u5ea6\u8d85\u8fc780");
                throw new Exception("identificationNo \u957f\u5ea6\u8d85\u8fc780");
            }
            if (StringUtil.isNotEmpty((String)org.getPhoneNo()) && !StringUtil.validateStrMaxLength((String)org.getPhoneNo(), (int)20)) {
                logger.error("phoneNo \u957f\u5ea6\u8d85\u8fc720");
                throw new Exception("phoneNo \u957f\u5ea6\u8d85\u8fc720");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getCertPeriod())) {
                org.setCertPeriod("0");
            }
            if (!StringUtil.isNaturalNumber((String)org.getCertPeriod(), (int)5)) {
                logger.error("certPeriod \u53d6\u503c\u9519\u8bef");
                throw new Exception(" certPeriod \u53d6\u503c\u9519\u8bef ");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getSceneCertPeriod())) {
                org.setSceneCertPeriod("0");
            }
            if (!StringUtil.isNaturalNumber((String)org.getSceneCertPeriod(), (int)5)) {
                logger.error("sceneCertPeriod \u53d6\u503c\u9519\u8bef");
                throw new Exception(" sceneCertPeriod \u53d6\u503c\u9519\u8bef ");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getHostWhiteList()) && !StringUtil.validateStrMaxLength((String)org.getHostWhiteList(), (int)512)) {
                logger.error("hostWhiteList \u957f\u5ea6\u8d85\u8fc7 512");
                throw new Exception("hostWhiteList \u957f\u5ea6\u8d85\u8fc7 512");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getParentId())) {
                logger.error("parentId \u4e3a\u7a7a ");
                throw new Exception("parentId \u4e3a\u7a7a ");
            }
            if (!StringUtil.validateStrMaxLength((String)org.getParentId(), (int)32)) {
                logger.error("parentId \u957f\u5ea6\u8d85\u8fc7 32");
                throw new Exception("parentId \u957f\u5ea6\u8d85\u8fc7 32");
            }
            if (!StringUtil.isNotEmptyAndNull((String)org.getTimeStampSupported())) {
                org.setTimeStampSupported("1");
            }
            if (!"0".equals(org.getTimeStampSupported()) && !"1".equals(org.getTimeStampSupported())) {
                logger.error("timeStampSupported \u6b63\u786e\u53d6\u503c\u4e3a\u63010 \u6216\u8005 1");
                throw new Exception("timeStampSupported \u6b63\u786e\u53d6\u503c\u4e3a\u63010 \u6216\u8005 1");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getAddress()) && !StringUtil.validateStrMaxLength((String)org.getAddress(), (int)64)) {
                logger.error("address \u957f\u5ea6\u8d85\u8fc7 64");
                throw new Exception("address \u957f\u5ea6\u8d85\u8fc7 64");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getProvince()) && !StringUtil.validateStrMaxLength((String)org.getProvince(), (int)32)) {
                logger.error("province \u957f\u5ea6\u8d85\u8fc7 32");
                throw new Exception("province \u957f\u5ea6\u8d85\u8fc7 32");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getCity()) && !StringUtil.validateStrMaxLength((String)org.getCity(), (int)32)) {
                logger.error("city \u957f\u5ea6\u8d85\u8fc7 32");
                throw new Exception("city \u957f\u5ea6\u8d85\u8fc7 32");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getEmail()) && !StringUtil.validateStrMaxLength((String)org.getEmail(), (int)80)) {
                logger.error("email \u957f\u5ea6\u8d85\u8fc7 80");
                throw new Exception("email \u957f\u5ea6\u8d85\u8fc7 80");
            }
            if (StringUtil.isNotEmptyAndNull((String)org.getRemark1()) && !StringUtil.validateStrMaxLength((String)org.getRemark1(), (int)100)) {
                logger.error("remark \u957f\u5ea6\u8d85\u8fc7 100");
                throw new Exception("remark \u957f\u5ea6\u8d85\u8fc7 100");
            }
            if (StringUtil.isNotEmpty((String)org.getNotBefore())) {
                try {
                    TimeUtil.getDateInFormat((String)org.getNotBefore(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    logger.error("notBefore \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                    throw new Exception("notBefore \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                }
            }
            if (!StringUtil.isNotEmpty((String)org.getNotAfter())) continue;
            try {
                TimeUtil.getDateInFormat((String)org.getNotAfter(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                logger.error("notAfter \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                throw new Exception("notAfter \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
            }
        }
    }

    public static void doCheckTx1009(Organization org) throws Exception {
        if (org == null) {
            logger.error("organization  is null");
            throw new Exception("organization  is null");
        }
        String code = org.getCode();
        if (!StringUtil.isNotEmptyAndNull((String)code)) {
            logger.error("code \u4e3a\u7a7a ");
            throw new Exception("code \u4e3a\u7a7a ");
        }
        if (!StringUtil.validateStrMaxLength((String)code, (int)32)) {
            logger.error("code \u957f\u5ea6\u8d85\u8fc732");
            throw new Exception("code \u957f\u5ea6\u8d85\u8fc732");
        }
        String name = org.getName();
        if (StringUtil.isNotEmpty((String)name) && !StringUtil.validateStrMaxLength((String)name, (int)128)) {
            logger.error("name \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("name \u957f\u5ea6\u8d85\u8fc7128");
        }
        if (StringUtil.isNotEmpty((String)org.getIdentificationType()) && !StringUtil.isNotEmptyAndNull((String)IdType.getNameByCode((String)org.getIdentificationType()))) {
            throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isNotEmpty((String)org.getIdentificationNo()) && !StringUtil.validateStrMaxLength((String)org.getIdentificationNo(), (int)80)) {
            logger.error("identificationNo \u957f\u5ea6\u8d85\u8fc780");
            throw new Exception("identificationNo \u957f\u5ea6\u8d85\u8fc780");
        }
        if (StringUtil.isNotEmpty((String)org.getPhoneNo()) && !StringUtil.validateStrMaxLength((String)org.getPhoneNo(), (int)20)) {
            logger.error("phoneNo \u957f\u5ea6\u8d85\u8fc720");
            throw new Exception("phoneNo \u957f\u5ea6\u8d85\u8fc720");
        }
        if (StringUtil.isNotEmpty((String)org.getCertPeriod()) && !StringUtil.isNaturalNumber((String)org.getCertPeriod(), (int)5)) {
            logger.error("certPeriod \u53d6\u503c\u9519\u8bef");
            throw new Exception(" certPeriod \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)org.getCertPeriod())) {
            org.setCertPeriod("-1");
        }
        if (StringUtil.isNotEmpty((String)org.getSceneCertPeriod()) && !StringUtil.isNaturalNumber((String)org.getSceneCertPeriod(), (int)5)) {
            logger.error("sceneCertPeriod \u53d6\u503c\u9519\u8bef");
            throw new Exception(" sceneCertPeriod \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)org.getSceneCertPeriod())) {
            org.setSceneCertPeriod("-1");
        }
        if (StringUtil.isNotEmpty((String)org.getHostWhiteList()) && !StringUtil.validateStrMaxLength((String)org.getHostWhiteList(), (int)512)) {
            logger.error("hostWhiteList \u957f\u5ea6\u8d85\u8fc7 512");
            throw new Exception("hostWhiteList \u957f\u5ea6\u8d85\u8fc7 512");
        }
        if (StringUtil.isNotEmptyAndNull((String)org.getParentId()) && !StringUtil.validateStrMaxLength((String)org.getParentId(), (int)32)) {
            logger.error("parentId \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("parentId \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isNotEmpty((String)org.getTimeStampSupported()) && !"0".equals(org.getTimeStampSupported()) && !"1".equals(org.getTimeStampSupported())) {
            logger.error("timeStampSupported \u6b63\u786e\u53d6\u503c\u4e3a\u63010 \u6216\u8005 1");
            throw new Exception("timeStampSupported \u6b63\u786e\u53d6\u503c\u4e3a\u63010 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)org.getTimeStampSupported())) {
            org.setTimeStampSupported("-1");
        }
        if (StringUtil.isNotEmpty((String)org.getAddress()) && !StringUtil.validateStrMaxLength((String)org.getAddress(), (int)64)) {
            logger.error("address \u957f\u5ea6\u8d85\u8fc7 64");
            throw new Exception("address \u957f\u5ea6\u8d85\u8fc7 64");
        }
        if (StringUtil.isNotEmpty((String)org.getProvince()) && !StringUtil.validateStrMaxLength((String)org.getProvince(), (int)32)) {
            logger.error("province \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("province \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isNotEmpty((String)org.getCity()) && !StringUtil.validateStrMaxLength((String)org.getCity(), (int)32)) {
            logger.error("city \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("city \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isNotEmpty((String)org.getEmail()) && !StringUtil.validateStrMaxLength((String)org.getEmail(), (int)80)) {
            logger.error("email \u957f\u5ea6\u8d85\u8fc7 80");
            throw new Exception("email \u957f\u5ea6\u8d85\u8fc7 80");
        }
        if (StringUtil.isNotEmpty((String)org.getRemark1()) && !StringUtil.validateStrMaxLength((String)org.getRemark1(), (int)100)) {
            logger.error("remark \u957f\u5ea6\u8d85\u8fc7 100");
            throw new Exception("remark \u957f\u5ea6\u8d85\u8fc7 100");
        }
        if (StringUtil.isNotEmpty((String)org.getNotBefore())) {
            try {
                TimeUtil.getDateInFormat((String)org.getNotBefore(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                logger.error("notBefore \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                throw new Exception("notBefore \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
            }
        }
        if (StringUtil.isNotEmpty((String)org.getNotAfter())) {
            try {
                TimeUtil.getDateInFormat((String)org.getNotAfter(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                logger.error("notAfter \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
                throw new Exception("notAfter \u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss");
            }
        }
    }

    public static void doCheckTx1010(Organization org) throws Exception {
        String code = org.getCode();
        if (!StringUtil.isNotEmptyAndNull((String)code)) {
            logger.error("code \u4e3a\u7a7a ");
            throw new Exception("code \u4e3a\u7a7a ");
        }
        if (!StringUtil.validateStrMaxLength((String)code, (int)32)) {
            logger.error("code \u957f\u5ea6\u8d85\u8fc732");
            throw new Exception("code \u957f\u5ea6\u8d85\u8fc732");
        }
        if (!StringUtil.isNotEmptyAndNull((String)org.getIdentificationType())) {
            logger.error("identificationType is null");
            throw new Exception("identificationType is null");
        }
        if (!StringUtil.isNotEmptyAndNull((String)IdType.getNameByCode((String)org.getIdentificationType()))) {
            throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
        }
        if (!StringUtil.isNotEmptyAndNull((String)org.getIdentificationNo())) {
            logger.error("identificationNo is null");
            throw new Exception("identificationNo is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)org.getIdentificationNo(), (int)80)) {
            logger.error("identificationNo \u957f\u5ea6\u8d85\u8fc780");
            throw new Exception("identificationNo \u957f\u5ea6\u8d85\u8fc780");
        }
    }

    public static void doCheckTx2001(MakeSquareSealImageRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        SquareImageStrategy squareImageStrategy = requestBody.getImageStrategy();
        if (squareImageStrategy == null) {
            logger.error("imageStrategy is null");
            throw new Exception("imageStrategy is null");
        }
        if (StringUtil.isEmpty((String)squareImageStrategy.getImageName())) {
            logger.error("imageName is null");
            throw new Exception("imageName is null");
        }
        if (!StringUtil.validateStrMaxLength((String)squareImageStrategy.getImageName(), (int)128)) {
            logger.error("imageName \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("imageName \u957f\u5ea6\u8d85\u8fc7128");
        }
        if (!"1".equals(squareImageStrategy.getImageShape()) && !"11".equals(squareImageStrategy.getImageShape())) {
            logger.error("imageShape \u53d6\u503c\u9519\u8bef");
            throw new Exception("imageShape \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)squareImageStrategy.getImageHeight())) {
            squareImageStrategy.setImageHeight("100");
        }
        if (!StringUtil.isPositiveNumeric((String)squareImageStrategy.getImageHeight())) {
            logger.error(" imageHeight \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageHeight \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)squareImageStrategy.getImageWidth())) {
            squareImageStrategy.setImageWidth("100");
        }
        if (!StringUtil.isPositiveNumeric((String)squareImageStrategy.getImageWidth())) {
            logger.error(" imageWidth \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageWidth \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)squareImageStrategy.getColor())) {
            squareImageStrategy.setColor("000000");
        }
        if (!StringUtil.isColorNumber((String)squareImageStrategy.getColor())) {
            logger.error(" color \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" color \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)squareImageStrategy.getFontSize())) {
            squareImageStrategy.setFontSize("12");
        }
        if (!StringUtil.isPositiveNumber((String)squareImageStrategy.getFontSize(), (int)6)) {
            logger.error(" fontSize \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fontSize \u53d6\u503c \u9519\u8bef ");
        }
    }

    public static void doCheckTx2002(MakeRectangleSealImageRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        RectangleImageStrategy rectangleImageStrategy = requestBody.getImageStrategy();
        if (rectangleImageStrategy == null) {
            logger.error("imageStrategy is null");
            throw new Exception("imageStrategy is null");
        }
        if (StringUtil.isEmpty((String)rectangleImageStrategy.getImageName())) {
            logger.error("imageName is null");
            throw new Exception("imageName is null");
        }
        if (!StringUtil.validateStrMaxLength((String)rectangleImageStrategy.getImageName(), (int)128)) {
            logger.error("imageName \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("imageName \u957f\u5ea6\u8d85\u8fc7128");
        }
        if (!"2".equals(rectangleImageStrategy.getImageShape()) && !"21".equals(rectangleImageStrategy.getImageShape())) {
            logger.error("imageShape \u53d6\u503c\u9519\u8bef");
            throw new Exception("imageShape \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)rectangleImageStrategy.getImageHeight())) {
            rectangleImageStrategy.setImageHeight("100");
        }
        if (!StringUtil.isPositiveNumeric((String)rectangleImageStrategy.getImageHeight())) {
            logger.error(" imageHeight \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageHeight \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)rectangleImageStrategy.getImageWidth())) {
            rectangleImageStrategy.setImageWidth("100");
        }
        if (!StringUtil.isPositiveNumeric((String)rectangleImageStrategy.getImageWidth())) {
            logger.error(" imageWidth \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageWidth \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)rectangleImageStrategy.getColor())) {
            rectangleImageStrategy.setColor("000000");
        }
        if (!StringUtil.isColorNumber((String)rectangleImageStrategy.getColor())) {
            logger.error(" color \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" color \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)rectangleImageStrategy.getFontSize())) {
            rectangleImageStrategy.setFontSize("12");
        }
        if (!StringUtil.isPositiveNumber((String)rectangleImageStrategy.getFontSize(), (int)6)) {
            logger.error(" fontSize \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fontSize \u53d6\u503c \u9519\u8bef ");
        }
    }

    public static void doCheckTx2003(MakeCircleSealImageRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        float ry;
        float rx;
        CircleImageStrategy circleImageStrategy = requestBody.getImageStrategy();
        if (circleImageStrategy == null) {
            logger.error("imageStrategy is null");
            throw new Exception("imageStrategy is null");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getImageName())) {
            logger.error("imageName is null");
            throw new Exception("imageName is null");
        }
        if (!StringUtil.validateStrMaxLength((String)circleImageStrategy.getImageName(), (int)128)) {
            logger.error("imageName \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("imageName \u957f\u5ea6\u8d85\u8fc7128");
        }
        if (!"3".equals(circleImageStrategy.getImageShape()) && !"4".equals(circleImageStrategy.getImageShape())) {
            logger.error("imageShape \u53d6\u503c\u9519\u8bef");
            throw new Exception("imageShape \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getUnit())) {
            circleImageStrategy.setUnit("0");
        }
        if (!"0".equals(circleImageStrategy.getUnit()) && !"1".equals(circleImageStrategy.getUnit())) {
            logger.error("unit \u53d6\u503c\u9519\u8bef");
            throw new Exception("unit \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f0\u6216\u80051");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getDpi()) || "0".equals(circleImageStrategy.getDpi())) {
            circleImageStrategy.setDpi("288");
        }
        if (!StringUtil.isNaturalNumber((String)circleImageStrategy.getDpi())) {
            logger.error(" dpi \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" dpi \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getImageHeight())) {
            circleImageStrategy.setImageHeight("100");
        }
        if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getImageHeight())) {
            logger.error(" imageHeight \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageHeight \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getImageWidth())) {
            circleImageStrategy.setImageWidth("100");
        }
        if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getImageWidth())) {
            logger.error(" imageWidth \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" imageWidth \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)circleImageStrategy.getFontSize())) {
            circleImageStrategy.setFontSize("12");
        }
        if (!StringUtil.isPositiveNumber((String)circleImageStrategy.getFontSize(), (int)6)) {
            logger.error(" fontSize \u53d6\u503c \u9519\u8bef ");
            throw new Exception(" fontSize \u53d6\u503c \u9519\u8bef ");
        }
        if (StringUtil.isNotEmpty((String)circleImageStrategy.getImageName2())) {
            if (!StringUtil.validateStrMaxLength((String)circleImageStrategy.getImageName2(), (int)128)) {
                logger.error("imageName2 \u957f\u5ea6\u8d85\u8fc7128");
                throw new Exception("imageName2 \u957f\u5ea6\u8d85\u8fc7128");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getImageName2FontSize())) {
                circleImageStrategy.setImageName2FontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)circleImageStrategy.getImageName2FontSize(), (int)6)) {
                logger.error(" imageName2FontSize \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" imageName2FontSize \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getImageName2RatioX())) {
                circleImageStrategy.setImageName2RatioX("0");
            }
            if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getImageName2RatioX())) {
                logger.error(" imageName2RatioX \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" imageName2RatioX \u53d6\u503c \u9519\u8bef ");
            }
            rx = Float.parseFloat(circleImageStrategy.getImageName2RatioX());
            if (rx < 0.0f || rx > 1.0f) {
                logger.error(" imageName2RatioX \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" imageName2RatioX \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getImageName2RatioY())) {
                circleImageStrategy.setImageName2RatioY("0");
            }
            if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getImageName2RatioY())) {
                logger.error(" imageName2RatioY \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" imageName2RatioY \u53d6\u503c \u9519\u8bef ");
            }
            ry = Float.parseFloat(circleImageStrategy.getImageName2RatioY());
            if (ry < 0.0f || ry > 1.0f) {
                logger.error(" imageName2RatioY \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" imageName2RatioY \u53d6\u503c \u9519\u8bef ");
            }
        }
        if (StringUtil.isNotEmpty((String)circleImageStrategy.getBusinessCode())) {
            if (!StringUtil.validateStrMaxLength((String)circleImageStrategy.getBusinessCode(), (int)32)) {
                logger.error("businessCode \u957f\u5ea6\u8d85\u8fc732");
                throw new Exception("businessCode \u957f\u5ea6\u8d85\u8fc732");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getBusinessFontSize())) {
                circleImageStrategy.setBusinessFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)circleImageStrategy.getBusinessFontSize(), (int)6)) {
                logger.error(" businessFontSize \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessFontSize \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getBusinessRatioX())) {
                circleImageStrategy.setBusinessRatioX("0");
            }
            if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getBusinessRatioX())) {
                logger.error(" businessRatioX \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessRatioX \u53d6\u503c \u9519\u8bef ");
            }
            rx = Float.parseFloat(circleImageStrategy.getBusinessRatioX());
            if (rx < 0.0f || rx > 1.0f) {
                logger.error(" businessRatioX \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessRatioX \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)circleImageStrategy.getBusinessRatioY())) {
                circleImageStrategy.setBusinessRatioY("0");
            }
            if (!StringUtil.isPositiveNumeric((String)circleImageStrategy.getBusinessRatioY())) {
                logger.error(" businessRatioY \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessRatioY \u53d6\u503c \u9519\u8bef ");
            }
            ry = Float.parseFloat(circleImageStrategy.getBusinessRatioY());
            if (ry < 0.0f || ry > 1.0f) {
                logger.error(" businessRatioY \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessRatioY \u53d6\u503c \u9519\u8bef ");
            }
        }
    }

    public static void doCheckTx2004(MakeSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        SealInfoBean sealInfoBean;
        String sealImageStr = requestBody.getSealImage();
        if (StringUtil.isEmpty((String)sealImageStr)) {
            logger.error("sealImage is null");
            throw new Exception(" sealImage is null ");
        }
        if (requestBody.getSealImageData() == null) {
            logger.error("sealImageData is null");
            throw new Exception(" sealImageData is null ");
        }
        if (!ValidityUtil.checkIsImage((byte[])requestBody.getSealImageData())) {
            logger.error("\u56fe\u7247\u6570\u636e\u5f02\u5e38");
            throw new Exception(" \u56fe\u7247\u6570\u636e\u5f02\u5e38 ");
        }
        requestBody.setSealImageData(null);
        if (StringUtil.isEmpty((String)requestBody.getSealType())) {
            requestBody.setSealType("1");
        }
        if (!"1".equals(requestBody.getSealType()) && !"2".equals(requestBody.getSealType())) {
            logger.error("sealType \u53d6\u503c\u9519\u8bef");
            throw new Exception(" sealType \u53d6\u503c\u9519\u8bef");
        }
        SealCertBean sealCertBean = requestBody.getSealCert();
        if (sealCertBean == null) {
            logger.error("sealCert is null");
            throw new Exception(" sealCert is null");
        }
        if (!"1".equals(sealCertBean.getCustomerType()) && !"2".equals(sealCertBean.getCustomerType())) {
            logger.error("customerType \u53d6\u503c\u9519\u8bef");
            throw new Exception(" customerType \u53d6\u503c\u9519\u8bef");
        }
        if (!"1".equals(sealCertBean.getType()) && !"2".equals(sealCertBean.getType())) {
            logger.error("type \u53d6\u503c\u9519\u8bef");
            throw new Exception(" type \u53d6\u503c\u9519\u8bef");
        }
        if (!"RSA".equals(sealCertBean.getKeyAlg()) && !"SM2".equals(sealCertBean.getKeyAlg())) {
            logger.error("keyAlg \u53d6\u503c\u9519\u8bef");
            throw new Exception(" keyAlg \u53d6\u503c\u9519\u8bef ");
        }
        if ("RSA".equals(sealCertBean.getKeyAlg())) {
            if (!"2048".equals(sealCertBean.getKeyLength())) {
                logger.error("keyLength \u53d6\u503c\u9519\u8bef");
                throw new Exception(" keyLength \u53d6\u503c\u9519\u8bef\uff0ckeyLength\u4ec5\u652f\u63012048");
            }
        } else if ("SM2".equals(sealCertBean.getKeyAlg()) && !"256".equals(sealCertBean.getKeyLength())) {
            logger.error("keyLength \u53d6\u503c\u9519\u8bef");
            throw new Exception(" keyLength \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)sealCertBean.getPkcs12Password())) {
            logger.error("pkcsPassword is null");
            throw new Exception(" pkcsPassword is null");
        }
        if ("1".equals(sealCertBean.getType())) {
            if (StringUtil.isEmpty((String)sealCertBean.getPkcs12())) {
                logger.error("pkcs12 is null");
                throw new Exception(" pkcs12 is null");
            }
        } else if ("2".equals(sealCertBean.getType())) {
            if (StringUtil.isEmpty((String)sealCertBean.getUserName())) {
                logger.error("userName is null");
                throw new Exception(" userName is null");
            }
            if (!StringUtil.validateStrMaxLength((String)sealCertBean.getUserName(), (int)128)) {
                logger.error("userName \u957f\u5ea6\u8d85\u8fc7 128");
                throw new Exception("userName \u957f\u5ea6\u8d85\u8fc7 128");
            }
            if (StringUtil.isEmpty((String)sealCertBean.getIdentificationType())) {
                logger.error("identificationType is null");
                throw new Exception("identificationType is null");
            }
            if (StringUtil.isEmpty((String)IdType.getNameByCode((String)sealCertBean.getIdentificationType()))) {
                throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealCertBean.getIdentificationNo())) {
                logger.error("identificationNo is null");
                throw new Exception("identificationNo is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)sealCertBean.getIdentificationNo(), (int)80)) {
                logger.error("identificationNo \u957f\u5ea6\u8d85\u8fc780");
                throw new Exception("identificationNo \u957f\u5ea6\u8d85\u8fc780");
            }
            if (StringUtil.isNotEmpty((String)sealCertBean.getPhoneNo()) && !StringUtil.validateStrMaxLength((String)sealCertBean.getPhoneNo(), (int)20)) {
                logger.error("phoneNo \u957f\u5ea6\u8d85\u8fc720");
                throw new Exception("phoneNo \u957f\u5ea6\u8d85\u8fc720");
            }
        }
        if ((sealInfoBean = requestBody.getSealInfo()) == null) {
            logger.error("sealInfo is null");
            throw new Exception(" sealInfo is null");
        }
        if (StringUtil.isEmpty((String)sealInfoBean.getSealCode())) {
            logger.error("sealCode is null");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfoBean.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isEmpty((String)sealInfoBean.getSealPassword())) {
            logger.error("sealPassword is null");
            throw new Exception("sealPassword is null");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfoBean.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
        if (StringUtil.isEmpty((String)sealInfoBean.getSealName())) {
            logger.error("sealName is null");
            throw new Exception("sealName  is null");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfoBean.getSealName(), (int)128)) {
            logger.error("sealName \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("sealName \u957f\u5ea6\u8d85\u8fc7128");
        }
    }

    public static void doCheckTx2005(UpdateSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"0".equals(requestBody.getSealCertUpdateFlag()) && !"1".equals(requestBody.getSealCertUpdateFlag())) {
            logger.error(" sealCertUpdateFlag \u53d6\u503c\u9519\u8bef");
            throw new Exception(" sealCertUpdateFlag \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealCode())) {
            logger.error(" sealCode is null");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealCode(), (int)32)) {
            logger.error(" sealCode \u957f\u5ea6\u8d85\u8fc732");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc732");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealPassword())) {
            logger.error(" sealPassword is null");
            throw new Exception("sealPassword is null");
        }
        if (StringUtil.isNotEmpty((String)requestBody.getNewSealPassword()) && !StringUtil.validateStrMaxLength((String)requestBody.getNewSealPassword(), (int)64)) {
            logger.error(" newSealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("newSealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
        if (StringUtil.isNotEmpty((String)requestBody.getSealName()) && !StringUtil.validateStrMaxLength((String)requestBody.getSealName(), (int)128)) {
            logger.error(" sealName \u957f\u5ea6\u8d85\u8fc7128");
            throw new Exception("sealName \u957f\u5ea6\u8d85\u8fc7128");
        }
    }

    public static void doCheckTx2006(DeleteSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getSealCode())) {
            logger.error(" sealCode is null");
            throw new Exception("sealCode is null");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealCode(), (int)32)) {
            logger.error(" sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealPassword())) {
            logger.error(" sealPassword is null");
            throw new Exception("sealPassword is null");
        }
        if (!("0".equals(requestBody.getRevokeFlag()) || "1".equals(requestBody.getRevokeFlag()) || "2".equals(requestBody.getRevokeFlag()))) {
            logger.error(" revokeFlag \u53d6\u503c\u9519\u8bef");
            throw new Exception(" revokeFlag \u53d6\u503c\u9519\u8bef");
        }
    }

    public static void doCheckTx3001(TransformHtmlToPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
            logger.error(" inputSource is null");
            throw new Exception(" inputSource is null");
        }
        try {
            PaperSize.valueOf(PaperSize.class, (String)requestBody.getSize());
        }
        catch (Exception e) {
            logger.error(" size \u53d6\u503c\u9519\u8bef");
            throw new Exception(" size \u53d6\u503c\u9519\u8bef ");
        }
        if (!"0".equals(requestBody.getLandscape()) && !"1".equals(requestBody.getLandscape())) {
            logger.error(" landscape \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f0\u6216\u80051");
            throw new Exception("landscape \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f0\u6216\u80051");
        }
    }

    public static void doCheckTx3002(TransformWordToPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
            logger.error(" inputSource is null");
            throw new Exception(" inputSource is null");
        }
    }

    public static void doCheckTx3003(TransformImageToPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List imageBeans = requestBody.getImages();
        if (imageBeans == null || imageBeans.size() == 0) {
            logger.error(" images is null");
            throw new Exception(" images is null");
        }
        int i = 1;
        for (ImageBean imageBean : imageBeans) {
            if (imageBean == null) {
                logger.error("\u7b2c" + i + "\u5f20\u56fe\u7247\u6570\u636e\u5f02\u5e38");
                throw new Exception("\u7b2c" + i + "\u5f20\u56fe\u7247\u6570\u636e\u5f02\u5e38");
            }
            if (!ValidityUtil.checkIsImage((byte[])imageBean.getImageData())) {
                logger.error("\u7b2c" + i + "\u5f20\u56fe\u7247\u6570\u636e\u5f02\u5e38");
                throw new Exception("\u7b2c" + i + "\u5f20\u56fe\u7247\u6570\u636e\u5f02\u5e38");
            }
            imageBean.setImageData(null);
            ++i;
        }
    }

    public static void doCheckTx3004(TransformPdfToImageRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource()});
        if (!StringUtil.isNaturalNumber((String)requestBody.getPageNo(), (int)6)) {
            logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
        }
    }

    public static void doCheckTx4001(SealPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        SealStrategy sealStrategy = requestBody.getSealStrategy();
        if (sealStrategy == null) {
            logger.error(" sealStrategy is null");
            throw new Exception(" sealStrategy is null");
        }
        ValidateUtil.checkSealStrategy(sealStrategy);
    }

    public static void doCheckTx4002(CompoundSealPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List proofSealStrategies;
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSceneCertChannel())) {
            requestBody.setSceneCertChannel("0");
        }
        if (!"0".equals(requestBody.getSceneCertChannel()) && !"1".equals(requestBody.getSceneCertChannel())) {
            logger.error(" sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception("sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        boolean flag = false;
        List sealStrategies = requestBody.getSealStrategies();
        if (sealStrategies != null && sealStrategies.size() > 0) {
            flag = true;
            for (SealStrategy sealStrategy : sealStrategies) {
                if (StringUtil.isEmpty((String)sealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                ValidateUtil.checkSealStrategy(sealStrategy);
            }
        }
        if ((proofSealStrategies = requestBody.getProofSealStrategies()) != null && proofSealStrategies.size() > 0) {
            flag = true;
            List multiDataBeans = requestBody.getMultiDatas();
            if (multiDataBeans == null || multiDataBeans.size() == 0) {
                logger.error(" \u8bc1\u636e\u7b7e\u7ae0\u65f6\uff0cmultiDataBeans \u4e0d\u80fd\u4e3a\u7a7a");
                throw new Exception("\u8bc1\u636e\u7b7e\u7ae0\u65f6\uff0cmultiDataBeans \u4e0d\u80fd\u4e3a\u7a7a ");
            }
            for (MultiDataBean multiDataBean : multiDataBeans) {
                if (StringUtil.isEmpty((String)multiDataBean.getFileName())) {
                    logger.error(" fileName is null");
                    throw new Exception("fileName is null ");
                }
                if (!StringUtil.validateStrMaxLength((String)multiDataBean.getFileName(), (int)128)) {
                    logger.error(" fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                    throw new Exception("fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                }
                if (StringUtil.isEmpty((String)multiDataBean.getFileDataHash())) {
                    logger.error("fileDataHash is null");
                    throw new Exception("fileDataHash is null");
                }
                if (!StringUtil.isEmpty((String)multiDataBean.getType())) continue;
                multiDataBean.setType("0");
            }
            for (ProofSealStrategy proofSealStrategy : proofSealStrategies) {
                if (StringUtil.isEmpty((String)proofSealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)proofSealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                ValidateUtil.checkProofSealStrategy(proofSealStrategy);
            }
        }
        if (!flag) {
            logger.error(" sealStrategies and proofSealStrategies both null");
            throw new Exception(" sealStrategies and proofSealStrategies both null");
        }
    }

    public static void doCheckTx4003(CompoundSealPdfListRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List proofSealStrategies;
        List pdfBeans = requestBody.getPdfBeans();
        int inputType1 = 0;
        int inputType2 = 0;
        for (int i = 0; i < pdfBeans.size(); ++i) {
            PdfBean pdfBean = (PdfBean)pdfBeans.get(i);
            if (!"1".equals(pdfBean.getInputType()) && !"2".equals(pdfBean.getInputType())) {
                logger.error("inputType \u53d6\u503c\u9519\u8bef\uff0cinputType \u53d6\u503c\u53ea\u80fd\u662f1 \u6216\u8005 2 ");
                throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0cinputType \u53d6\u503c\u53ea\u80fd\u662f1 \u6216\u8005 2 ");
            }
            if ("1".equals(pdfBean.getInputType())) {
                ++inputType1;
                if (StringUtil.isEmpty((String)pdfBean.getInputSource())) {
                    logger.error("inputSource is null");
                    throw new Exception("inputSource is null");
                }
                String pdfSuffix = IoUtil.getFileNameSuffix((String)pdfBean.getInputSource());
                if (!"pdf".equals(pdfSuffix)) {
                    logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                    throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                }
            } else if ("2".equals(pdfBean.getInputType())) {
                ++inputType2;
                if (pdfBean.getPdfData() == null) {
                    logger.error("\u7b2c" + (i + 1) + " \u4e2a pdfData is null ");
                    throw new Exception("\u7b2c" + (i + 1) + " \u4e2a pdfData is null ");
                }
                fileDataList.add(pdfBean.getPdfData());
                pdfBean.setPdfData(null);
            }
            if (StringUtil.isEmpty((String)pdfBean.getBizSerialNo())) {
                logger.error("bizSerialNo is null");
                throw new Exception("bizSerialNo is null");
            }
            if (StringUtil.validateStrMaxLength((String)pdfBean.getBizSerialNo(), (int)32)) continue;
            logger.error("bizSerialNo \u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\uff0c\u6700\u592732\u4f4d");
            throw new Exception("bizSerialNo \u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236\uff0c\u6700\u592732\u4f4d");
        }
        if (inputType1 > 0 && inputType2 > 0) {
            throw new Exception("inputType \u6570\u636e\u6e90\u7c7b\u578b\u5728pdfBeans\u4e2d\u53ea\u80fd\u540c\u65f6\u5b58\u5728\u4e00\u79cd");
        }
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error("timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSceneCertChannel())) {
            requestBody.setSceneCertChannel("0");
        }
        if (!"0".equals(requestBody.getSceneCertChannel()) && !"1".equals(requestBody.getSceneCertChannel())) {
            logger.error("sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception("sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        boolean flag = false;
        List sealStrategies = requestBody.getSealStrategies();
        if (sealStrategies != null && sealStrategies.size() > 0) {
            flag = true;
            for (SealStrategy sealStrategy : sealStrategies) {
                if (StringUtil.isEmpty((String)sealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                if (StringUtil.isEmpty((String)sealStrategy.getPdfIndex())) {
                    sealStrategy.setPdfIndex("0");
                }
                ValidateUtil.checkSealStrategy(sealStrategy);
            }
        }
        if ((proofSealStrategies = requestBody.getProofSealStrategies()) != null && proofSealStrategies.size() > 0) {
            flag = true;
            List multiDataBeans = requestBody.getMultiDatas();
            if (multiDataBeans == null || multiDataBeans.size() == 0) {
                logger.error(" \u8bc1\u636e\u7b7e\u7ae0\u65f6\uff0cmultiDataBeans \u4e0d\u80fd\u4e3a\u7a7a");
                throw new Exception("\u8bc1\u636e\u7b7e\u7ae0\u65f6\uff0cmultiDataBeans \u4e0d\u80fd\u4e3a\u7a7a ");
            }
            for (MultiDataBean multiDataBean : multiDataBeans) {
                if (StringUtil.isEmpty((String)multiDataBean.getFileName())) {
                    logger.error(" fileName is null");
                    throw new Exception("fileName is null ");
                }
                if (!StringUtil.validateStrMaxLength((String)multiDataBean.getFileName(), (int)128)) {
                    logger.error(" fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                    throw new Exception("fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                }
                if (StringUtil.isEmpty((String)multiDataBean.getFileDataHash())) {
                    logger.error("fileDataHash is null");
                    throw new Exception("fileDataHash is null");
                }
                if (!StringUtil.isEmpty((String)multiDataBean.getType())) continue;
                multiDataBean.setType("0");
            }
            for (ProofSealStrategy proofSealStrategy : proofSealStrategies) {
                if (StringUtil.isEmpty((String)proofSealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)proofSealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                if (CommonUtil.isEmpty(proofSealStrategy.getPdfIndex())) {
                    proofSealStrategy.setPdfIndex("0");
                }
                ValidateUtil.checkProofSealStrategy(proofSealStrategy);
            }
        }
        if (!flag) {
            logger.error("sealStrategies and proofSealStrategies both null");
            throw new Exception(" sealStrategies and proofSealStrategies both null");
        }
    }

    public static void doCheckTx4005(VerifyPdfSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        if (!"1".equals(requestBody.getSealVerifyType()) && !"2".equals(requestBody.getSealVerifyType())) {
            logger.error("sealVerifyType \u53d6\u503c\u9519\u8bef\uff0csealVerifyType\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("sealVerifyType \u53d6\u503c\u9519\u8bef\uff0csealVerifyType\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
        }
    }

    public static void doCheckTx4006(RevokePdfSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error("inputSource is null");
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        if (!StringUtil.isNaturalNumber((String)requestBody.getCount(), (int)4)) {
            logger.error(" count \u53d6\u503c\u4e0d\u6b63\u786e ");
            throw new Exception(" count \u53d6\u503c\u4e0d\u6b63\u786e ");
        }
    }

    public static void doCheckTx4007(CalculatePdfHashRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error(" inputSource is null");
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource()});
        if (requestBody.getX509Cert() == null) {
            logger.error(" x509Cert is null");
            throw new Exception(" x509Cert is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0\u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0\u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSignatureType())) {
            requestBody.setSignatureType("1");
        }
        if (!"1".equals(requestBody.getSignatureType()) && !"2".equals(requestBody.getSignatureType())) {
            logger.error(" signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception(" signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        SealStrategy sealStrategy = requestBody.getSealStrategy();
        if (sealStrategy == null) {
            logger.error(" sealStrategy is null");
            throw new Exception(" sealStrategy is null");
        }
        ValidateUtil.checkSealStrategy4Asyn(sealStrategy, false);
    }

    public static void doCheckTx4008(SynthesizeOuterSignatureRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (requestBody.getSignature() == null) {
            logger.error(" signature is null");
            throw new Exception("signature is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getPdfId())) {
            logger.error(" pdfId is null");
            throw new Exception("pdfId is null");
        }
        if (!"1".equals(requestBody.getSignatureType()) && !"2".equals(requestBody.getSignatureType())) {
            logger.error(" signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
    }

    public static void doCheckTx4009(SynthesizeOuterSignatureAndSealPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (requestBody.getSignature() == null) {
            logger.error(" signature is null");
            throw new Exception("signature is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getPdfId())) {
            logger.error("pdfId is null");
            throw new Exception("pdfId is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getSignatureType())) {
            requestBody.setSignatureType("1");
        }
        if (!"1".equals(requestBody.getSignatureType()) && !"2".equals(requestBody.getSignatureType())) {
            logger.error("signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u8005 2");
            throw new Exception(" signatureType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0\u6216\u80051");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0\u6216\u80051");
        }
        List sealStrategies = requestBody.getSealStrategies();
        if (sealStrategies == null || sealStrategies.size() == 0) {
            logger.error("sealStrategies is null");
            throw new Exception("sealStrategies is null");
        }
        for (SealStrategy sealStrategy : sealStrategies) {
            if (StringUtil.isEmpty((String)sealStrategy.getSerialNo())) {
                logger.error(" serialNo is null");
                throw new Exception(" serialNo is null");
            }
            if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSerialNo(), (int)32)) {
                logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
            }
            ValidateUtil.checkSealStrategy(sealStrategy);
        }
    }

    public static void doCheckTx4011(ApplyAndDownloadCertRequestBody requestBody) throws Exception {
        if (!("1".equals(requestBody.getCustomerType()) || "2".equals(requestBody.getCustomerType()) || "7".equals(requestBody.getCustomerType()) || "8".equals(requestBody.getCustomerType()))) {
            logger.error("customerType \u53d6\u503c\u9519\u8bef\uff0ccustomerType\u53d6\u503c\u53ea\u80fd\u662f 1\u6216\u80052\u6216\u80057\u6216\u80058");
            throw new Exception(" customerType \u53d6\u503c\u9519\u8bef\uff0ccustomerType\u53d6\u503c\u53ea\u80fd\u662f 1\u6216\u80052\u6216\u80057\u6216\u80058 ");
        }
        if (StringUtil.isEmpty((String)requestBody.getIdentificationNo()) || StringUtil.isEmpty((String)requestBody.getIdentificationType()) || StringUtil.isEmpty((String)requestBody.getUserName())) {
            logger.error("identificationType or identificationNo or useName is null");
            throw new Exception(" identificationType or identificationNo or useName is null");
        }
        if (StringUtil.isEmpty((String)IdType.getNameByCode((String)requestBody.getIdentificationType()))) {
            throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)requestBody.getP10())) {
            logger.error("p10 is null");
            throw new Exception(" p10 is null ");
        }
        if (("7".equals(requestBody.getCustomerType()) || "8".equals(requestBody.getCustomerType())) && StringUtil.isEmpty((String)requestBody.getSelfExtValue())) {
            logger.error("\u7533\u8bf7\u573a\u666f\u8bc1\u4e66\u65f6\uff0c  selfExtValue \u4e0d\u80fd\u4e3a\u7a7a");
            throw new Exception("\u7533\u8bf7\u573a\u666f\u8bc1\u4e66\u65f6\uff0c  selfExtValue \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"RSA".equalsIgnoreCase(requestBody.getKeyAlg()) && !"SM2".equalsIgnoreCase(requestBody.getKeyAlg())) {
            logger.error("keyAlg \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662fRSA\u6216\u8005SM2");
            throw new Exception("keyAlg \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662fRSA\u6216\u8005SM2");
        }
        if ("RSA".equalsIgnoreCase(requestBody.getKeyAlg())) {
            if (!"2048".equals(requestBody.getKeyLength())) {
                logger.error("keyLength\u53d6\u503c\u9519\u8bef\uff0ckeyAlg \u4e3aRSA\u65f6 keyLength\u4ec5\u652f\u63012048");
                throw new Exception("keyLength\u53d6\u503c\u9519\u8bef\uff0ckeyAlg \u4e3aRSA\u65f6keyLength\u4ec5\u652f\u63012048");
            }
        } else if ("SM2".equalsIgnoreCase(requestBody.getKeyAlg()) && !"256".equals(requestBody.getKeyLength())) {
            logger.error("keyLength \u53d6\u503c\u9519\u8bef\uff0ckeyAlg \u4e3aSM2\u65f6 keyLength \u53ea\u80fd\u662f256");
            throw new Exception("keyLength \u53d6\u503c\u9519\u8bef\uff0ckeyAlg \u4e3aSM2\u65f6 keyLength \u53ea\u80fd\u662f256");
        }
    }

    public static void doCheckTx4012(CrossPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        int toPage;
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"pdf".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fpdf\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        CrossPdfStrategy crossStrategy = requestBody.getCrossPdfStrategy();
        if (crossStrategy == null) {
            logger.error("crossSealStrategy  is null");
            throw new Exception("crossSealStrategy is null");
        }
        if (!("5".equals(crossStrategy.getCrossStyle()) || "6".equals(crossStrategy.getCrossStyle()) || "7".equals(crossStrategy.getCrossStyle()))) {
            logger.error("crossStyle \u53d6\u503c\u9519\u8bef");
            throw new Exception("crossStyle \u53d6\u503c\u9519\u8bef");
        }
        if (!StringUtil.isNaturalNumber((String)crossStrategy.getFromPage(), (int)6)) {
            logger.error("fromPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" fromPage \u53d6\u503c\u9519\u8bef ");
        }
        if ("0".equals(crossStrategy.getFromPage())) {
            crossStrategy.setToPage("0");
        }
        if (!StringUtil.isNaturalNumber((String)crossStrategy.getToPage(), (int)6)) {
            logger.error("toPage \u53d6\u503c\u9519\u8bef");
            throw new Exception(" toPage \u53d6\u503c\u9519\u8bef ");
        }
        int fromPage = Integer.parseInt(crossStrategy.getFromPage());
        if (fromPage > (toPage = Integer.parseInt(crossStrategy.getToPage()))) {
            logger.error("frompage \u53d6\u503c \u5927\u4e8e toPage ");
            throw new Exception(" frompage \u53d6\u503c \u5927\u4e8e toPage ");
        }
        if ("5".equals(crossStrategy.getCrossStyle()) || "6".equals(crossStrategy.getCrossStyle())) {
            crossStrategy.setAbsoluteX("0");
        }
        if ("7".equals(crossStrategy.getCrossStyle())) {
            crossStrategy.setAbsoluteY("0");
        }
        if (StringUtil.isEmpty((String)crossStrategy.getAbsoluteX())) {
            crossStrategy.setAbsoluteX("0");
        }
        if (!StringUtil.isPositiveNumeric((String)crossStrategy.getAbsoluteX())) {
            logger.error("absoluteX\u53d6\u503c\u9519\u8bef");
            throw new Exception("absoluteX\u53d6\u503c\u9519\u8bef");
        }
        if (StringUtil.isEmpty((String)crossStrategy.getAbsoluteY())) {
            crossStrategy.setAbsoluteY("0");
        }
        if (!StringUtil.isPositiveNumeric((String)crossStrategy.getAbsoluteY())) {
            logger.error("absoluteY\u53d6\u503c\u9519\u8bef");
            throw new Exception("absoluteY\u53d6\u503c\u9519\u8bef");
        }
        CrossSealStrategy sealStrategy = requestBody.getSealStrategy();
        if (sealStrategy == null) {
            logger.error(" sealStrategy is null");
            throw new Exception(" sealStrategy is null");
        }
        ValidateUtil.checkCrossSealStrategy(sealStrategy);
    }

    public static void doCheckTx4013(SignPdfProofHashRequestBody requestBody) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSceneCertChannel())) {
            requestBody.setSceneCertChannel("0");
        }
        if (!"0".equals(requestBody.getSceneCertChannel()) && !"1".equals(requestBody.getSceneCertChannel())) {
            logger.error(" sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception("sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        List pdfHashs = requestBody.getPdfHashs();
        if (pdfHashs == null || pdfHashs.size() == 0) {
            logger.error(" pdfHashs");
            throw new Exception("pdfHashs is null ");
        }
        for (Object pdfHash : pdfHashs) {
            if (!StringUtil.isEmpty((String)pdfHash.getPdfSealHash())) continue;
            logger.error(" pdfSealHash is null");
            throw new Exception(" pdfSealHash is null");
        }
        List proofHashs = requestBody.getProofHashs();
        if (proofHashs == null || proofHashs.size() == 0) {
            logger.error(" proofHashs");
            throw new Exception("proofHashs is null ");
        }
        for (MultiDataBean multiDataBean : proofHashs) {
            if (StringUtil.isEmpty((String)multiDataBean.getFileName())) {
                logger.error(" fileName is null");
                throw new Exception("fileName is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)multiDataBean.getFileName(), (int)128)) {
                logger.error(" fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                throw new Exception("fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            }
            if (!StringUtil.isEmpty((String)multiDataBean.getFileDataHash())) continue;
            logger.error(" fileDataHash is null");
            throw new Exception("fileDataHash is null");
        }
        byte[] x509Cert = requestBody.getX509Cert();
        SignInfoBean signInfo = requestBody.getSignInfo();
        if ((x509Cert == null || x509Cert.length == 0) && signInfo == null) {
            throw new Exception("signInfo \u548c  x509Cert \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if ((x509Cert == null || x509Cert.length == 0) && signInfo != null) {
            if (StringUtil.isEmpty((String)signInfo.getUserName())) {
                logger.error("userName is null");
                throw new Exception(" userName is null");
            }
            if (!StringUtil.validateStrMaxLength((String)signInfo.getUserName(), (int)128)) {
                logger.error("userName \u957f\u5ea6\u8d85\u8fc7 128");
                throw new Exception("userName \u957f\u5ea6\u8d85\u8fc7 128");
            }
            if (StringUtil.isEmpty((String)signInfo.getIdentificationType())) {
                logger.error("identificationType is null");
                throw new Exception("identificationType is null");
            }
            if (StringUtil.isEmpty((String)IdType.getNameByCode((String)signInfo.getIdentificationType()))) {
                throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)signInfo.getIdentificationNo())) {
                logger.error("identificationNo is null");
                throw new Exception("identificationNo is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)signInfo.getIdentificationNo(), (int)80)) {
                logger.error("identificationNo \u957f\u5ea6\u8d85\u8fc780");
                throw new Exception("identificationNo \u957f\u5ea6\u8d85\u8fc780");
            }
        }
    }

    public static void doCheckTx4014(SignPdfHashRequestBody requestBody) throws Exception {
        List pdfHashs = requestBody.getPdfHashs();
        if (pdfHashs == null || pdfHashs.size() == 0) {
            logger.error(" pdfHashs");
            throw new Exception("pdfHashs is null ");
        }
        for (PdfHashBean pdfHash : pdfHashs) {
            if (!StringUtil.isEmpty((String)pdfHash.getPdfSealHash())) continue;
            logger.error(" pdfSealHash is null");
            throw new Exception(" pdfSealHash is null");
        }
        SealInfoBean sealInfo = requestBody.getSealInfo();
        if (StringUtil.isEmpty((String)sealInfo.getSealCode())) {
            logger.error("sealCode is null");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfo.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isEmpty((String)sealInfo.getSealPassword())) {
            logger.error("sealPassword is null");
            throw new Exception("sealPassword is null");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfo.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
    }

    public static void doCheckTx4016(WebSealRequestBody requestBody) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
            logger.error(" inputSource is null");
            throw new Exception(" inputSource is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (StringUtil.isNotEmpty((String)requestBody.getTimestampChannel()) && !"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
        if (StringUtil.isEmpty((String)requestBody.getHashAlg())) {
            logger.error("hashAlg is null ");
            throw new Exception(" hashAlg is null  ");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealLocation())) {
            logger.error("sealLocation is null ");
            throw new Exception(" sealLocation is null  ");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealReason())) {
            logger.error("sealReason is null ");
            throw new Exception(" sealReason is null  ");
        }
    }

    public static void doCheckTx4017(MessageSealRequestBody requestBody) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getMessageHash())) {
            logger.error("messageHash is null ");
            throw new Exception(" messageHash is null  ");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (StringUtil.isEmpty((String)requestBody.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)requestBody.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
        if (StringUtil.isEmpty((String)requestBody.getHashAlg())) {
            logger.error("hashAlg is null ");
            throw new Exception(" hashAlg is null  ");
        }
    }

    public static void doCheckTx4018(VerifyWebSealRequestBody requestBody) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
            logger.error(" inputSource is null");
            throw new Exception(" inputSource is null");
        }
        if (StringUtil.isEmpty((String)requestBody.getHashAlg())) {
            logger.error("hashAlg is null ");
            throw new Exception(" hashAlg is null  ");
        }
        if (StringUtil.isEmpty((String)requestBody.getSignature())) {
            logger.error("signature is null ");
            throw new Exception(" signature is null  ");
        }
    }

    public static void doCheckTx4019(VerifyMessageSealRequestBody requestBody) throws Exception {
        if (StringUtil.isEmpty((String)requestBody.getSignature())) {
            logger.error("signature is null ");
            throw new Exception(" signature is null  ");
        }
    }

    public static void doCheckTx4101(SealOfdRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"ofd".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fofd\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fofd\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getOfdData() == null) {
                logger.error(" ofdData is null");
                throw new Exception(" ofdData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getOfdFileDataHash())) {
                String ofdFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getOfdData());
                requestBody.setOfdFileDataHash(ofdFileDataHash);
            }
            fileDataList.add(requestBody.getOfdData());
            requestBody.setOfdData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getOfdFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        OfdSealStrategy ofdSealStrategy = requestBody.getSealStrategy();
        if (ofdSealStrategy == null) {
            logger.error(" ofdSealStrategy is null");
            throw new Exception(" ofdSealStrategy is null");
        }
        ValidateUtil.checkOfdSealStrategy(ofdSealStrategy);
    }

    public static void doCheckTx4105(VerifyOfdSealRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception(" inputSource is null");
            }
            String pdfSuffix = IoUtil.getFileNameSuffix((String)requestBody.getInputSource());
            if (!"ofd".equals(pdfSuffix)) {
                logger.error(" \u6240\u9009\u6587\u4ef6\u4e0d\u662fofd\u6587\u4ef6");
                throw new Exception("\u6240\u9009\u6587\u4ef6\u4e0d\u662fofd\u6587\u4ef6");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getOfdData() == null) {
                logger.error(" ofdData is null");
                throw new Exception(" ofdData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getOfdFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getOfdData());
                requestBody.setOfdFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getOfdData());
            requestBody.setOfdData(null);
        }
    }

    public static void doCheckTx5001(CheckNetWorkConnRequestBody requestBody) throws Exception {
        if (CommonUtil.isEmpty(requestBody.getTestMsg())) {
            logger.error("testMsg is null");
            throw new Exception(" testMsg is null  ");
        }
    }

    public static void doCheckTx5002(HeartBeatRequestBody requestBody) throws Exception {
        if (CommonUtil.isEmpty(requestBody.getOrganizationCode())) {
            logger.error("organizationCode is null ");
            throw new Exception(" organizationCode is null  ");
        }
    }

    public static void doCheckTx5003(GetP10AmountRequestBody requestBody) throws Exception {
        if (CommonUtil.isEmpty(requestBody.getHashAlg())) {
            logger.error("hashAlg is null ");
            throw new Exception(" hashAlg is null  ");
        }
        if (CommonUtil.isEmpty(requestBody.getKeyAlg())) {
            logger.error("keyAlg is null ");
            throw new Exception(" keyAlg is null  ");
        }
        if (CommonUtil.isEmpty(requestBody.getKeyLength())) {
            logger.error("keyLength is null ");
            throw new Exception(" keyLength is null  ");
        }
    }

    public static void doCheckTx5004(GetSceneCertAmountRequestBody requestBody) throws Exception {
        if (CommonUtil.isEmpty(requestBody.getKeyAlg())) {
            logger.error("keyAlg is null ");
            throw new Exception(" keyAlg is null  ");
        }
    }

    public static void doCheckTx6001(QueryProofInfoListRequestBody requestBody) throws Exception {
        if (StringUtil.isNotEmpty((String)requestBody.getStartTime()) && StringUtil.isNotEmpty((String)requestBody.getEndTime())) {
            Date endDate;
            Date startDate = TimeUtil.getDateInFormat((String)requestBody.getStartTime(), (String)"yyyyMMdd");
            if (startDate.compareTo(endDate = TimeUtil.getDateInFormat((String)requestBody.getEndTime(), (String)"yyyyMMdd")) > 0) {
                logger.error("startTime > endTime  ");
                throw new Exception(" startTime > endTime ");
            }
            long day = (endDate.getTime() - startDate.getTime()) / 86400000L;
            if (day > 30L) {
                logger.error("endTime - stratTime > 30 ");
                throw new Exception("  endTime - stratTime > 30");
            }
        }
    }

    public static void doCheckTx8001(SynthesizeAndCompoundSealPdfRequestBody requestBody, List<byte[]> fileDataList) throws Exception {
        List proofSealStrategies;
        if (!("1".equals(requestBody.getInputType()) || "2".equals(requestBody.getInputType()) || "3".equals(requestBody.getInputType()))) {
            logger.error(" inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
            throw new Exception("inputType \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                logger.error("inputSource is null ");
                throw new Exception(" inputSource is null");
            }
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                logger.error(" pdfData is null");
                throw new Exception(" pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])requestBody.getPdfData());
                requestBody.setPdfFileDataHash(pdfFileDataHash);
            }
            fileDataList.add(requestBody.getPdfData());
            requestBody.setPdfData(null);
        }
        logger.info("inputType={} pdfFileDataHash={} inputSource={} outputFilepath={}", new Object[]{requestBody.getInputType(), requestBody.getPdfFileDataHash(), requestBody.getInputSource(), requestBody.getOutputFilepath()});
        if (StringUtil.isEmpty((String)requestBody.getTimestampChannel())) {
            requestBody.setTimestampChannel("0");
        }
        if (!"0".equals(requestBody.getTimestampChannel()) && !"1".equals(requestBody.getTimestampChannel())) {
            logger.error(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1 ");
            throw new Exception(" timestampChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        if (StringUtil.isEmpty((String)requestBody.getSceneCertChannel())) {
            requestBody.setSceneCertChannel("0");
        }
        if (!"0".equals(requestBody.getSceneCertChannel()) && !"1".equals(requestBody.getSceneCertChannel())) {
            logger.error(" sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1 ");
            throw new Exception("sceneCertChannel \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f0 \u6216\u8005 1");
        }
        List fieldBeans = requestBody.getFieldBeans();
        List textBeans = requestBody.getTextBeans();
        List imageBeans = requestBody.getImageBeans();
        ValidateUtil.checkBusinessData(fieldBeans, textBeans, imageBeans);
        boolean flag = false;
        List sealStrategies = requestBody.getSealStrategies();
        if (sealStrategies != null && sealStrategies.size() > 0) {
            flag = true;
            for (SealStrategy sealStrategy : sealStrategies) {
                if (StringUtil.isEmpty((String)sealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                ValidateUtil.checkSealStrategy(sealStrategy);
            }
        }
        if ((proofSealStrategies = requestBody.getProofSealStrategies()) != null && proofSealStrategies.size() > 0) {
            flag = true;
            List multiDataBeans = requestBody.getMultiDatas();
            if (multiDataBeans == null || multiDataBeans.size() == 0) {
                logger.error(" multiDataBeans");
                throw new Exception("multiDataBeans is null ");
            }
            for (MultiDataBean multiDataBean : multiDataBeans) {
                if (StringUtil.isEmpty((String)multiDataBean.getFileName())) {
                    logger.error(" fileName is null");
                    throw new Exception("fileName is null ");
                }
                if (!StringUtil.validateStrMaxLength((String)multiDataBean.getFileName(), (int)128)) {
                    logger.error(" fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                    throw new Exception("fileName \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                }
                if (StringUtil.isEmpty((String)multiDataBean.getFileDataHash())) {
                    logger.error(" fileDataHash is null");
                    throw new Exception("fileDataHash is null");
                }
                if (!StringUtil.isEmpty((String)multiDataBean.getType())) continue;
                multiDataBean.setType("0");
            }
            for (ProofSealStrategy proofSealStrategy : proofSealStrategies) {
                if (StringUtil.isEmpty((String)proofSealStrategy.getSerialNo())) {
                    logger.error(" serialNo is null");
                    throw new Exception(" serialNo is null");
                }
                if (!StringUtil.validateStrMaxLength((String)proofSealStrategy.getSerialNo(), (int)32)) {
                    logger.error(" serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                    throw new Exception("serialNo \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                }
                ValidateUtil.checkProofSealStrategy(proofSealStrategy);
            }
        }
        if (!flag) {
            logger.error(" sealStrategies and proofSealStrategies is null");
            throw new Exception(" sealStrategies and proofSealStrategies is null");
        }
    }

    public static void doCheckTx6002(DownloadProofFileRequestBody requestBody) throws Exception {
        if (CommonUtil.isEmpty(requestBody.getBizSerialNo()) && CommonUtil.isEmpty(requestBody.getProofPdfId())) {
            logger.error(" bizSerialNo  and proofPdfId \u90fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u67e5\u8be2\u6761\u4ef6");
            throw new Exception("bizSerialNo  and proofPdfId \u90fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u67e5\u8be2\u6761\u4ef6");
        }
    }

    public static void doCheckTx6003(SealInfoBean sealInfo) throws Exception {
        if (sealInfo == null) {
            throw new Exception("sealInfo is null ");
        }
        if (CommonUtil.isEmpty(sealInfo.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfo.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (CommonUtil.isEmpty(sealInfo.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealInfo.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
    }

    public static void checkCrossSealStrategy(CrossSealStrategy sealStrategy) throws Exception {
        if (!"1".equals(sealStrategy.getType()) && !"2".equals(sealStrategy.getType())) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1\u6216\u80052");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealCode(), (int)32)) {
            logger.error("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
            throw new Exception("sealCode \u957f\u5ea6\u8d85\u8fc7 32");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealPassword(), (int)64)) {
            logger.error("sealPassword \u957f\u5ea6\u8d85\u8fc764");
            throw new Exception("sealPassword \u957f\u5ea6\u8d85\u8fc764");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealPerson())) {
            logger.error(" sealPerson is null ");
            throw new Exception("sealPerson is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealPerson(), (int)128)) {
            logger.error(" sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            throw new Exception("sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
        }
        if (!("SHA-1".equals(sealStrategy.getHashAlg()) || "SHA-256".equals(sealStrategy.getHashAlg()) || "SHA-384".equals(sealStrategy.getHashAlg()) || "SHA-512".equals(sealStrategy.getHashAlg()) || "MD5".equals(sealStrategy.getHashAlg()) || "SM3".equals(sealStrategy.getHashAlg()))) {
            logger.error(" hashAlg \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" hashAlg \u53d6\u503c\u9519\u8bef ");
        }
        if ("2".equals(sealStrategy.getType()) && CommonUtil.isEmpty(sealStrategy.getSealImage())) {
            logger.error(" sealImage is null  ");
            throw new Exception("sealImage is null ");
        }
    }

    public static void checkOfdSealStrategy(OfdSealStrategy ofdSealStrategy) throws Exception {
        if (!"1".equals(ofdSealStrategy.getType()) && !"2".equals(ofdSealStrategy.getType())) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1\u6216\u80052");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052");
        }
        if (CommonUtil.isEmpty(ofdSealStrategy.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (CommonUtil.isEmpty(ofdSealStrategy.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (!("SHA-1".equals(ofdSealStrategy.getHashAlg()) || "SHA-256".equals(ofdSealStrategy.getHashAlg()) || "SHA-384".equals(ofdSealStrategy.getHashAlg()) || "SHA-512".equals(ofdSealStrategy.getHashAlg()) || "MD5".equals(ofdSealStrategy.getHashAlg()) || "SM3".equals(ofdSealStrategy.getHashAlg()))) {
            logger.error(" hashAlg \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" hashAlg \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getDisplaySize())) {
            ofdSealStrategy.setDisplaySize("0");
        }
        if (!StringUtil.isNaturalNumber((String)ofdSealStrategy.getDisplaySize(), (int)3)) {
            logger.error(" displaySize \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" displaySize \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getOffsetX())) {
            ofdSealStrategy.setOffsetX("0");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getOffsetY())) {
            ofdSealStrategy.setOffsetY("0");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getKeywordIndex())) {
            ofdSealStrategy.setKeywordIndex("0");
        }
        if ("2".equals(ofdSealStrategy.getType()) && CommonUtil.isEmpty(ofdSealStrategy.getSealImage())) {
            logger.error(" sealImage is null  ");
            throw new Exception("sealImage is null ");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getLx())) {
            ofdSealStrategy.setLx("0");
        }
        if (!"2".equals(ofdSealStrategy.getSealType()) && !"3".equals(ofdSealStrategy.getSealType())) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f  2 \u6216\u8005 3  ");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f  2 \u6216\u8005 3 ");
        }
        if (StringUtil.isEmpty((String)ofdSealStrategy.getLy())) {
            ofdSealStrategy.setLy("0");
        }
        if ("2".equals(ofdSealStrategy.getSealType())) {
            if (CommonUtil.isEmpty(ofdSealStrategy.getPageNo())) {
                logger.error(" pageNo is null ");
                throw new Exception("pageNo is null");
            }
            if (!StringUtil.isNaturalNumber((String)ofdSealStrategy.getPageNo(), (int)6)) {
                logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
            }
            if (!StringUtil.isPositiveNumeric((String)ofdSealStrategy.getLx())) {
                logger.error("lx \u53d6\u503c\u9519\u8bef ");
                throw new Exception("lx \u53d6\u503c\u9519\u8bef");
            }
            if (!StringUtil.isPositiveNumeric((String)ofdSealStrategy.getLy())) {
                logger.error("ly \u53d6\u503c\u9519\u8bef ");
                throw new Exception("ly \u53d6\u503c\u9519\u8bef");
            }
        }
        if ("3".equals(ofdSealStrategy.getSealType())) {
            if (StringUtil.isEmpty((String)ofdSealStrategy.getPageNo())) {
                ofdSealStrategy.setPageNo("0");
            }
            if (!StringUtil.isNaturalNumber((String)ofdSealStrategy.getPageNo(), (int)6)) {
                logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
            }
            if (CommonUtil.isEmpty(ofdSealStrategy.getKeyword())) {
                logger.error(" keyword  is null ");
                throw new Exception("keyword  is null");
            }
            if (!StringUtil.isNumeric((String)ofdSealStrategy.getOffsetX())) {
                logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
            }
            if (!StringUtil.isNumeric((String)ofdSealStrategy.getOffsetY())) {
                logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
            }
        }
    }

    public static void checkSealStrategy(SealStrategy sealStrategy) throws Exception {
        int i;
        List signatureFieldNameList;
        if (!("1".equals(sealStrategy.getType()) || "2".equals(sealStrategy.getType()) || "3".equals(sealStrategy.getType()))) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1\u6216\u8005 2\u6216\u8005 3");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1\u6216\u80052\u6216\u80053");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealCode())) {
            logger.error(" sealCode is null ");
            throw new Exception("sealCode is null ");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealPassword())) {
            logger.error(" sealPassword is null ");
            throw new Exception("sealPassword is null ");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealPerson())) {
            logger.error(" sealPerson is null ");
            throw new Exception("sealPerson is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealPerson(), (int)128)) {
            logger.error(" sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            throw new Exception("sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
        }
        if (!("SHA-1".equals(sealStrategy.getHashAlg()) || "SHA-256".equals(sealStrategy.getHashAlg()) || "SHA-384".equals(sealStrategy.getHashAlg()) || "SHA-512".equals(sealStrategy.getHashAlg()) || "MD5".equals(sealStrategy.getHashAlg()) || "SM3".equals(sealStrategy.getHashAlg()))) {
            logger.error(" hashAlg \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" hashAlg \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)sealStrategy.getFillOpacity())) {
            sealStrategy.setFillOpacity("1");
        }
        if (!StringUtil.isPositiveNumeric((String)sealStrategy.getFillOpacity())) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        float fillOpacity = Float.parseFloat(sealStrategy.getFillOpacity());
        if (fillOpacity < 0.0f || fillOpacity > 1.0f) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)sealStrategy.getDisplaySize())) {
            sealStrategy.setDisplaySize("0");
        }
        if (StringUtil.isNotEmpty((String)sealStrategy.getBusinessCode())) {
            if (!StringUtil.validateStrMaxLength((String)sealStrategy.getBusinessCode(), (int)32)) {
                logger.error(" businessCode \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                throw new Exception("businessCode \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getBusinessFontSize())) {
                sealStrategy.setBusinessFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getBusinessFontSize(), (int)6)) {
                logger.error(" businessFontSize \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessFontSize \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getTextRectHeightPercent())) {
                sealStrategy.setTextRectHeightPercent("0.5");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getTextRectHeightPercent())) {
                logger.error(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
            }
            float rx = Float.parseFloat(sealStrategy.getTextRectHeightPercent());
            if (rx < 0.0f || rx > 1.0f) {
                logger.error(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getBusinessColor())) {
                sealStrategy.setBusinessColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getBusinessColor())) {
                logger.error(" businessColor \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessColor \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getBusinessFamily())) {
                sealStrategy.setBusinessFamily("\u5b8b\u4f53");
            }
        }
        if ("2".equals(sealStrategy.getType()) && CommonUtil.isEmpty(sealStrategy.getSealImage())) {
            logger.error(" sealImage is null  ");
            throw new Exception("sealImage is null ");
        }
        if ("3".equals(sealStrategy.getType())) {
            if (CommonUtil.isEmpty(sealStrategy.getSealText())) {
                logger.error(" sealText is null   ");
                throw new Exception("sealText is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealText(), (int)128)) {
                logger.error(" sealText \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                throw new Exception("sealText \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getWidth())) {
                sealStrategy.setWidth("100");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getWidth())) {
                logger.error(" width \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" width \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getHeight())) {
                sealStrategy.setHeight("100");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getHeight())) {
                logger.error(" height \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" height \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getFontSize())) {
                sealStrategy.setFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getFontSize(), (int)4)) {
                logger.error("fontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getFontColor())) {
                sealStrategy.setFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getFontColor())) {
                logger.error("fontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontColor \u53d6\u503c\u9519\u8bef");
            }
        }
        if (!("1".equals(sealStrategy.getSealType()) || "2".equals(sealStrategy.getSealType()) || "3".equals(sealStrategy.getSealType()))) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1 \u6216\u8005  2 \u6216\u8005 3  ");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1 \u6216\u8005  2 \u6216\u8005 3 ");
        }
        if ("1".equals(sealStrategy.getSealType()) && ((signatureFieldNameList = sealStrategy.getSignatureFieldNameList()) == null || signatureFieldNameList.size() == 0) && CommonUtil.isEmpty(sealStrategy.getSignatureFieldName())) {
            logger.error(" signatureFieldName is null ");
            throw new Exception("signatureFieldName is null");
        }
        if ("2".equals(sealStrategy.getSealType())) {
            List signLocationList = sealStrategy.getSignLocationList();
            if (signLocationList == null || signLocationList.size() == 0) {
                if (CommonUtil.isEmpty(sealStrategy.getPageNo())) {
                    sealStrategy.setPageNo("1");
                }
                if (!StringUtil.isNaturalNumber((String)sealStrategy.getPageNo(), (int)6)) {
                    logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
                }
                if (StringUtil.isEmpty((String)sealStrategy.getLx())) {
                    sealStrategy.setLx("0");
                }
                if (!StringUtil.isPositiveNumeric((String)sealStrategy.getLx())) {
                    logger.error("lx \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("lx \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)sealStrategy.getLy())) {
                    sealStrategy.setLy("0");
                }
                if (!StringUtil.isPositiveNumeric((String)sealStrategy.getLy())) {
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("ly \u53d6\u503c\u9519\u8bef");
                }
            } else {
                for (i = 0; i < signLocationList.size(); ++i) {
                    SignLocation signLocation = (SignLocation)signLocationList.get(i);
                    if (CommonUtil.isEmpty(signLocation.getPageNo())) {
                        signLocation.setPageNo("1");
                    }
                    if (!StringUtil.isNaturalNumber((String)signLocation.getPageNo(), (int)6)) {
                        logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " pageNo \u53d6\u503c\u9519\u8bef  ");
                    }
                    if (StringUtil.isEmpty((String)signLocation.getLx())) {
                        signLocation.setLx("0");
                    }
                    if (!StringUtil.isPositiveNumeric((String)signLocation.getLx())) {
                        logger.error("lx \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " lx \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)signLocation.getLy())) {
                        signLocation.setLy("0");
                    }
                    if (StringUtil.isPositiveNumeric((String)signLocation.getLy())) continue;
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("\u7b2c" + (i + 1) + " ly \u53d6\u503c\u9519\u8bef");
                }
            }
        }
        if ("3".equals(sealStrategy.getSealType())) {
            List keywordLocationList = sealStrategy.getKeywordLocationList();
            if (keywordLocationList == null || keywordLocationList.size() == 0) {
                if (StringUtil.isEmpty((String)sealStrategy.getPageNo())) {
                    sealStrategy.setPageNo("0");
                }
                if (!StringUtil.isNaturalNumber((String)sealStrategy.getPageNo(), (int)6)) {
                    logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
                }
                if (CommonUtil.isEmpty(sealStrategy.getKeyword())) {
                    logger.error(" keyword  is null ");
                    throw new Exception("keyword  is null");
                }
                if (StringUtil.isEmpty((String)sealStrategy.getOffsetX())) {
                    sealStrategy.setOffsetX("0");
                }
                if (!StringUtil.isNumeric((String)sealStrategy.getOffsetX())) {
                    logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)sealStrategy.getOffsetY())) {
                    sealStrategy.setOffsetY("0");
                }
                if (!StringUtil.isNumeric((String)sealStrategy.getOffsetY())) {
                    logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
                }
            } else {
                for (i = 0; i < keywordLocationList.size(); ++i) {
                    KeywordLocation keywordLocation = (KeywordLocation)keywordLocationList.get(i);
                    if (StringUtil.isEmpty((String)keywordLocation.getPageNo())) {
                        keywordLocation.setPageNo("0");
                    }
                    if (!StringUtil.isNaturalNumber((String)keywordLocation.getPageNo(), (int)6)) {
                        logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " pageNo \u53d6\u503c\u9519\u8bef  ");
                    }
                    if (CommonUtil.isEmpty(keywordLocation.getKeyword())) {
                        logger.error(" keyword  is null ");
                        throw new Exception("\u7b2c" + (i + 1) + "keyword  is null");
                    }
                    if (StringUtil.isEmpty((String)keywordLocation.getOffsetX())) {
                        keywordLocation.setOffsetX("0");
                    }
                    if (!StringUtil.isNumeric((String)keywordLocation.getOffsetX())) {
                        logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " offsetX \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)keywordLocation.getOffsetY())) {
                        keywordLocation.setOffsetY("0");
                    }
                    if (StringUtil.isNumeric((String)keywordLocation.getOffsetY())) continue;
                    logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("\u7b2c" + (i + 1) + " offsetY \u53d6\u503c\u9519\u8bef");
                }
            }
        }
        if ("1".equals(sealStrategy.getIsAddDateText())) {
            if (StringUtil.isEmpty((String)sealStrategy.getDateFontSize())) {
                sealStrategy.setDateFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getDateFontSize(), (int)4)) {
                logger.error("dateFontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getDateFontColor())) {
                sealStrategy.setDateFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getDateFontColor())) {
                logger.error("dateFontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontColor \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getDateRectHeight())) {
                sealStrategy.setDateRectHeight("40");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getDateRectHeight())) {
                logger.error("dateRectHeight \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateRectHeight \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getDateFontFamily())) {
                sealStrategy.setDateFontFamily("\u5b8b\u4f53");
            }
        }
    }

    public static void checkSealStrategy4Asyn(SealStrategy sealStrategy, boolean isLocal) throws Exception {
        if (!"2".equals(sealStrategy.getType()) && !"3".equals(sealStrategy.getType())) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u8005 3");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f2\u6216\u80053");
        }
        if (CommonUtil.isEmpty(sealStrategy.getSealPerson())) {
            logger.error(" sealPerson is null ");
            throw new Exception("sealPerson is null ");
        }
        if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealPerson(), (int)128)) {
            logger.error(" sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            throw new Exception("sealPerson \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
        }
        if (!("SHA-1".equals(sealStrategy.getHashAlg()) || "SHA-256".equals(sealStrategy.getHashAlg()) || "SHA-384".equals(sealStrategy.getHashAlg()) || "SHA-512".equals(sealStrategy.getHashAlg()) || "MD5".equals(sealStrategy.getHashAlg()) || "SM3".equals(sealStrategy.getHashAlg()))) {
            logger.error(" hashAlg \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" hashAlg \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)sealStrategy.getFillOpacity())) {
            sealStrategy.setFillOpacity("1");
        }
        if (!StringUtil.isPositiveNumeric((String)sealStrategy.getFillOpacity())) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        float fillOpacity = Float.parseFloat(sealStrategy.getFillOpacity());
        if (fillOpacity < 0.0f || fillOpacity > 1.0f) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        if (StringUtil.isEmpty((String)sealStrategy.getDisplaySize())) {
            sealStrategy.setDisplaySize("0");
        }
        if (StringUtil.isNotEmpty((String)sealStrategy.getBusinessCode())) {
            if (!StringUtil.validateStrMaxLength((String)sealStrategy.getBusinessCode(), (int)32)) {
                logger.error(" businessCode \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
                throw new Exception("businessCode \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f32");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getBusinessFontSize())) {
                sealStrategy.setBusinessFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getBusinessFontSize(), (int)6)) {
                logger.error(" businessFontSize \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessFontSize \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getTextRectHeightPercent())) {
                sealStrategy.setTextRectHeightPercent("0.5");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getTextRectHeightPercent())) {
                logger.error(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
            }
            float rx = Float.parseFloat(sealStrategy.getTextRectHeightPercent());
            if (rx < 0.0f || rx > 1.0f) {
                logger.error(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" textRectHeightPercent \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getBusinessColor())) {
                sealStrategy.setBusinessColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getBusinessColor())) {
                logger.error(" businessColor \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" businessColor \u53d6\u503c \u9519\u8bef ");
            }
            if (!StringUtil.isEmpty((String)sealStrategy.getBusinessFamily())) {
                sealStrategy.setBusinessFamily("\u5b8b\u4f53");
            }
        }
        if ("2".equals(sealStrategy.getType())) {
            if (isLocal) {
                if (sealStrategy.getSealImageData() == null) {
                    logger.error(" sealImageData is null  ");
                    throw new Exception("sealImageData is null ");
                }
            } else if (CommonUtil.isEmpty(sealStrategy.getSealImage())) {
                logger.error(" sealImage is null  ");
                throw new Exception("sealImage is null ");
            }
        }
        if ("3".equals(sealStrategy.getType())) {
            if (CommonUtil.isEmpty(sealStrategy.getSealText())) {
                logger.error(" sealText is null   ");
                throw new Exception("sealText is null ");
            }
            if (!StringUtil.validateStrMaxLength((String)sealStrategy.getSealText(), (int)128)) {
                logger.error(" sealText \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
                throw new Exception("sealText \u957f\u5ea6\u8d85\u957f\uff0c\u9650\u957f128");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getWidth())) {
                sealStrategy.setWidth("100");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getWidth())) {
                logger.error(" width \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" width \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getHeight())) {
                sealStrategy.setHeight("100");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getHeight())) {
                logger.error(" height \u53d6\u503c \u9519\u8bef ");
                throw new Exception(" height \u53d6\u503c \u9519\u8bef ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getFontSize())) {
                sealStrategy.setFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getFontSize(), (int)4)) {
                logger.error("fontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getFontColor())) {
                sealStrategy.setFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getFontColor())) {
                logger.error("fontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontColor \u53d6\u503c\u9519\u8bef");
            }
        }
        if (!("1".equals(sealStrategy.getSealType()) || "2".equals(sealStrategy.getSealType()) || "3".equals(sealStrategy.getSealType()))) {
            logger.error(" type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1 \u6216\u8005  2 \u6216\u8005 3  ");
            throw new Exception("type\u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f 1 \u6216\u8005  2 \u6216\u8005 3 ");
        }
        if ("1".equals(sealStrategy.getSealType()) && CommonUtil.isEmpty(sealStrategy.getSignatureFieldName())) {
            logger.error(" signatureFieldName is null ");
            throw new Exception("signatureFieldName is null");
        }
        if ("2".equals(sealStrategy.getSealType())) {
            if (CommonUtil.isEmpty(sealStrategy.getPageNo())) {
                logger.error(" pageNo is null ");
                throw new Exception("pageNo is null");
            }
            if (!StringUtil.isNaturalNumber((String)sealStrategy.getPageNo(), (int)6)) {
                logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getLx())) {
                sealStrategy.setLx("0");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getLx())) {
                logger.error("lx \u53d6\u503c\u9519\u8bef ");
                throw new Exception("lx \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getLy())) {
                sealStrategy.setLy("0");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getLy())) {
                logger.error("ly \u53d6\u503c\u9519\u8bef ");
                throw new Exception("ly \u53d6\u503c\u9519\u8bef");
            }
        }
        if ("3".equals(sealStrategy.getSealType())) {
            if (StringUtil.isEmpty((String)sealStrategy.getPageNo())) {
                sealStrategy.setPageNo("0");
            }
            if (!StringUtil.isNaturalNumber((String)sealStrategy.getPageNo(), (int)6)) {
                logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
            }
            if (CommonUtil.isEmpty(sealStrategy.getKeyword())) {
                logger.error(" keyword  is null ");
                throw new Exception("keyword  is null");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getOffsetX())) {
                sealStrategy.setOffsetX("0");
            }
            if (!StringUtil.isNumeric((String)sealStrategy.getOffsetX())) {
                logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getOffsetY())) {
                sealStrategy.setOffsetY("0");
            }
            if (!StringUtil.isNumeric((String)sealStrategy.getOffsetY())) {
                logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
            }
        }
        if ("1".equals(sealStrategy.getIsAddDateText())) {
            if (StringUtil.isEmpty((String)sealStrategy.getDateFontSize())) {
                sealStrategy.setDateFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)sealStrategy.getDateFontSize(), (int)4)) {
                logger.error("dateFontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getDateFontColor())) {
                sealStrategy.setDateFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)sealStrategy.getDateFontColor())) {
                logger.error("dateFontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontColor \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)sealStrategy.getDateRectHeight())) {
                sealStrategy.setDateRectHeight("40");
            }
            if (!StringUtil.isPositiveNumeric((String)sealStrategy.getDateRectHeight())) {
                logger.error("dateRectHeight \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateRectHeight \u53d6\u503c\u9519\u8bef");
            }
        }
    }

    public static void checkProofSealStrategy(ProofSealStrategy proofSealStrategy) throws Exception {
        int i;
        List signatureFieldNameList;
        if (CommonUtil.isEmpty(proofSealStrategy.getSerialNo())) {
            logger.error(" serialNo  is null ");
            throw new Exception("serialNo  is null");
        }
        if (CommonUtil.isEmpty(proofSealStrategy.getHandwritingImage()) && CommonUtil.isEmpty(proofSealStrategy.getSealText())) {
            logger.error(" handwritingImage and sealText  is null ");
            throw new Exception("handwritingImage and sealText  is null");
        }
        if (CommonUtil.isEmpty(proofSealStrategy.getIdentificationType())) {
            logger.error(" identificationType is null ");
            throw new Exception("identificationType  is null");
        }
        if (StringUtil.isEmpty((String)IdType.getNameByCode((String)proofSealStrategy.getIdentificationType()))) {
            throw new Exception("identificationType \u53d6\u503c\u9519\u8bef");
        }
        if (CommonUtil.isEmpty(proofSealStrategy.getIdentificationNo())) {
            logger.error(" identificationNo is null ");
            throw new Exception("identificationNo  is null");
        }
        if (CommonUtil.isEmpty(proofSealStrategy.getSealPerson())) {
            logger.error(" sealPerson is null ");
            throw new Exception("sealPerson  is null");
        }
        if (StringUtil.isEmpty((String)proofSealStrategy.getDisplaySize())) {
            proofSealStrategy.setDisplaySize("0");
        }
        if (StringUtil.isNotEmpty((String)proofSealStrategy.getSealText())) {
            if (StringUtil.isEmpty((String)proofSealStrategy.getWidth())) {
                proofSealStrategy.setWidth("100");
            }
            if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getWidth())) {
                logger.error(" width \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" width \u53d6\u503c\u9519\u8bef  ");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getHeight())) {
                proofSealStrategy.setHeight("100");
            }
            if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getHeight())) {
                logger.error(" width \u53d6\u503c\u9519\u8bef ");
                throw new Exception(" width \u53d6\u503c\u9519\u8bef  ");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getFontSize())) {
                proofSealStrategy.setFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)proofSealStrategy.getFontSize(), (int)4)) {
                logger.error("fontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getFontColor())) {
                proofSealStrategy.setFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)proofSealStrategy.getFontColor())) {
                logger.error("fontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("fontColor \u53d6\u503c\u9519\u8bef");
            }
        }
        if (!"RSA".equalsIgnoreCase(proofSealStrategy.getKeyAlg()) && !"SM2".equalsIgnoreCase(proofSealStrategy.getKeyAlg())) {
            logger.error("keyAlg \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662fRSA\u6216\u8005SM2");
            throw new Exception("keyAlg \u53d6\u503c\u9519\u8bef\uff0c\u53ea\u80fd\u662fRSA\u6216\u8005SM2");
        }
        if (StringUtil.isEmpty((String)proofSealStrategy.getFillOpacity())) {
            proofSealStrategy.setFillOpacity("1");
        }
        if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getFillOpacity())) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        float fillOpacity = Float.parseFloat(proofSealStrategy.getFillOpacity());
        if (fillOpacity < 0.0f || fillOpacity > 1.0f) {
            logger.error(" fillOpacity \u53d6\u503c\u9519\u8bef ");
            throw new Exception(" fillOpacity \u53d6\u503c\u9519\u8bef ");
        }
        if (!("1".equals(proofSealStrategy.getSealType()) || "2".equals(proofSealStrategy.getSealType()) || "3".equals(proofSealStrategy.getSealType()))) {
            logger.error(" sealType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1 \u6216\u8005 2 \u6216\u8005 3 ");
            throw new Exception("sealType \u53d6\u503c\u9519\u8bef\uff0c\u53d6\u503c\u53ea\u80fd\u662f1 \u6216\u8005 2 \u6216\u8005 3");
        }
        if ("1".equals(proofSealStrategy.getSealType()) && ((signatureFieldNameList = proofSealStrategy.getSignatureFieldNameList()) == null || signatureFieldNameList.size() == 0) && CommonUtil.isEmpty(proofSealStrategy.getSignatureFieldName())) {
            logger.error(" signatureFieldName is null ");
            throw new Exception("signatureFieldName is null");
        }
        if ("2".equals(proofSealStrategy.getSealType())) {
            List signLocationList = proofSealStrategy.getSignLocationList();
            if (signLocationList == null || signLocationList.size() == 0) {
                if (CommonUtil.isEmpty(proofSealStrategy.getPageNo())) {
                    logger.error(" pageNo is null ");
                    throw new Exception("pageNo is null");
                }
                if (!StringUtil.isNaturalNumber((String)proofSealStrategy.getPageNo(), (int)6)) {
                    logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
                }
                if (StringUtil.isEmpty((String)proofSealStrategy.getLx())) {
                    proofSealStrategy.setLx("0");
                }
                if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getLx())) {
                    logger.error("lx \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("lx \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)proofSealStrategy.getLy())) {
                    proofSealStrategy.setLy("0");
                }
                if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getLy())) {
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("ly \u53d6\u503c\u9519\u8bef");
                }
            } else {
                for (i = 0; i < signLocationList.size(); ++i) {
                    SignLocation signLocation = (SignLocation)signLocationList.get(i);
                    if (CommonUtil.isEmpty(signLocation.getPageNo())) {
                        logger.error(" pageNo is null ");
                        throw new Exception("\u7b2c " + (i + 1) + " pageNo is null");
                    }
                    if (!StringUtil.isNaturalNumber((String)signLocation.getPageNo(), (int)6)) {
                        logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c " + (i + 1) + " pageNo \u53d6\u503c\u9519\u8bef  ");
                    }
                    if (StringUtil.isEmpty((String)signLocation.getLx())) {
                        signLocation.setLx("0");
                    }
                    if (!StringUtil.isPositiveNumeric((String)signLocation.getLx())) {
                        logger.error("lx \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c " + (i + 1) + " lx \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)signLocation.getLy())) {
                        signLocation.setLy("0");
                    }
                    if (StringUtil.isPositiveNumeric((String)signLocation.getLy())) continue;
                    logger.error("ly \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("\u7b2c " + (i + 1) + " ly \u53d6\u503c\u9519\u8bef");
                }
            }
        }
        if ("3".equals(proofSealStrategy.getSealType())) {
            List keywordLocationList = proofSealStrategy.getKeywordLocationList();
            if (keywordLocationList == null || keywordLocationList.size() == 0) {
                if (StringUtil.isEmpty((String)proofSealStrategy.getPageNo())) {
                    proofSealStrategy.setPageNo("0");
                }
                if (!StringUtil.isNaturalNumber((String)proofSealStrategy.getPageNo(), (int)6)) {
                    logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                    throw new Exception(" pageNo \u53d6\u503c\u9519\u8bef  ");
                }
                if (CommonUtil.isEmpty(proofSealStrategy.getKeyword())) {
                    logger.error(" keyword is null ");
                    throw new Exception("keyword is null ");
                }
                if (StringUtil.isEmpty((String)proofSealStrategy.getOffsetX())) {
                    proofSealStrategy.setOffsetX("0");
                }
                if (!StringUtil.isNumeric((String)proofSealStrategy.getOffsetX())) {
                    logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetX \u53d6\u503c\u9519\u8bef");
                }
                if (StringUtil.isEmpty((String)proofSealStrategy.getOffsetY())) {
                    proofSealStrategy.setOffsetY("0");
                }
                if (!StringUtil.isNumeric((String)proofSealStrategy.getOffsetY())) {
                    logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("offsetY \u53d6\u503c\u9519\u8bef");
                }
            } else {
                for (i = 0; i < keywordLocationList.size(); ++i) {
                    KeywordLocation keywordLocaton = (KeywordLocation)keywordLocationList.get(i);
                    if (StringUtil.isEmpty((String)keywordLocaton.getPageNo())) {
                        keywordLocaton.setPageNo("0");
                    }
                    if (!StringUtil.isNaturalNumber((String)keywordLocaton.getPageNo(), (int)6)) {
                        logger.error(" pageNo \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " pageNo \u53d6\u503c\u9519\u8bef  ");
                    }
                    if (CommonUtil.isEmpty(keywordLocaton.getKeyword())) {
                        logger.error(" keyword is null ");
                        throw new Exception("\u7b2c" + (i + 1) + " keyword is null ");
                    }
                    if (StringUtil.isEmpty((String)keywordLocaton.getOffsetX())) {
                        keywordLocaton.setOffsetX("0");
                    }
                    if (!StringUtil.isNumeric((String)keywordLocaton.getOffsetX())) {
                        logger.error("offsetX \u53d6\u503c\u9519\u8bef ");
                        throw new Exception("\u7b2c" + (i + 1) + " offsetX \u53d6\u503c\u9519\u8bef");
                    }
                    if (StringUtil.isEmpty((String)keywordLocaton.getOffsetY())) {
                        keywordLocaton.setOffsetY("0");
                    }
                    if (StringUtil.isNumeric((String)keywordLocaton.getOffsetY())) continue;
                    logger.error("offsetY \u53d6\u503c\u9519\u8bef ");
                    throw new Exception("\u7b2c" + (i + 1) + " offsetY \u53d6\u503c\u9519\u8bef");
                }
            }
        }
        if ("1".equals(proofSealStrategy.getIsAddDateText())) {
            if (StringUtil.isEmpty((String)proofSealStrategy.getDateFontSize())) {
                proofSealStrategy.setDateFontSize("12");
            }
            if (!StringUtil.isPositiveNumber((String)proofSealStrategy.getDateFontSize(), (int)4)) {
                logger.error("dateFontSize \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontSize \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getDateFontColor())) {
                proofSealStrategy.setDateFontColor("000000");
            }
            if (!StringUtil.isColorNumber((String)proofSealStrategy.getDateFontColor())) {
                logger.error("dateFontColor \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateFontColor \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getDateRectHeight())) {
                proofSealStrategy.setDateRectHeight("40");
            }
            if (!StringUtil.isPositiveNumeric((String)proofSealStrategy.getDateRectHeight())) {
                logger.error("dateRectHeight \u53d6\u503c\u9519\u8bef ");
                throw new Exception("dateRectHeight \u53d6\u503c\u9519\u8bef");
            }
            if (StringUtil.isEmpty((String)proofSealStrategy.getDateFontFamily())) {
                proofSealStrategy.setDateFontFamily("\u5b8b\u4f53");
            }
        }
    }
}

